/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.uri;

import com.streamscape.sef.network.http.server.uri.UriTree;
import com.streamscape.sef.network.http.server.uri.UriUtils;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.util.HashMap;
import java.util.Map;

public class UriRegistry<T> {
    private UriTree<T> uriTree = new UriTree();
    private Map<String, T> uriToData = new HashMap<String, T>();
    private Map<T, String> dataToUri = new HashMap<T, String>();
    private Map<Class<?>, String> dataClassToUri = new HashMap();
    private String prefix;

    public void setPrefix(String prefix) throws UriTree.UriException {
        this.uriTree.setPrefix(prefix);
    }

    public void setPrefixes(String ... prefixes) throws UriTree.UriException {
        this.uriTree.setPrefixes(prefixes);
    }

    public String getPrefix() {
        return this.uriTree.getPrefix();
    }

    public void register(String uri, T data) throws UriTree.UriException {
        this.register(uri, data, true);
    }

    public void register(String uri, T data, boolean checkUnique) throws UriTree.UriException {
        this.uriTree.add(uri, data, checkUnique);
        this.uriToData.put(uri, data);
        this.dataToUri.put(data, uri);
        this.dataClassToUri.put(data.getClass(), uri);
    }

    public T getData(String uri) {
        return this.uriToData.get(uri);
    }

    public String getUri(T data) {
        return this.dataToUri.get(data);
    }

    public String getFullUri(T data) {
        String uri = this.dataToUri.get(data);
        if (uri == null) {
            return null;
        }
        return this.uriTree.getPrefix() + uri;
    }

    public String getUri(Class<?> clazz) {
        return this.dataToUri.get(clazz);
    }

    public String getFullUri(Class<?> clazz) {
        String uri = this.dataToUri.get(clazz);
        if (uri == null) {
            return null;
        }
        return this.uriTree.getPrefix() + uri;
    }

    public String formatUri(T data, String ... args) {
        return UriUtils.format(this.getUri(data), args);
    }

    public String formatFullUri(T data, String ... args) {
        return UriUtils.format(this.getFullUri(data), args);
    }

    public T lookup(FabricHTTPRequest url) throws UriTree.UriException {
        return this.lookup(url, url.getUri());
    }

    public T lookupPathInfo(FabricHTTPRequest url) throws UriTree.UriException {
        return this.lookup(url, url.getRequest().getPathInfo());
    }

    public T lookup(FabricHTTPRequest url, String uri) throws UriTree.UriException {
        UriTree.ParsedUri<T> parsedUri = this.uriTree.parse(uri);
        if (parsedUri == null) {
            return null;
        }
        url.setUriParameters(parsedUri.getParameters());
        return parsedUri.getData();
    }
}

