/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.service;

import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.servlet.ServletError;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.SwaggerServlet;
import com.streamscape.sef.network.http.server.swagger.Utils;
import com.streamscape.sef.network.http.server.swagger.dataspace.AccessList;
import com.streamscape.sef.network.http.server.swagger.service.ServiceSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.service.ServicesAccessList;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.StringTokenizer;
import javax.servlet.ServletException;

public class ServiceSwaggerBuilderFactory
extends SwaggerServlet.AbstractSwaggerBuilderFactory {
    private static String objectsParameter = "objects";
    private static String serviceNameParameter = "serviceName";
    private static String nodeNameParameter = "nodeName";
    private static String excludedHandlersParameter = "excludedHandlers";
    private static String includedHandlersParameter = "includedHandlers";

    @Override
    public SwaggerBuilder create(FabricHTTPRequest url, HTTPServerFabricConnection fabricConnection) throws ServletException, ServletError {
        return new ServiceSwaggerBuilder(ServiceSwaggerBuilderFactory.parseServiceAccessList(url), this.getClientParameter(url));
    }

    public SwaggerBuilder create(ServicesAccessList servicesAccessList, String client) {
        return new ServiceSwaggerBuilder(servicesAccessList, client);
    }

    public static ServicesAccessList parseServiceAccessList(FabricHTTPRequest url) throws ServletError {
        ServicesAccessList servicesAccessList = new ServicesAccessList();
        String objects = url.getParameter(objectsParameter);
        if (objects != null) {
            Utils.checkParameterNotEmpty(objectsParameter, objects);
            try {
                servicesAccessList = (ServicesAccessList)HTTPUtils.getJsonSerializerForJaxrx().deserialize(objects.getBytes());
            }
            catch (SerializerException exception) {
                throw new ServletError(400, "OMF", "Deserialization of objects failed.", exception);
            }
        } else {
            Object serviceName;
            String nodeName = url.getParameter(nodeNameParameter);
            if (nodeName != null) {
                nodeName = nodeName.trim();
                Utils.checkParameterNotEmpty(nodeNameParameter, nodeName);
                servicesAccessList.setNodeName(nodeName);
            }
            if ((serviceName = url.getUriParameter(serviceNameParameter)) == null) {
                serviceName = url.getParameter(serviceNameParameter);
            }
            if (serviceName != null) {
                serviceName = ((String)serviceName).trim();
                Utils.checkParameterNotEmpty(serviceNameParameter, (String)serviceName);
                StringTokenizer tokenizer = new StringTokenizer((String)serviceName, ".");
                if (tokenizer.countTokens() == 3 && nodeName != null) {
                    throw new ServletError(427, "URL", "If " + nodeNameParameter + " parameter is specfied " + serviceNameParameter + " should be in format [<NodeName>.]<ServiceType>.<ServiceName>.");
                }
                if (tokenizer.countTokens() < 2 || tokenizer.countTokens() > 3) {
                    throw new ServletError(427, "URL", "Invalid Service Resource '" + (String)serviceName + "'. Should be in format [<NodeName>.]<ServiceType>.<ServiceName>.");
                }
                if (nodeName != null) {
                    serviceName = nodeName + "." + (String)serviceName;
                }
                servicesAccessList.setServicesAccessList(new AccessList().include(new String[]{serviceName}));
            }
            ServicesAccessList.ServiceObjectsAccessList serviceObjectsAccessList = new ServicesAccessList.ServiceObjectsAccessList();
            serviceObjectsAccessList.includeHandlers(Utils.split(includedHandlersParameter, url.getParameter(includedHandlersParameter)));
            serviceObjectsAccessList.excludeHandlers(Utils.split(excludedHandlersParameter, url.getParameter(excludedHandlersParameter)));
            servicesAccessList.addServiceObjectsAccessList((String)serviceName, serviceObjectsAccessList);
        }
        return servicesAccessList;
    }
}

