/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.service;

import com.streamscape.Trace;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.lib.utils.SemanticTypeResolver;
import com.streamscape.runtime.mf.operation.service.ListServicesOperation;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sef.accessor.FabricComponentAccessor;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.server.swagger.AbstractSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.dataspace.SwaggerTypeResolver;
import com.streamscape.sef.network.http.server.swagger.service.ServicesAccessList;
import com.streamscape.service.osf.evh.EventHandler;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class ServiceSwaggerBuilder
extends AbstractSwaggerBuilder {
    private ServicesAccessList servicesAccessList;

    public ServiceSwaggerBuilder(ServicesAccessList servicesAccessList, String client) {
        super(client);
        this.servicesAccessList = servicesAccessList;
    }

    @Override
    public Swagger build() throws SwaggerBuilderException {
        Swagger swagger = new Swagger();
        this.setHost(swagger);
        this.setInfo(swagger);
        this.setSecurity(swagger);
        swagger.basePath(this.getBasePath());
        if (this.servicesAccessList.getServicesAccessList().isSingleName()) {
            Object fullName = this.servicesAccessList.getServicesAccessList().getSingleName();
            if (this.servicesAccessList.getNodeName() != null) {
                fullName = this.servicesAccessList.getNodeName() + "." + (String)fullName;
            }
            swagger.getInfo().title((String)fullName);
            swagger.getInfo().description("<div>REST API for invoking Service Operations.<br><table><tr><td>Service Type:</td><td>" + ModeratorUtils.extractComponentNameType(this.servicesAccessList.getServicesAccessList().getSingleName()) + "</td></tr><tr><td>Service Name:</td><td>" + ModeratorUtils.extractComponentNameName(this.servicesAccessList.getServicesAccessList().getSingleName()) + "</td></tr><tr><td>Full Name:</td><td>" + (String)fullName + "</td></tr></table></div>");
        } else {
            swagger.getInfo().title("StreamScape Service REST API.");
            swagger.getInfo().description("REST API for invoking Service Operations.");
        }
        return this.build(swagger);
    }

    public static ServiceAccessor createServiceAccessor(String serviceFullName, String nodeName, FabricConnection connection) throws FabricConnectionException, FabricComponentAccessorException {
        StringTokenizer tokenizer = new StringTokenizer(serviceFullName, ".");
        if (tokenizer.countTokens() == 3) {
            nodeName = tokenizer.nextToken();
        }
        String serviceType = tokenizer.nextToken();
        String serviceName = tokenizer.nextToken();
        return nodeName != null ? connection.createServiceAccessor(nodeName, serviceType, serviceName) : connection.createServiceAccessor(serviceType, serviceName);
    }

    @Override
    public Swagger build(Swagger swagger) throws SwaggerBuilderException {
        if (swagger.getBasePath() == null) {
            swagger.setBasePath(this.getBasePath());
        }
        this.swaggerTypeResolver = new SwaggerTypeResolver(swagger, new SemanticTypeResolver());
        List<String> services = ServiceSwaggerBuilder.listServices(this.servicesAccessList, this.connection);
        for (String service : services) {
            FabricComponentAccessor accessor = null;
            try {
                accessor = ServiceSwaggerBuilder.createServiceAccessor(service, this.servicesAccessList.getNodeName(), this.connection);
                String urlprefix = this.getPrefix(service);
                String tagprefix = this.servicesAccessList.getServicesAccessList().isSingleName() && this.getBasePath().contains(service) ? accessor.getComponentType() + " : " : "Service " + service + " : ";
                ServicesAccessList.ServiceObjectsAccessList serviceObjectsAccessList = this.getServiceObjectsAccessList(service);
                this.addEventHandlersCalls(swagger, urlprefix, tagprefix, (ServiceAccessor)accessor, service, serviceObjectsAccessList);
                if (serviceObjectsAccessList.getGenericInvokeMethodMask() == null) continue;
                this.addGenericInvokeCall(swagger, urlprefix, tagprefix, (ServiceAccessor)accessor, service, serviceObjectsAccessList.getGenericInvokeMethodMask());
            }
            catch (SwaggerBuilderException exception) {
                throw exception;
            }
            catch (Exception exception) {
                Trace.logError(this, exception.getMessage());
                throw new SwaggerBuilderException("Failed to create service accessor to '" + service + "'.", exception);
            }
            finally {
                try {
                    if (accessor == null) continue;
                    accessor.close();
                }
                catch (Exception exception) {}
            }
        }
        return swagger;
    }

    private void addGenericInvokeCall(Swagger swagger, String urlprefix, String tagprefix, ServiceAccessor accessor, String serviceFullName, String genericInvokeMethodMask) throws SwaggerBuilderException {
        Path path = new Path();
        swagger.path(urlprefix, path);
        String tag = tagprefix + "General Service Invoke";
        swagger.tag(new Tag().name(tag));
        if (genericInvokeMethodMask.contains("*") || genericInvokeMethodMask.contains("GET")) {
            Operation operation = new Operation();
            operation.tag(tag);
            operation.summary("Generic REST call to invoke service '" + serviceFullName + "'.");
            operation.description("Generic REST call to invoke service '" + serviceFullName + "'.<br>Service can be invoked by handler name or by event ID depending on specified parameters.");
            this.setSecurityDefinitionsForOperation(swagger, operation);
            this.addDefaultProduces(operation);
            this.addDefaultResponses(operation);
            QueryParameter parameter = (QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("eventHandler")).description("Service handler name. One of handlerName or eventId should be specified.")).required(false)).type("string");
            List<String> handlers = null;
            try {
                handlers = accessor.listEventHandlers();
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to list event handlers for service " + serviceFullName);
                Trace.logException(this, exception, false);
            }
            if (handlers != null) {
                handlers.sort((o1, o2) -> o1.compareToIgnoreCase((String)o2));
                parameter._enum(handlers);
            }
            operation.parameter((Parameter)parameter);
            List eventIds = null;
            try {
                eventIds = accessor.getEventHandlers().stream().map(h -> h.getRequestEventId()).filter(e -> e != null && e.trim().length() > 0).collect(Collectors.toList());
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to get event handlers for service " + serviceFullName);
                Trace.logException(this, exception, false);
            }
            QueryParameter parameter2 = (QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("eventId")).description("Event ID. One of 'handlerName' or 'eventId' should be specified.")).required(false)).type("string");
            if (eventIds != null) {
                eventIds.sort((o1, o2) -> o1.compareToIgnoreCase((String)o2));
                parameter2._enum(eventIds);
            }
            operation.parameter((Parameter)parameter2);
            operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("data")).description("Data object serialized in corresponding format. One of 'data' or 'event' should be specified.")).required(false)).type("string"));
            operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("event")).description("Event serialized in corresponding format. One of 'eventId', 'event' or 'dataHandler' should be specified.")).required(false)).type("string"));
            this.addTimeoutParameter(operation);
            this.addLoadBalanceParameter(operation);
            operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("correlationId")).description("Event correlation ID.")).required(false)).type("string"));
            operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("eventGroupId")).description("Event group ID.")).required(false)).type("string"));
            operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("eventKey")).description("Event key.")).required(false)).type("string"));
            operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("durable")).description("Event durable or not.")).required(false)).type("boolean"));
            operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("eventProperties")).description("Event properties in format propertyName1=value1;....")).required(false)).type("string"));
            operation.response(200, new Response().description("Response").schema((Property)new StringProperty()));
            this.addRequestFormatParameter(operation);
            this.addResponseFormatParameter(operation);
            path.get(operation);
        }
    }

    private void addEventHandlersCalls(Swagger swagger, String urlprefix, String tagprefix, ServiceAccessor accessor, String serviceFullName, ServicesAccessList.ServiceObjectsAccessList serviceObjectsAccessList) throws SwaggerBuilderException {
        ServicesAccessList.ServiceObjectsAccessList serviceAccessList = this.servicesAccessList.getServiceObjectsAccessList(serviceFullName);
        try {
            ArrayList<EventHandler> handlers = new ArrayList<EventHandler>(accessor.getEventHandlers());
            handlers.sort((o1, o2) -> o1.getHandlerName().compareToIgnoreCase(o2.getHandlerName()));
            for (EventHandler eventHandler : handlers) {
                if (!serviceAccessList.getHandlers().isAllowed(eventHandler.getHandlerName(), "POST")) continue;
                this.addEventHandlerCallByName(swagger, urlprefix, tagprefix, serviceFullName, eventHandler);
            }
        }
        catch (FabricComponentAccessorException exception) {
            throw new SwaggerBuilderException("Failed to get event handlers list for service '" + serviceFullName + "'.", exception);
        }
    }

    private void addEventHandlerCallByName(Swagger swagger, String urlprefix, String tagprefix, String serviceFullName, EventHandler eventHandler) throws SwaggerBuilderException {
        urlprefix = (String)urlprefix + (((String)urlprefix).endsWith("/") ? "" : "/");
        urlprefix = (String)urlprefix + eventHandler.getHandlerName();
        Path path = new Path();
        swagger.path((String)urlprefix, path);
        String tag = tagprefix + eventHandler.getHandlerName();
        swagger.tag(new Tag().name(tag));
        this.addEventHandlerOperation(swagger, path, tag, serviceFullName, eventHandler);
    }

    private void addEventHandlerOperation(Swagger swagger, Path path, String tag, String serviceFullName, EventHandler eventHandler) throws SwaggerBuilderException {
        Operation operation = new Operation();
        operation.tag(tag);
        operation.summary("REST call to invoke service event handler.");
        this.setSecurityDefinitionsForOperation(swagger, operation);
        operation.description("REST call to invoke service event handler.");
        this.addDefaultResponses(operation);
        this.addDefaultProducesXmlJson(operation);
        String result = ServiceSwaggerBuilder.getSemanticTypeOrEventId(eventHandler.getResponseSemanticType(), eventHandler.getResponseEventId(), this.swaggerTypeResolver);
        if (result != null) {
            if (result == eventHandler.getResponseEventId()) {
                Response response = new Response().description("Event handler response");
                this.schemaEvent(response, result);
                operation.response(200, response);
            } else {
                Response response = new Response().description("Event handler response");
                this.schema(response, result);
                operation.response(200, response);
            }
        } else {
            this.addResponseFormatParameter(operation);
        }
        this.addDefaultConsumesXmlJson(operation);
        ServiceSwaggerBuilder.addDataBodyParameter(eventHandler, operation, this.swaggerTypeResolver, this);
        this.addTimeoutParameter(operation);
        path.post(operation);
    }

    public static void addDataBodyParameter(EventHandler eventHandler, Operation operation, SwaggerTypeResolver swaggerTypeResolver, AbstractSwaggerBuilder builder) throws SwaggerBuilderException {
        String result = ServiceSwaggerBuilder.getSemanticTypeOrEventId(eventHandler.getRequestSemanticType(), eventHandler.getRequestEventId(), swaggerTypeResolver);
        String dataParameterDescription = "Data object of type '" + eventHandler.getRequestSemanticType() + "' serialized in corresponding format.";
        if (result == eventHandler.getRequestEventId()) {
            dataParameterDescription = "Event [" + eventHandler.getRequestEventId() + "] serialized in corresponding format.";
        }
        BodyParameter bodyParameter = new BodyParameter();
        if (result == null || !result.equalsIgnoreCase("void")) {
            if (result != null) {
                if (result == eventHandler.getRequestEventId()) {
                    builder.schemaEventWrapper(bodyParameter, eventHandler.getHandlerName(), result);
                } else {
                    builder.schema(bodyParameter, result);
                }
            } else {
                bodyParameter.schema((Model)new RefModel("string"));
            }
            bodyParameter.name("data").description(dataParameterDescription);
            bodyParameter.setRequired(true);
            operation.parameter((Parameter)bodyParameter);
        }
    }

    public static String getSemanticTypeOrEventId(String semanticType, String eventId, SwaggerTypeResolver swaggerTypeResolver) {
        block4: {
            if (semanticType == null || semanticType.trim().length() == 0) {
                return eventId;
            }
            try {
                Class<?> semanticTypeClass = swaggerTypeResolver.getSemanticTypeResolver().resolveSemanticType(semanticType);
                if (ImmutableEventDatagram.class.isAssignableFrom(semanticTypeClass)) {
                    return eventId;
                }
            }
            catch (Exception exception) {
                if (!semanticType.equals("event") && !semanticType.equals("ImmutableEventDatagram")) break block4;
                return eventId;
            }
        }
        return semanticType;
    }

    private void addTimeoutParameter(Operation operation) {
        ServiceSwaggerBuilder.addTimeoutParameter(operation, new QueryParameter().name("timeout"));
    }

    public static void addTimeoutParameter(Operation operation, AbstractSerializableParameter parameter) {
        operation.parameter((Parameter)parameter.description("Invoke timeout in milliseconds. Default value is 30000ms.").required(false).type("integer"));
    }

    private void addLoadBalanceParameter(Operation operation) {
        operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("loadBalance")).description("Load balance.")).required(false)).type("string"))._enum(Arrays.asList(RequestDistributionStrategy.AUCTION.toString(), RequestDistributionStrategy.CYCLIC.toString(), RequestDistributionStrategy.FAIR.toString(), RequestDistributionStrategy.WEIGHTED.toString())));
    }

    private void addDefaultResponses(Operation operation) throws SwaggerBuilderException {
        operation.response(200, new Response().description("OK"));
        operation.response(400, new Response().description("Invalid Request"));
        operation.response(404, new Response().description("Not Found"));
        operation.response(500, this.httpExceptionResponse().description("Service error"));
    }

    public static List<String> listServices(ServicesAccessList accessList, FabricConnection connection) throws SwaggerBuilderException {
        String nodeName = accessList.getNodeName();
        List<String> services = accessList.getServicesAccessList().getExactNames();
        if (services.size() == 0) {
            FabricNodeReference node;
            try {
                if (nodeName != null) {
                    node = connection.getModerator().lookupFabricNode(nodeName);
                    if (node == null) {
                        throw new SwaggerBuilderException("Node '" + nodeName + "' not found.");
                    }
                } else {
                    node = connection.getModerator().getFabricNode();
                }
            }
            catch (SwaggerBuilderException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new SwaggerBuilderException("Failed to get fabric node.", exception);
            }
            List<String> componentNames = node.listComponents();
            for (String componentName : componentNames) {
                ComponentReference component = node.lookupComponent(componentName);
                if (component.getModel() != ComponentModel.SERVICE) continue;
                componentName = ModeratorUtils.extractComponentName(componentName);
                Object componentFullName = componentName;
                if (nodeName != null) {
                    componentFullName = nodeName + "." + componentName;
                }
                if (ListServicesOperation.isSystemService(ModeratorUtils.extractComponentNameType(componentName), ModeratorUtils.extractComponentNameName(componentName)) || accessList.getServicesAccessList().isExcluded(componentName) || accessList.getServicesAccessList().isExcluded((String)componentFullName) || !accessList.getServicesAccessList().isAllowed(componentName) && !accessList.getServicesAccessList().isAllowed((String)componentFullName)) continue;
                services.add((String)componentFullName);
            }
        }
        return services;
    }

    private String getBasePath() {
        if (this.basePath != null) {
            return this.basePath;
        }
        return this.servicesAccessList.getServicesAccessList().isSingleName() ? "/service/invoke/" + this.servicesAccessList.getServicesAccessList().getSingleName() : "/service/invoke";
    }

    private String getPrefix(String service) {
        if (this.basePath != null) {
            if (this.basePath.equals("/")) {
                return "/service/invoke/" + service;
            }
            if (this.basePath.equalsIgnoreCase("/service")) {
                return "/invoke/" + service;
            }
            return "";
        }
        return this.servicesAccessList.getServicesAccessList().isSingleName() ? "/" : "/" + service;
    }

    private ServicesAccessList.ServiceObjectsAccessList getServiceObjectsAccessList(String service) {
        return this.servicesAccessList.getServiceObjectsAccessList(service);
    }
}

