/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.service;

import com.streamscape.Trace;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApplicationResourceMatcher;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspaceApiDiscover;
import com.streamscape.sef.network.http.server.swagger.service.ServiceSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.service.ServicesAccessList;
import java.util.List;
import java.util.Set;

public class ServiceApiDiscover {
    private FabricConnection connection;
    private Set<Application.Resource> resources;
    private ApplicationResourceMatcher.Matcher matcher;

    public ServiceApiDiscover(FabricConnection connection, Set<Application.Resource> resources) {
        this.connection = connection;
        this.resources = resources;
        this.matcher = ApplicationResourceMatcher.create(resources, (method, url) -> new Application.Resource(method, url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServicesAccessList discoverServicesAccessList() throws SwaggerBuilderException {
        ServicesAccessList allowAllList = new ServicesAccessList();
        ServicesAccessList accessList = new ServicesAccessList();
        List<String> services = ServiceSwaggerBuilder.listServices(allowAllList, this.connection);
        for (String service : services) {
            ServiceAccessor accessor = null;
            try {
                accessor = ServiceSwaggerBuilder.createServiceAccessor(service, null, this.connection);
                ServicesAccessList.ServiceObjectsAccessList objectsAccessList = new ServicesAccessList.ServiceObjectsAccessList();
                boolean accepted = false;
                accepted |= this.acceptEventHandlers(accessor, service, objectsAccessList);
                if (!(accepted |= this.acceptGenericInvoke(service, objectsAccessList))) continue;
                accessList.getServicesAccessList().include(service);
                accessList.addServiceObjectsAccessList(service, objectsAccessList);
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to create accessor to service '{}'.", service);
                Trace.logException(this, exception, true);
            }
            finally {
                if (accessor == null) continue;
                accessor.close();
                accessor = null;
            }
        }
        return accessList.isEmpty() ? null : accessList;
    }

    private boolean acceptEventHandlers(ServiceAccessor accessor, String service, ServicesAccessList.ServiceObjectsAccessList objectsAccessList) throws FabricComponentAccessorException {
        boolean accepted = false;
        String handlerInvokePrefix = "/service/invoke/" + service;
        for (String eventHandler : accessor.listEventHandlers()) {
            String handlerInvoke = handlerInvokePrefix + "/" + eventHandler;
            ApplicationResourceMatcher.ResourceInfo info = this.matcher.matches(handlerInvoke);
            String mask = DataspaceApiDiscover.getMethodMask(info);
            if (mask.length() <= 0) continue;
            objectsAccessList.includeHandler(eventHandler, mask);
            accepted = true;
        }
        if (!accepted) {
            objectsAccessList.excludeHandlers("*");
        }
        return accepted;
    }

    private boolean acceptGenericInvoke(String service, ServicesAccessList.ServiceObjectsAccessList accessList) {
        String genericInvoke = "/service/invoke/" + service;
        ApplicationResourceMatcher.ResourceInfo info = this.matcher.matches(genericInvoke);
        String mask = DataspaceApiDiscover.getMethodMask(info);
        if (mask.length() > 0) {
            accessList.setGenericInvokeMethodMask(mask);
            return true;
        }
        accessList.setGenericInvokeMethodMask(null);
        return false;
    }
}

