/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.importer;

import com.streamscape.Trace;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.importer.SwaggerImporter;
import com.streamscape.tools.dag.DAG;
import com.streamscape.tools.dag.TopologicalSorter;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SwaggerImporterTypeCache {
    private final Swagger swagger;
    private final SwaggerImporter.ModelNamesRewriter rewriter;
    private final Map<String, SwaggerSdoModel> swaggerSdoModelsMap = new HashMap<String, SwaggerSdoModel>();
    private String namespace;
    private String packageName;
    private boolean addPackage;
    private String archiveName;
    private boolean addArchive;

    public SwaggerImporterTypeCache(Swagger swagger, SwaggerImporter.ModelNamesRewriter rewriter) {
        this.swagger = swagger;
        this.rewriter = rewriter;
    }

    public void importModels() {
        for (Map.Entry entry : this.swagger.getDefinitions().entrySet()) {
            this.importModel((String)entry.getKey(), (Model)entry.getValue());
        }
    }

    public void importModel(RefProperty refProperty) {
        this.importModel(refProperty.getSimpleRef());
    }

    public void importModel(RefModel refModel) {
        this.importModel(refModel.getSimpleRef());
    }

    public boolean importModel(String ref) {
        Model model = (Model)this.swagger.getDefinitions().get(ref);
        if (model != null) {
            this.importModel(ref, model);
            return true;
        }
        return false;
    }

    private void importModel(String name, Model model) {
        if (model instanceof ModelImpl) {
            this.importModelImpl(name, (ModelImpl)model);
        }
    }

    private void importModelImpl(String name, ModelImpl model) {
        if (this.swaggerSdoModelsMap.containsKey(name)) {
            return;
        }
        SwaggerSdoModel swaggerSdoModel = new SwaggerSdoModel(name);
        for (Map.Entry entry : model.getProperties().entrySet()) {
            Property property = (Property)entry.getValue();
            String type = SwaggerImporterTypeCache.resolvePropertyType(property, swaggerSdoModel.references, this.rewriter);
            swaggerSdoModel.fields.add(new SwaggerSdoModelField((String)entry.getKey(), type));
        }
        for (String reference : swaggerSdoModel.references) {
            this.importModel(reference);
        }
        this.swaggerSdoModelsMap.put(swaggerSdoModel.name, swaggerSdoModel);
    }

    public static String resolvePropertyType(Property property, List<String> dependencies, SwaggerImporter.ModelNamesRewriter rewriter) {
        Object type = "object";
        if ("integer".equalsIgnoreCase(property.getType())) {
            type = "long";
            if ("int32".equalsIgnoreCase(property.getFormat())) {
                type = "int";
            } else if ("int64".equalsIgnoreCase(property.getFormat())) {
                type = "long";
            } else {
                Trace.logError(SwaggerImporterTypeCache.class, "Unknown property format '" + property.getFormat() + "' of type '" + property.getType() + "'.");
            }
        } else if ("number".equalsIgnoreCase(property.getType())) {
            type = "double";
            if ("float".equalsIgnoreCase(property.getFormat())) {
                type = "float";
            } else if ("double".equalsIgnoreCase(property.getFormat())) {
                type = "double";
            } else {
                Trace.logError(SwaggerImporterTypeCache.class, "Unknown property format '" + property.getFormat() + "' of type '" + property.getType() + "'.");
            }
        } else if ("string".equalsIgnoreCase(property.getType())) {
            type = "string";
            if ("byte".equalsIgnoreCase(property.getFormat())) {
                type = "string";
            } else if ("binary".equalsIgnoreCase(property.getFormat())) {
                type = "byte[]";
            } else if ("string".equalsIgnoreCase(property.getFormat()) || "".equalsIgnoreCase(property.getFormat()) || "password".equalsIgnoreCase(property.getFormat())) {
                type = "string";
            } else if ("date".equalsIgnoreCase(property.getFormat())) {
                type = "SqlDate";
            } else if ("date-time".equalsIgnoreCase(property.getFormat())) {
                type = "date";
            } else {
                Trace.logError(SwaggerImporterTypeCache.class, "Unknown property format '" + property.getFormat() + "' of type '" + property.getType() + "'.");
            }
        } else if ("boolean".equalsIgnoreCase(property.getType())) {
            type = "boolean";
        } else if ("array".equalsIgnoreCase(property.getType())) {
            String itemType = SwaggerImporterTypeCache.resolvePropertyType(((ArrayProperty)property).getItems(), dependencies, rewriter);
            type = "list(" + itemType + ")";
        } else if ("ref".equalsIgnoreCase(property.getType())) {
            type = rewriter.rewrite(((RefProperty)property).getSimpleRef());
            if (dependencies != null) {
                dependencies.add(((RefProperty)property).getSimpleRef());
            }
        } else if (property instanceof MapProperty) {
            type = "map(string, " + property.getType().toLowerCase() + ")";
        } else {
            Trace.logError(SwaggerImporterTypeCache.class, "Unknown property ' of type '" + property.getType() + "' and format '" + property.getFormat() + "'.");
        }
        return type;
    }

    public Map<String, String> getSwaggerSdoModelsCommands(boolean alter) throws SwaggerBuilderException {
        List<SwaggerSdoModel> swaggerSdoModels = this.getTopologyOrderedModels(this.swaggerSdoModelsMap);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (SwaggerSdoModel swaggerSdoModel : swaggerSdoModels) {
            StringBuilder builder = new StringBuilder();
            String action = alter ? "alter" : "create";
            builder.append(action + " sdo " + this.rewriter.rewrite(swaggerSdoModel.name)).append("\n");
            builder.append("  as\n");
            builder.append("  {\n");
            for (SwaggerSdoModelField field : swaggerSdoModel.fields) {
                Object name = field.name;
                if (org.apache.commons.lang3.StringUtils.containsAny((CharSequence)field.name, (char[])new char[]{'-', ':', ' '})) {
                    String aliasName = StringUtils.toCamelCase(field.name, false, '-', ':', ' ');
                    name = aliasName + " alias '" + field.name + "'";
                }
                builder.append("    " + field.type + " " + (String)name + ";\n");
            }
            builder.append("  }\n");
            if (!alter) {
                builder.append("  namespace ").append(this.namespace).append("\n");
                builder.append(this.addArchive ? "  add " : "  replace ").append("archive ").append(this.archiveName).append("\n");
                builder.append(this.addPackage ? "  add " : "  replace ").append("package ").append(this.packageName).append("\n");
            }
            result.put(swaggerSdoModel.name, builder.toString());
        }
        return result;
    }

    public Map<String, String> getSwaggerSdoModelsCommands() throws SwaggerBuilderException {
        return this.getSwaggerSdoModelsCommands(false);
    }

    public List<SwaggerSdoModel> getTopologyOrderedModels(Map<String, SwaggerSdoModel> swaggerSdoModels) throws SwaggerBuilderException {
        try {
            DAG dag = new DAG();
            for (SwaggerSdoModel model : swaggerSdoModels.values()) {
                for (String refModelName : model.references) {
                    dag.addEdge(model.name, refModelName);
                }
            }
            List<String> sortedModelNames = TopologicalSorter.sort(dag);
            LinkedList<SwaggerSdoModel> res = new LinkedList<SwaggerSdoModel>();
            for (String modelName : sortedModelNames) {
                res.add(swaggerSdoModels.get(modelName));
            }
            for (String modelName : swaggerSdoModels.keySet()) {
                if (sortedModelNames.contains(modelName)) continue;
                res.add(swaggerSdoModels.get(modelName));
            }
            return res;
        }
        catch (Exception e) {
            throw new SwaggerBuilderException(e.getMessage());
        }
    }

    private Set<String> getAllReferences(SwaggerSdoModel m, Set<String> set) {
        if (m == null) {
            return set;
        }
        set.addAll(m.references);
        for (String reference : m.references) {
            if (set.contains(reference)) continue;
            this.getAllReferences(this.swaggerSdoModelsMap.get(reference), set);
        }
        set.remove(m.name);
        return set;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setPackage(String packageName, boolean addPackage) {
        this.packageName = packageName;
        this.addPackage = addPackage;
    }

    public void setArchive(String archiveName, boolean addArchive) {
        this.archiveName = archiveName;
        this.addArchive = addArchive;
    }

    public SwaggerImporter.ModelNamesRewriter getRewriter() {
        return this.rewriter;
    }

    public static class SwaggerSdoModel {
        private String name;
        private List<String> references = new ArrayList<String>();
        private List<SwaggerSdoModelField> fields = new ArrayList<SwaggerSdoModelField>();

        public SwaggerSdoModel(String name) {
            this.name = name;
        }
    }

    public static class SwaggerSdoModelField {
        private String name;
        private String type;

        public SwaggerSdoModelField(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

