/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.importer;

import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.importer.SwaggerImporterTypeCache;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SwaggerImporter {
    private final Swagger swagger;
    private String httpFactoryName = "SwaggerImported";
    private String httpFactoryFullName = "HTTP." + this.httpFactoryName;
    private String dataspaceFullName = null;
    private String webServerName = "SwaggerImported";
    private boolean withSdo;
    private List<ImportOperationInfo> importOperationInfos;
    private final ModelNamesRewriter rewriter = new ModelNamesRewriter();
    private final SwaggerImporterTypeCache typeCache;
    private String httpFactoryCreateCommand;
    private String webServerCreateCommand;
    private Map<String, HTTPRequest> httpRequestMap = new HashMap<String, HTTPRequest>();

    public SwaggerImporter(Swagger swagger) {
        this.swagger = swagger;
        this.typeCache = new SwaggerImporterTypeCache(swagger, this.rewriter);
    }

    public void buildDefinitions() throws SwaggerBuilderException {
        this.buildHttpFactoryDefinition();
        this.buildWebServerDefinition();
        this.buildHttpRequests();
        if (this.withSdo) {
            this.importModels();
        }
    }

    public String getHttpFactoryFullName() {
        return this.httpFactoryFullName;
    }

    public SwaggerImporter setHttpFactoryFullName(String httpFactoryFullName) {
        this.httpFactoryFullName = httpFactoryFullName;
        return this;
    }

    public String getDataspaceFullName() {
        return this.dataspaceFullName;
    }

    public SwaggerImporter setDataspaceFullName(String dataspaceFullName) {
        this.dataspaceFullName = dataspaceFullName;
        return this;
    }

    public String getWebServerName() {
        return this.webServerName;
    }

    public SwaggerImporter setWebServerName(String webServerName) {
        this.webServerName = webServerName;
        return this;
    }

    public void addImportOperationInfo(ImportOperationInfo importOperationInfo) {
        if (this.importOperationInfos == null) {
            this.importOperationInfos = new ArrayList<ImportOperationInfo>();
        }
        this.importOperationInfos.add(importOperationInfo);
    }

    public void setWithSdo(boolean withSdo) {
        this.withSdo = withSdo;
    }

    public boolean getWithSdo() {
        return this.withSdo;
    }

    public ModelNamesRewriter getRewriter() {
        return this.rewriter;
    }

    public String getHttpFactoryCreateCommand() {
        return this.httpFactoryCreateCommand;
    }

    public String getWebServerCreateCommand() {
        return this.webServerCreateCommand;
    }

    public List<String> getHttpRequestsCreateCommands() {
        return this.httpRequestsToCommands();
    }

    public Map<String, HTTPRequest> getHttpRequests() {
        return this.httpRequestMap;
    }

    public Map<String, String> getSemanticTypesCreateCommands() throws SwaggerBuilderException {
        return this.typeCache.getSwaggerSdoModelsCommands();
    }

    public Map<String, String> getSemanticTypesAlterCommands() throws SwaggerBuilderException {
        return this.typeCache.getSwaggerSdoModelsCommands(true);
    }

    public void buildHttpFactoryDefinition() throws SwaggerBuilderException {
        StringBuilder builder = new StringBuilder();
        builder.append("create http connection factory ").append(this.httpFactoryName);
        Object url = this.swagger.getHost().trim();
        if (((String)url).indexOf("://") == -1) {
            if (this.swagger.getSchemes().contains(Scheme.HTTP)) {
                url = "http://" + (String)url;
            } else if (this.swagger.getSchemes().contains(Scheme.HTTPS)) {
                url = "https://" + (String)url;
            } else {
                throw new SwaggerBuilderException("Unsupported schemas '" + String.valueOf(this.swagger.getSchemes()) + "'.");
            }
        }
        builder.append(" url '").append((String)url).append("'\n");
        builder.append("  set properties(\n");
        builder.append("    description='Factory generated from swagger definition.',\n");
        builder.append("    EnableOAuth=true,\n");
        builder.append("    TrustAllCertificates=true\n");
        builder.append("  )");
        this.httpFactoryCreateCommand = builder.toString();
    }

    public void buildWebServerDefinition() {
        StringBuilder builder = new StringBuilder();
        builder.append("create virtual web server [").append(this.webServerName).append("] using ").append(this.httpFactoryFullName);
        this.webServerCreateCommand = builder.toString();
    }

    public void buildHttpRequests() throws SwaggerBuilderException {
        if (this.importOperationInfos != null && this.importOperationInfos.size() > 0) {
            for (ImportOperationInfo info : this.importOperationInfos) {
                Path path = (Path)this.swagger.getPaths().get(info.path);
                if (path == null) {
                    throw new SwaggerBuilderException("Operation with path '" + info.path + "' doesn't exist.");
                }
                if (info.method == null) continue;
                HttpMethod method = HttpMethod.valueOf((String)info.method.toUpperCase());
                Operation operation = (Operation)path.getOperationMap().get(method);
                if (operation == null) {
                    throw new SwaggerBuilderException("Operation with path '" + info.path + "' and method '" + info.method + "' doesn't exist.");
                }
                this.buildHttpRequest(info.path, method, operation, info.name, info.withSdo);
            }
        } else {
            for (Map.Entry entry : this.swagger.getPaths().entrySet()) {
                for (Map.Entry operationEntry : ((Path)entry.getValue()).getOperationMap().entrySet()) {
                    this.buildHttpRequest((String)entry.getKey(), (HttpMethod)operationEntry.getKey(), (Operation)operationEntry.getValue(), null, false);
                }
            }
            if (this.withSdo) {
                this.importModels();
            }
        }
    }

    private void buildHttpRequest(String uri, HttpMethod method, Operation operation, String requestName, boolean withSdo) {
        String ref;
        Property schema;
        if (requestName == null) {
            requestName = this.uriToRequestName(uri) + "_" + method.toString().toLowerCase();
        }
        HTTPRequest request = new HTTPRequest();
        request.setMethod(method.toString());
        request.setUri(UriMatcher.normalizeUriWithLastSlashRemove(this.swagger.getBasePath() + uri));
        for (Parameter parameter : operation.getParameters()) {
            if (parameter instanceof QueryParameter) {
                request.addQueryParameter(parameter.getName(), ((QueryParameter)parameter).getDefaultValue());
                continue;
            }
            if (parameter instanceof HeaderParameter) {
                request.addHeader(parameter.getName(), ((HeaderParameter)parameter).getDefaultValue());
                continue;
            }
            if (parameter instanceof FormParameter) {
                request.addFormParameter(parameter.getName(), ((FormParameter)parameter).getDefaultValue());
                continue;
            }
            if (parameter instanceof CookieParameter) {
                request.addCookie(parameter.getName(), ((CookieParameter)parameter).getDefaultValue());
                continue;
            }
            if (parameter instanceof BodyParameter) {
                Map examples = ((BodyParameter)parameter).getExamples();
                if (examples != null) {
                    for (Map.Entry entry : examples.entrySet()) {
                        if (!((String)entry.getKey()).contains("json")) continue;
                        request.setData((String)entry.getValue());
                    }
                }
                if (!((schema = ((BodyParameter)parameter).getSchema()) instanceof RefModel)) continue;
                ref = ((RefModel)schema).getSimpleRef();
                request.setRequestSemanticType(this.rewriter.rewrite(ref));
                if (!withSdo) continue;
                this.typeCache.importModel((RefModel)schema);
                continue;
            }
            if (!(parameter instanceof PathParameter)) continue;
        }
        for (Map.Entry entry : operation.getResponses().entrySet()) {
            String code = (String)entry.getKey();
            if ("default".equals(code)) {
                code = "*";
            }
            if ((schema = ((Response)entry.getValue()).getSchema()) == null) continue;
            ref = SwaggerImporterTypeCache.resolvePropertyType(schema, null, this.rewriter);
            request.getResponseSemanticTypes().set(code, "//", ref);
            if (!withSdo || !(schema instanceof RefProperty)) continue;
            this.typeCache.importModel((RefProperty)schema);
        }
        this.httpRequestMap.put((String)requestName, request);
    }

    public boolean importModel(String ref) {
        return this.typeCache.importModel(ref);
    }

    public void importModels() {
        this.typeCache.importModels();
    }

    private String uriToRequestName(String uri) {
        uri = UriMatcher.normalizeUriWithLastSlashRemove(uri);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (Character.isLetterOrDigit(c) || "_-".indexOf(c) != -1) {
                builder.append(c);
                continue;
            }
            if (builder.length() == 0) continue;
            builder.append("_");
        }
        return builder.toString();
    }

    private List<String> httpRequestsToCommands() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, HTTPRequest> entry : this.httpRequestMap.entrySet()) {
            StringBuilder builder = new StringBuilder();
            HTTPRequest request = entry.getValue();
            builder.append("create http request ").append(entry.getKey());
            builder.append("\n  method ").append(request.getMethod().toLowerCase());
            builder.append("\n  uri '").append(request.getUri()).append("'");
            if (request.getDataString() != null) {
                builder.append("\n  body data '").append(request.getDataString().replaceAll("'", "''"));
            }
            this.appendNameValueMap(builder, "\n  query parameters", request.getQueryParameters());
            this.appendNameValueMap(builder, "\n  form parameters", request.getFormParameters());
            this.appendNameValueMap(builder, "\n  headers", request.getHeaders());
            this.appendNameValueMap(builder, "\n  cookies", request.getCookies());
            Map<String, Map<String, String>> map = request.getResponseSemanticTypes().getMap();
            if (map != null && map.size() > 0) {
                boolean first1 = true;
                builder.append("\n  response semantic types (");
                for (Map.Entry<String, Map<String, String>> entry1 : map.entrySet()) {
                    if (!first1) {
                        builder.append(",");
                    }
                    builder.append("\n    '").append(entry1.getKey()).append("' (");
                    boolean first2 = true;
                    for (Map.Entry<String, String> entry2 : entry1.getValue().entrySet()) {
                        if (!first2) {
                            builder.append(", ");
                        }
                        builder.append("'").append(entry2.getKey()).append("' '").append(entry2.getValue()).append("'");
                        first2 = false;
                    }
                    builder.append(")");
                    first1 = false;
                }
                builder.append(")");
            }
            if (request.getRequestSemanticType() != null) {
                builder.append("\n  request semantic type '").append(request.getRequestSemanticType()).append("'");
            }
            result.add(builder.toString());
        }
        return result;
    }

    private void appendNameValueMap(StringBuilder builder, String name, Map<String, String> map) {
        if (map != null && map.size() > 0) {
            builder.append(name).append("(");
            builder.append(map.entrySet().stream().map(e -> "'" + ((String)e.getKey()).replaceAll("'", "''") + "' " + (String)(e.getValue() != null ? "'" + ((String)e.getValue()).replaceAll("'", "''") + "'" : "null")).collect(Collectors.joining(",")));
            builder.append(")");
        }
    }

    public void setNamespace(String namespace) {
        this.typeCache.setNamespace(namespace);
    }

    public void setArchive(String archiveName, boolean addArchive) {
        this.typeCache.setArchive(archiveName, addArchive);
    }

    public void setPackage(String packageName, boolean addPackage) {
        this.typeCache.setPackage(packageName, addPackage);
    }

    public static class ModelNamesRewriter {
        private String prefix;
        private String postfix;
        private Map<String, String> aliases = new HashMap<String, String>();

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public void setPostfix(String postfix) {
            this.postfix = postfix;
        }

        public Map<String, String> getAliases() {
            return this.aliases;
        }

        public void setAliases(Map<String, String> aliases) {
            this.aliases = aliases;
        }

        public void addAlias(String name, String alias) {
            this.aliases.put(name, alias);
        }

        public String rewrite(String name) {
            if (this.aliases.containsKey(name)) {
                return this.aliases.get(name);
            }
            if (this.prefix != null) {
                name = this.prefix + (String)name;
            }
            if (this.postfix != null) {
                name = (String)name + this.postfix;
            }
            return name;
        }
    }

    public static class ImportOperationInfo {
        public String path;
        public String method;
        public String name;
        public boolean withSdo;

        public ImportOperationInfo(String path, String method, String name, boolean withSdo) {
            this.path = path;
            this.method = method;
            this.name = name;
            this.withSdo = withSdo;
        }
    }
}

