/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.eventwrapper;

import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.AdvisoryEvent;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.AcknowledgementEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.AdvisoryEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.AuditEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.BytesEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.DataEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.DeltaEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.EventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.ExceptionEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.FileEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.MailEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.MapEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.OpaqueEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.ReflectiveEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.ReflectiveExceptionEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.StreamStateEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.TextEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.XMLEventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.XMPPEventWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EventWrapperFactory {
    private static final Map<Class<?>, EventWrapper<?>> wrappers = new ConcurrentHashMap();

    private static void add(EventWrapper wrapper) {
        wrappers.put(wrapper.getModelEventClass(), wrapper);
    }

    public static EventWrapper createEventWrapper(ImmutableEventDatagram event) {
        ReflectiveEventWrapper wrapper = wrappers.get(event.getClass());
        if (wrapper == null && event instanceof AdvisoryEvent) {
            wrapper = new AdvisoryEventWrapper((Class)event.getClass());
            wrappers.put(wrapper.getModelEventClass(), wrapper);
        }
        if (wrapper == null && event instanceof IAbstractExceptionEvent) {
            wrapper = new ReflectiveExceptionEventWrapper((Class)event.getClass());
            wrappers.put(wrapper.getModelEventClass(), wrapper);
        }
        if (wrapper == null) {
            throw new IllegalArgumentException("Event model '" + event.getClass().getName() + "' not supported.");
        }
        return wrapper;
    }

    static {
        EventWrapperFactory.add(new AcknowledgementEventWrapper());
        EventWrapperFactory.add(new AuditEventWrapper());
        EventWrapperFactory.add(new BytesEventWrapper());
        EventWrapperFactory.add(new DataEventWrapper());
        EventWrapperFactory.add(new DeltaEventWrapper());
        EventWrapperFactory.add(new ExceptionEventWrapper());
        EventWrapperFactory.add(new FileEventWrapper());
        EventWrapperFactory.add(new MailEventWrapper());
        EventWrapperFactory.add(new MapEventWrapper());
        EventWrapperFactory.add(new OpaqueEventWrapper());
        EventWrapperFactory.add(new StreamStateEventWrapper());
        EventWrapperFactory.add(new TextEventWrapper());
        EventWrapperFactory.add(new XMLEventWrapper());
        EventWrapperFactory.add(new XMPPEventWrapper());
    }
}

