/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.eventwrapper;

import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class EventWrapper<T extends ImmutableEventDatagram> {
    protected final Map<String, Class<?>> fields = new LinkedHashMap();
    private final Class<T> clazz;

    protected EventWrapper(Class<T> clazz) {
        this.clazz = clazz;
    }

    public final Map<String, Class<?>> getAllFields(T event) {
        LinkedHashMap result = new LinkedHashMap(this.fields);
        this.onGetSpecificFields(event, result);
        return result;
    }

    public final void setField(T event, String name, Object value) {
        try {
            this.onSetField(event, name, value);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to set field '" + name + "' to value '" + String.valueOf(value) + "' for event [" + event.getEventId() + "]", exception);
        }
    }

    public final Class<?> getFieldType(T event, String name) {
        Class<?> type = this.onGetSpecificFieldType(event, name);
        if (type == null) {
            type = this.fields.get(name);
        }
        return type;
    }

    public final Class<?> getModelEventClass() {
        return this.clazz;
    }

    public Map<String, Property> getProperties(T event) {
        return null;
    }

    protected void onGetSpecificFields(T event, Map<String, Class<?>> result) {
    }

    protected Class<?> onGetSpecificFieldType(T event, String name) {
        return null;
    }

    protected abstract void onSetField(T var1, String var2, Object var3) throws Exception;

    protected final <TT> TT convertValueTo(Object value, Class<TT> clazz) {
        if (value == null) {
            return null;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return (TT)value;
        }
        Class<?> wrapped = TypeFactory.wrapPrimitive(clazz);
        if (wrapped == Byte.class) {
            if (value instanceof Number) {
                return (TT)Byte.valueOf(((Number)value).byteValue());
            }
            return (TT)Byte.valueOf(value.toString());
        }
        if (wrapped == Short.class) {
            if (value instanceof Number) {
                return (TT)Short.valueOf(((Number)value).shortValue());
            }
            return (TT)Short.valueOf(value.toString());
        }
        if (wrapped == Integer.class) {
            if (value instanceof Number) {
                return (TT)Integer.valueOf(((Number)value).intValue());
            }
            return (TT)Integer.valueOf(value.toString());
        }
        if (wrapped == Long.class) {
            if (value instanceof Number) {
                return (TT)Long.valueOf(((Number)value).longValue());
            }
            return (TT)Long.valueOf(value.toString());
        }
        if (wrapped == Float.class) {
            if (value instanceof Number) {
                return (TT)Float.valueOf(((Number)value).floatValue());
            }
            return (TT)Float.valueOf(value.toString());
        }
        if (wrapped == Double.class) {
            if (value instanceof Number) {
                return (TT)Double.valueOf(((Number)value).doubleValue());
            }
            return (TT)Double.valueOf(value.toString());
        }
        if (wrapped == BigInteger.class) {
            if (value instanceof Number) {
                return (TT)BigInteger.valueOf(((Number)value).longValue());
            }
            return (TT)new BigInteger(value.toString());
        }
        if (wrapped == BigDecimal.class) {
            if (value instanceof Number) {
                return (TT)BigDecimal.valueOf(((Number)value).doubleValue());
            }
            return (TT)new BigDecimal(value.toString());
        }
        if (wrapped == Boolean.class) {
            return (TT)Boolean.valueOf(value.toString());
        }
        if (wrapped == Character.class) {
            String s = value.toString();
            if (s.length() == 1) {
                return (TT)Character.valueOf(s.charAt(0));
            }
            throw new IllegalArgumentException("Failed to convert value '" + String.valueOf(value) + "' to char.");
        }
        if (clazz == String.class) {
            return (TT)value.toString();
        }
        if (clazz == Date.class) {
            Long l = this.convertValueTo(value, Long.class);
            return (TT)new Date(l);
        }
        if (clazz == List.class) {
            if (value.getClass().isArray()) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    result.add(Array.get(value, i));
                }
                return (TT)result;
            }
            if (value instanceof Collection) {
                ArrayList result = new ArrayList();
                for (Object o : (Collection)value) {
                    result.add(o);
                }
                return (TT)result;
            }
        } else if (clazz.isArray()) {
            if (value.getClass().isArray()) {
                Object result = Array.newInstance(value.getClass().getComponentType(), Array.getLength(value));
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Array.set(result, i, Array.get(value, i));
                }
                return (TT)result;
            }
            if (value instanceof Collection) {
                Object result = Array.newInstance(value.getClass().getComponentType(), ((Collection)value).size());
                int i = 0;
                for (Object o : (Collection)value) {
                    Array.set(result, i, o);
                }
                return (TT)result;
            }
        }
        throw new IllegalArgumentException("Failed to convert value '" + String.valueOf(value) + "' to '" + String.valueOf(clazz) + "'.");
    }

    public static class Property {
        private String name;
        private Class<?> type;
        private Object value;

        public Property(String name, Class<?> type, Object value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

