/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.eventwrapper;

import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.EventDatagramWithProperties;
import com.streamscape.sdo.SDOException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.EventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.ImmutableEventDatagramWrapper;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class EventDatagramWrapper<T extends EventDatagram>
extends ImmutableEventDatagramWrapper<T> {
    protected EventDatagramWrapper(Class<T> clazz) {
        super(clazz);
        this.fields.put("durable", Boolean.class);
        this.fields.put("eventKey", String.class);
        this.fields.put("eventGroupId", String.class);
        this.fields.put("correlationId", String.class);
        this.fields.put("replyTo", String.class);
        this.fields.put("forwardTo", String.class);
        this.fields.put("expiration", Long.class);
        this.fields.put("eventProperties", Map.class);
    }

    @Override
    protected void onSetField(T event, String name, Object value) throws Exception {
        if (value == null) {
            super.onSetField(event, name, value);
            return;
        }
        if (name.equals("durable")) {
            event.setDurable(this.convertValueTo(value, Boolean.class));
        } else if (name.equals("eventKey")) {
            event.setEventKey(value.toString());
        } else if (name.equals("eventGroupId")) {
            event.setEventGroupId(value.toString());
        } else if (name.equals("correlationId")) {
            event.setCorrelationId(value.toString());
        } else if (name.equals("replyTo")) {
            event.setReplyTo(value.toString());
        } else if (name.equals("forwardTo")) {
            event.setForwardTo(value.toString());
        } else if (name.equals("expiration")) {
            event.setEventExpiration(this.convertValueTo(value, Long.class));
        } else if (name.equals("eventProperties")) {
            EventDatagramWrapper.setEventProperties(event, value);
        } else {
            super.onSetField(event, name, value);
        }
    }

    @Override
    public Map<String, EventWrapper.Property> getProperties(T event) {
        return EventDatagramWrapper.getProperties(event);
    }

    public static Map<String, EventWrapper.Property> getProperties(EventDatagramWithProperties event) {
        LinkedHashMap<String, EventWrapper.Property> properties = new LinkedHashMap<String, EventWrapper.Property>();
        for (String name : event.getEventPropertyNames()) {
            try {
                properties.put(name, new EventWrapper.Property(name, null, event.getEventObjectProperty(name)));
            }
            catch (SDOException sDOException) {}
        }
        return properties;
    }

    static void setEventProperties(EventDatagramWithProperties event, Object value) throws Exception {
        for (String propertyName : event.getEventPropertyNames()) {
            Object propertyValue = ((Map)value).remove(propertyName);
            if (propertyValue == null) continue;
            propertyValue = TypeFactory.convertPropertyValue(event.getEventPropertyType(propertyName), propertyValue);
            event.setEventObjectProperty(propertyName, propertyValue);
        }
    }
}

