/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.dataspace;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.streamscape.Trace;
import com.streamscape.lib.analyzer.EventAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphVisitor;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.SemanticTypeResolver;
import com.streamscape.omf.odata.v4.server.jdbc.model.JdbcModel;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.network.http.server.servlet.ExchangeServletHelper;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.dataspace.SemanticTypeProperty;
import com.streamscape.sef.network.http.server.swagger.dataspace.SqlTypeToSwaggerMapping;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.EventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.EventWrapperFactory;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.PrimitiveType;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SwaggerTypeResolver {
    private Swagger swagger;
    private SemanticTypeResolver semanticTypeResolver;
    private static final SimpleDateFormat swaggerDateFormatSSSXXX;
    private static final SimpleDateFormat swaggerDateFormatSSSZ;
    private static final SimpleDateFormat swaggerDateFormatPython1;
    private static final SimpleDateFormat swaggerDateFormatPython2;
    private static final SimpleDateFormat swaggerDateFormatSqlDate;
    private static final SimpleDateFormat swaggerDateFormatSqlTime;

    public SwaggerTypeResolver(Swagger swagger, SemanticTypeResolver semanticTypeResolver) {
        this.swagger = swagger;
        this.semanticTypeResolver = semanticTypeResolver;
    }

    public SemanticTypeResolver getSemanticTypeResolver() {
        return this.semanticTypeResolver;
    }

    public Resolver createResolver() {
        return new Resolver();
    }

    public Resolver createResolver(List<String> processedTypes) {
        return new Resolver(processedTypes);
    }

    public RefProperty getRefProperty(String name) {
        if (this.swagger.getDefinitions() != null && this.swagger.getDefinitions().containsKey(name)) {
            return new RefProperty(name);
        }
        return null;
    }

    public void addDefinition(ModelImpl model) {
        this.addDefinition(model.getName(), model);
    }

    public void addDefinition(String name, ModelImpl model) {
        model.discriminator("@type");
        this.swagger.addDefinition(name, (Model)model);
    }

    public RefModel createRefModel(Property property) {
        RefModel model = RefProperty.isType((String)property.getType(), null) ? new RefModel(((RefProperty)property).getSimpleRef()) : new RefModel(property.getType());
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String dateToString(java.util.Date date) {
        SimpleDateFormat simpleDateFormat = swaggerDateFormatSSSXXX;
        synchronized (simpleDateFormat) {
            return swaggerDateFormatSSSXXX.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sqlDateToString(Date date) {
        SimpleDateFormat simpleDateFormat = swaggerDateFormatSSSXXX;
        synchronized (simpleDateFormat) {
            return swaggerDateFormatSSSXXX.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sqlTimeToString(Time time) {
        SimpleDateFormat simpleDateFormat = swaggerDateFormatSSSXXX;
        synchronized (simpleDateFormat) {
            return swaggerDateFormatSSSXXX.format(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static java.util.Date stringToDate(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = swaggerDateFormatSSSXXX;
        synchronized (simpleDateFormat) {
            try {
                return swaggerDateFormatSSSXXX.parse(date);
            }
            catch (ParseException exception) {
                try {
                    return swaggerDateFormatPython1.parse(date);
                }
                catch (ParseException exception1) {
                    return swaggerDateFormatPython2.parse(date);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date stringToSqlDate(String date) throws ParseException {
        SimpleDateFormat simpleDateFormat = swaggerDateFormatSSSXXX;
        synchronized (simpleDateFormat) {
            try {
                return new Date(swaggerDateFormatSqlDate.parse(date).getTime());
            }
            catch (ParseException exception) {
                return new Date(SwaggerTypeResolver.stringToDate(date).getTime());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Time stringToSqlTime(String time) throws ParseException {
        SimpleDateFormat simpleDateFormat = swaggerDateFormatSSSXXX;
        synchronized (simpleDateFormat) {
            try {
                return new Time(swaggerDateFormatSqlTime.parse(time).getTime());
            }
            catch (ParseException exception) {
                return new Time(SwaggerTypeResolver.stringToDate(time).getTime());
            }
        }
    }

    static {
        try {
            swaggerDateFormatSSSXXX = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            swaggerDateFormatSSSZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            swaggerDateFormatPython1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            swaggerDateFormatPython2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
            swaggerDateFormatSqlDate = new SimpleDateFormat("yyyy-MM-dd");
            swaggerDateFormatSqlTime = new SimpleDateFormat("HH:mm:ss");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public class Resolver {
        private List<String> processedTypes = new ArrayList<String>();
        private String propertyNamePostfix = null;
        private String propertyNamePrefix = null;
        private TraverseStrategy strategy = new DefaultTraverseStrategy(this);

        public Resolver() {
        }

        public Resolver(List<String> processedTypes) {
            this.processedTypes = processedTypes;
        }

        private Resolver setStrategy(EventTraverseStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public Resolver setPostfix(String propertyNamePostfix) {
            this.propertyNamePostfix = propertyNamePostfix;
            return this;
        }

        public Resolver setPrefix(String propertyNamePrefix) {
            this.propertyNamePrefix = propertyNamePrefix;
            return this;
        }

        public Property getAndAddJdbcTypeOrThrowException(JdbcModel.JdbcColumn column, boolean addDefinitionForComplex) throws SwaggerBuilderException {
            try {
                Property property = SqlTypeToSwaggerMapping.getOrThrowException(column.columnType, column.columnTypeName);
                if (property instanceof ArrayProperty) {
                    ((ArrayProperty)property).setItems(this.convertSemanticTypeProperty(((ArrayProperty)property).getItems()));
                }
                if (addDefinitionForComplex) {
                    property = this.convertSemanticTypeProperty(property);
                }
                return property;
            }
            catch (Exception exception) {
                throw new SwaggerBuilderException("Failed to create swagger type for column '" + column.columnName + "'.", exception);
            }
        }

        public Property getAndAddJavaTypeOrThrowException(String semanticTypeName) throws SwaggerBuilderException {
            try {
                return this.getAndAddJavaTypeOrThrowException(SwaggerTypeResolver.this.getSemanticTypeResolver().resolveSemanticType(semanticTypeName));
            }
            catch (ClassNotFoundException exception) {
                Trace.logError(this, "Failed to resolve and load class for complex type " + semanticTypeName);
                Trace.logException(this, exception, false);
                throw new SwaggerBuilderException("Failed to resolve and load class for complex type " + semanticTypeName + ".", exception);
            }
        }

        public Property getAndAddEventTypeOrThrowException(String eventId) throws SwaggerBuilderException {
            Pair<Prototype, ImmutableEventDatagram> pair = null;
            try {
                pair = ExchangeServletHelper.createEventPrototype(eventId);
            }
            catch (DatagramFactoryException exception) {
                throw new SwaggerBuilderException("Event prototype [" + eventId + "] doesn't exist.");
            }
            this.setStrategy(new EventTraverseStrategy((Prototype)pair.first, (ImmutableEventDatagram)pair.second));
            return this.getAndAddJavaTypeOrThrowException(((Prototype)pair.first).getModelName());
        }

        public Property getAndAddEventWrapperTypeOrThrowException(String eventId) throws SwaggerBuilderException {
            Pair<Prototype, ImmutableEventDatagram> pair = null;
            try {
                pair = ExchangeServletHelper.createEventPrototype(eventId);
            }
            catch (DatagramFactoryException exception) {
                throw new SwaggerBuilderException("Event prototype [" + eventId + "] doesn't exist.");
            }
            String modelName = this.propertyNamePrefix + ((Prototype)pair.first).getModelName();
            String propertyTypeName = this.buildPropertyTypeName(modelName);
            if (SwaggerTypeResolver.this.swagger.getDefinitions() != null && SwaggerTypeResolver.this.swagger.getDefinitions().containsKey(propertyTypeName)) {
                return new RefProperty(propertyTypeName);
            }
            ModelImpl model = new ModelImpl();
            model.setName(propertyTypeName);
            EventWrapper wrapper = EventWrapperFactory.createEventWrapper((ImmutableEventDatagram)pair.second);
            for (Map.Entry<String, Class<?>> entry : wrapper.getAllFields((ImmutableEventDatagram)pair.second).entrySet()) {
                if (entry.getKey().equals("eventId")) continue;
                if (entry.getKey().equals("eventProperties")) {
                    Map<String, EventWrapper.Property> properties = wrapper.getProperties((ImmutableEventDatagram)pair.second);
                    if (properties == null || properties.size() <= 0) continue;
                    String propertiesTypeName = eventId.replace('.', '_') + "_properties";
                    ModelImpl propertiesModel = new ModelImpl();
                    propertiesModel.setName(propertiesTypeName);
                    for (Map.Entry<String, EventWrapper.Property> entryProperty : properties.entrySet()) {
                        this.addEventProperty(propertiesModel, entryProperty.getKey(), entryProperty.getValue().getType(), entryProperty.getValue().getValue());
                    }
                    SwaggerTypeResolver.this.addDefinition(propertiesModel);
                    model.addProperty(entry.getKey(), (Property)new RefProperty(propertiesModel.getName()));
                    continue;
                }
                model.addProperty(entry.getKey(), this.getAndAddJavaTypeOrThrowException(entry.getValue()));
            }
            SwaggerTypeResolver.this.addDefinition(propertyTypeName, model);
            return new RefProperty(propertyTypeName);
        }

        private Property addEventProperty(ModelImpl propertiesModel, String name, Class<?> type, Object value) throws SwaggerBuilderException {
            if (type == null) {
                type = value != null ? value.getClass() : String.class;
            }
            Property property = SwaggerTypeResolver.this.createResolver().getAndAddJavaTypeOrThrowException(type);
            propertiesModel.addProperty(name, property);
            return property;
        }

        public Property getAndAddJavaTypeOrThrowException(Type type) throws SwaggerBuilderException {
            Object property = null;
            if (type == byte[].class || type == Byte[].class) {
                property = new ByteArrayProperty();
            } else if (type == Byte.TYPE || type == Byte.class) {
                property = new IntegerProperty();
            } else if (type instanceof Class && ((Class)type).isArray()) {
                property = this.getAndAddJavaTypeOrThrowException(((Class)type).getComponentType());
                property = new ArrayProperty((Property)property);
            } else if (type instanceof ParameterizedType) {
                if (((ParameterizedType)type).getRawType() instanceof Class) {
                    if (Collection.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
                        property = this.getAndAddJavaTypeOrThrowException(((ParameterizedType)type).getActualTypeArguments()[0]);
                        property = new ArrayProperty((Property)property);
                    } else if (Map.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
                        property = this.getAndAddJavaTypeOrThrowException(((ParameterizedType)type).getActualTypeArguments()[1]);
                        property = new MapProperty((Property)property);
                    }
                }
            } else if (type instanceof Class && ((Class)type).isEnum()) {
                List enums = Arrays.asList(((Class)type).getEnumConstants()).stream().map(e -> e.toString()).collect(Collectors.toList());
                property = new StringProperty()._enum(enums);
            }
            if (property != null) {
                return property;
            }
            property = PrimitiveType.createProperty((Type)type);
            if (property == null) {
                String className = TypeFactory.defaultInstance().constructType(type).getRawClass().getName();
                SemanticType semanticType = SwaggerTypeResolver.this.getSemanticTypeResolver().getSemanticTypeCache().lookupSemanticClass(className);
                if (semanticType != null) {
                    className = semanticType.getTypeName();
                }
                property = new SemanticTypeProperty().name(className);
            }
            return this.convertSemanticTypeProperty((Property)property);
        }

        private Property convertSemanticTypeProperty(Property property) throws SwaggerBuilderException {
            if (property == null) {
                return property;
            }
            if (!SemanticTypeProperty.isType(property.getType())) {
                return property;
            }
            return this.addDefinitionOrCreateObjectProperty(property.getName());
        }

        private String buildPropertyTypeName(String name) {
            if (this.propertyNamePostfix != null) {
                name = (String)name + "_" + this.propertyNamePostfix;
            }
            if (((String)name).equals("object")) {
                name = "ObjectType";
            }
            return name;
        }

        private Property addDefinitionOrCreateObjectProperty(final String semanticTypeName) throws SwaggerBuilderException {
            final String propertyTypeName = this.buildPropertyTypeName(semanticTypeName);
            if (SwaggerTypeResolver.this.swagger.getDefinitions() != null && SwaggerTypeResolver.this.swagger.getDefinitions().containsKey(propertyTypeName)) {
                return new RefProperty(propertyTypeName);
            }
            try {
                Class<?> complexClazz = SwaggerTypeResolver.this.getSemanticTypeResolver().resolveSemanticType(semanticTypeName);
                try {
                    TypeAnalyzer analyzer = TypeAnalyzerFactory.getInstance().createTypeAnalyzer();
                    TypeGraph typeGraph = analyzer.getTypeGraph(complexClazz);
                    final ModelImpl model = new ModelImpl();
                    model.setName(semanticTypeName.equals("object") ? "ObjectType" : "object");
                    typeGraph.traverse(new TypeGraphVisitor(){

                        @Override
                        public boolean visit(TypeGraph node, int level) throws TypeAnalyzerException {
                            if (level != 1) {
                                return true;
                            }
                            if (Resolver.this.strategy.shouldSkip(node, semanticTypeName)) {
                                return true;
                            }
                            if (Resolver.this.processedTypes.contains(semanticTypeName)) {
                                Resolver.this.processedTypes.add(0, semanticTypeName);
                                model.addProperty(node.getName(), (Property)new RefProperty(propertyTypeName));
                                return true;
                            }
                            try {
                                Resolver.this.processedTypes.add(semanticTypeName);
                                Property property = Resolver.this.strategy.getPropertyForNode(node, semanticTypeName);
                                if (property == null) {
                                    property = SwaggerTypeResolver.this.createResolver(Resolver.this.processedTypes).getAndAddJavaTypeOrThrowException(node.getType());
                                }
                                model.addProperty(node.getName(), property);
                            }
                            catch (SwaggerBuilderException exception) {
                                throw new TypeAnalyzerException("Faield to create type for field '" + node.getName() + "'.", exception);
                            }
                            finally {
                                Resolver.this.processedTypes.remove(Resolver.this.processedTypes.size() - 1);
                            }
                            return true;
                        }

                        @Override
                        public void afterChildrenVisit(TypeGraph node, int level) throws TypeAnalyzerException {
                        }
                    });
                    if (SwaggerTypeResolver.this.getSemanticTypeResolver().getSemanticTypeCache().existsSemanticType(semanticTypeName) || this.processedTypes.contains(semanticTypeName)) {
                        SwaggerTypeResolver.this.addDefinition(propertyTypeName, model);
                        return new RefProperty(propertyTypeName);
                    }
                    return new ObjectProperty().properties(model.getProperties());
                }
                catch (TypeAnalyzerException exception) {
                    Trace.logError(this, "Failed to analyze complex type " + semanticTypeName);
                    Trace.logException(this, exception, false);
                    throw new SwaggerBuilderException("Failed to analyze complex type " + semanticTypeName + ".", exception);
                }
            }
            catch (ClassNotFoundException exception) {
                Trace.logError(this, "Failed to resolve and load class for complex type " + semanticTypeName);
                Trace.logException(this, exception, false);
                throw new SwaggerBuilderException("Failed to resolve and load class for complex type " + semanticTypeName + ".", exception);
            }
        }

        class DefaultTraverseStrategy
        implements TraverseStrategy {
            DefaultTraverseStrategy(Resolver this$1) {
            }

            @Override
            public boolean shouldSkip(TypeGraph node, String semanticTypeName) {
                return false;
            }

            @Override
            public Property getPropertyForNode(TypeGraph node, String semanticTypeName) {
                return null;
            }
        }

        class EventTraverseStrategy
        implements TraverseStrategy {
            private Prototype prototype;
            private ImmutableEventDatagram event;
            private EventAnalyzer eventAnalyzer;

            public EventTraverseStrategy(Prototype prototype, ImmutableEventDatagram event) {
                this.prototype = prototype;
                this.event = event;
                this.eventAnalyzer = new EventAnalyzer(event);
            }

            @Override
            public boolean shouldSkip(TypeGraph node, String semanticTypeName) {
                return node.getName().equals("serialVersionUID") || node.getName().equals("eventAnnotations") || node.getName().equals("eventProperties") && this.eventAnalyzer.getUserProperties().isEmpty();
            }

            @Override
            public Property getPropertyForNode(TypeGraph node, String semanticTypeName) throws SwaggerBuilderException {
                if (node.getName().equals("eventProperties")) {
                    LinkedHashMap<String, EventAnalyzer.Property> properties = this.eventAnalyzer.getUserProperties();
                    String propertiesTypeName = this.event.getEventId().replace('.', '_') + "_properties";
                    ModelImpl propertiesModel = new ModelImpl();
                    propertiesModel.setName(propertiesTypeName);
                    for (Map.Entry<String, EventAnalyzer.Property> entry : properties.entrySet()) {
                        Resolver.this.addEventProperty(propertiesModel, entry.getKey(), entry.getValue().getType(), entry.getValue().getValue());
                    }
                    SwaggerTypeResolver.this.addDefinition(propertiesModel);
                    return new RefProperty(propertiesModel.getName());
                }
                if (node.getName().equals("eventId")) {
                    StringProperty property = new StringProperty();
                    property.setDefault(this.event.getEventId());
                    property.setRequired(true);
                    return property;
                }
                if (node.getName().equals("data") && (semanticTypeName.equals("DataEvent") || semanticTypeName.equals("OpaqueEvent")) || (node.getName().equals("beforeImage") || node.getName().equals("afterImage")) && semanticTypeName.equals("DeltaEvent")) {
                    return SwaggerTypeResolver.this.createResolver().getAndAddJavaTypeOrThrowException(this.eventAnalyzer.getPayLoadClass());
                }
                return null;
            }
        }
    }

    public static class SwaggerJsonSqlTimestampDeserializer
    extends StdScalarDeserializer<Timestamp> {
        public SwaggerJsonSqlTimestampDeserializer() {
            super(Timestamp.class);
        }

        @Override
        public Timestamp deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                return new Timestamp(SwaggerTypeResolver.stringToDate(jp.getValueAsString()).getTime());
            }
            catch (ParseException exception) {
                throw ctxt.mappingException("Cannot parse value '" + jp.getValueAsString() + "' to sql timestamp.");
            }
        }
    }

    public static class SwaggerJsonSqlTimeDeserializer
    extends StdScalarDeserializer<Time> {
        public SwaggerJsonSqlTimeDeserializer() {
            super(Time.class);
        }

        @Override
        public Time deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                return SwaggerTypeResolver.stringToSqlTime(jp.getValueAsString());
            }
            catch (ParseException exception) {
                throw ctxt.mappingException("Cannot parse value '" + jp.getValueAsString() + "' to sql time.");
            }
        }
    }

    public static class SwaggerJsonSqlDateDeserializer
    extends StdScalarDeserializer<Date> {
        public SwaggerJsonSqlDateDeserializer() {
            super(Date.class);
        }

        @Override
        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                return SwaggerTypeResolver.stringToSqlDate(jp.getValueAsString());
            }
            catch (ParseException exception) {
                throw ctxt.mappingException("Cannot parse value '" + jp.getValueAsString() + "' to sql date.");
            }
        }
    }

    public static class SwaggerJsonDateDeserializer
    extends StdScalarDeserializer<java.util.Date> {
        public SwaggerJsonDateDeserializer() {
            super(java.util.Date.class);
        }

        @Override
        public java.util.Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            try {
                return SwaggerTypeResolver.stringToDate(jp.getValueAsString());
            }
            catch (ParseException exception) {
                throw ctxt.mappingException("Cannot parse value '" + jp.getValueAsString() + "' to Date.");
            }
        }
    }

    public static class SwaggerJsonSqlTimeSerializer
    extends StdScalarSerializer<Time> {
        public SwaggerJsonSqlTimeSerializer() {
            super(Time.class);
        }

        @Override
        public void serialize(Time value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(SwaggerTypeResolver.sqlTimeToString(value));
        }
    }

    public static class SwaggerJsonSqlDateSerializer
    extends StdScalarSerializer<Date> {
        public SwaggerJsonSqlDateSerializer() {
            super(Date.class);
        }

        @Override
        public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(SwaggerTypeResolver.sqlDateToString(value));
        }
    }

    public static class SwaggerJsonDateSerializer
    extends StdScalarSerializer<java.util.Date> {
        public SwaggerJsonDateSerializer() {
            super(java.util.Date.class);
        }

        @Override
        public void serialize(java.util.Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(SwaggerTypeResolver.dateToString(value));
        }
    }

    static interface TraverseStrategy {
        public boolean shouldSkip(TypeGraph var1, String var2);

        public Property getPropertyForNode(TypeGraph var1, String var2) throws SwaggerBuilderException;
    }
}

