/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.dataspace;

import com.streamscape.omf.odata.v4.server.jdbc.SqlTypeToEdmMapping;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.dataspace.SemanticTypeProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;

public class SqlTypeToSwaggerMapping {
    public static Property getOrThrowException(int sqlType, String sqlTypeName) throws SwaggerBuilderException {
        Property property = SqlTypeToSwaggerMapping.get(sqlType, sqlTypeName);
        if (property == null) {
            throw new SwaggerBuilderException("Not supported sql type " + sqlTypeName + "(" + sqlType + ").");
        }
        return property;
    }

    public static Property get(int sqlType, String sqlTypeName) {
        switch (sqlType) {
            case -7: {
                return new StringProperty("byte");
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return new BinaryProperty();
            }
            case -6: 
            case 4: 
            case 5: {
                return new IntegerProperty();
            }
            case -5: {
                return new LongProperty();
            }
            case 6: {
                return new FloatProperty();
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return new DoubleProperty();
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return new StringProperty();
            }
            case 91: {
                return new DateProperty();
            }
            case 92: 
            case 93: {
                return new DateTimeProperty();
            }
            case 16: {
                return new BooleanProperty();
            }
            case 2003: {
                String complexTypeName = SqlTypeToEdmMapping.extractItemTypeFromArrayType((String)sqlTypeName);
                if (complexTypeName == null) {
                    complexTypeName = "object";
                }
                int sqlSubType = SqlTypeToEdmMapping.getPrimitiveSqlType((String)complexTypeName);
                Property itemProperty = null;
                if (sqlSubType != -1) {
                    itemProperty = SqlTypeToSwaggerMapping.get(sqlSubType, complexTypeName);
                }
                if (itemProperty == null) {
                    itemProperty = SqlTypeToSwaggerMapping.get(1111, complexTypeName);
                }
                return new ArrayProperty(itemProperty);
            }
            case 1111: 
            case 2000: {
                if (sqlTypeName.equalsIgnoreCase("other")) {
                    sqlTypeName = "object";
                }
                return new SemanticTypeProperty().name(sqlTypeName);
            }
            case 1113: {
                return new SemanticTypeProperty().name("event");
            }
            case 1119: {
                return new StringProperty();
            }
        }
        return null;
    }
}

