/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.dataspace;

import com.streamscape.sef.network.http.server.swagger.dataspace.AccessList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataspacesAccessList {
    private String nodeName;
    private AccessList dataspacesAccessList;
    private Map<String, DataspaceObjectsAccessList> dataspaceObjectsAccessList;

    public boolean isEmpty() {
        return this.dataspacesAccessList == null && this.dataspaceObjectsAccessList == null && this.nodeName == null;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public AccessList getDataspacesAccessList() {
        if (this.dataspacesAccessList == null) {
            this.dataspacesAccessList = new AccessList();
        }
        return this.dataspacesAccessList;
    }

    public void setDataspacesAccessList(AccessList dataspacesAccessList) {
        this.dataspacesAccessList = dataspacesAccessList;
    }

    public Map<String, DataspaceObjectsAccessList> getDataspaceObjectsAccessList() {
        return this.dataspaceObjectsAccessList != null ? this.dataspaceObjectsAccessList : new HashMap<String, DataspaceObjectsAccessList>();
    }

    public DataspaceObjectsAccessList getDataspaceObjectsAccessList(String dataspaceName) {
        DataspaceObjectsAccessList result;
        DataspaceObjectsAccessList dataspaceObjectsAccessList = result = this.dataspaceObjectsAccessList != null ? this.dataspaceObjectsAccessList.get(dataspaceName) : new DataspaceObjectsAccessList();
        if (result == null) {
            result = new DataspaceObjectsAccessList();
        }
        return result;
    }

    public void setDataspaceObjectsAccessList(Map<String, DataspaceObjectsAccessList> dataspaceObjectsAccessList) {
        this.dataspaceObjectsAccessList = dataspaceObjectsAccessList;
    }

    public void addDataspaceObjectsAccessList(String dataspaceName, DataspaceObjectsAccessList dataspaceObjectsAccessList) {
        if (this.dataspaceObjectsAccessList == null) {
            this.dataspaceObjectsAccessList = new HashMap<String, DataspaceObjectsAccessList>();
        }
        this.dataspaceObjectsAccessList.put(dataspaceName, dataspaceObjectsAccessList);
    }

    public static class DataspaceObjectsAccessList {
        private String anyDsqlMethods = "*";
        private AccessList tables;
        private AccessList functions;

        public AccessList getTables() {
            return this.tables != null ? this.tables : new AccessList();
        }

        public void setTables(AccessList tables) {
            this.tables = tables;
        }

        public AccessList getFunctions() {
            return this.functions != null ? this.functions : new AccessList();
        }

        public void setFunctions(AccessList functions) {
            this.functions = functions;
        }

        public void includeTables(List<String> names) {
            if (this.tables == null) {
                this.tables = new AccessList();
            }
            this.tables.include(names);
        }

        public void includeTable(String name) {
            if (this.tables == null) {
                this.tables = new AccessList();
            }
            this.tables.include(name);
        }

        public void includeTable(String name, String method) {
            if (this.tables == null) {
                this.tables = new AccessList();
            }
            this.tables.includeWithMethod(name, method);
        }

        public void excludeTables(String ... names) {
            this.excludeTables(Arrays.asList(names));
        }

        public void excludeTables(List<String> names) {
            if (this.tables == null) {
                this.tables = new AccessList();
            }
            this.tables.exclude(names);
        }

        public void includeFunctions(List<String> names) {
            if (this.functions == null) {
                this.functions = new AccessList();
            }
            this.functions.include(names);
        }

        public void includeFunction(String name) {
            if (this.functions == null) {
                this.functions = new AccessList();
            }
            this.functions.include(name);
        }

        public void includeFunction(String name, String method) {
            if (this.functions == null) {
                this.functions = new AccessList();
            }
            this.functions.includeWithMethod(name, method);
        }

        public void excludeFunctions(String ... names) {
            this.excludeFunctions(Arrays.asList(names));
        }

        public void excludeFunctions(List<String> names) {
            if (this.functions == null) {
                this.functions = new AccessList();
            }
            this.functions.exclude(names);
        }

        public String getAnyDsqlMethods() {
            return this.anyDsqlMethods;
        }

        public void setAnyDsql(String anyDsqlMethods) {
            this.anyDsqlMethods = anyDsqlMethods;
        }
    }
}

