/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.dataspace;

import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.servlet.ServletError;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.SwaggerServlet;
import com.streamscape.sef.network.http.server.swagger.Utils;
import com.streamscape.sef.network.http.server.swagger.dataspace.AccessList;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspaceSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspacesAccessList;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.util.StringTokenizer;
import javax.servlet.ServletException;

public class DataspaceSwaggerBuilderFactory
extends SwaggerServlet.AbstractSwaggerBuilderFactory {
    private static String objectsParameter = "objects";
    private static String dataspaceNameParameter = "dataspaceName";
    private static String nodeNameParameter = "nodeName";
    private static String excludedTablesParameter = "excludedTables";
    private static String includedTablesParameter = "includedTables";
    private static String excludedFunctionsParameter = "excludedFunctions";
    private static String includedFunctionsParameter = "includedFunctions";

    @Override
    public SwaggerBuilder create(FabricHTTPRequest url, HTTPServerFabricConnection fabricConnection) throws ServletException, ServletError {
        return new DataspaceSwaggerBuilder(DataspaceSwaggerBuilderFactory.parseDataspaceAccessList(url), this, this.getClientParameter(url));
    }

    public SwaggerBuilder create(DataspacesAccessList dataspacesAccessList, String client) {
        return new DataspaceSwaggerBuilder(dataspacesAccessList, this, client);
    }

    public static DataspacesAccessList parseDataspaceAccessList(FabricHTTPRequest url) throws ServletError {
        DataspacesAccessList dataspacesAccessList = new DataspacesAccessList();
        String objects = url.getParameter(objectsParameter);
        if (objects != null) {
            Utils.checkParameterNotEmpty(objectsParameter, objects);
            try {
                dataspacesAccessList = (DataspacesAccessList)HTTPUtils.getJsonSerializerForJaxrx().deserialize(objects.getBytes());
            }
            catch (SerializerException exception) {
                throw new ServletError(400, "OMF", "Deserialization of objects failed.", exception);
            }
        } else {
            Object dataspaceName;
            String nodeName = url.getParameter(nodeNameParameter);
            if (nodeName != null) {
                nodeName = nodeName.trim();
                Utils.checkParameterNotEmpty(nodeNameParameter, nodeName);
                dataspacesAccessList.setNodeName(nodeName);
            }
            if ((dataspaceName = url.getUriParameter(dataspaceNameParameter)) == null) {
                dataspaceName = url.getParameter(dataspaceNameParameter);
            }
            if (dataspaceName != null) {
                dataspaceName = ((String)dataspaceName).trim();
                Utils.checkParameterNotEmpty(dataspaceNameParameter, (String)dataspaceName);
                StringTokenizer tokenizer = new StringTokenizer((String)dataspaceName, ".");
                if (tokenizer.countTokens() == 3 && nodeName != null) {
                    throw new ServletError(424, "URL", "If " + nodeNameParameter + " parameter is specified " + dataspaceNameParameter + " should be in format [<NodeName>.]<DataspaceType>.<DataspaceName>.");
                }
                if (tokenizer.countTokens() < 2 || tokenizer.countTokens() > 3) {
                    throw new ServletError(424, "URL", "Invalid Dataspace Resource '" + (String)dataspaceName + "'. Should be in format [<NodeName>.]<DataspaceType>.<DataspaceName>.");
                }
                if (nodeName != null) {
                    dataspaceName = nodeName + "." + (String)dataspaceName;
                }
                dataspacesAccessList.setDataspacesAccessList(new AccessList().include(new String[]{dataspaceName}));
                DataspacesAccessList.DataspaceObjectsAccessList dataspaceObjectsAccessList = new DataspacesAccessList.DataspaceObjectsAccessList();
                dataspaceObjectsAccessList.includeTables(Utils.split(includedTablesParameter, url.getParameter(includedTablesParameter)));
                dataspaceObjectsAccessList.excludeTables(Utils.split(excludedTablesParameter, url.getParameter(excludedTablesParameter)));
                dataspaceObjectsAccessList.includeFunctions(Utils.split(includedFunctionsParameter, url.getParameter(includedFunctionsParameter)));
                dataspaceObjectsAccessList.excludeFunctions(Utils.split(excludedFunctionsParameter, url.getParameter(excludedFunctionsParameter)));
                dataspacesAccessList.addDataspaceObjectsAccessList((String)dataspaceName, dataspaceObjectsAccessList);
            }
        }
        return dataspacesAccessList;
    }
}

