/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.dataspace;

import com.streamscape.Trace;
import com.streamscape.cli.ds.CollectionType;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.collection.Queue;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.ds.schema.collection.AbstractCollection;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueProxy;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueProxy;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.SemanticTypeResolver;
import com.streamscape.omf.odata.v4.server.jdbc.connector.Jdbc;
import com.streamscape.omf.odata.v4.server.jdbc.connector.JdbcOverFabricConnectionImpl;
import com.streamscape.omf.odata.v4.server.jdbc.model.JdbcModel;
import com.streamscape.omf.odata.v4.server.jdbc.model.JdbcModelGenerator;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.server.swagger.AbstractSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.SwaggerServlet;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspaceSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspacesAccessList;
import com.streamscape.sef.network.http.server.swagger.dataspace.SemanticTypeProperty;
import com.streamscape.sef.network.http.server.swagger.dataspace.SwaggerTypeResolver;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DataspaceSwaggerBuilder
extends AbstractSwaggerBuilder {
    private DataspacesAccessList dataspaceAccessList;
    private boolean useTupleSet = true;
    private SwaggerServlet.AbstractSwaggerBuilderFactory factory;

    public DataspaceSwaggerBuilder(DataspacesAccessList dataspaceAccessList, DataspaceSwaggerBuilderFactory factory, String client) {
        super(client);
        this.dataspaceAccessList = dataspaceAccessList;
        this.factory = factory;
    }

    @Override
    public Swagger build() throws SwaggerBuilderException {
        Swagger swagger = new Swagger();
        this.setHost(swagger);
        this.setInfo(swagger);
        this.setSecurity(swagger);
        swagger.basePath(this.getBasePath());
        if (this.dataspaceAccessList != null && this.dataspaceAccessList.getDataspacesAccessList().isSingleName()) {
            Object fullName = this.dataspaceAccessList.getDataspacesAccessList().getSingleName();
            if (this.dataspaceAccessList.getNodeName() != null) {
                fullName = this.dataspaceAccessList.getNodeName() + "." + (String)fullName;
            }
            swagger.getInfo().title((String)fullName);
            swagger.getInfo().description("<div>REST API for CRUD matrix operations on Dataspace Collections.<br><br><table><tr><td>Dataspace Type:</td><td>" + ModeratorUtils.extractComponentNameType(this.dataspaceAccessList.getDataspacesAccessList().getSingleName()) + "</td></tr><tr><td>Dataspace Name:</td><td>" + ModeratorUtils.extractComponentNameName(this.dataspaceAccessList.getDataspacesAccessList().getSingleName()) + "</td></tr><tr><td>Full Name:</td><td>" + (String)fullName + "</td></tr></table></div>");
        } else {
            swagger.getInfo().title("StreamScape Dataspace REST API.");
            swagger.getInfo().description("REST API for CRUD matrix operations on Dataspace Collections.");
        }
        return this.build(swagger);
    }

    @Override
    public Swagger build(Swagger swagger) throws SwaggerBuilderException {
        if (this.dataspaceAccessList == null) {
            return swagger;
        }
        if (swagger.getBasePath() == null) {
            swagger.setBasePath(this.getBasePath());
        }
        this.swaggerTypeResolver = new SwaggerTypeResolver(swagger, new SemanticTypeResolver());
        List<String> dataspaces = DataspaceSwaggerBuilder.listDataspaces(this.dataspaceAccessList, this.connection);
        for (String dataspace : dataspaces) {
            JdbcOverFabricConnectionImpl jdbc = null;
            try {
                jdbc = new JdbcOverFabricConnectionImpl((FabricConnection)this.connection, dataspace);
                jdbc.connect();
                JdbcModelGenerator modelGenerator = new JdbcModelGenerator(JdbcModelGenerator.Scope.SWAGGER);
                DataspacesAccessList.DataspaceObjectsAccessList objectsAccessList = this.dataspaceAccessList.getDataspaceObjectsAccessList(dataspace);
                modelGenerator.setTablesAccessList(objectsAccessList.getTables());
                modelGenerator.setFunctionsAccessList(objectsAccessList.getFunctions());
                JdbcModel jdbcModel = modelGenerator.createJdbcModel((Jdbc)jdbc);
                JdbcModel.JdbcSchema schema = (JdbcModel.JdbcSchema)jdbcModel.schemas.get(jdbc.getDataspaceName());
                if (schema == null) {
                    throw new SwaggerBuilderException("Dataspace schema '" + dataspace + "' not found.");
                }
                String tagPrefix = this.dataspaceAccessList.getDataspacesAccessList().isSingleName() && this.getBasePath().contains(dataspace) ? "" : "Dataspace " + dataspace + " : ";
                DataspacesAccessList.DataspaceObjectsAccessList dataspaceObjectsAccessList = this.getDataspaceObjectsAccessList(dataspace);
                this.addTableCalls(swagger, dataspace, schema, jdbc.getDataspaceAccessor(), tagPrefix, dataspaceObjectsAccessList);
                this.addFunctionCalls(swagger, dataspace, schema, jdbc.getDataspaceAccessor(), tagPrefix, dataspaceObjectsAccessList);
                if (objectsAccessList.getAnyDsqlMethods() == null || objectsAccessList.getAnyDsqlMethods().length() <= 0) continue;
                this.addAnyStatementCall(swagger, dataspace, tagPrefix, objectsAccessList.getAnyDsqlMethods());
            }
            catch (SwaggerBuilderException exception) {
                throw exception;
            }
            catch (Exception exception) {
                Trace.logError(this, exception.getMessage());
                Trace.logException(this, exception, true);
                throw new SwaggerBuilderException("Failed to establish JDBC connection to dataspace '" + dataspace + "'.", exception);
            }
            finally {
                try {
                    if (jdbc != null) {
                        jdbc.disconnect();
                    }
                    jdbc = null;
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
            }
        }
        return swagger;
    }

    private void addTableCalls(Swagger swagger, String dataspaceName, JdbcModel.JdbcSchema schema, DataspaceAccessor dataspaceAccessor, String tagPrefix, DataspacesAccessList.DataspaceObjectsAccessList dataspaceObjectsAccessList) throws SwaggerBuilderException {
        ArrayList<JdbcModel.JdbcTable> tables = new ArrayList<JdbcModel.JdbcTable>(schema.tables.values());
        tables.sort((o1, o2) -> o1.tableName.compareToIgnoreCase(o2.tableName));
        CollectionType[] typesSequence = new CollectionType[]{CollectionType.TABLE, CollectionType.MAP, CollectionType.MAP, CollectionType.EVENT_TABLE, CollectionType.FILE_TABLE, CollectionType.VTABLE, CollectionType.DIRECTORY_TABLE, CollectionType.QUEUE, CollectionType.BLOCKING_QUEUE, CollectionType.EVENT_QUEUE, CollectionType.PROCESS_QUEUE, CollectionType.AUDIT_QUEUE, CollectionType.MESSAGE_QUEUE, CollectionType.FUNCTION_TABLE, CollectionType.SOURCE_STREAM, CollectionType.JOURNAL_FILE_TABLE, CollectionType.LOG_FILE_TABLE, CollectionType.SEMAGRAPTH_TABLE};
        tables.forEach(t -> {
            try {
                t.collection = dataspaceAccessor.lookupCollection(t.tableName);
            }
            catch (DataspaceComponentException exception) {
                Trace.logError(this, "Failed to get collection '" + t.tableName + "'. Cause: " + exception.getMessage());
            }
        });
        String urlprefix = this.getPrefix(dataspaceName);
        for (CollectionType type : typesSequence) {
            for (JdbcModel.JdbcTable table : this.getAndRemoveTablesOfType(tables, type, typesSequence)) {
                Path path = new Path();
                swagger.path(urlprefix + "/collection/" + table.tableName, path);
                String tag = tagPrefix + AbstractCollection.getCollectionTypeNameCamelCase(type) + " : " + table.tableName;
                if (table.collection instanceof Queue) {
                    this.addQueueCalls(swagger, table, path, dataspaceAccessor, tag, dataspaceObjectsAccessList);
                    continue;
                }
                this.addTableCalls(swagger, table, path, tag, dataspaceObjectsAccessList);
            }
        }
    }

    private List<JdbcModel.JdbcTable> getAndRemoveTablesOfType(List<JdbcModel.JdbcTable> tables, CollectionType type, CollectionType[] allTypes) {
        List<Object> result = type != CollectionType.TABLE ? tables.stream().filter(t -> t.collection != null && t.collection.getCollectionType() == type).collect(Collectors.toList()) : tables.stream().filter(t -> {
            if (t.collection != null && t.collection.getCollectionType() == CollectionType.TABLE) {
                return true;
            }
            boolean present = false;
            for (CollectionType allType : allTypes) {
                if (t.collection == null || t.collection.getCollectionType() != allType) continue;
                present = true;
                break;
            }
            return !present;
        }).collect(Collectors.toList());
        tables.removeAll(result);
        return result;
    }

    private void addQueueCalls(Swagger swagger, JdbcModel.JdbcTable table, Path path, DataspaceAccessor dataspaceAccessor, String tag, DataspacesAccessList.DataspaceObjectsAccessList dataspaceObjectsAccessList) throws SwaggerBuilderException {
        Response response;
        Pair<Property, Consumer> pair;
        swagger.tag(new Tag().name(tag));
        Queue queue = (Queue)table.collection;
        String objectName = "event";
        if (queue.getClass() == BlockingQueueProxy.class) {
            objectName = "object";
        }
        Operation operation = new Operation();
        operation.tag(tag);
        operation.summary("Puts new " + objectName + " into the '" + table.tableName + "' queue.");
        operation.description("Puts new " + objectName + " into the '" + table.tableName + "' queue.");
        this.setSecurityDefinitionsForOperation(swagger, operation);
        this.addDefaultConsumesXmlJson(operation);
        this.addDefaultProducesXmlJson(operation);
        this.addDefaultResponses(operation);
        operation.response(200, this.getResponseUpdateCount());
        DataspaceSwaggerBuilder.addQueueBodyParameter(operation, table, this.swaggerTypeResolver, this.getExamplesProvider());
        if (this.isUiClient()) {
            this.addNorowsetParameterForDSResultUpdateCount(operation);
        }
        this.addQueryTimeoutParameter(operation);
        if (dataspaceObjectsAccessList == null || dataspaceObjectsAccessList.getTables().isAllowed(table.tableName, "PUT")) {
            path.put(operation);
        } else if (dataspaceObjectsAccessList.getTables().isAllowed(table.tableName, "POST")) {
            path.post(operation);
        }
        if (dataspaceObjectsAccessList == null || dataspaceObjectsAccessList.getTables().isAllowed(table.tableName, "GET")) {
            operation = new Operation();
            operation.tag(tag);
            operation.summary("Reads " + objectName + " from the '" + table.tableName + "' queue.");
            operation.description("Reads " + objectName + " from the '" + table.tableName + "' queue.");
            this.setSecurityDefinitionsForOperation(swagger, operation);
            this.addDefaultProducesXmlJson(operation);
            this.addDefaultResponses(operation);
            pair = DataspaceSwaggerBuilder.createQueueObjectProperty(table, queue, this.swaggerTypeResolver, this.getExamplesProvider());
            response = new Response().description("Result").schema((Property)pair.first);
            if (pair.second != null) {
                ((Consumer)pair.second).accept(response);
            }
            operation.response(200, response);
            if (queue.getClass() != BlockingQueueProxy.class) {
                operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("selector")).description("DSQL selector")).required(false)).property((Property)new StringProperty()));
            }
            this.addQueryTimeoutParameter(operation);
            if (dataspaceObjectsAccessList == null || dataspaceObjectsAccessList.getTables().isAllowed(table.tableName, "GET")) {
                path.get(operation);
            }
        }
        operation = new Operation();
        operation.tag(tag);
        operation.summary("Reads and removes " + objectName + " from the '" + table.tableName + "' queue.");
        operation.description("Reads and removes " + objectName + " from the '" + table.tableName + "' queue.");
        this.setSecurityDefinitionsForOperation(swagger, operation);
        this.addDefaultProducesXmlJson(operation);
        this.addDefaultResponses(operation);
        pair = DataspaceSwaggerBuilder.createQueueObjectProperty(table, queue, this.swaggerTypeResolver, this.getExamplesProvider());
        response = new Response().description("Result").schema((Property)pair.first);
        if (pair.second != null) {
            ((Consumer)pair.second).accept(response);
        }
        operation.response(200, response);
        if (queue.getClass() != BlockingQueueProxy.class) {
            operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("selector")).description("DSQL selector")).required(false)).property((Property)new StringProperty()));
        }
        this.addQueryTimeoutParameter(operation);
        if (dataspaceObjectsAccessList == null || dataspaceObjectsAccessList.getTables().isAllowed(table.tableName, "DELETE")) {
            path.delete(operation);
        }
    }

    public static void addQueueBodyParameter(Operation operation, JdbcModel.JdbcTable table, SwaggerTypeResolver swaggerTypeResolver, AbstractSwaggerBuilder.SwaggerExamplesProvider examplesProvider) throws SwaggerBuilderException {
        BodyParameter bodyParameter = new BodyParameter();
        Pair<Property, Consumer> pair = DataspaceSwaggerBuilder.createQueueObjectProperty(table, (Queue)table.collection, swaggerTypeResolver, examplesProvider);
        if (table.collection.getClass() == BlockingQueueProxy.class) {
            String typeName = table.columns.stream().filter((Predicate<JdbcModel.JdbcColumn>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$addQueueBodyParameter$4(com.streamscape.omf.odata.v4.server.jdbc.model.JdbcModel$JdbcColumn ), (Lcom/streamscape/omf/odata/v4/server/jdbc/model/JdbcModel$JdbcColumn;)Z)()).findFirst().get().columnTypeName;
            bodyParameter.name("object").description("Object of type '" + typeName + "' serialized in corresponding format.");
        } else {
            bodyParameter.name("event").description("Event [" + ((EventQueueProxy)table.collection).getEventId() + "] serialized in corresponding format.");
        }
        bodyParameter.setRequired(true);
        bodyParameter.setSchema((Model)swaggerTypeResolver.createRefModel((Property)pair.first));
        if (pair.second != null) {
            ((Consumer)pair.second).accept(bodyParameter);
        }
        operation.parameter((Parameter)bodyParameter);
    }

    public static Pair<Property, Consumer> createQueueObjectProperty(JdbcModel.JdbcTable table, Queue queue, SwaggerTypeResolver swaggerTypeResolver, AbstractSwaggerBuilder.SwaggerExamplesProvider examplesProvider) throws SwaggerBuilderException {
        try {
            Property typeProperty = null;
            Consumer<Object> consumer = null;
            if (queue.getClass() == BlockingQueueProxy.class) {
                JdbcModel.JdbcColumn objectColumn = table.columns.stream().filter(c -> c.columnName.equals("Object")).findFirst().get();
                if (objectColumn == null) {
                    throw new SwaggerBuilderException("Queue '" + table.tableName + "' doesn't contain Object column.");
                }
                typeProperty = swaggerTypeResolver.createResolver().getAndAddJdbcTypeOrThrowException(objectColumn, true);
                if (typeProperty instanceof RefProperty) {
                    String type = ((RefProperty)typeProperty).getSimpleRef();
                    consumer = p -> examplesProvider.examples(p, type);
                }
            } else {
                String eventId = ((EventQueueProxy)queue).getEventId();
                typeProperty = swaggerTypeResolver.createResolver().setPostfix(eventId.replace('.', '_')).getAndAddEventTypeOrThrowException(eventId);
                consumer = p -> examplesProvider.examplesEvent(p, eventId);
            }
            return new Pair<Property, Consumer>(typeProperty, consumer);
        }
        catch (Exception exception) {
            Trace.logError(DataspaceSwaggerBuilder.class, "Failed to create queue object for queue '" + queue.getCollectionName() + "'.");
            Trace.logException(DataspaceSwaggerBuilder.class, exception, false);
            return new Pair<Property, Object>(swaggerTypeResolver.createResolver().getAndAddJavaTypeOrThrowException((Type)((Object)Object.class)), null);
        }
    }

    private void addTableCalls(Swagger swagger, JdbcModel.JdbcTable table, Path path, String tag, DataspacesAccessList.DataspaceObjectsAccessList dataspaceObjectsAccessList) throws SwaggerBuilderException {
        Operation operation;
        swagger.tag(new Tag().name(tag));
        if (dataspaceObjectsAccessList == null || dataspaceObjectsAccessList.getTables().isAllowed(table.tableName, "GET")) {
            operation = new Operation();
            operation.tag(tag);
            operation.summary("Selects entries or rows from '" + table.tableName + "' collection.");
            operation.description("Selects entries or rows from '" + table.tableName + "' collection. If no columns or tuples are specified, all columns will be selected.");
            this.setSecurityDefinitionsForOperation(swagger, operation);
            this.addDefaultProduces(operation);
            this.addDefaultResponses(operation);
            operation.response(200, new Response().description("OK").schema((Property)DataspaceSwaggerBuilder.createDSRowSetProperty(table.columns, table.tableName, this.swaggerTypeResolver)));
            if (this.isUiClient()) {
                for (JdbcModel.JdbcColumn column : table.columns) {
                    operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name(column.columnName)).description("Select or not '" + column.columnName + "' column.")).required(false)).type("boolean"));
                }
            } else {
                this.addColumnsTupleForSelect(operation, table.columns, table.tableName, true);
                this.addDefaultConsumesXmlJson(operation);
            }
            this.addWhereParameter(operation);
            this.addOderByParameter(operation, table);
            this.addLimitParameter(operation);
            if (this.isUiClient()) {
                this.addNorowsetParameter(operation);
                this.addNorowsParameter(operation);
            }
            this.addQueryTimeoutParameter(operation);
            path.get(operation);
        }
        if (dataspaceObjectsAccessList == null || dataspaceObjectsAccessList.getTables().isAllowed(table.tableName, "POST")) {
            operation = new Operation();
            operation.tag(tag);
            operation.summary("Inserts new row into '" + table.tableName + "' collection.");
            operation.description("Inserts new row into '" + table.tableName + "' collection.");
            this.setSecurityDefinitionsForOperation(swagger, operation);
            this.addDefaultResponses(operation);
            this.addDefaultProducesXmlJson(operation);
            operation.response(200, this.getResponseUpdateCount());
            if (this.useTupleSet) {
                this.addColumnsTuple(operation, table.columns, table.tableName, true);
                this.addDefaultConsumesXmlJson(operation);
            } else {
                this.addColumns(operation, table.columns, true, table.tableName, true, true);
                this.addRequestFormatParameter(operation);
            }
            if (this.isUiClient()) {
                this.addNorowsetParameterForDSResultUpdateCount(operation);
            }
            this.addQueryTimeoutParameter(operation);
            path.post(operation);
        }
        if (dataspaceObjectsAccessList == null || dataspaceObjectsAccessList.getTables().isAllowed(table.tableName, "PUT")) {
            operation = new Operation();
            operation.tag(tag);
            operation.summary("Updates specified row(s) in '" + table.tableName + "' collection.");
            operation.description("Updates specified row(s) in '" + table.tableName + "' collection.");
            this.setSecurityDefinitionsForOperation(swagger, operation);
            this.addDefaultProducesXmlJson(operation);
            this.addDefaultResponses(operation);
            operation.response(200, this.getResponseUpdateCount());
            if (this.useTupleSet) {
                this.addColumnsTuple(operation, table.columns, table.tableName, true);
                this.addDefaultConsumesXmlJson(operation);
            } else {
                this.addColumns(operation, table.columns, false, table.tableName, true, true);
                this.addRequestFormatParameter(operation);
            }
            this.addWhereParameter(operation);
            if (this.isUiClient()) {
                this.addNorowsetParameterForDSResultUpdateCount(operation);
            }
            this.addQueryTimeoutParameter(operation);
            path.put(operation);
        }
        if (dataspaceObjectsAccessList == null || dataspaceObjectsAccessList.getTables().isAllowed(table.tableName, "DELETE")) {
            operation = new Operation();
            operation.tag(tag);
            operation.summary("Deletes specified row(s) from '" + table.tableName + "' table.");
            operation.description("Deletes specified row(s) from '" + table.tableName + "' table.");
            this.setSecurityDefinitionsForOperation(swagger, operation);
            this.addDefaultProducesXmlJson(operation);
            this.addDefaultResponses(operation);
            operation.response(200, this.getResponseUpdateCount());
            this.addWhereParameter(operation, "0=1");
            if (this.isUiClient()) {
                this.addNorowsetParameterForDSResultUpdateCount(operation);
            }
            this.addQueryTimeoutParameter(operation);
            path.delete(operation);
        }
    }

    private void addFunctionCalls(Swagger swagger, String dataspaceName, JdbcModel.JdbcSchema schema, DataspaceAccessor dataspaceAccessor, String tagPrefix, DataspacesAccessList.DataspaceObjectsAccessList dataspaceObjectsAccessList) throws SwaggerBuilderException {
        Object urlprefix = this.getPrefix(dataspaceName);
        urlprefix = (String)urlprefix + "/fn";
        ArrayList functions = new ArrayList(schema.functions.values());
        functions.sort((o1, o2) -> o1.functionName.compareToIgnoreCase(o2.functionName));
        for (JdbcModel.JdbcFunction function : functions) {
            Path path = new Path();
            swagger.path((String)urlprefix + "/" + function.functionName, path);
            String tag = tagPrefix + "Function : " + function.functionName;
            swagger.tag(new Tag().name(tag));
            Operation operation = new Operation();
            operation.tag(tag);
            operation.summary("Calls function '" + function.functionName + "'.");
            if (dataspaceObjectsAccessList == null || dataspaceObjectsAccessList.getFunctions().isAllowed(function.functionName, "POST")) {
                path.post(operation);
            } else if (dataspaceObjectsAccessList.getFunctions().isAllowed(function.functionName, "GET")) {
                path.get(operation);
            } else {
                if (!dataspaceObjectsAccessList.getFunctions().isAllowed(function.functionName, "PUT")) continue;
                path.put(operation);
            }
            this.setSecurityDefinitionsForOperation(swagger, operation);
            operation.description(DataspaceSwaggerBuilder.getFunctionDescription(dataspaceAccessor, function, "Calls function '" + function.functionName + "'."));
            this.addDefaultProducesXmlJson(operation);
            this.addDefaultResponses(operation);
            DataspaceSwaggerBuilder.addFunctionResponse(operation, function, 200, this.swaggerTypeResolver, this.getExamplesProvider());
            if (function.arguments.size() > 0) {
                if (this.useTupleSet) {
                    this.addColumnsTuple(operation, function.arguments, function.functionName, false);
                    this.addDefaultConsumesXmlJson(operation);
                } else {
                    this.addColumns(operation, function.arguments, true, function.functionName, false, false);
                    this.addRequestFormatParameter(operation);
                }
            }
            if (function.result == null) {
                this.addResponseFormatParameter(operation);
            }
            if (this.isUiClient()) {
                this.addNorowsetParameterForDSResultSingleValue(operation);
            }
            this.addQueryTimeoutParameter(operation);
        }
    }

    public static void addFunctionResponse(Operation operation, JdbcModel.JdbcFunction function, int successStatus, SwaggerTypeResolver swaggerTypeResolver, AbstractSwaggerBuilder.SwaggerExamplesProvider examplesProvider) throws SwaggerBuilderException {
        if (function.result != null) {
            Property property = swaggerTypeResolver.createResolver().getAndAddJdbcTypeOrThrowException(function.result, true);
            Response response = new Response().description("Function result").schema(property);
            if (property instanceof RefProperty) {
                examplesProvider.examples(response, ((RefProperty)property).getSimpleRef());
            }
            operation.response(successStatus, response);
        }
    }

    public static String getFunctionDescription(DataspaceAccessor dataspaceAccessor, JdbcModel.JdbcFunction function, String description) {
        try {
            String d;
            RowSet rowSet = dataspaceAccessor.executeQuery("describe function " + function.functionName + " doc");
            if (rowSet.next() && (d = rowSet.getString(1)) != null && d.trim().length() > 0) {
                description = d;
            }
        }
        catch (Exception exception) {
            Trace.logError(DataspaceSwaggerBuilder.class, "Failed to get function " + function.functionName + " doc.");
            Trace.logException(DataspaceSwaggerBuilder.class, exception, false);
        }
        return description;
    }

    private void addAnyStatementCall(Swagger swagger, String dataspaceName, String tagPrefix, String anyDsqlMethods) throws SwaggerBuilderException {
        Object urlprefix = this.getPrefix(dataspaceName);
        urlprefix = (String)urlprefix + "/dsql/";
        Path path = new Path();
        swagger.path((String)urlprefix, path);
        String tag = tagPrefix + "Any DSQL Statement";
        swagger.tag(new Tag().name(tag));
        Operation operation = new Operation();
        operation.tag(tag);
        operation.summary("Executes any DSQL statement.");
        operation.description("Executes any DSQL statement.");
        if (anyDsqlMethods.contains("*")) {
            path.get(operation);
        } else if (anyDsqlMethods.contains("GET")) {
            path.get(operation);
        } else if (anyDsqlMethods.contains("POST")) {
            path.post(operation);
        } else if (anyDsqlMethods.contains("PUT")) {
            path.put(operation);
        } else {
            return;
        }
        this.setSecurityDefinitionsForOperation(swagger, operation);
        this.addDefaultProduces(operation);
        this.addDefaultResponses(operation);
        operation.response(200, new Response().description("OK").schema((Property)new StringProperty()));
        operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("q")).description("DSQL query")).required(true)).type("string"));
        this.addResponseFormatParameter(operation);
        this.addNorowsetParameter(operation);
        this.addNorowsParameter(operation);
        this.addQueryTimeoutParameter(operation);
    }

    private void addColumns(Operation operation, List<JdbcModel.JdbcColumn> columns, boolean required, String functionTableName, boolean isTable, boolean isPost) throws SwaggerBuilderException {
        String complexColumns = "";
        for (JdbcModel.JdbcColumn column : columns) {
            AbstractSerializableParameter parameter = (isPost ? new FormParameter() : new QueryParameter()).name(column.columnName).description("Value of " + (isTable ? "column" : "parameter")).required(required);
            complexColumns = DataspaceSwaggerBuilder.fillParameterForColumn(parameter, column, this.swaggerTypeResolver, functionTableName, isTable, complexColumns);
            operation.parameter((Parameter)parameter);
        }
        if (complexColumns.length() > 0) {
            operation.description(operation.getDescription() + "\nFor complex " + (isTable ? "columns " : "parameters ") + complexColumns + " values should be specified in format that specified for requestFormat parameter.");
        }
    }

    public static String fillParameterForColumn(AbstractSerializableParameter<?> parameter, JdbcModel.JdbcColumn column, SwaggerTypeResolver swaggerTypeResolver, String functionTableName, boolean isTable, String complexColumns) throws SwaggerBuilderException {
        try {
            Property property = swaggerTypeResolver.createResolver().getAndAddJdbcTypeOrThrowException(column, false);
            if (ObjectProperty.isType((String)property.getType()) || SemanticTypeProperty.isType(property.getType())) {
                complexColumns = (String)complexColumns + (((String)complexColumns).length() == 0 ? "" : ", ") + column.columnName;
                property = new StringProperty(property.getName());
                parameter.description("Should be serialized representation of '" + property.getFormat() + "' type in requestFormat format.");
            }
            parameter.property(property);
        }
        catch (SwaggerBuilderException exception) {
            throw new SwaggerBuilderException("Failed build swagger type for " + (isTable ? "column" : "parameter") + " '" + column.columnName + "' in " + (isTable ? "table" : "function") + " '" + functionTableName + "'.", exception);
        }
        return complexColumns;
    }

    private void addColumnsTuple(Operation operation, List<JdbcModel.JdbcColumn> columns, String functionTableName, boolean isTable) throws SwaggerBuilderException {
        BodyParameter bodyParameter = new BodyParameter();
        bodyParameter.name("tuple set").description("Tuple set serialized in corresponding format.");
        bodyParameter.setRequired(true);
        String tupleSetTypeName = functionTableName + "TupleSet";
        RefProperty tupleSetRefProperty = this.swaggerTypeResolver.getRefProperty(tupleSetTypeName);
        if (tupleSetRefProperty == null) {
            ModelImpl tupleSetModel = new ModelImpl();
            tupleSetModel.setName(tupleSetTypeName);
            for (JdbcModel.JdbcColumn column : columns) {
                try {
                    Property property = this.swaggerTypeResolver.createResolver().getAndAddJdbcTypeOrThrowException(column, true);
                    tupleSetModel.addProperty(column.columnName, property);
                }
                catch (SwaggerBuilderException exception) {
                    throw new SwaggerBuilderException("Failed build swagger collection tuple set for " + (isTable ? "column" : "parameter") + " '" + column.columnName + "' in " + (isTable ? "table" : "function") + " '" + functionTableName + "'.", exception);
                }
            }
            this.swaggerTypeResolver.addDefinition(tupleSetModel);
            tupleSetRefProperty = new RefProperty(tupleSetModel.getName());
        }
        RefModel tupleSetRefModel = new RefModel(tupleSetRefProperty.getSimpleRef());
        bodyParameter.schema((Model)tupleSetRefModel);
        operation.parameter((Parameter)bodyParameter);
    }

    private void addColumnsTupleForSelect(Operation operation, List<JdbcModel.JdbcColumn> columns, String functionTableName, boolean isTable) throws SwaggerBuilderException {
        QueryParameter tupleSetParameter = new QueryParameter();
        tupleSetParameter.name("tupleSet");
        tupleSetParameter.description("Tuple set of columns to select in format {column1 : {true | false}, ...}. If empty or null all columns will be selected.");
        tupleSetParameter.setRequired(true);
        tupleSetParameter.example("{" + columns.stream().map(c -> c.columnName + ":true").collect(Collectors.joining(",")) + "}");
        tupleSetParameter.property((Property)new StringProperty());
        operation.parameter((Parameter)tupleSetParameter);
    }

    public static ArrayProperty createDSRowSetProperty(List<JdbcModel.JdbcColumn> columns, String tableName, SwaggerTypeResolver swaggerTypeResolver) throws SwaggerBuilderException {
        String dsRowSetName = tableName + "DSRowSet";
        String dsRowSetItemName = tableName + "DSRow";
        RefProperty dsRowSetItemProperty = swaggerTypeResolver.getRefProperty(dsRowSetItemName);
        if (dsRowSetItemProperty == null) {
            ModelImpl dsRowSetItemModel = new ModelImpl();
            dsRowSetItemModel.setName(dsRowSetItemName);
            for (JdbcModel.JdbcColumn column : columns) {
                try {
                    Property property = swaggerTypeResolver.createResolver().getAndAddJdbcTypeOrThrowException(column, true);
                    dsRowSetItemModel.property(column.columnName, property);
                }
                catch (SwaggerBuilderException exception) {
                    throw new SwaggerBuilderException("Failed build swagger collection DSRowSet for column '" + column.columnName + "' in table '" + tableName + "'.", exception);
                }
            }
            swaggerTypeResolver.addDefinition(dsRowSetItemModel);
            dsRowSetItemProperty = new RefProperty(dsRowSetItemModel.getName());
        }
        ArrayProperty dsRowSetProperty = new ArrayProperty();
        dsRowSetProperty.items((Property)dsRowSetItemProperty);
        return dsRowSetProperty;
    }

    private void addDefaultResponses(Operation operation) {
        DataspaceSwaggerBuilder.addDefaultResponses(operation, this.httpExceptionResponse());
    }

    public static void addDefaultResponses(Operation operation, Response httpExceptionResponse) {
        operation.response(200, new Response().description("OK"));
        operation.response(400, new Response().description("Invalid Request"));
        operation.response(404, new Response().description("Not Found"));
        operation.response(500, httpExceptionResponse.description("DSQL Error"));
    }

    private void addWhereParameter(Operation operation) {
        this.addWhereParameter(operation, "");
    }

    private void addWhereParameter(Operation operation, String defaultValue) {
        DataspaceSwaggerBuilder.addWhereParameter(operation, defaultValue, new QueryParameter().name("where"));
    }

    public static void addWhereParameter(Operation operation, String defaultValue, AbstractSerializableParameter parameter) {
        operation.parameter((Parameter)parameter.description("Specifies DSQL where clause.").required(false).example(defaultValue).type("string"));
    }

    private void addOderByParameter(Operation operation, JdbcModel.JdbcTable table) {
        DataspaceSwaggerBuilder.addOderByParameter(operation, table, new QueryParameter().name("order_by"));
    }

    public static void addOderByParameter(Operation operation, JdbcModel.JdbcTable table, AbstractSerializableParameter parameter) {
        operation.parameter((Parameter)parameter.description("Specifies DSQL order by column.").required(false).type("string")._enum(table.columns.stream().map(c -> c.columnName).collect(Collectors.toList())));
    }

    private void addLimitParameter(Operation operation) {
        DataspaceSwaggerBuilder.addLimitParameter(operation, new QueryParameter().name("limit"));
    }

    public static void addLimitParameter(Operation operation, AbstractSerializableParameter parameter) {
        operation.parameter((Parameter)parameter.description("Specifies maximum selected rows.").required(false).type("integer"));
    }

    private void addNorowsParameter(Operation operation) {
        DataspaceSwaggerBuilder.addNorowsParameter(operation, new QueryParameter().name("norows"));
    }

    public static void addNorowsParameter(Operation operation, AbstractSerializableParameter parameter) {
        operation.parameter((Parameter)parameter.description("When norowset is FALSE, specifies wether row elements in a JSON response should be wrapped in a 'rows' element.").required(false).example("true").type("boolean"));
    }

    private void addNorowsetParameter(Operation operation) {
        DataspaceSwaggerBuilder.addNorowsetParameter(operation, new QueryParameter().name("norowset"));
    }

    public static void addNorowsetParameter(Operation operation, AbstractSerializableParameter parameter) {
        DataspaceSwaggerBuilder.addNorowsetParameter(operation, parameter, "Specifies if response in JSON format should contain 'DSRowSet' field.");
    }

    public static void addNorowsetParameter(Operation operation, AbstractSerializableParameter parameter, String description) {
        operation.parameter((Parameter)parameter.description(description).required(false).example("true").type("boolean"));
    }

    private void addNorowsetParameterForDSResultUpdateCount(Operation operation) {
        DataspaceSwaggerBuilder.addNorowsetParameterForDSResultUpdateCount(operation, new QueryParameter().name("norowset"));
    }

    public static void addNorowsetParameterForDSResultUpdateCount(Operation operation, AbstractSerializableParameter parameter) {
        DataspaceSwaggerBuilder.addNorowsetParameter(operation, parameter, "Specifies either response should consist of single update count value or should be wrapped into DSResultUpdateCount.");
    }

    private void addNorowsetParameterForDSResultSingleValue(Operation operation) {
        DataspaceSwaggerBuilder.addNorowsetParameterForDSResultUpdateCount(operation, new QueryParameter().name("norowset"));
    }

    public static void addNorowsetParameterForDSResultSingleValue(Operation operation, AbstractSerializableParameter parameter) {
        DataspaceSwaggerBuilder.addNorowsetParameter(operation, parameter, "Specifies either response should consist of single update count value or should be wrapped into DSResultSingleValue.");
    }

    private void addQueryTimeoutParameter(Operation operation) {
        DataspaceSwaggerBuilder.addQueryTimeoutParameter(operation, new QueryParameter().name("queryTimeout"), this.factory);
    }

    public static void addQueryTimeoutParameter(Operation operation, AbstractSerializableParameter parameter, SwaggerServlet.AbstractSwaggerBuilderFactory factory) {
        operation.parameter((Parameter)parameter.description("Query timeout in seconds. Default is " + factory.getServlet().getDefaultQueryTimeout() + " seconds.").required(false).type("integer"));
    }

    public static List<String> listDataspaces(DataspacesAccessList dataspaceAccessList, FabricConnection connection) throws SwaggerBuilderException {
        String nodeName = dataspaceAccessList.getNodeName();
        List<String> dataspaces = dataspaceAccessList.getDataspacesAccessList().getExactNames();
        if (dataspaces.size() == 0) {
            FabricNodeReference node;
            try {
                if (nodeName != null) {
                    node = connection.getModerator().lookupFabricNode(nodeName);
                    if (node == null) {
                        throw new SwaggerBuilderException("Node '" + nodeName + "' not found.");
                    }
                } else {
                    node = connection.getModerator().getFabricNode();
                }
            }
            catch (SwaggerBuilderException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new SwaggerBuilderException("Failed to get fabric node.", exception);
            }
            List<String> componentNames = node.listComponents();
            for (String componentName : componentNames) {
                String dataspaceName;
                ComponentReference component = node.lookupComponent(componentName);
                if (component.getModel() != ComponentModel.DATASPACE) continue;
                componentName = ModeratorUtils.extractComponentName(componentName);
                Object componentFullName = componentName;
                if (nodeName != null) {
                    componentFullName = nodeName + "." + componentName;
                }
                if (SqlInvariants.isSystemSchemaName(dataspaceName = ModeratorUtils.extractComponentNameName(componentName)) || SqlInvariants.isLobsSchemaName(dataspaceName) || dataspaceAccessList.getDataspacesAccessList().isExcluded(componentName) || dataspaceAccessList.getDataspacesAccessList().isExcluded((String)componentFullName) || !dataspaceAccessList.getDataspacesAccessList().isAllowed(componentName) && !dataspaceAccessList.getDataspacesAccessList().isAllowed((String)componentFullName)) continue;
                dataspaces.add((String)componentFullName);
            }
        }
        return dataspaces;
    }

    private String getBasePath() {
        if (this.basePath != null) {
            return this.basePath;
        }
        return this.dataspaceAccessList.getDataspacesAccessList().isSingleName() ? "/ds/" + this.dataspaceAccessList.getDataspacesAccessList().getSingleName() : "/ds";
    }

    private String getPrefix(String dataspaceName) {
        if (this.basePath != null) {
            if (this.basePath.equals("/")) {
                return "/ds/" + dataspaceName;
            }
            if (this.basePath.equalsIgnoreCase("/ds")) {
                return "/" + dataspaceName;
            }
            return "";
        }
        return this.dataspaceAccessList.getDataspacesAccessList().isSingleName() ? "" : "/" + dataspaceName;
    }

    private DataspacesAccessList.DataspaceObjectsAccessList getDataspaceObjectsAccessList(String dataspaceName) {
        return this.dataspaceAccessList.getDataspaceObjectsAccessList(dataspaceName);
    }

    private static /* synthetic */ boolean lambda$addQueueBodyParameter$4(JdbcModel.JdbcColumn c) {
        return c.columnName.equals("Object");
    }
}

