/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.dataspace;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.ds.SqlInvariants;
import com.streamscape.omf.odata.v4.server.jdbc.connector.JdbcOverFabricConnectionImpl;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApplicationResourceMatcher;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspaceSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspacesAccessList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class DataspaceApiDiscover {
    private FabricConnection connection;
    private Set<Application.Resource> resources;
    private ApplicationResourceMatcher.Matcher matcher;
    private static final List<String> methods = Arrays.asList("GET", "POST", "PUT", "DELETE", "PATCH");

    public DataspaceApiDiscover(FabricConnection connection, Set<Application.Resource> resources) {
        this.connection = connection;
        this.resources = resources;
        this.matcher = ApplicationResourceMatcher.create(resources, (m, u) -> new Application.Resource(m, u));
    }

    public DataspacesAccessList discoverDataspacesAccessList() throws SwaggerBuilderException {
        DataspacesAccessList allowAllList = new DataspacesAccessList();
        DataspacesAccessList accessList = new DataspacesAccessList();
        List<String> dataspaces = DataspaceSwaggerBuilder.listDataspaces(allowAllList, this.connection);
        for (String dataspace : dataspaces) {
            try (JdbcOverFabricConnectionImpl jdbc = new JdbcOverFabricConnectionImpl(this.connection, dataspace);){
                jdbc.connect();
                DataspacesAccessList.DataspaceObjectsAccessList objectsAccessList = new DataspacesAccessList.DataspaceObjectsAccessList();
                boolean accepted = false;
                accepted |= this.acceptAnyDsqlQuery(dataspace, objectsAccessList);
                accepted |= this.acceptFunctionsQuery(dataspace, DataspaceApiDiscover.listFunctionNames(jdbc), objectsAccessList);
                if (!(accepted |= this.acceptCollectionsQuery(dataspace, DataspaceApiDiscover.listCollectionNames(jdbc, true, false, false), objectsAccessList))) continue;
                accessList.getDataspacesAccessList().include(dataspace);
                accessList.addDataspaceObjectsAccessList(dataspace, objectsAccessList);
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to establish JDBC connection to dataspace '{}'.", dataspace);
                Trace.logException(this, exception, true);
            }
        }
        return accessList.isEmpty() ? null : accessList;
    }

    public static Set<String> listFunctionNames(JdbcOverFabricConnectionImpl jdbc) {
        TreeSet<String> names = new TreeSet<String>();
        try {
            RowSet rowSet = jdbc.getDataspaceAccessor().executeQuery("list functions");
            while (rowSet.next()) {
                names.add(rowSet.getString(1));
            }
        }
        catch (Exception exception) {
            Trace.logException(DataspaceApiDiscover.class, exception, true);
        }
        return names;
    }

    public static Set<String> listCollectionNames(JdbcOverFabricConnectionImpl jdbc, boolean all, boolean onlyTables, boolean onlyQueues) {
        TreeSet<String> names = new TreeSet<String>();
        try {
            RowSet rowSet = jdbc.getDataspaceAccessor().executeQuery("list collections");
            while (rowSet.next()) {
                if (SqlInvariants.isSystemCollection(jdbc.getDataspaceAccessor().getComponentType(), jdbc.getDataspaceAccessor().getComponentName(), rowSet.getString(2))) continue;
                String type = rowSet.getString(1).toLowerCase();
                if (!all && (!onlyTables || type.contains("queue")) && (!onlyQueues || !type.contains("queue"))) continue;
                names.add(rowSet.getString(2));
            }
        }
        catch (Exception exception) {
            Trace.logException(DataspaceApiDiscover.class, exception, true);
        }
        return names;
    }

    private boolean acceptAnyDsqlQuery(String dataspace, DataspacesAccessList.DataspaceObjectsAccessList accessList) {
        String dsqlCall = "/ds/" + dataspace + "/dsql";
        ApplicationResourceMatcher.ResourceInfo info = this.matcher.matches(dsqlCall);
        String mask = DataspaceApiDiscover.getMethodMask(info);
        if (mask.length() > 0) {
            accessList.setAnyDsql(mask);
            return true;
        }
        accessList.setAnyDsql(null);
        return false;
    }

    private boolean acceptFunctionsQuery(String dataspace, Set<String> functionNames, DataspacesAccessList.DataspaceObjectsAccessList objectsAccessList) {
        boolean accepted = false;
        for (String functionName : functionNames) {
            String functionCall = "/ds/" + dataspace + "/fn/" + functionName;
            ApplicationResourceMatcher.ResourceInfo info = this.matcher.matches(functionCall);
            String mask = DataspaceApiDiscover.getMethodMask(info);
            if (mask.length() <= 0) continue;
            objectsAccessList.includeFunction(functionName, mask);
            accepted = true;
        }
        if (!accepted) {
            objectsAccessList.excludeFunctions("*");
        }
        return accepted;
    }

    private boolean acceptCollectionsQuery(String dataspace, Set<String> names, DataspacesAccessList.DataspaceObjectsAccessList objectsAccessList) {
        boolean accepted = false;
        for (String name : names) {
            String collectionCall = "/ds/" + dataspace + "/collection/" + name;
            ApplicationResourceMatcher.ResourceInfo info = this.matcher.matches(collectionCall);
            String mask = DataspaceApiDiscover.getMethodMask(info);
            if (mask.length() <= 0) continue;
            objectsAccessList.includeTable(name, mask);
            accepted = true;
        }
        if (!accepted) {
            objectsAccessList.excludeTables("*");
        }
        return accepted;
    }

    public static String getMethodMask(ApplicationResourceMatcher.ResourceInfo info) {
        if (info != null) {
            return methods.stream().filter(method -> info.getMethodMatcher().matches((String)method)).collect(Collectors.joining("|"));
        }
        return "";
    }
}

