/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.dataspace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AccessList {
    private Map<String, String> included;
    private Map<String, String> excluded;

    public boolean isSingleName() {
        return (this.excluded == null || this.excluded.size() == 0) && this.included != null && this.included.size() == 1 && !this.included.containsKey("*");
    }

    public String getSingleName() {
        if (this.isSingleName()) {
            return (String)this.included.keySet().stream().findAny().get();
        }
        return null;
    }

    public List<String> getExactNames() {
        ArrayList<String> exactNames = new ArrayList<String>();
        if (this.included != null && this.included.size() > 0 && !this.included.containsKey("*")) {
            exactNames = new ArrayList<String>(this.included.keySet());
            if (this.excluded != null) {
                exactNames.removeAll(this.included.keySet());
            }
        }
        return exactNames;
    }

    public List<String> getExact(List<String> names) {
        List<String> exactNames = new ArrayList<String>(names);
        if (this.excluded != null) {
            if (this.excluded.containsKey("*")) {
                exactNames.clear();
                return exactNames;
            }
            exactNames.removeAll(this.excluded.keySet());
        }
        if (this.included != null && !this.included.containsKey("*")) {
            exactNames = exactNames.stream().filter(d -> this.included.containsKey(d)).collect(Collectors.toList());
        }
        return exactNames;
    }

    public boolean isAllAllowed() {
        return (this.excluded == null || this.excluded.size() == 0) && (this.included == null || this.included.size() == 0 || this.included.containsKey("*") && this.included.get("*").equals("*"));
    }

    public boolean isAllowed(String name) {
        if (this.excluded != null && (this.excluded.containsKey("*") || this.excluded.containsKey(name))) {
            return false;
        }
        return this.included == null || this.included.size() == 0 || this.included.containsKey("*") || this.included.containsKey(name);
    }

    public boolean isAllowed(String name, String method) {
        if (this.excluded != null && (this.excluded.containsKey("*") && this.isMethodHere(this.excluded.get("*"), method) || this.excluded.containsKey(name) && this.isMethodHere(this.excluded.get(name), method))) {
            return false;
        }
        return this.included == null || this.included.size() == 0 || this.included.containsKey("*") && this.isMethodHere(this.included.get("*"), method) || this.included.containsKey(name) && this.isMethodHere(this.included.get(name), method);
    }

    public boolean isExcluded(String name) {
        return this.excluded != null && (this.excluded.containsKey("*") || this.excluded.containsKey(name));
    }

    public boolean isExcluded(String name, String method) {
        return this.excluded != null && (this.excluded.containsKey("*") && this.isMethodHere(this.excluded.get("*"), method) || this.excluded.containsKey(name) && this.isMethodHere(this.excluded.get(name), method));
    }

    public AccessList include(String ... names) {
        return this.include(Arrays.asList(names));
    }

    public AccessList include(List<String> names) {
        if (this.included == null) {
            this.included = new HashMap<String, String>();
        }
        names.stream().forEach(name -> this.included.put((String)name, "*"));
        return this;
    }

    public AccessList includeWithMethod(String name, String method) {
        this.included = this.addTo(name, method, this.included);
        return this;
    }

    public AccessList exclude(String ... names) {
        return this.exclude(Arrays.asList(names));
    }

    public AccessList exclude(List<String> names) {
        if (this.excluded == null) {
            this.excluded = new HashMap<String, String>();
        }
        names.stream().forEach(name -> this.excluded.put((String)name, "*"));
        return this;
    }

    public AccessList excludeWithMethod(String name, String method) {
        this.excluded = this.addTo(name, method, this.excluded);
        return this;
    }

    private Map<String, String> addTo(String name, String method, Map<String, String> map) {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        method = method.toUpperCase();
        Object mask = map.get(name);
        if (mask != null) {
            if (method.equals("*")) {
                mask = method;
            } else if (!((String)mask).equals("*") && !((String)mask).contains(method)) {
                mask = (String)mask + "|" + method;
            }
        } else {
            mask = method;
        }
        map.put(name, (String)mask);
        return map;
    }

    private boolean isMethodHere(String mask, String method) {
        return mask.equals("*") || mask.contains(method.toUpperCase());
    }
}

