/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.clientgen;

import com.streamscape.Trace;
import com.streamscape.lib.http.HTTPClient;
import com.streamscape.lib.http.HTTPClientResponse;
import com.streamscape.lib.http.ModuleException;
import com.streamscape.lib.http.NVPair;
import com.streamscape.lib.http.SSLContextFactory;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.ZipUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.swagger.clientgen.SwaggerClientGenGeneratorService;
import com.streamscape.sef.network.http.server.swagger.clientgen.SwaggerClientGenService;
import com.streamscape.sef.network.http.server.utils.MultipartFormDataHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;

public class SwaggerClientGenServiceIml
implements SwaggerClientGenService {
    private HTTPAcceptorConfiguration httpAcceptorConfiguration;

    public void setHttpAcceptorConfiguration(HTTPAcceptorConfiguration httpAcceptorConfiguration) {
        this.httpAcceptorConfiguration = httpAcceptorConfiguration;
    }

    @Override
    public void generateFromUrl(String url, String language, String properties, HttpServletRequest request, HttpServletResponse response) {
        Object newurl = url;
        String scheme = "http";
        String host = null;
        int port = 80;
        int pos = ((String)newurl).indexOf("://");
        if (pos != -1) {
            scheme = ((String)newurl).substring(0, pos);
            newurl = ((String)newurl).substring(pos + 3);
        }
        if ((pos = ((String)newurl).indexOf("/")) == -1) {
            pos = ((String)newurl).length();
        }
        if (pos > 0) {
            host = ((String)newurl).substring(0, pos);
            newurl = ((String)newurl).substring(pos);
        } else {
            host = this.httpAcceptorConfiguration.getResolvedUrlWithoutSchema();
            String string = scheme = this.httpAcceptorConfiguration.getEnableSSL() ? "https" : "http";
        }
        if (scheme.equals("https")) {
            port = 443;
        }
        if ((pos = host.indexOf(":")) != -1) {
            port = Integer.valueOf(host.substring(pos + 1));
            host = host.substring(0, pos);
        }
        String definition = null;
        try {
            HTTPClient client = new HTTPClient(scheme, host, port);
            if (scheme.equals("https")) {
                try {
                    SSLContextFactory sslContextFactory = new SSLContextFactory();
                    sslContextFactory.trustAllCertificates();
                    client.setSSLContextFactory(sslContextFactory);
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
            }
            NVPair[] headers = null;
            int pos2 = ((String)newurl).indexOf("?h=");
            boolean authenticated = false;
            if (pos2 > 0) {
                try {
                    newurl = ((String)newurl).substring(0, pos2 + 1) + "x-session-token=" + new String(Base64.decode(((String)newurl).substring(pos2 + 3)));
                    headers = new NVPair[]{new NVPair("User-Agent", request.getHeader("User-Agent"))};
                    authenticated = true;
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    throw new ServerErrorException("Failed to encode x-session-token.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)exception);
                }
            } else {
                HTTPCredentials httpCredentials = (HTTPCredentials)request.getAttribute(HTTPCredentials.ATTRIBUTE);
                if (httpCredentials != null && "basic".equalsIgnoreCase(request.getAuthType())) {
                    String password = HTTPCredentials.wrapCredentials(httpCredentials.getCredentials());
                    newurl = ((String)newurl).indexOf("?") != -1 ? (String)newurl + "&" : (String)newurl + "?";
                    newurl = (String)newurl + "Authorization=basic " + Base64.encodeBytes((httpCredentials.getUserName() + ":" + password).getBytes());
                    authenticated = true;
                }
                if (!authenticated) {
                    Trace.logInfo(this, "WARNING: using anonymous authentication to get swagger URL '" + (String)newurl + "'.");
                }
            }
            HTTPClientResponse clientResponse = client.Get((String)newurl, (String)null, headers);
            byte[] data = clientResponse.getData();
            if (clientResponse.getStatusCode() != 200) {
                String sdata = null;
                if (data != null) {
                    sdata = new String(data);
                }
                Trace.logError(this, sdata);
                if (!authenticated) {
                    Trace.logError(this, "WARNING: anonymous authentication was used to access swagger URL '" + (String)newurl + "'. It seems that anonymous user doesn't have access to this realm.");
                }
                throw new ClientErrorException("Failed to get swagger definition from specified url '" + url + "'. Status " + clientResponse.getStatusCode() + " received. Cause: " + sdata, Response.Status.BAD_REQUEST);
            }
            definition = new String(data);
        }
        catch (ModuleException | IOException exception) {
            throw new ServerErrorException("Failed to get swagger definition from specified url '" + url + "'. Cause: " + exception.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.generateFromDefinition(definition, language, properties, response);
    }

    @Override
    public void generateFromDefinition(String language, HttpServletRequest request, String properties, HttpServletResponse response) {
        List<FileItem> items;
        if (!MultipartFormDataHelper.isMultipartFormDataRequest(request)) {
            throw new BadRequestException("Generate from definition should contain multipart form data.");
        }
        try {
            items = MultipartFormDataHelper.getOrParseMultiParts(request, this.httpAcceptorConfiguration, 1);
        }
        catch (IOException exception) {
            throw new ClientErrorException("Failed to parse multi part message.", Response.Status.BAD_REQUEST);
        }
        String definition = null;
        for (FileItem item : items) {
            if (item.isFormField()) continue;
            definition = new String(item.get());
        }
        if (language == null) {
            throw new ClientErrorException("Language parameter is missing.", Response.Status.BAD_REQUEST);
        }
        if (definition == null) {
            throw new ClientErrorException("Definition parameter is missing.", Response.Status.BAD_REQUEST);
        }
        this.generateFromDefinition(definition, language, properties, response);
    }

    private void generateFromDefinition(String definition, String language, String properties, HttpServletResponse response) {
        Class<?> generatorServiceClass = null;
        try {
            generatorServiceClass = SwaggerClientGenServiceIml.loadGeneratorServiceImpl();
        }
        catch (Exception exception) {
            throw new ServerErrorException("stswagger-client-gen.jar is not found on classpath. Please add it as ext or lib jar.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)exception);
        }
        SwaggerClientGenGeneratorService generatorService = null;
        try {
            generatorService = (SwaggerClientGenGeneratorService)generatorServiceClass.newInstance();
        }
        catch (Exception exception) {
            throw new ServerErrorException("Failed to create instance of '" + String.valueOf(generatorServiceClass) + "'.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)exception);
        }
        Path tmpDirectory = this.getTmpDirectory(language);
        try {
            Path appDirectory = generatorService.generate(definition, language, properties, tmpDirectory);
            this.zipFileAndSendToResponse(appDirectory, response);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            throw new ServerErrorException("Failed to generate client.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)exception);
        }
        finally {
            FileIOUtils.deleteFileDir(tmpDirectory.toFile());
        }
    }

    private void zipFileAndSendToResponse(Path appDirectory, HttpServletResponse response) {
        Path zipFilepath = Paths.get(appDirectory.getParent().toAbsolutePath().toString(), String.valueOf(appDirectory.getFileName()) + ".zip");
        try {
            ZipUtils.compress(appDirectory.toFile(), zipFilepath.toFile());
        }
        catch (IOException exception) {
            throw new ServerErrorException("Failed to zip directory.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)exception);
        }
        response.setContentType("application/x-download");
        response.setContentLengthLong(zipFilepath.toFile().length());
        try (FileInputStream input = new FileInputStream(zipFilepath.toFile());){
            FileIOUtils.copy((InputStream)input, (OutputStream)response.getOutputStream());
        }
        catch (Exception exception) {
            throw new ServerErrorException("Failed write zip file to response.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)exception);
        }
    }

    private Path getTmpDirectory(String language) {
        JettyAdvancedProperties.Properties properties = JettyAdvancedProperties.build(this.httpAcceptorConfiguration);
        String tmpDirectory = properties.getProperty("jetstream.tmp.directory");
        if (tmpDirectory == null || tmpDirectory.length() == 0) {
            tmpDirectory = ".";
        }
        try {
            return Files.createTempDirectory(Paths.get(tmpDirectory, new String[0]), "swagger_client_" + language + "_", new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new ServerErrorException("Failed to create tmp directory.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)exception);
        }
    }

    private static Class<?> loadGeneratorServiceImpl() throws ClassNotFoundException {
        return RuntimeContext.getInstance().getPackageLoaderRegistry().getSystemClassLoaderChain().loadClass("com.streamscape.swagger.client.gen.SwaggerClientGenGeneratorServiceImpl");
    }

    public static boolean isGeneratorServiceImplExists() {
        try {
            return SwaggerClientGenServiceIml.loadGeneratorServiceImpl() != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

