/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.clientgen;

import com.streamscape.sef.network.http.server.jaxrs.exception.HttpResourceError;
import com.streamscape.sef.network.http.server.jaxrs.injection.ServiceInject;
import com.streamscape.sef.network.http.server.jaxrs.swagger.FileParam;
import com.streamscape.sef.network.http.server.swagger.clientgen.SwaggerClientGenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

@Path(value="/")
@Api(tags={"Swagger Client Generator"}, produces="application/octet-stream", consumes="application/json")
@Produces(value={"application/octet-stream"})
@Consumes(value={"application/json"})
@ApiResponses(value={@ApiResponse(code=400, message="Bad request", response=HttpResourceError.class), @ApiResponse(code=401, message="Unauthorized", response=HttpResourceError.class), @ApiResponse(code=405, message="Invalid arguments", response=HttpResourceError.class), @ApiResponse(code=406, message="Server error", response=HttpResourceError.class), @ApiResponse(code=500, message="Internal server error", response=HttpResourceError.class)})
public class SwaggerClientGenResource {
    @ServiceInject
    SwaggerClientGenService service;
    public static final Map<String, String> allowableLanguagesMap = new LinkedHashMap<String, String>();
    static final String allowableLanguages = "java,android,javascript,objc,python,scala,swift,csharp,cpprest,clojure,dart,groovy,go,php,ruby";

    @Path(value="/generate")
    @GET
    @ApiOperation(value="Generates swagger client in specified language for specified swagger definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=byte[].class)})
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/json"})
    public void generate(@ApiParam(value="URL to swagger definition.", required=true) @QueryParam(value="url") String url, @ApiParam(value="Client language.", allowableValues="java,android,javascript,objc,python,scala,swift,csharp,cpprest,clojure,dart,groovy,go,php,ruby", required=true) @QueryParam(value="language") String language, @ApiParam(value="Language specific properties.", required=false) @QueryParam(value="properties") @DefaultValue(value="") String properties, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        this.service.generateFromUrl(url, language, properties, request, response);
    }

    @Path(value="/generate")
    @POST
    @ApiOperation(value="Generates swagger client in specified language for specified swagger definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=byte[].class)})
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"multipart/form-data"})
    public void upload(@ApiParam(value="Swagger definition.", required=true) @FileParam(value="definition") String definition, @ApiParam(value="Client language.", allowableValues="java,android,javascript,objc,python,scala,swift,csharp,cpprest,clojure,dart,groovy,go,php,ruby", required=true) @QueryParam(value="language") String language, @ApiParam(value="Language specific properties.", required=false) @QueryParam(value="properties") @DefaultValue(value="") String properties, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        this.service.generateFromDefinition(language, request, properties, response);
    }

    static {
        allowableLanguagesMap.put("java", "Java");
        allowableLanguagesMap.put("android", "Java Android");
        allowableLanguagesMap.put("javascript", "Javascript");
        allowableLanguagesMap.put("javascript", "NodeJS/Javascript");
        allowableLanguagesMap.put("csharp", "C#");
        allowableLanguagesMap.put("objc", "ObjC");
        allowableLanguagesMap.put("python", "Python");
        allowableLanguagesMap.put("scala", "Scala");
        allowableLanguagesMap.put("swift", "Swift");
        allowableLanguagesMap.put("---", "-----------");
        allowableLanguagesMap.put("cpprest", "C++");
        allowableLanguagesMap.put("clojure", "Clojure");
        allowableLanguagesMap.put("dart", "Dart");
        allowableLanguagesMap.put("groovy", "Groovy");
        allowableLanguagesMap.put("go", "Go");
        allowableLanguagesMap.put("php", "PHP");
        allowableLanguagesMap.put("ruby", "Ruby");
    }
}

