/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.apikey;

import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.service.ApplicationService;
import com.streamscape.sef.network.http.server.swagger.AbstractSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.SwaggerServlet;
import com.streamscape.sef.network.http.server.swagger.apicustomizer.AbstractApiCustomizerSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.apicustomizer.ApiCustomizerDataspaceSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.apicustomizer.ApiCustomizerDataspaceSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.swagger.apicustomizer.ApiCustomizerFilter;
import com.streamscape.sef.network.http.server.swagger.apicustomizer.ApiCustomizerServiceSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.apicustomizer.ApiCustomizerServiceSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.swagger.apikey.ApiKeyApplicationSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspaceApiDiscover;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspaceSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspaceSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspacesAccessList;
import com.streamscape.sef.network.http.server.swagger.service.ServiceApiDiscover;
import com.streamscape.sef.network.http.server.swagger.service.ServiceSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.service.ServiceSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.swagger.service.ServicesAccessList;
import com.streamscape.sef.network.http.server.uri.UriUtils;
import com.streamscape.sef.security.SecurityManagerException;
import io.swagger.models.Swagger;
import java.util.List;
import java.util.stream.Collectors;

public class ApiKeyApplicationSwaggerBuilder
extends AbstractSwaggerBuilder {
    private final String applicationId;
    private final ApiKeyApplicationSwaggerBuilderFactory factory;
    private Application application;

    public ApiKeyApplicationSwaggerBuilder(String applicationId, ApiKeyApplicationSwaggerBuilderFactory factory, String client) {
        super(client);
        this.applicationId = applicationId;
        this.factory = factory;
    }

    @Override
    public Swagger build() throws SwaggerBuilderException {
        try {
            ApplicationService service = RuntimeContext.getInstance().getHTTPAuthenticationManager().authorize(this.connection.getSecurityManager().lookupUser(this.connection.getUserName())).getApiKeyServiceFactory().getApplicationService();
            this.application = service.get(this.applicationId, true);
            if (this.application == null) {
                throw new SwaggerBuilderException("Specified application doesn't exist.");
            }
        }
        catch (FabricConnectionException | SecurityManagerException exception) {
            throw new SwaggerBuilderException("Failed to get security manager.", exception);
        }
        Swagger swagger = new Swagger();
        this.setHost(swagger);
        this.setInfo(swagger);
        this.setSecurity(swagger);
        swagger.getInfo().title("API to Application " + this.application.getName());
        swagger.getInfo().description(this.application.getDescription());
        return this.build(swagger);
    }

    @Override
    public Swagger build(Swagger swagger) throws SwaggerBuilderException {
        AbstractSwaggerBuilder builder;
        SwaggerServlet.AbstractSwaggerBuilderFactory factory;
        DataspacesAccessList dataspacesAccessList = new DataspaceApiDiscover(this.connection, this.application.getResources()).discoverDataspacesAccessList();
        ServicesAccessList servicesAccessListAccessList = new ServiceApiDiscover(this.connection, this.application.getResources()).discoverServicesAccessList();
        APICustomizerConfiguration apiCustomizerConfiguration = new ApiCustomizerFilter(this.acceptorConfiguration.getAPICustomizerConfiguration()).filterBy(this.application).getConfiguration();
        String basePath = null;
        List<AbstractRule> allRules = apiCustomizerConfiguration.listAllRules();
        if (allRules.size() > 0) {
            basePath = UriUtils.buildPrefixForUris(allRules.stream().map(rule -> rule.getExternalURI()).collect(Collectors.toList()));
        }
        if (servicesAccessListAccessList != null) {
            basePath = UriUtils.buildPrefixForUris(basePath, "/service");
        }
        if (dataspacesAccessList != null) {
            basePath = UriUtils.buildPrefixForUris(basePath, "/ds");
        }
        if (basePath != null) {
            swagger.setBasePath(basePath);
        }
        if (dataspacesAccessList != null) {
            factory = new DataspaceSwaggerBuilderFactory();
            factory.setServlet(this.factory.getServlet());
            builder = (DataspaceSwaggerBuilder)((DataspaceSwaggerBuilderFactory)factory).create(dataspacesAccessList, this.client);
            builder.setConnection(this.connection);
            builder.setAcceptorConfiguration(this.acceptorConfiguration);
            builder.setBasePath(swagger.getBasePath());
            swagger = ((DataspaceSwaggerBuilder)builder).build(swagger);
        }
        if (servicesAccessListAccessList != null) {
            factory = new ServiceSwaggerBuilderFactory();
            factory.setServlet(this.factory.getServlet());
            builder = (ServiceSwaggerBuilder)((ServiceSwaggerBuilderFactory)factory).create(servicesAccessListAccessList, this.client);
            builder.setConnection(this.connection);
            builder.setAcceptorConfiguration(this.acceptorConfiguration);
            builder.setBasePath(swagger.getBasePath());
            swagger = ((ServiceSwaggerBuilder)builder).build(swagger);
        }
        if (apiCustomizerConfiguration != null) {
            if (apiCustomizerConfiguration.listDataspaceRules().size() > 0) {
                factory = new ApiCustomizerDataspaceSwaggerBuilderFactory();
                factory.setServlet(this.factory.getServlet());
                builder = (ApiCustomizerDataspaceSwaggerBuilder)((ApiCustomizerDataspaceSwaggerBuilderFactory)factory).create(new DataspacesAccessList(), this.client);
                builder.setConnection(this.connection);
                builder.setAcceptorConfiguration(this.acceptorConfiguration);
                builder.setBasePath(swagger.getBasePath());
                ((AbstractApiCustomizerSwaggerBuilder)builder).setApiCustomizerConfiguration(apiCustomizerConfiguration);
                ((AbstractApiCustomizerSwaggerBuilder)builder).setApplication(this.application);
                swagger = ((ApiCustomizerDataspaceSwaggerBuilder)builder).build(swagger);
            }
            if (apiCustomizerConfiguration.listServiceRules().size() > 0) {
                factory = new ApiCustomizerServiceSwaggerBuilderFactory();
                factory.setServlet(this.factory.getServlet());
                builder = ((ApiCustomizerServiceSwaggerBuilderFactory)factory).create(new ServicesAccessList(), this.client);
                builder.setConnection(this.connection);
                builder.setAcceptorConfiguration(this.acceptorConfiguration);
                builder.setBasePath(swagger.getBasePath());
                ((AbstractApiCustomizerSwaggerBuilder)builder).setApiCustomizerConfiguration(apiCustomizerConfiguration);
                ((AbstractApiCustomizerSwaggerBuilder)builder).setApplication(this.application);
                swagger = ((ApiCustomizerServiceSwaggerBuilder)builder).build(swagger);
            }
        }
        return swagger;
    }
}

