/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.apicustomizer;

import com.streamscape.Trace;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.lib.utils.SemanticTypeResolver;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.service.AbstractServiceRule;
import com.streamscape.sef.network.http.server.apicustomizer.service.AbstractServiceRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceRuleWrapper;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.apicustomizer.AbstractApiCustomizerSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.dataspace.SwaggerTypeResolver;
import com.streamscape.sef.network.http.server.swagger.service.ServiceSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.service.ServicesAccessList;
import com.streamscape.service.osf.evh.EventHandler;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class ApiCustomizerServiceSwaggerBuilder
extends AbstractApiCustomizerSwaggerBuilder {
    private final ServicesAccessList servicesAccessList;
    private List<AbstractServiceRule> serviceRules = null;
    private List<String> servicesList;
    private Map<String, List<EventHandler>> eventHandlersMap = new HashMap<String, List<EventHandler>>();

    public ApiCustomizerServiceSwaggerBuilder(String client, ServicesAccessList servicesAccessList) {
        super(client);
        this.servicesAccessList = servicesAccessList;
    }

    @Override
    public Swagger build() throws SwaggerBuilderException {
        Swagger swagger = new Swagger();
        this.setHost(swagger);
        this.setInfo(swagger);
        this.setSecurity(swagger);
        swagger.basePath(this.getBasePath());
        if (this.servicesAccessList.getServicesAccessList().isSingleName()) {
            Object fullName = this.servicesAccessList.getServicesAccessList().getSingleName();
            if (this.servicesAccessList.getNodeName() != null) {
                fullName = this.servicesAccessList.getNodeName() + "." + (String)fullName;
            }
            swagger.getInfo().title((String)fullName);
            swagger.getInfo().description("<div>REST API for invoking Service Operations.<br><table><tr><td>Service Type:</td><td>" + ModeratorUtils.extractComponentNameType(this.servicesAccessList.getServicesAccessList().getSingleName()) + "</td></tr><tr><td>Service Name:</td><td>" + ModeratorUtils.extractComponentNameName(this.servicesAccessList.getServicesAccessList().getSingleName()) + "</td></tr><tr><td>Full Name:</td><td>" + (String)fullName + "</td></tr></table></div>");
        } else {
            swagger.getInfo().title("Customized API to services in node '" + RuntimeContext.getInstance().getName() + "'.");
            swagger.getInfo().description("Customized API to services in node '" + RuntimeContext.getInstance().getName() + "'.");
        }
        return this.build(swagger);
    }

    @Override
    public Swagger build(Swagger swagger) throws SwaggerBuilderException {
        if (this.servicesAccessList == null) {
            return swagger;
        }
        if (swagger.getBasePath() == null) {
            swagger.setBasePath(this.getBasePath());
        }
        this.swaggerTypeResolver = new SwaggerTypeResolver(swagger, new SemanticTypeResolver());
        for (AbstractServiceRule rule : this.getServiceRulesThatSatisfyToServicesAccessList()) {
            try {
                ServiceRuleWrapper wrapper = (ServiceRuleWrapper)rule.createWrapper();
                this.acceptsServices(wrapper, (service, oal) -> {
                    try {
                        this.addEventHandlerCalls(wrapper, swagger, (String)service);
                    }
                    catch (SwaggerBuilderException exception) {
                        Trace.logException(this, exception, true);
                    }
                    return true;
                }, false);
            }
            catch (APICustomizerException aPICustomizerException) {}
        }
        return swagger;
    }

    private void addEventHandlerCalls(ServiceRuleWrapper wrapper, Swagger swagger, String service) throws SwaggerBuilderException {
        for (EventHandler eventHandler : this.getEventHandlersList(service)) {
            try {
                if (!wrapper.getEventHandlerMacros().acceptsValue(eventHandler.getHandlerName())) continue;
                this.addEventHandlerCall(wrapper, swagger, service, eventHandler);
            }
            catch (Exception excepton) {
                Trace.logException(this, excepton, true);
            }
        }
    }

    private void addEventHandlerCall(ServiceRuleWrapper wrapper, Swagger swagger, final String service, final EventHandler eventHandler) throws SwaggerBuilderException {
        AbstractSerializableParameter parameter;
        String uri = this.buildUri(wrapper, new AbstractServiceRuleParametersResolver(this, wrapper){

            @Override
            protected String onGetServiceName() {
                return service;
            }

            @Override
            protected String onGetEventHandler(String parameterName) {
                return eventHandler.getHandlerName();
            }

            @Override
            protected String onGetCorrelationId(String parameterName) {
                return "{" + parameterName + "}";
            }

            @Override
            protected String onGetDataContent(String parameterName) {
                return "{" + parameterName + "}";
            }

            @Override
            protected String onGetDurable(String parameterName) {
                return "{" + parameterName + "}";
            }

            @Override
            protected String onGetEventGroupId(String parameterName) {
                return "{" + parameterName + "}";
            }

            @Override
            protected String onGetEventId(String parameterName) {
                return "{" + parameterName + "}";
            }

            @Override
            protected String onGetEventKey(String parameterName) {
                return "{" + parameterName + "}";
            }

            @Override
            protected String onGetLoadBalance(String parameterName) {
                return "{" + parameterName + "}";
            }

            @Override
            protected String onGetTimeout(String parameterName) {
                return "{" + parameterName + "}";
            }

            @Override
            protected String onGetEventProperty(String name) {
                return "{" + name + "}";
            }
        });
        if (uri == null) {
            return;
        }
        String method = this.acceptedByApplication(((AbstractServiceRule)wrapper.getRule()).getHttpMethod(), uri, "GET");
        if (method == null) {
            return;
        }
        String tag = ((AbstractServiceRule)wrapper.getRule()).getExternalURI();
        swagger.tag(new Tag().name(tag));
        Operation operation = new Operation();
        operation.tag(tag);
        operation.summary("Customization of event handler call.");
        operation.description("Customization of event handler call.");
        Path path = new Path();
        path.set(method, operation);
        swagger.path(this.relativeUriFromBasePath(uri), path);
        this.setSecurityDefinitionsForOperation(swagger, operation);
        this.addCustomizedProduces(operation, wrapper, true);
        this.addCustomizedResponses(operation, wrapper);
        String result = ServiceSwaggerBuilder.getSemanticTypeOrEventId(eventHandler.getResponseSemanticType(), eventHandler.getResponseEventId(), this.swaggerTypeResolver);
        if (result != null) {
            if (result == eventHandler.getResponseEventId()) {
                response = new Response().description("Event handler response");
                this.schemaEvent(response, result);
                operation.response(200, response);
            } else {
                response = new Response().description("Event handler response");
                this.schema(response, result);
                operation.response(200, response);
            }
        }
        if ((parameter = this.createParameterFromMacros(wrapper.getDataContentAsMacros())) != null) {
            String result2 = ServiceSwaggerBuilder.getSemanticTypeOrEventId(eventHandler.getRequestSemanticType(), eventHandler.getRequestEventId(), this.swaggerTypeResolver);
            String dataParameterDescription = "Data object of type '" + eventHandler.getRequestSemanticType() + "' serialized in corresponding format.";
            if (result2 == eventHandler.getRequestEventId()) {
                dataParameterDescription = "Event [" + eventHandler.getRequestEventId() + "] serialized in corresponding format.";
            }
            operation.parameter((Parameter)parameter.description(dataParameterDescription).required(true).type("string"));
        } else if (wrapper.getDataContentAsMacros() != null && (wrapper.getDataContentAsMacros().isHttpContent() || wrapper.getDataContentAsMacros().isHttpContentBytes())) {
            ServiceSwaggerBuilder.addDataBodyParameter(eventHandler, operation, this.swaggerTypeResolver, this);
            this.addCustomizedConsumes(operation, wrapper, true);
        }
        this.addRequestFormatParameter(operation, wrapper, true);
        this.addResponseFormatParameter(operation, wrapper, true);
        parameter = this.createParameterFromMacros(wrapper.getTimeoutMacros());
        if (parameter != null) {
            ServiceSwaggerBuilder.addTimeoutParameter(operation, parameter);
        }
    }

    private List<AbstractServiceRule> getServiceRulesThatSatisfyToServicesAccessList() throws SwaggerBuilderException {
        if (this.serviceRules != null) {
            return this.serviceRules;
        }
        this.serviceRules = new ArrayList<AbstractServiceRule>();
        APICustomizerConfiguration apiCustomizerConfiguration = this.getApiCustomizerConfiguration();
        if (apiCustomizerConfiguration == null) {
            return this.serviceRules;
        }
        for (AbstractServiceRule rule : apiCustomizerConfiguration.listAllServiceRules()) {
            try {
                boolean[] satisfy = new boolean[]{false};
                ServiceRuleWrapper wrapper = (ServiceRuleWrapper)rule.createWrapper();
                this.acceptsServices(wrapper, (service, oal) -> {
                    for (EventHandler eventHandler : this.getEventHandlersList((String)service)) {
                        if (oal != null && oal.getHandlers() != null && !oal.getHandlers().isAllAllowed() && !oal.getHandlers().isAllowed(eventHandler.getHandlerName()) || !wrapper.getEventHandlerMacros().acceptsValue(eventHandler.getHandlerName())) continue;
                        satisfy[0] = true;
                        return true;
                    }
                    return false;
                }, true);
                if (!satisfy[0]) continue;
                this.serviceRules.add(rule);
            }
            catch (APICustomizerException aPICustomizerException) {}
        }
        return this.serviceRules;
    }

    @Override
    protected List getRules() throws SwaggerBuilderException {
        return this.getServiceRulesThatSatisfyToServicesAccessList();
    }

    private void acceptsServices(ServiceRuleWrapper wrapper, BiFunction<String, ServicesAccessList.ServiceObjectsAccessList, Boolean> onService, boolean breakIfFound) throws SwaggerBuilderException {
        for (String service : this.getServicesList()) {
            ServicesAccessList.ServiceObjectsAccessList oal;
            if (!this.isServiceMacroAcceptsValue(wrapper.getServiceNameMacros(), service) || !onService.apply(service, oal = this.servicesAccessList.getServiceObjectsAccessList(service)).booleanValue() || !breakIfFound) continue;
            break;
        }
    }

    private boolean isServiceMacroAcceptsValue(ParameterMacros macros, String value) {
        return macros.acceptsValue(value);
    }

    public List<String> getServicesList() throws SwaggerBuilderException {
        if (this.servicesList == null) {
            this.servicesList = ServiceSwaggerBuilder.listServices(this.servicesAccessList, this.connection);
        }
        return this.servicesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventHandler> getEventHandlersList(String service) {
        List<EventHandler> eventHandlersList = this.eventHandlersMap.get(service);
        if (eventHandlersList != null) {
            return eventHandlersList;
        }
        try (ServiceAccessor accessor = null;){
            accessor = ServiceSwaggerBuilder.createServiceAccessor(service, null, this.connection);
            eventHandlersList = accessor.getEventHandlers();
            eventHandlersList.sort((o1, o2) -> o1.getHandlerName().compareToIgnoreCase(o2.getHandlerName()));
            this.eventHandlersMap.put(service, eventHandlersList);
        }
        return eventHandlersList;
    }
}

