/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.apicustomizer;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.any.AnyRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRule;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.EventFabricRule;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceRule;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.authentication.runtime.model.ApplicationResourceMatcher;
import com.streamscape.sef.network.http.server.uri.UriTree;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ApiCustomizerFilter {
    private APICustomizerConfiguration configuration;

    public ApiCustomizerFilter(APICustomizerConfiguration configuration) {
        this.configuration = configuration;
    }

    public ApiCustomizerFilter filterBy(Application application) {
        APICustomizerConfiguration filtered = new APICustomizerConfiguration();
        this.processRules(this.configuration.listAllRules(), rule -> {
            try {
                if (rule instanceof AbstractDataspaceRule) {
                    filtered.addDataspaceRule((AbstractDataspaceRule)rule);
                } else if (rule instanceof ServiceRule) {
                    filtered.addServiceRule((ServiceRule)rule);
                } else if (rule instanceof EventFabricRule) {
                    filtered.addEventFabricRule((EventFabricRule)rule);
                } else if (rule instanceof AnyRule) {
                    filtered.addAnyRule((AnyRule)rule);
                }
            }
            catch (APICustomizerException exception) {
                Trace.logException(this, exception, true);
            }
        }, application);
        this.configuration = filtered;
        return this;
    }

    public APICustomizerConfiguration getConfiguration() {
        return this.configuration;
    }

    private void processRules(List rules, Consumer<AbstractRule> acceptedRuleConsumer, Application application) {
        for (Object objectRule : rules) {
            AbstractRule rule = (AbstractRule)objectRule;
            if (!this.acceptRule(rule, application)) continue;
            acceptedRuleConsumer.accept(rule);
        }
    }

    private boolean acceptRule(AbstractRule rule, Application application) {
        if (!this.isUriParametrized(rule.getExternalURI())) {
            return application.matches(rule.getHttpMethod(), rule.getExternalURI()) != null;
        }
        Set<Application.Resource> resources = this.getResourcesByMethod(application, rule.getHttpMethod());
        if (resources.size() == 0) {
            return false;
        }
        List<UriTree.UriNodeValue> ruleUri = this.parseUriToNodeValues(rule.getExternalURI(), "rule");
        if (ruleUri == null) {
            return false;
        }
        for (Application.Resource resource : resources) {
            List<UriTree.UriNodeValue> resourceUri = this.parseUriToNodeValues(resource.getUrl(), "resource");
            if (resourceUri == null) continue;
            boolean matches = false;
            boolean doesnotMatch = false;
            for (int index = 0; index < ruleUri.size(); ++index) {
                UriTree.UriNodeValue ruleUriNode = ruleUri.get(index);
                if (resourceUri.size() <= index) {
                    doesnotMatch = true;
                    break;
                }
                UriTree.UriNodeValue resourceUriNode = resourceUri.get(index);
                if (resourceUriNode instanceof UriTree.UriNodeValueStar) {
                    matches = true;
                    break;
                }
                if (ruleUriNode instanceof UriTree.UriNodeValueFixed) {
                    if (resourceUriNode.accept(ruleUriNode)) continue;
                    doesnotMatch = true;
                    break;
                }
                if (ruleUriNode instanceof UriTree.UriNodeValueParameter) continue;
                if (ruleUriNode instanceof UriTree.UriNodeRegexpParameter) {
                    if (!(resourceUriNode instanceof UriTree.UriNodeValueFixed) || ruleUriNode.accept(resourceUriNode)) continue;
                    doesnotMatch = true;
                    break;
                }
                if (!(ruleUriNode instanceof UriTree.UriNodeValueStar)) continue;
            }
            if (matches) {
                return true;
            }
            if (doesnotMatch || ruleUri.size() != resourceUri.size()) continue;
            return true;
        }
        return false;
    }

    private List<UriTree.UriNodeValue> parseUriToNodeValues(String uri, String name) {
        try {
            return UriTree.parseUriToNodeValues(uri);
        }
        catch (UriTree.UriException exception) {
            Trace.logError(this, "Failed to parse {} URI {}.", name, uri);
            return null;
        }
    }

    private boolean isUriParametrized(String uri) {
        return uri.contains("{") || uri.contains("*");
    }

    private Set<Application.Resource> getResourcesByMethod(Application application, String method) {
        return application.getResources().stream().filter(resource -> ApplicationResourceMatcher.MethodMatcher.matches(resource.getMethod(), method)).collect(Collectors.toSet());
    }
}

