/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.apicustomizer;

import com.streamscape.Trace;
import com.streamscape.cli.ds.collection.Queue;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueProxy;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueProxy;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.SemanticTypeResolver;
import com.streamscape.omf.odata.v4.server.jdbc.connector.Jdbc;
import com.streamscape.omf.odata.v4.server.jdbc.connector.JdbcOverFabricConnectionImpl;
import com.streamscape.omf.odata.v4.server.jdbc.model.JdbcModel;
import com.streamscape.omf.odata.v4.server.jdbc.model.JdbcModelGenerator;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceAnyStatementRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceAnyStatementRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceAnyStatementRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceCollectionRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceFunctionRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceODataRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceQueueRule;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceQueueRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.DataspaceQueueRuleWrapper;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.SwaggerServlet;
import com.streamscape.sef.network.http.server.swagger.apicustomizer.AbstractApiCustomizerSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.dataspace.AccessList;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspaceApiDiscover;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspaceSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspacesAccessList;
import com.streamscape.sef.network.http.server.swagger.dataspace.SwaggerTypeResolver;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.lang.invoke.LambdaMetafactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ApiCustomizerDataspaceSwaggerBuilder
extends AbstractApiCustomizerSwaggerBuilder {
    private final DataspacesAccessList dataspaceAccessList;
    private SwaggerServlet.AbstractSwaggerBuilderFactory factory;
    private List<String> dataspacesList;
    private Map<String, List<String>> functionNamesMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> tableNamesMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> queueNamesMap = new HashMap<String, List<String>>();
    private Map<String, JdbcModel.JdbcSchema> queueSchemaMap = new HashMap<String, JdbcModel.JdbcSchema>();
    private Map<String, JdbcModel.JdbcSchema> tableSchemaMap = new HashMap<String, JdbcModel.JdbcSchema>();
    private Map<String, JdbcModel.JdbcSchema> functionSchemaMap = new HashMap<String, JdbcModel.JdbcSchema>();
    private List<AbstractDataspaceRule> dataspaceRules = null;

    public ApiCustomizerDataspaceSwaggerBuilder(String client, DataspacesAccessList dataspaceAccessList, SwaggerServlet.AbstractSwaggerBuilderFactory factory) {
        super(client);
        this.dataspaceAccessList = dataspaceAccessList;
        this.factory = factory;
    }

    @Override
    public Swagger build() throws SwaggerBuilderException {
        Swagger swagger = new Swagger();
        this.setHost(swagger);
        this.setInfo(swagger);
        this.setSecurity(swagger);
        swagger.basePath(this.getBasePath());
        if (this.dataspaceAccessList != null && this.dataspaceAccessList.getDataspacesAccessList().isSingleName()) {
            String fullName = this.dataspaceAccessList.getDataspacesAccessList().getSingleName();
            swagger.getInfo().title(fullName);
            swagger.getInfo().description("<div>Customized REST operations for dataspace '" + fullName + "' in node '" + RuntimeContext.getInstance().getName() + "'.<br><br><table><tr><td>Dataspace Type:</td><td>" + ModeratorUtils.extractComponentNameType(this.dataspaceAccessList.getDataspacesAccessList().getSingleName()) + "</td></tr><tr><td>Dataspace Name:</td><td>" + ModeratorUtils.extractComponentNameName(this.dataspaceAccessList.getDataspacesAccessList().getSingleName()) + "</td></tr><tr><td>Full Name:</td><td>" + fullName + "</td></tr></table></div>");
        } else {
            swagger.getInfo().title("Customized API to dataspaces in node '" + RuntimeContext.getInstance().getName() + "'.");
            swagger.getInfo().description("Customized API to dataspaces in node '" + RuntimeContext.getInstance().getName() + "'.");
        }
        return this.build(swagger);
    }

    @Override
    public Swagger build(Swagger swagger) throws SwaggerBuilderException {
        if (this.dataspaceAccessList == null) {
            return swagger;
        }
        if (swagger.getBasePath() == null) {
            swagger.setBasePath(this.getBasePath());
        }
        this.swaggerTypeResolver = new SwaggerTypeResolver(swagger, new SemanticTypeResolver());
        for (AbstractDataspaceRule rule : this.getDataspaceRulesThatSatisfyToDataspaceAccessList()) {
            try {
                AbstractDataspaceRuleWrapper wrapper = (AbstractDataspaceRuleWrapper)rule.createWrapper();
                this.acceptsDataspaces(wrapper, (dataspace, oal) -> {
                    try {
                        if (rule instanceof DataspaceAnyStatementRule) {
                            this.addAnyStatementCall((DataspaceAnyStatementRuleWrapper)wrapper, swagger, (String)dataspace);
                        } else if (rule instanceof DataspaceCollectionRule) {
                            this.addCollectionCalls((DataspaceCollectionRuleWrapper)wrapper, swagger, (String)dataspace);
                        } else if (rule instanceof DataspaceFunctionRule) {
                            this.addFunctionCalls((DataspaceFunctionRuleWrapper)wrapper, swagger, (String)dataspace);
                        } else if (rule instanceof DataspaceQueueRule) {
                            this.addQueueCalls((DataspaceQueueRuleWrapper)wrapper, swagger, (String)dataspace);
                        }
                    }
                    catch (SwaggerBuilderException exception) {
                        Trace.logException(this, exception, true);
                    }
                    return true;
                }, false);
            }
            catch (APICustomizerException aPICustomizerException) {}
        }
        return swagger;
    }

    private void addAnyStatementCall(DataspaceAnyStatementRuleWrapper wrapper, Swagger swagger, final String dataspaceName) throws SwaggerBuilderException {
        String uri = this.buildUri(wrapper, new DataspaceAnyStatementRuleParametersResolver(this, wrapper){

            @Override
            protected String onGetDsqlQuery() {
                return null;
            }

            @Override
            protected String onGetDataspaceName() {
                return dataspaceName;
            }
        });
        if (uri == null) {
            return;
        }
        String method = this.acceptedByApplication(((DataspaceAnyStatementRule)wrapper.getRule()).getHttpMethod(), uri, "GET");
        if (method == null) {
            return;
        }
        String tag = ((DataspaceAnyStatementRule)wrapper.getRule()).getExternalURI();
        swagger.tag(new Tag().name(tag));
        Operation operation = new Operation();
        operation.tag(tag);
        operation.summary("Customization of any DSQL statement call.");
        operation.description("Customization of any DSQL statement call.");
        Path path = new Path();
        path.set(method, operation);
        swagger.path(this.relativeUriFromBasePath(uri), path);
        this.setSecurityDefinitionsForOperation(swagger, operation);
        this.addCustomizedProduces(operation, wrapper, false);
        this.addCustomizedResponses(operation, wrapper);
        operation.response(this.getSuccessCode(wrapper), new Response().description("OK").schema((Property)new StringProperty()));
        ParameterMacros dqlQueryMacros = wrapper.getDsqlQueryMacros();
        if (dqlQueryMacros.isHttpHeader()) {
            operation.parameter((Parameter)((HeaderParameter)((HeaderParameter)((HeaderParameter)new HeaderParameter().name(dqlQueryMacros.getParameterName())).description("DSQL query")).required(true)).type("string"));
        } else if (dqlQueryMacros.isUrlQueryParameter()) {
            operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name(dqlQueryMacros.getParameterName())).description("DSQL query")).required(true)).type("string"));
        }
        this.addResponseFormatParameter(operation, wrapper, false);
        this.addNorowsetParameter(operation, wrapper);
        this.addNorowsParameter(operation, wrapper);
        this.addQueryTimeoutParameter(operation, wrapper);
    }

    private void addCollectionCalls(DataspaceCollectionRuleWrapper wrapper, Swagger swagger, String dataspaceName) throws SwaggerBuilderException {
        JdbcModel.JdbcSchema schema = this.getTableSchema(dataspaceName);
        for (String collectionName : this.getTableNamesList(dataspaceName)) {
            try {
                if (!wrapper.getCollectionNameMacros().acceptsValue(collectionName)) continue;
                this.addCollectionCall(wrapper, swagger, dataspaceName, collectionName, (JdbcModel.JdbcTable)schema.tables.get(collectionName));
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to add call for collection '" + collectionName + "'.");
                Trace.logException(this, exception, true);
            }
        }
    }

    private void addCollectionCall(DataspaceCollectionRuleWrapper wrapper, Swagger swagger, final String dataspaceName, final String collectionName, JdbcModel.JdbcTable table) throws SwaggerBuilderException {
        String uri;
        if (table == null) {
            Trace.logError(this, "Collection '" + collectionName + "' not found.");
            return;
        }
        if (!(((DataspaceCollectionRule)wrapper.getRule()).getOperation() != DataspaceCollectionRule.DataspaceCollectionOperation.INSERT || table.columns.size() == wrapper.getColumnsMacros().size() && table.columns.stream().map(c -> c.columnName).collect(Collectors.toSet()).equals(wrapper.getColumnsMacros().stream().map(p -> (String)p.first).collect(Collectors.toSet())))) {
            return;
        }
        if (((DataspaceCollectionRule)wrapper.getRule()).getOperation() == DataspaceCollectionRule.DataspaceCollectionOperation.UPDATE || ((DataspaceCollectionRule)wrapper.getRule()).getOperation() == DataspaceCollectionRule.DataspaceCollectionOperation.SELECT) {
            Set ruleColumns = wrapper.getColumnsMacros().stream().map(p -> ((String)p.first).trim()).collect(Collectors.toSet());
            ruleColumns.remove("*");
            ruleColumns.removeAll(table.columns.stream().map(c -> c.columnName).collect(Collectors.toSet()));
            if (ruleColumns.size() > 0) {
                return;
            }
        }
        if ((uri = this.buildUri(wrapper, new DataspaceCollectionRuleParametersResolver(this, wrapper){

            @Override
            protected String onGetDataspaceName() {
                return dataspaceName;
            }

            @Override
            protected String onGetCollectionName(String parameterName) {
                return collectionName;
            }

            @Override
            protected String onGetSelector(String parameterName) {
                return "{" + parameterName + "}";
            }

            @Override
            protected String onGetColumn(String name) {
                return "{" + name + "}";
            }
        })) == null) {
            return;
        }
        String method = this.acceptedByApplication(((DataspaceCollectionRule)wrapper.getRule()).getHttpMethod(), uri, "GET");
        if (method == null) {
            return;
        }
        String tag = ((DataspaceCollectionRule)wrapper.getRule()).getExternalURI();
        swagger.tag(new Tag().name(tag));
        Operation operation = new Operation();
        operation.tag(tag);
        operation.summary("Customization of collection '" + ((DataspaceCollectionRule)wrapper.getRule()).getOperation().toString() + "' operation.");
        operation.description("Customization of collection '" + ((DataspaceCollectionRule)wrapper.getRule()).getOperation().toString() + "' operation.");
        Path path = new Path();
        path.set(method, operation);
        swagger.path(this.relativeUriFromBasePath(uri), path);
        this.setSecurityDefinitionsForOperation(swagger, operation);
        this.addCustomizedProduces(operation, wrapper, false);
        this.addCustomizedResponses(operation, wrapper);
        if (((DataspaceCollectionRule)wrapper.getRule()).getOperation() == DataspaceCollectionRule.DataspaceCollectionOperation.INSERT) {
            operation.response(this.getSuccessCode(wrapper), this.getResponseUpdateCount());
            this.addColumns(wrapper.getColumnsMacros(), table.columns, collectionName, operation, false, true);
            this.addRequestFormatParameter(operation, wrapper, false);
            this.addResponseFormatParameter(operation, wrapper, false);
            this.addNorowsetParameterForDSResultUpdateCount(operation, wrapper);
            this.addQueryTimeoutParameter(operation, wrapper);
        } else if (((DataspaceCollectionRule)wrapper.getRule()).getOperation() == DataspaceCollectionRule.DataspaceCollectionOperation.UPDATE) {
            operation.response(this.getSuccessCode(wrapper), this.getResponseUpdateCount());
            this.addColumns(wrapper.getColumnsMacros(), table.columns, collectionName, operation, false, false);
            AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getSelectorMacros());
            if (parameter != null) {
                DataspaceSwaggerBuilder.addWhereParameter(operation, "0=1", parameter);
            }
            this.addRequestFormatParameter(operation, wrapper, false);
            this.addResponseFormatParameter(operation, wrapper, false);
            this.addNorowsetParameterForDSResultUpdateCount(operation, wrapper);
            this.addQueryTimeoutParameter(operation, wrapper);
        } else if (((DataspaceCollectionRule)wrapper.getRule()).getOperation() == DataspaceCollectionRule.DataspaceCollectionOperation.DELETE) {
            operation.response(this.getSuccessCode(wrapper), this.getResponseUpdateCount());
            AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getSelectorMacros());
            if (parameter != null) {
                DataspaceSwaggerBuilder.addWhereParameter(operation, "0=1", parameter);
            }
            this.addNorowsetParameterForDSResultUpdateCount(operation, wrapper);
            this.addQueryTimeoutParameter(operation, wrapper);
        } else if (((DataspaceCollectionRule)wrapper.getRule()).getOperation() == DataspaceCollectionRule.DataspaceCollectionOperation.SELECT) {
            operation.response(this.getSuccessCode(wrapper), new Response().description("OK").schema((Property)DataspaceSwaggerBuilder.createDSRowSetProperty(table.columns, table.tableName, this.swaggerTypeResolver)));
            AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getSelectorMacros());
            if (parameter != null) {
                DataspaceSwaggerBuilder.addWhereParameter(operation, "", parameter);
            }
            this.addResponseFormatParameter(operation, wrapper, false);
            this.addNorowsetParameter(operation, wrapper);
            this.addNorowsParameter(operation, wrapper);
            this.addQueryTimeoutParameter(operation, wrapper);
        }
    }

    private void addQueueCalls(DataspaceQueueRuleWrapper wrapper, Swagger swagger, String dataspaceName) throws SwaggerBuilderException {
        JdbcModel.JdbcSchema schema = this.getQueueSchema(dataspaceName);
        for (String collectionName : this.getQueueNamesList(dataspaceName)) {
            try {
                if (!wrapper.getQueueNameMacros().acceptsValue(collectionName)) continue;
                this.addQueueCall(wrapper, swagger, dataspaceName, collectionName, (JdbcModel.JdbcTable)schema.tables.get(collectionName));
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to add call for collection '" + collectionName + "'.");
                Trace.logException(this, exception, true);
            }
        }
    }

    private void addQueueCall(DataspaceQueueRuleWrapper wrapper, Swagger swagger, final String dataspaceName, final String collectionName, JdbcModel.JdbcTable table) throws SwaggerBuilderException {
        if (table == null) {
            Trace.logError(this, "Queue '" + collectionName + "' not found.");
            return;
        }
        String uri = this.buildUri(wrapper, new DataspaceQueueRuleParametersResolver(this, wrapper){

            @Override
            protected String onGetDataspaceName() {
                return dataspaceName;
            }

            @Override
            protected String onGetQueueName(String parameterName) {
                return collectionName;
            }

            @Override
            protected String onGetSelector(String parameterName) {
                return "{" + parameterName + "}";
            }

            @Override
            protected String onGetObject(String parameterName) {
                return "{" + parameterName + "}";
            }
        });
        if (uri == null) {
            return;
        }
        String method = this.acceptedByApplication(((DataspaceQueueRule)wrapper.getRule()).getHttpMethod(), uri, "GET");
        if (method == null) {
            return;
        }
        String tag = ((DataspaceQueueRule)wrapper.getRule()).getExternalURI();
        swagger.tag(new Tag().name(tag));
        Operation operation = new Operation();
        operation.tag(tag);
        operation.summary("Customization of queue '" + ((DataspaceQueueRule)wrapper.getRule()).getOperation().toString() + "' operation.");
        operation.description("Customization of queue '" + ((DataspaceQueueRule)wrapper.getRule()).getOperation().toString() + "' operation.");
        Path path = new Path();
        path.set(method, operation);
        swagger.path(this.relativeUriFromBasePath(uri), path);
        this.setSecurityDefinitionsForOperation(swagger, operation);
        this.addCustomizedProduces(operation, wrapper, false);
        this.addCustomizedResponses(operation, wrapper);
        if (((DataspaceQueueRule)wrapper.getRule()).getOperation() == DataspaceQueueRule.DataspaceQueueOperation.PUT) {
            operation.response(this.getSuccessCode(wrapper), this.getResponseUpdateCount());
            AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getObjectMacros());
            if (parameter != null) {
                if (table.collection.getClass() == BlockingQueueProxy.class) {
                    String typeName = table.columns.stream().filter((Predicate<JdbcModel.JdbcColumn>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$addQueueCall$5(com.streamscape.omf.odata.v4.server.jdbc.model.JdbcModel$JdbcColumn ), (Lcom/streamscape/omf/odata/v4/server/jdbc/model/JdbcModel$JdbcColumn;)Z)()).findFirst().get().columnTypeName;
                    parameter.description("Object of type '" + typeName + "' serialized in corresponding format.");
                } else {
                    parameter.description("Event [" + ((EventQueueProxy)table.collection).getEventId() + "] serialized in corresponding format.");
                }
                parameter.required(false).type("string");
                operation.parameter((Parameter)parameter);
            } else if (wrapper.getObjectMacros().isHttpContent()) {
                DataspaceSwaggerBuilder.addQueueBodyParameter(operation, table, this.swaggerTypeResolver, this.getExamplesProvider());
            }
            this.addRequestFormatParameter(operation, wrapper, false);
            this.addNorowsetParameterForDSResultUpdateCount(operation, wrapper);
            this.addQueryTimeoutParameter(operation, wrapper);
        } else if (((DataspaceQueueRule)wrapper.getRule()).getOperation() == DataspaceQueueRule.DataspaceQueueOperation.READ || ((DataspaceQueueRule)wrapper.getRule()).getOperation() == DataspaceQueueRule.DataspaceQueueOperation.TAKE) {
            AbstractSerializableParameter parameter;
            Pair<Property, Consumer> pair = DataspaceSwaggerBuilder.createQueueObjectProperty(table, (Queue)table.collection, this.swaggerTypeResolver, this.getExamplesProvider());
            Response response = new Response().description("Result").schema((Property)pair.first);
            if (pair.second != null) {
                ((Consumer)pair.second).accept(response);
            }
            operation.response(this.getSuccessCode(wrapper), response);
            if (table.collection.getClass() != BlockingQueueProxy.class && (parameter = this.createParameterFromMacros(wrapper.getObjectMacros())) != null) {
                operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("selector")).description("DSQL selector")).required(false)).property((Property)new StringProperty()));
            }
            this.addQueryTimeoutParameter(operation, wrapper);
        }
    }

    private void addFunctionCalls(DataspaceFunctionRuleWrapper wrapper, Swagger swagger, String dataspaceName) throws SwaggerBuilderException {
        JdbcModel.JdbcSchema schema = this.getFunctionSchema(dataspaceName);
        for (String functionName : this.getFunctionNamesList(dataspaceName)) {
            try {
                if (!wrapper.getFunctionNameMacros().acceptsValue(functionName)) continue;
                this.addFunctionCall(wrapper, swagger, dataspaceName, functionName, (JdbcModel.JdbcFunction)schema.functions.get(functionName));
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to add call for function '" + functionName + "'.");
                Trace.logException(this, exception, true);
            }
        }
    }

    private void addFunctionCall(DataspaceFunctionRuleWrapper wrapper, Swagger swagger, final String dataspaceName, final String functionName, JdbcModel.JdbcFunction function) throws SwaggerBuilderException {
        if (function == null) {
            Trace.logError(this, "Function '" + functionName + "' not found.");
            return;
        }
        if (function.arguments.size() != wrapper.getParametersMacros().size() || !function.arguments.stream().map(c -> c.columnName).collect(Collectors.toSet()).equals(wrapper.getParametersMacros().keySet().stream().collect(Collectors.toSet()))) {
            return;
        }
        String uri = this.buildUri(wrapper, new DataspaceFunctionRuleParametersResolver(this, wrapper){

            @Override
            protected String onGetDataspaceName() {
                return dataspaceName;
            }

            @Override
            protected String onGetFunctionName() {
                return functionName;
            }

            @Override
            protected String onGetParameter(String name) {
                return "{" + name + "}";
            }
        });
        if (uri == null) {
            return;
        }
        String method = this.acceptedByApplication(((DataspaceFunctionRule)wrapper.getRule()).getHttpMethod(), uri, "GET");
        if (method == null) {
            return;
        }
        String tag = ((DataspaceFunctionRule)wrapper.getRule()).getExternalURI();
        swagger.tag(new Tag().name(tag));
        Operation operation = new Operation();
        operation.tag(tag);
        operation.summary("Customization of function '" + functionName + "' call.");
        operation.description("Customization of function '" + functionName + "' call.");
        Path path = new Path();
        path.set(method, operation);
        swagger.path(this.relativeUriFromBasePath(uri), path);
        this.setSecurityDefinitionsForOperation(swagger, operation);
        this.addCustomizedProduces(operation, wrapper, false);
        this.addCustomizedResponses(operation, wrapper);
        try (JdbcOverFabricConnectionImpl jdbc2 = new JdbcOverFabricConnectionImpl((FabricConnection)this.connection, dataspaceName);){
            operation.description(DataspaceSwaggerBuilder.getFunctionDescription(jdbc2.getDataspaceAccessor(), function, operation.getDescription()));
        }
        catch (SQLException jdbc2) {
            // empty catch block
        }
        DataspaceSwaggerBuilder.addFunctionResponse(operation, function, this.getSuccessCode(wrapper), this.swaggerTypeResolver, this.getExamplesProvider());
        List<Pair<String, ParameterMacros>> columnMacroses = wrapper.getParametersMacros().entrySet().stream().map(entry -> new Pair<String, ParameterMacros>((String)entry.getKey(), (ParameterMacros)entry.getValue())).collect(Collectors.toList());
        this.addColumns(columnMacroses, function.arguments, functionName, operation, true, true);
        this.addRequestFormatParameter(operation, wrapper, false);
        this.addResponseFormatParameter(operation, wrapper, false);
        this.addNorowsetParameterForDSResultSingleValue(operation, wrapper);
        this.addQueryTimeoutParameter(operation, wrapper);
    }

    private void addColumns(List<Pair<String, ParameterMacros>> columnMacroses, List<JdbcModel.JdbcColumn> columns, String name, Operation operation, boolean function, boolean required) throws SwaggerBuilderException {
        String complexColumns = "";
        for (Pair<String, ParameterMacros> pair : columnMacroses) {
            AbstractSerializableParameter parameter = this.createParameterFromMacros((ParameterMacros)pair.second);
            if (parameter == null) continue;
            parameter.description("Value of " + (function ? "parameter" : "column") + " '" + (String)pair.first + "'.").required(required);
            JdbcModel.JdbcColumn column = columns.stream().filter(c -> c.columnName.equals(pair.first)).findFirst().orElseGet(null);
            if (column == null) {
                throw new SwaggerBuilderException((function ? "Parameter" : "Column") + " '" + (String)pair.first + "' not found in " + (function ? "function." : "table."));
            }
            complexColumns = DataspaceSwaggerBuilder.fillParameterForColumn(parameter, column, this.swaggerTypeResolver, name, true, complexColumns);
            operation.parameter((Parameter)parameter);
        }
        if (complexColumns.length() > 0) {
            operation.description(operation.getDescription() + "\nFor complex columns " + complexColumns + " values should be specified in format that specified for requestFormat parameter.");
        }
    }

    private void addNorowsetParameterForDSResultUpdateCount(Operation operation, AbstractDataspaceRuleWrapper wrapper) {
        AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getNorowsetMacros());
        if (parameter != null) {
            DataspaceSwaggerBuilder.addNorowsetParameterForDSResultUpdateCount(operation, parameter);
        }
    }

    private void addNorowsetParameterForDSResultSingleValue(Operation operation, AbstractDataspaceRuleWrapper wrapper) {
        AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getNorowsetMacros());
        if (parameter != null) {
            DataspaceSwaggerBuilder.addNorowsetParameterForDSResultSingleValue(operation, parameter);
        }
    }

    private void addNorowsetParameter(Operation operation, AbstractDataspaceRuleWrapper wrapper) {
        AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getNorowsetMacros());
        if (parameter != null) {
            DataspaceSwaggerBuilder.addNorowsetParameter(operation, parameter);
        }
    }

    private void addNorowsParameter(Operation operation, AbstractDataspaceRuleWrapper wrapper) {
        AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getNorowsMacros());
        if (parameter != null) {
            DataspaceSwaggerBuilder.addNorowsParameter(operation, parameter);
        }
    }

    private void addQueryTimeoutParameter(Operation operation, AbstractDataspaceRuleWrapper wrapper) {
        AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getQueryTimeoutMacros());
        if (parameter != null) {
            DataspaceSwaggerBuilder.addQueryTimeoutParameter(operation, parameter, this.factory);
        }
    }

    private void acceptsDataspaces(AbstractDataspaceRuleWrapper wrapper, BiFunction<String, DataspacesAccessList.DataspaceObjectsAccessList, Boolean> onDataspace, boolean breakIfFound) throws SwaggerBuilderException {
        for (String dataspace : this.getDataspacesList()) {
            DataspacesAccessList.DataspaceObjectsAccessList oal;
            if (!this.isDataspaceMacroAcceptsValue(wrapper.getDataspaceNameMacros(), dataspace) || !onDataspace.apply(dataspace, oal = this.dataspaceAccessList.getDataspaceObjectsAccessList(dataspace)).booleanValue() || !breakIfFound) continue;
            break;
        }
    }

    private boolean isDataspaceMacroAcceptsValue(ParameterMacros macros, String value) {
        if (macros.acceptsValue(value)) {
            return true;
        }
        if (macros.isAsValue()) {
            String macroValue = macros.getValue();
            if (macroValue == null) {
                return false;
            }
            String[] macroValues = macroValue.split("\\.");
            String[] values = value.split("\\.");
            if (macroValues.length == 2 && values.length == 2) {
                return macroValues[0].toLowerCase().equals(values[0].toLowerCase()) && macroValues[1].equals(values[1]);
            }
            return macroValues[1].equals(values[1]);
        }
        return false;
    }

    private List<String> getDataspacesList() throws SwaggerBuilderException {
        if (this.dataspacesList == null) {
            this.dataspacesList = DataspaceSwaggerBuilder.listDataspaces(this.dataspaceAccessList, this.connection);
        }
        return this.dataspacesList;
    }

    private List<String> getFunctionNamesList(String dataspaceName) {
        List<String> functionNamesList = this.functionNamesMap.get(dataspaceName);
        if (functionNamesList == null) {
            try (JdbcOverFabricConnectionImpl jdbc = new JdbcOverFabricConnectionImpl((FabricConnection)this.connection, dataspaceName);){
                jdbc.connect();
                functionNamesList = new ArrayList<String>(DataspaceApiDiscover.listFunctionNames(jdbc));
                this.functionNamesMap.put(dataspaceName, functionNamesList);
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to establish JDBC connection to dataspace '{}'.", dataspaceName);
                Trace.logException(this, exception, true);
            }
        }
        return functionNamesList;
    }

    private List<String> getTableNamesList(String dataspaceName) {
        return this.getTableQueuesNamesList(dataspaceName, this.tableNamesMap, true);
    }

    private List<String> getQueueNamesList(String dataspaceName) {
        return this.getTableQueuesNamesList(dataspaceName, this.queueNamesMap, false);
    }

    private List<String> getTableQueuesNamesList(String dataspaceName, Map<String, List<String>> map, boolean onlyTables) {
        List<String> list = map.get(dataspaceName);
        if (list == null) {
            try (JdbcOverFabricConnectionImpl jdbc = new JdbcOverFabricConnectionImpl((FabricConnection)this.connection, dataspaceName);){
                jdbc.connect();
                list = new ArrayList<String>(DataspaceApiDiscover.listCollectionNames(jdbc, false, onlyTables, !onlyTables));
                map.put(dataspaceName, list);
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to establish JDBC connection to dataspace '{}'.", dataspaceName);
                Trace.logException(this, exception, true);
            }
        }
        return list;
    }

    private JdbcModel.JdbcSchema getTableSchema(String dataspaceName) throws SwaggerBuilderException {
        JdbcModel.JdbcSchema schema = this.tableSchemaMap.get(dataspaceName);
        if (schema == null) {
            schema = this.fillSchema(new JdbcModelGenerator(JdbcModelGenerator.Scope.SWAGGER).setTablesAccessList(new AccessList().include(this.getTableNamesList(dataspaceName))), dataspaceName);
            this.tableSchemaMap.put(dataspaceName, schema);
        }
        return schema;
    }

    private JdbcModel.JdbcSchema getQueueSchema(String dataspaceName) throws SwaggerBuilderException {
        JdbcModel.JdbcSchema schema = this.queueSchemaMap.get(dataspaceName);
        if (schema == null) {
            schema = this.fillSchema(new JdbcModelGenerator(JdbcModelGenerator.Scope.SWAGGER).setTablesAccessList(new AccessList().include(this.getQueueNamesList(dataspaceName))), dataspaceName);
            try (JdbcOverFabricConnectionImpl jdbc = new JdbcOverFabricConnectionImpl((FabricConnection)this.connection, dataspaceName);){
                jdbc.connect();
                schema.tables.entrySet().forEach(t -> {
                    try {
                        ((JdbcModel.JdbcTable)t.getValue()).collection = jdbc.getDataspaceAccessor().lookupCollection(((JdbcModel.JdbcTable)t.getValue()).tableName);
                    }
                    catch (Exception exception) {
                        Trace.logError(this, "Failed to get collection '" + ((JdbcModel.JdbcTable)t.getValue()).tableName + "'. Cause: " + exception.getMessage());
                    }
                });
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.queueSchemaMap.put(dataspaceName, schema);
        }
        return schema;
    }

    private JdbcModel.JdbcSchema getFunctionSchema(String dataspaceName) throws SwaggerBuilderException {
        JdbcModel.JdbcSchema schema = this.functionSchemaMap.get(dataspaceName);
        if (schema == null) {
            schema = this.fillSchema(new JdbcModelGenerator(JdbcModelGenerator.Scope.SWAGGER).setFunctionsAccessList(new AccessList().include(this.getFunctionNamesList(dataspaceName))), dataspaceName);
            this.functionSchemaMap.put(dataspaceName, schema);
        }
        return schema;
    }

    private JdbcModel.JdbcSchema fillSchema(JdbcModelGenerator modelGenerator, String dataspaceName) throws SwaggerBuilderException {
        JdbcModel.JdbcSchema schema;
        try (JdbcOverFabricConnectionImpl jdbc = new JdbcOverFabricConnectionImpl((FabricConnection)this.connection, dataspaceName);){
            jdbc.connect();
            JdbcModel jdbcModel = modelGenerator.createJdbcModel((Jdbc)jdbc);
            schema = (JdbcModel.JdbcSchema)jdbcModel.schemas.get(jdbc.getDataspaceName());
            if (schema == null) {
                throw new SwaggerBuilderException("Dataspace schema '" + dataspaceName + "' not found.");
            }
        }
        catch (SwaggerBuilderException exception) {
            throw exception;
        }
        catch (Exception exception) {
            Trace.logError(this, exception.getMessage());
            Trace.logException(this, exception, true);
            throw new SwaggerBuilderException("Failed to establish JDBC connection to dataspace '" + dataspaceName + "'.", exception);
        }
        return schema;
    }

    private List<AbstractDataspaceRule> getDataspaceRulesThatSatisfyToDataspaceAccessList() throws SwaggerBuilderException {
        if (this.dataspaceRules != null) {
            return this.dataspaceRules;
        }
        this.dataspaceRules = new ArrayList<AbstractDataspaceRule>();
        APICustomizerConfiguration apiCustomizerConfiguration = this.getApiCustomizerConfiguration();
        if (apiCustomizerConfiguration == null) {
            return this.dataspaceRules;
        }
        for (AbstractDataspaceRule rule : apiCustomizerConfiguration.listDataspaceRules()) {
            try {
                boolean[] satisfy = new boolean[]{false};
                AbstractDataspaceRuleWrapper wrapper = (AbstractDataspaceRuleWrapper)rule.createWrapper();
                if (rule instanceof DataspaceAnyStatementRule) {
                    this.acceptsDataspaces(wrapper, (dataspace, oal) -> {
                        if (oal == null || oal.getAnyDsqlMethods() != null && oal.getAnyDsqlMethods().length() > 0) {
                            satisfy[0] = true;
                            return true;
                        }
                        return false;
                    }, true);
                } else if (rule instanceof DataspaceFunctionRule) {
                    this.acceptsDataspaces(wrapper, (dataspace, oal) -> {
                        for (String functionName : this.getFunctionNamesList((String)dataspace)) {
                            if (oal != null && oal.getFunctions() != null && !oal.getFunctions().isAllAllowed() && !oal.getFunctions().isAllowed(functionName) || !((DataspaceFunctionRuleWrapper)wrapper).getFunctionNameMacros().acceptsValue(functionName)) continue;
                            satisfy[0] = true;
                            return true;
                        }
                        return false;
                    }, true);
                } else if (rule instanceof DataspaceCollectionRule) {
                    this.acceptsDataspaces(wrapper, (dataspace, oal) -> {
                        for (String collectionName : this.getTableNamesList((String)dataspace)) {
                            if (oal != null && oal.getTables() != null && !oal.getTables().isAllAllowed() && !oal.getTables().isAllowed(collectionName) || !((DataspaceCollectionRuleWrapper)wrapper).getCollectionNameMacros().acceptsValue(collectionName)) continue;
                            satisfy[0] = true;
                            return true;
                        }
                        return false;
                    }, true);
                } else if (rule instanceof DataspaceQueueRule) {
                    this.acceptsDataspaces(wrapper, (dataspace, oal) -> {
                        for (String collectionName : this.getQueueNamesList((String)dataspace)) {
                            if (oal != null && oal.getTables() != null && !oal.getTables().isAllAllowed() && !oal.getTables().isAllowed(collectionName) || !((DataspaceQueueRuleWrapper)wrapper).getQueueNameMacros().acceptsValue(collectionName)) continue;
                            satisfy[0] = true;
                            return true;
                        }
                        return false;
                    }, true);
                } else if (rule instanceof DataspaceODataRule) {
                    this.acceptsDataspaces(wrapper, (dataspace, oal) -> {
                        satisfy[0] = true;
                        return true;
                    }, true);
                }
                if (!satisfy[0]) continue;
                this.dataspaceRules.add(rule);
            }
            catch (APICustomizerException aPICustomizerException) {}
        }
        return this.dataspaceRules;
    }

    @Override
    protected List getRules() throws SwaggerBuilderException {
        return this.getDataspaceRulesThatSatisfyToDataspaceAccessList();
    }

    private static /* synthetic */ boolean lambda$addQueueCall$5(JdbcModel.JdbcColumn c) {
        return c.columnName.equals("Object");
    }
}

