/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger.apicustomizer;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRule;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleParametersResolver;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.ParameterMacros;
import com.streamscape.sef.network.http.server.apicustomizer.UriBuilder;
import com.streamscape.sef.network.http.server.authentication.runtime.model.Application;
import com.streamscape.sef.network.http.server.swagger.AbstractSwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.uri.UriUtils;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractApiCustomizerSwaggerBuilder
extends AbstractSwaggerBuilder {
    private Iterable<? extends Object> rules;
    private APICustomizerConfiguration apiCustomizerConfiguration;
    private Application application;

    public AbstractApiCustomizerSwaggerBuilder(String client) {
        super(client);
    }

    public void setApiCustomizerConfiguration(APICustomizerConfiguration apiCustomizerConfiguration) {
        this.apiCustomizerConfiguration = apiCustomizerConfiguration;
    }

    protected APICustomizerConfiguration getApiCustomizerConfiguration() {
        if (this.apiCustomizerConfiguration != null) {
            return this.apiCustomizerConfiguration;
        }
        return this.acceptorConfiguration.getAPICustomizerConfiguration();
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    protected String getBasePath() {
        if (this.basePath != null) {
            return this.basePath;
        }
        return this.buildPrefixForRules();
    }

    protected String relativeUriFromBasePath(String uri) {
        if (((String)uri).startsWith(this.getBasePath()) && !((String)(uri = ((String)uri).substring(this.getBasePath().length()))).startsWith("/")) {
            uri = "/" + (String)uri;
        }
        return uri;
    }

    protected String buildPrefixForRules() {
        try {
            return UriUtils.buildPrefixForUris(this.getRules().stream().map(rule -> ((AbstractRule)rule).getExternalURI()).collect(Collectors.toList()));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            return "/";
        }
    }

    protected String acceptedByApplication(String method, String uri, String defaultMethod) {
        if (this.application == null) {
            if (method.contains("*")) {
                method = defaultMethod;
            }
        } else if (method.contains("*")) {
            method = null;
            if (this.application.matches(defaultMethod, uri) != null) {
                method = defaultMethod;
            } else {
                for (HttpMethod m : HttpMethod.values()) {
                    if (this.application.matches(m.name(), uri) == null) continue;
                    method = m.name();
                    break;
                }
            }
        } else if (this.application.matches(method, uri) == null) {
            method = null;
        }
        if (method != null) {
            method = method.toLowerCase();
        }
        return method;
    }

    protected AbstractSerializableParameter createParameterFromMacros(ParameterMacros macros) {
        if (macros == null) {
            return null;
        }
        if (macros.isHttpHeader()) {
            return new HeaderParameter().name(macros.getParameterName());
        }
        if (macros.isUrlQueryParameter()) {
            return new QueryParameter().name(macros.getParameterName());
        }
        if (macros.isUriFragment()) {
            return new PathParameter().name(macros.getParameterName());
        }
        if (!macros.isAsValue()) {
            Trace.logError(this, "Not supported macro '" + macros.getParameter() + "'.");
        }
        return null;
    }

    protected int getSuccessCode(AbstractRuleWrapper wrapper) {
        if (((AbstractRule)wrapper.getRule()).getReturnCode() == 0) {
            return 200;
        }
        return ((AbstractRule)wrapper.getRule()).getReturnCode();
    }

    protected String buildUri(AbstractRuleWrapper wrapper, AbstractRuleParametersResolver resolver) {
        try {
            return new UriBuilder(wrapper.getUriMatcher()).build(resolver);
        }
        catch (APICustomizerException exception) {
            Trace.logException(this, exception, true);
            return null;
        }
    }

    protected void addCustomizedResponses(Operation operation, AbstractRuleWrapper wrapper) {
        operation.response(this.getSuccessCode(wrapper), new Response().description("OK"));
        operation.response(((AbstractRule)wrapper.getRule()).getErrorCode() != 0 ? ((AbstractRule)wrapper.getRule()).getErrorCode() : 400, new Response().description("Invalid Request"));
        operation.response(((AbstractRule)wrapper.getRule()).getErrorCode() != 0 ? ((AbstractRule)wrapper.getRule()).getErrorCode() : 404, new Response().description("Not Found"));
        operation.response(((AbstractRule)wrapper.getRule()).getErrorCode() != 0 ? ((AbstractRule)wrapper.getRule()).getErrorCode() : 500, this.httpExceptionResponse().description("DSQL Error"));
    }

    protected void addCustomizedProduces(Operation operation, AbstractRuleWrapper wrapper, boolean swagger) {
        if (wrapper.getResponseFormatMacros().isAsValue()) {
            if (wrapper.getResponseFormatMacros().getValue().contains("json")) {
                this.addDefaultProduces(operation, swagger ? "application/json;swagger=true" : "application/json");
            } else if (wrapper.getResponseFormatMacros().getValue().contains("xml")) {
                this.addDefaultProduces(operation, swagger ? "application/xml;swagger=true" : "application/xml");
            } else {
                this.addDefaultProduces(operation, "text/html");
            }
        } else {
            this.addDefaultProduces(operation, swagger ? "json;swagger=true" : "json", swagger ? "xml;swagger=true" : "xml", "text/html");
        }
    }

    protected void addCustomizedConsumes(Operation operation, AbstractRuleWrapper wrapper, boolean swagger) {
        if (wrapper.getRequestFormatMacros().isAsValue()) {
            if (wrapper.getRequestFormatMacros().getValue().contains("json")) {
                this.addDefaultConsumes(operation, swagger ? "application/json;swagger=true" : "application/json");
            } else if (wrapper.getRequestFormatMacros().getValue().contains("xml")) {
                this.addDefaultConsumes(operation, swagger ? "application/xml;swagger=true" : "application/xml");
            } else {
                this.addDefaultConsumes(operation, "text/html");
            }
        } else {
            this.addDefaultConsumes(operation, swagger ? "json;swagger=true" : "json", swagger ? "xml;swagger=true" : "xml", "text/html");
        }
    }

    protected void addResponseFormatParameter(Operation operation, AbstractRuleWrapper wrapper, boolean swagger) {
        AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getResponseFormatMacros());
        if (parameter != null) {
            this.addResponseFormatParameter(operation, swagger ? "json;swagger=true" : "json", parameter, swagger);
        }
    }

    protected void addResponseFormatParameter(Operation operation, String defaultValue, AbstractSerializableParameter parameter, boolean swagger) {
        parameter.description("Response data format. Overrides Accept header value.").required(false).type("string")._enum(Arrays.asList(swagger ? "json;swagger=true" : "json", swagger ? "xml;swagger=true" : "xml", "string", "html")).example(swagger ? "json;swagger=true" : "json");
        operation.parameter((Parameter)parameter);
        if (defaultValue != null) {
            parameter.example(defaultValue);
        }
    }

    protected void addRequestFormatParameter(Operation operation, AbstractRuleWrapper wrapper, boolean swagger) {
        AbstractSerializableParameter parameter = this.createParameterFromMacros(wrapper.getRequestFormatMacros());
        if (parameter != null) {
            this.addRequestFormatParameter(operation, parameter, swagger);
        }
    }

    protected void addRequestFormatParameter(Operation operation, AbstractSerializableParameter parameter, boolean swagger) {
        operation.parameter((Parameter)parameter.description("Request data format. Overrides Content-Type header value.").required(false).type("string")._enum(Arrays.asList(swagger ? "json;swagger=true" : "json", swagger ? "xml;swagger=true" : "xml", "string")).example(swagger ? "json;swagger=true" : "json"));
    }

    protected abstract List getRules() throws SwaggerBuilderException;
}

