/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.servlet.AbstractServlet;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.servlet.RestErrorResponse;
import com.streamscape.sef.network.http.server.servlet.ServletError;
import com.streamscape.sef.network.http.server.servlet.ServletErrorNotFound;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.apicustomizer.ApiCustomizerDataspaceSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.swagger.apicustomizer.ApiCustomizerServiceSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.swagger.apikey.ApiKeyApplicationSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.swagger.dataspace.DataspaceSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.swagger.service.ServiceSwaggerBuilderFactory;
import com.streamscape.sef.network.http.server.uri.UriRegistry;
import com.streamscape.sef.network.http.server.uri.UriTree;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SwaggerServlet
extends AbstractServlet {
    private UriRegistry<SwaggerBuilderFactory> registry;
    private Integer defaultQueryTimeout;

    @Override
    public void init() throws ServletException {
        super.init();
        try {
            this.registry = new UriRegistry();
            this.registry.setPrefix("/swagger/v2");
            this.registry.register("ds/swagger.json", new DataspaceSwaggerBuilderFactory());
            this.registry.register("ds/swagger.yaml", new DataspaceSwaggerBuilderFactory());
            this.registry.register("ds/{dataspaceName}/swagger.json", new DataspaceSwaggerBuilderFactory());
            this.registry.register("ds/{dataspaceName}/swagger.yaml", new DataspaceSwaggerBuilderFactory());
            this.registry.register("service/swagger.json", new ServiceSwaggerBuilderFactory());
            this.registry.register("service/swagger.yaml", new ServiceSwaggerBuilderFactory());
            this.registry.register("service/{serviceName}/swagger.json", new ServiceSwaggerBuilderFactory());
            this.registry.register("service/{serviceName}/swagger.yaml", new ServiceSwaggerBuilderFactory());
            this.registry.register("apikeyapplication/swagger.json", new ApiKeyApplicationSwaggerBuilderFactory());
            this.registry.register("apikeyapplication/swagger.yaml", new ApiKeyApplicationSwaggerBuilderFactory());
            this.registry.register("apikeyapplication/{applicationId}/swagger.json", new ApiKeyApplicationSwaggerBuilderFactory());
            this.registry.register("apikeyapplication/{applicationId}/swagger.yaml", new ApiKeyApplicationSwaggerBuilderFactory());
            this.registry.register("apicustomizer/ds/swagger.json", new ApiCustomizerDataspaceSwaggerBuilderFactory());
            this.registry.register("apicustomizer/ds/swagger.yaml", new ApiCustomizerDataspaceSwaggerBuilderFactory());
            this.registry.register("apicustomizer/ds/{dataspaceName}/swagger.json", new ApiCustomizerDataspaceSwaggerBuilderFactory());
            this.registry.register("apicustomizer/ds/{dataspaceName}/swagger.yaml", new ApiCustomizerDataspaceSwaggerBuilderFactory());
            this.registry.register("apicustomizer/service/swagger.json", new ApiCustomizerServiceSwaggerBuilderFactory());
            this.registry.register("apicustomizer/service/swagger.yaml", new ApiCustomizerServiceSwaggerBuilderFactory());
            this.registry.register("apicustomizer/service/{serviceName}/swagger.json", new ApiCustomizerServiceSwaggerBuilderFactory());
            this.registry.register("apicustomizer/service/{serviceName}/swagger.yaml", new ApiCustomizerServiceSwaggerBuilderFactory());
        }
        catch (UriTree.UriException e) {
            Trace.logError(this, "Initialization of swagger uri registry failed. Cause: " + e.getMessage());
            throw new ServletException(e);
        }
        this.defaultQueryTimeout = JettyAdvancedProperties.build(this.getAcceptorConfiguration()).getIntProperty("jetstream.dataspace.query.timeout.secs");
    }

    @Override
    public String getServletInfo() {
        return "Swagger servlet.";
    }

    public int getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FabricHTTPRequest url = new FabricHTTPRequest(request);
        try {
            ObjectWriter mapper;
            SwaggerBuilderFactory factory = this.registry.lookup(url);
            if (factory == null) {
                throw new ServletErrorNotFound(url.getRequest().getPathInfo(), "Swagger");
            }
            factory.setServlet(this);
            HTTPServerFabricConnection fabricConnection = SwaggerServlet.getFabricConnectionOrThrowException(request);
            SwaggerBuilder builder = factory.create(url, fabricConnection);
            builder.setConnection(fabricConnection);
            builder.setAcceptorConfiguration(this.getAcceptorConfiguration());
            Swagger swagger = builder.build();
            if (swagger.getPaths() == null) {
                swagger.setPaths(new LinkedHashMap());
            }
            if (url.getUri().endsWith(".json")) {
                mapper = Json.pretty();
                response.setContentType("application/json; charset=UTF-8");
            } else {
                mapper = Yaml.pretty();
                response.setContentType("application/yml; charset=UTF-8");
            }
            response.getWriter().println(mapper.writeValueAsString(swagger));
        }
        catch (ServletErrorNotFound exception) {
            RestErrorResponse.build(exception).reply(url, response, FormatAndMimeTypes.JSON_SWAGGER);
        }
        catch (ServletError exception) {
            Trace.logException(this, exception, true);
            RestErrorResponse.build(exception).reply(url, response, FormatAndMimeTypes.JSON_SWAGGER);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            RestErrorResponse.build(new ServletError(500, "OMF", "Processing error.", exception)).reply(url, response, FormatAndMimeTypes.JSON_SWAGGER);
        }
    }

    public static interface SwaggerBuilderFactory {
        public SwaggerBuilder create(FabricHTTPRequest var1, HTTPServerFabricConnection var2) throws ServletException, ServletError;

        public void setServlet(SwaggerServlet var1);

        public SwaggerServlet getServlet();
    }

    public static abstract class AbstractSwaggerBuilderFactory
    implements SwaggerBuilderFactory {
        private SwaggerServlet swaggerServlet;

        @Override
        public void setServlet(SwaggerServlet swaggerServlet) {
            this.swaggerServlet = swaggerServlet;
        }

        @Override
        public SwaggerServlet getServlet() {
            return this.swaggerServlet;
        }

        protected String getClientParameter(FabricHTTPRequest url) {
            String client = url.getParameter("client");
            if (client == null) {
                client = "ui";
            }
            return client;
        }
    }
}

