/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.swagger;

import com.streamscape.Trace;
import com.streamscape.Version;
import com.streamscape.lib.reflection.creator.ObjectCreatorFactory;
import com.streamscape.lib.utils.SemanticTypeResolver;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.servlet.RestErrorResponse;
import com.streamscape.sef.network.http.server.servlet.dataspace.DSResultUpdateCountResponse;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilder;
import com.streamscape.sef.network.http.server.swagger.SwaggerBuilderException;
import com.streamscape.sef.network.http.server.swagger.dataspace.SwaggerTypeResolver;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import java.lang.reflect.Type;
import java.util.Arrays;

public abstract class AbstractSwaggerBuilder
implements SwaggerBuilder {
    protected HTTPServerFabricConnection connection;
    protected HTTPAcceptorConfiguration acceptorConfiguration;
    protected SwaggerTypeResolver swaggerTypeResolver;
    protected String client;
    protected String basePath = null;
    public static String DEFAULT_AUTH_DESCRIPTION = "This is default authentication on schema generation time.";

    public AbstractSwaggerBuilder(String client) {
        this.client = client;
    }

    @Override
    public void setConnection(HTTPServerFabricConnection connection) {
        this.connection = connection;
    }

    @Override
    public void setAcceptorConfiguration(HTTPAcceptorConfiguration acceptorConfiguration) {
        this.acceptorConfiguration = acceptorConfiguration;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    protected boolean isUiClient() {
        return this.client == null || this.client.equalsIgnoreCase("ui");
    }

    private String resolveHost() {
        if (this.acceptorConfiguration != null) {
            return this.acceptorConfiguration.getResolvedUrlWithoutSchema();
        }
        return "HOST_PLACE_HOLDER";
    }

    private String resolveHostWithSchema() {
        if (this.acceptorConfiguration != null) {
            return this.acceptorConfiguration.getResolvedUrlWithSchema();
        }
        return "HOST_WITH_SCHEMA_PLACE_HOLDER";
    }

    protected void setHost(Swagger swagger) {
        swagger.host(this.resolveHost());
        if (this.acceptorConfiguration != null) {
            swagger.setSchemes(Arrays.asList(this.acceptorConfiguration.getEnableSSL() ? Scheme.HTTPS : Scheme.HTTP));
        }
    }

    protected void setInfo(Swagger swagger) {
        Info info = new Info();
        info.version(Version.getVersion());
        swagger.info(info);
    }

    protected void setSecurity(Swagger swagger) {
        swagger.securityDefinition("basicAuth", (SecuritySchemeDefinition)new BasicAuthDefinition());
        swagger.securityDefinition("oauth2Auth", (SecuritySchemeDefinition)new OAuth2Definition().implicit(this.resolveHostWithSchema() + "/security/oauth2/authorize"));
        ApiKeyAuthDefinition definition = new ApiKeyAuthDefinition("x-session-token", In.QUERY);
        definition.setDescription("Token authorization URL: " + this.resolveHostWithSchema() + "/security/apikey/token/authorize/basic");
        swagger.securityDefinition(new ApiKeyAuthDefinition().getType(), (SecuritySchemeDefinition)definition);
        SecuritySchemeDefinition defaultDefiniton = null;
        if (this.acceptorConfiguration != null) {
            switch (this.acceptorConfiguration.getAuthenticationType()) {
                case BASIC: 
                case DIGEST: {
                    defaultDefiniton = (SecuritySchemeDefinition)swagger.getSecurityDefinitions().get("basicAuth");
                    break;
                }
                case OAUTH2: {
                    defaultDefiniton = (SecuritySchemeDefinition)swagger.getSecurityDefinitions().get("oauth2Auth");
                    break;
                }
            }
            if (this.acceptorConfiguration.getSessionAuthentication()) {
                defaultDefiniton = (SecuritySchemeDefinition)swagger.getSecurityDefinitions().get(new ApiKeyAuthDefinition().getType());
            }
        }
        if (defaultDefiniton != null) {
            Object description = defaultDefiniton.getDescription();
            if (description == null) {
                description = "";
            }
            if (((String)description).length() > 0) {
                description = "\n" + (String)description;
            }
            description = DEFAULT_AUTH_DESCRIPTION + (String)description;
            defaultDefiniton.setDescription((String)description);
        }
    }

    protected void setSecurityDefinitionsForOperation(Swagger swagger, Operation operation) {
        swagger.getSecurityDefinitions().keySet().forEach(name -> operation.addSecurity(name, null));
    }

    protected void addDefaultConsumesXmlJson(Operation operation) {
        operation.consumes("application/json;swagger=true");
        operation.consumes("application/xml;swagger=true");
    }

    protected void addDefaultConsumes(Operation operation) {
        operation.consumes("application/json;swagger=true");
        operation.consumes("application/xml;swagger=true");
        operation.consumes("text/plain");
    }

    protected void addDefaultConsumes(Operation operation, String ... formats) {
        for (String format : formats) {
            operation.consumes(format);
        }
    }

    protected void addDefaultProduces(Operation operation) {
        this.addDefaultProduces(operation, "application/json;swagger=true", "application/xml;swagger=true", "text/html");
    }

    protected void addDefaultProducesXmlJson(Operation operation) {
        this.addDefaultProduces(operation, "application/json;swagger=true", "application/xml;swagger=true");
    }

    protected void addDefaultProduces(Operation operation, String ... formats) {
        for (String format : formats) {
            operation.produces(format);
        }
    }

    protected void addResponseFormatParameterNoDefault(Operation operation) {
        this.addResponseFormatParameter(operation, null);
    }

    protected void addResponseFormatParameter(Operation operation) {
        this.addResponseFormatParameter(operation, "json;swagger=true");
    }

    protected void addResponseFormatParameter(Operation operation, String defaultValue) {
        this.addResponseFormatParameter(operation, defaultValue, new QueryParameter().name("responseFormat"));
    }

    protected void addResponseFormatParameter(Operation operation, String defaultValue, AbstractSerializableParameter parameter) {
        parameter.description("Response data format. Overrides Accept header value.").required(false).type("string")._enum(Arrays.asList("json;swagger=true", "xml;swagger=true", "string", "html")).example("json;swagger=true");
        operation.parameter((Parameter)parameter);
        if (defaultValue != null) {
            parameter.example(defaultValue);
        }
    }

    protected void addRequestFormatParameter(Operation operation) {
        operation.parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("requestFormat")).description("Request data format. Overrides Content-Type header value.")).required(false)).type("string"))._enum(Arrays.asList("json;swagger=true", "xml;swagger=true", "string"))).example("json;swagger=true"));
    }

    protected Response httpExceptionResponse() {
        Response response = new Response();
        try {
            response.schema(this.swaggerTypeResolver.createResolver().getAndAddJavaTypeOrThrowException((Type)((Object)RestErrorResponse.HTTPException.class)));
            this.getExamplesProvider().examples(response, RestErrorResponse.HTTPException.class);
        }
        catch (SwaggerBuilderException exception) {
            Trace.logError(this, "Failed to add HTTPException definition.");
            Trace.logException(this, exception, false);
        }
        return response;
    }

    protected SwaggerExamplesProvider getExamplesProvider() {
        return new SwaggerExamplesProvider(this, this.swaggerTypeResolver.getSemanticTypeResolver());
    }

    public <T> T schemaEventWrapper(T parameter, String handlerName, String eventId) throws SwaggerBuilderException {
        return this.schema(parameter, this.swaggerTypeResolver.createResolver().setPrefix(handlerName).getAndAddEventWrapperTypeOrThrowException(eventId));
    }

    protected <T> T schemaEvent(T parameter, String eventId) throws SwaggerBuilderException {
        return this.schema(parameter, this.swaggerTypeResolver.createResolver().setPostfix(eventId.replace('.', '_')).getAndAddEventTypeOrThrowException(eventId));
    }

    public <T> T schema(T parameter, String semanticTypeName) throws SwaggerBuilderException {
        return this.schema(parameter, this.swaggerTypeResolver.createResolver().getAndAddJavaTypeOrThrowException(semanticTypeName));
    }

    protected <T> T schema(T parameter, Class<?> semanticTypeClass) throws SwaggerBuilderException {
        return this.schema(parameter, this.swaggerTypeResolver.createResolver().getAndAddJavaTypeOrThrowException(semanticTypeClass));
    }

    protected <T> T schema(T parameter, Property property) throws SwaggerBuilderException {
        if (parameter instanceof Response) {
            ((Response)parameter).schema(property);
        } else if (parameter instanceof BodyParameter) {
            ((BodyParameter)parameter).schema((Model)this.swaggerTypeResolver.createRefModel(property));
        } else {
            throw new SwaggerBuilderException("Unsupported parameter '" + String.valueOf(parameter.getClass()) + "'.");
        }
        return parameter;
    }

    protected Response getResponseUpdateCount() throws SwaggerBuilderException {
        Response response = new Response().description("OK");
        this.schema(response, DSResultUpdateCountResponse.DSResultUpdateCount.class);
        return response;
    }

    public class SwaggerExamplesProvider {
        private SemanticTypeResolver semanticTypeResolver;

        public SwaggerExamplesProvider(AbstractSwaggerBuilder this$0, SemanticTypeResolver semanticTypeResolver) {
            this.semanticTypeResolver = semanticTypeResolver;
        }

        public <T> T examples(T parameter, Class<?> clazz) {
            return this.examples(parameter, this.semanticTypeResolver.getSemanticTypeCache().resolveSemanticClass(clazz));
        }

        public <T> T examples(T parameter, String semanticType) {
            try {
                Object object = ObjectCreatorFactory.createObjectCreator().createDefaultObject(semanticType);
                if (object == null) {
                    throw new Exception("Creation of semantic type instance failed.");
                }
                this.examples(parameter, object);
            }
            catch (Exception exception) {
                Trace.logError(this, "Failed to create sample object for type '" + semanticType + "'.");
                Trace.logException(this, exception, false);
            }
            return parameter;
        }

        public <T> T examplesEvent(T parameter, String eventId) {
            EventDatagram event = null;
            try {
                event = EventDatagramFactory.getInstance().createEvent(eventId);
            }
            catch (DatagramFactoryException exception) {
                Trace.logError(this, "Failed to create instanceof event [" + eventId + "].");
                Trace.logException(this, exception, false);
                return parameter;
            }
            if (event instanceof PayloadEvent) {
                try {
                    Object object = ObjectCreatorFactory.createObjectCreator().createDefaultObject(((PayloadEvent)((Object)event)).getPayloadClass());
                    if (object == null) {
                        throw new Exception("Creation of semantic type instance failed.");
                    }
                    if (event instanceof DataEvent) {
                        ((DataEvent)event).setData(object);
                    } else if (event instanceof DeltaEvent) {
                        ((DeltaEvent)event).setBeforeImage(object);
                        ((DeltaEvent)event).setAfterImage(object);
                    }
                }
                catch (Exception exception) {
                    Trace.logError(this, "Failed to create instance of class " + String.valueOf(((PayloadEvent)((Object)event)).getPayloadClass()) + ".");
                    Trace.logException(this, exception, false);
                }
            }
            return this.examples(parameter, event);
        }

        private <T> T examples(T parameter, Object object) {
            this.examples(parameter, object, HTTPUtils.getJsonSerializerForRest(FormatAndMimeTypes.JSON_SWAGGER), "application/json;swagger=true");
            this.examples(parameter, object, HTTPUtils.getXmlSerializer(), "application/xml;swagger=true");
            return parameter;
        }

        private <T> T examples(T parameter, Object object, TextSerializer serializer, String type) {
            block5: {
                try {
                    String s = serializer.serialize(object);
                    if (parameter instanceof Response) {
                        ((Response)parameter).example(type, (Object)s);
                        break block5;
                    }
                    if (parameter instanceof BodyParameter) {
                        ((BodyParameter)parameter).example(type, s);
                        break block5;
                    }
                    if (parameter instanceof AbstractSerializableParameter) {
                        ((AbstractSerializableParameter)parameter).example(s);
                        break block5;
                    }
                    throw new Exception("Unsupported parameter '" + String.valueOf(parameter.getClass()) + "'.");
                }
                catch (Exception exception) {
                    Trace.logError(this, "Failed to serialize sample object of type '" + String.valueOf(object.getClass()) + "'.");
                    Trace.logException(this, exception, false);
                }
            }
            return parameter;
        }
    }
}

