/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet.dataspace;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.streamscape.Trace;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.ds.collection.EventQueue;
import com.streamscape.cli.ds.collection.Queue;
import com.streamscape.ds.schema.collection.qspace.equeue.EventQueueProxy;
import com.streamscape.ds.schema.collection.qspace.queue.BlockingQueueProxy;
import com.streamscape.ds.types.BinaryType;
import com.streamscape.ds.types.BlobType;
import com.streamscape.ds.types.ClobType;
import com.streamscape.ds.types.FlobType;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.odata.v4.server.jdbc.SqlTypeToEdmMapping;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.jetty.HTTPRequestTrigger;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.servlet.AbstractRestResponse;
import com.streamscape.sef.network.http.server.servlet.AbstractServlet;
import com.streamscape.sef.network.http.server.servlet.ExchangeServletHelper;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.servlet.RestErrorResponse;
import com.streamscape.sef.network.http.server.servlet.RestServletUtils;
import com.streamscape.sef.network.http.server.servlet.ServletError;
import com.streamscape.sef.network.http.server.servlet.ServletErrorInvalidUri;
import com.streamscape.sef.network.http.server.servlet.ServletErrorNotFound;
import com.streamscape.sef.network.http.server.servlet.dataspace.DSResultObjectResponse;
import com.streamscape.sef.network.http.server.servlet.dataspace.DSResultSingleValueResponse;
import com.streamscape.sef.network.http.server.servlet.dataspace.DSResultUpdateCountResponse;
import com.streamscape.sef.network.http.server.servlet.dataspace.DSRowSetResponse;
import com.streamscape.sef.network.http.server.uri.UriRegistry;
import com.streamscape.sef.network.http.server.uri.UriTree;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.network.http.server.utils.MultipartFormDataHelper;
import com.streamscape.slex.file.SLFileSessionContext;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class DataspaceServlet
extends AbstractServlet {
    public static final String QUERY_PARAMETER = "q";
    public static final String WHERE_PARAMETER = "where";
    public static final String LIMIT_PARAMETER = "limit";
    public static final String ORDERBY_PARAMETER = "order_by";
    public static final String USE_TUPLE_SET_PARAMETER = "useTupleSet";
    public static final String TUPLE_SET_PARAMETER = "tupleSet";
    public static final String QUEUE_DATA_PARAMETER = "data";
    public static final String NOROWSET_PARAMETER = "norowset";
    public static final String NOROWS_PARAMETER = "norows";
    public static final String TRANSFER_BUFFER_SIZE_PARAMETER = "transferBufferSize";
    public static final String QUERY_TIMEOUT_PARAMETER = "queryTimeout";
    public static final String NOHEADER_PARAMETER = "noheader";
    public static final int TRANSFER_BUFFER_SIZE_DEFAULT = 10383360;
    public static final int TRANSFER_BUFFER_SIZE_MAX = 0x6306000;
    private int defaultQueryTimeout;
    private UriRegistry<DataspaceRequestDispatcher> registry = new UriRegistry();

    @Override
    public void init() throws ServletException {
        super.init();
        try {
            this.registry.setPrefix("/ds");
            this.registry.register("{dataspaceName}/dsql", new DataspaceAnyRequestDispatcher());
            this.registry.register("{dataspaceName}/{collectionName}", new DataspaceCrudRequestDispatcher(), false);
            this.registry.register("{dataspaceName}/collection/{collectionName}", new DataspaceCrudRequestDispatcher());
            this.registry.register("{dataspaceName}/fn/{functionName}", new DataspaceFunctionRequestDispatcher());
        }
        catch (UriTree.UriException e) {
            Trace.logError(this, "Initialization of dataspace uri registry failed. Cause: " + e.getMessage());
            throw new ServletException(e);
        }
        this.defaultQueryTimeout = JettyAdvancedProperties.build(this.getAcceptorConfiguration()).getIntProperty("jetstream.dataspace.query.timeout.secs");
    }

    @Override
    public String getServletInfo() {
        return "Dataspace servlet.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FabricHTTPRequest url = new FabricHTTPRequest(request);
        try {
            DataspaceRequestDispatcher dispatcher = this.registry.lookup(url);
            if (dispatcher == null) {
                throw new ServletErrorNotFound(url.getUri());
            }
            String dataspaceName = url.getUriParameter("dataspaceName");
            HTTPRequestTrigger.setOperationType(url.getRequest(), HTTPRequestTrigger.OperationType.DATASPACE);
            HTTPRequestTrigger.setComponentName(url.getRequest(), dataspaceName);
            this.getHTTPRequestTrigger().postBefore(request);
            if (dataspaceName == null) {
                throw new ServletErrorInvalidUri("No dataspace name specified.");
            }
            DataspaceAccessor accessor = this.getDataspaceAccessor(url, dataspaceName);
            DataspaceAccessorConfigurator configurator = new DataspaceAccessorConfigurator(accessor, url);
            configurator.configure();
            try {
                dispatcher.dispatch(url, response, accessor);
            }
            finally {
                configurator.unconfigure();
            }
        }
        catch (ServletErrorInvalidUri exception) {
            RestErrorResponse.build(exception).reply(url, response);
        }
        catch (ServletErrorNotFound exception) {
            RestErrorResponse.build(exception).reply(url, response);
        }
        catch (ServletError exception) {
            Trace.logException(this, exception, true);
            RestErrorResponse.build(exception).reply(url, response);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            RestErrorResponse.build(new ServletError(500, "DSQL", "Processing error.", exception)).reply(url, response);
        }
    }

    private void doAdd(final FabricHTTPRequest url, HttpServletResponse response, DataspaceAccessor accessor, String collectionName, Queue queue) throws ServletError, IOException {
        final Object[] data = new Object[2];
        this.listParameters(url, new ParameterObserver(){

            @Override
            public void onParameter(String parameterName, Object parameterValue) throws ServletError {
                if (RestServletUtils.isRequestResponseFormatParameter(url, parameterName) || DataspaceServlet.this.isQueryTimeoutParameter(parameterName) || parameterName.equalsIgnoreCase(DataspaceServlet.NOROWSET_PARAMETER) || parameterName.equalsIgnoreCase("x-session-token") || parameterName.equalsIgnoreCase("x-resource-token")) {
                    return;
                }
                if (parameterName.equalsIgnoreCase(DataspaceServlet.QUEUE_DATA_PARAMETER)) {
                    data[0] = parameterValue;
                    data[1] = true;
                    return;
                }
                throw new ServletErrorInvalidUri("Invalid add request, unknown parameter '" + parameterName + "'.");
            }

            @Override
            public String getParameterSemanticType(String parameterName) {
                return null;
            }

            @Override
            public String getParameterType(String parameterName) {
                return null;
            }
        });
        if (data[1] == null) {
            data[0] = HTTPUtils.readPostRequestAsString(url.getRequest());
        }
        if (data[0] == null) {
            throw new ServletErrorInvalidUri("Invalid add request, data  parameter not specified.");
        }
        if (!(data[0] instanceof String)) {
            throw new ServletErrorInvalidUri("Invalid add request, data parameter should be of type string.");
        }
        String type = null;
        if (queue.getClass() == BlockingQueueProxy.class) {
            Map<String, String> types = this.getCollectionColumnTypes(accessor, collectionName);
            type = types.get("Object");
        } else {
            String eventId = ((EventQueueProxy)queue).getEventId();
            Prototype prototype = RuntimeContext.getInstance().getDatagramPrototypeCache().lookupPrototype(eventId);
            if (prototype != null) {
                type = prototype.getModelName();
            }
        }
        if (type != null && type.equalsIgnoreCase("object")) {
            type = null;
        }
        FormatAndMimeTypes.FormatAndMimeType requestFormat = RestServletUtils.getRequestFormatAndMimeType(url);
        Object object = this.processRequestParameter((String)data[0], requestFormat, type);
        try {
            queue.add(object);
            DSResultUpdateCountResponse.build(1, url).reply(url, response);
        }
        catch (Exception exception) {
            Trace.logDebug(this, exception.getMessage());
            throw new ServletError(500, "DSQL", "Failed to add object to the queue '" + collectionName + "'", exception);
        }
    }

    private void doReadTake(FabricHTTPRequest url, HttpServletResponse response, DataspaceAccessor accessor, String collectionName, Queue queue, boolean isRead) throws ServletError {
        String selector = null;
        for (String parameterName : url.listParameterNames()) {
            if (RestServletUtils.isRequestResponseFormatParameter(url, parameterName) || this.isQueryTimeoutParameter(parameterName) || parameterName.equalsIgnoreCase("x-session-token") || parameterName.equalsIgnoreCase("x-resource-token")) continue;
            if (parameterName.equalsIgnoreCase("selector") || parameterName.equalsIgnoreCase(WHERE_PARAMETER)) {
                selector = url.getParameter(parameterName);
                continue;
            }
            throw new ServletErrorInvalidUri("Invalid read/take request, unknown parameter '" + parameterName + "'.");
        }
        try {
            Object result;
            if (queue instanceof EventQueue && selector != null) {
                EventQueue eventQueue = (EventQueue)queue;
                result = isRead ? eventQueue.read(selector) : eventQueue.take(selector);
            } else {
                if (selector != null) {
                    throw new ServletErrorInvalidUri("Invalid read/take request, selector can be specified for event queue only.");
                }
                result = isRead ? queue.peek() : queue.poll();
            }
            DSResultObjectResponse.build(result).reply(url, response);
        }
        catch (Exception exception) {
            if (exception instanceof ServletError) {
                throw (ServletError)exception;
            }
            Trace.logDebug(this, exception.getMessage());
            throw new ServletError(500, "DSQL", "Failed to read/take object from the queue '" + collectionName + "'.", exception);
        }
    }

    private void doInsert(final FabricHTTPRequest url, HttpServletResponse response, final DataspaceAccessor accessor, final String collectionName) throws Exception {
        FormatAndMimeTypes.FormatAndMimeType requestFormat = RestServletUtils.getRequestFormatAndMimeType(url);
        final StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("insert into ").append(collectionName).append(" (");
        final StringBuilder params = new StringBuilder();
        final ArrayList<Object> values = new ArrayList<Object>();
        final Map[] collectionColumnTypes = new LinkedHashMap[1];
        this.addDefaultParametersForSwaggerClient(url, USE_TUPLE_SET_PARAMETER);
        this.listParameters(url, new ParameterObserver(){

            @Override
            public void onParameter(String parameterName, Object parameterValue) {
                if (RestServletUtils.isRequestResponseFormatParameter(url, parameterName) || parameterName.equalsIgnoreCase(DataspaceServlet.TRANSFER_BUFFER_SIZE_PARAMETER) || DataspaceServlet.this.isQueryTimeoutParameter(parameterName) || parameterName.equalsIgnoreCase(DataspaceServlet.NOROWSET_PARAMETER) || parameterName.equalsIgnoreCase("x-session-token") || parameterName.equalsIgnoreCase("x-resource-token")) {
                    return;
                }
                if (params.length() != 0) {
                    queryBuilder.append(",");
                    params.append(",");
                }
                queryBuilder.append(parameterName);
                if (parameterValue instanceof FunctionWrapper) {
                    params.append(((FunctionWrapper)parameterValue).getFunctionCall());
                    values.addAll(((FunctionWrapper)parameterValue).getParameterValues());
                } else {
                    params.append("?");
                    values.add(parameterValue);
                }
            }

            @Override
            public String getParameterSemanticType(String parameterName) {
                return DataspaceServlet.this.getCollectionColumnSemanticType(accessor, collectionName, collectionColumnTypes, parameterName);
            }

            @Override
            public String getParameterType(String parameterName) {
                return DataspaceServlet.this.getCollectionColumnType(accessor, collectionName, collectionColumnTypes, parameterName);
            }
        });
        queryBuilder.append(") values (").append(params.toString()).append(")");
        String query = queryBuilder.toString();
        Trace.logDebug(this, query);
        this.processRequestParameters(values, requestFormat);
        try {
            RowSet rowSet = accessor.executeQuery(query, values.toArray());
            DSResultUpdateCountResponse.build(rowSet, url).reply(url, response);
            rowSet.close();
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Failed to execute insert query: {}", query);
            Trace.logDebug(this, exception.getMessage());
            Trace.logDebug(this, "Insert values: {}", values);
            throw new ServletError(500, "DSQL", "Failed to execute insert query '" + query + "'.", exception);
        }
    }

    private void doSelect(FabricHTTPRequest url, HttpServletResponse response, DataspaceAccessor accessor, String collectionName) throws ServletError {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("select ");
        StringBuilder whereClause = new StringBuilder();
        String limit = null;
        String orderBy = null;
        String tupleSet = null;
        boolean noColumnsSpecified = true;
        this.addDefaultParametersForSwaggerClient(url, NOROWSET_PARAMETER, NOROWS_PARAMETER);
        for (String parameterName : url.listParameterNames()) {
            if (RestServletUtils.isRequestResponseFormatParameter(url, parameterName) || this.isQueryTimeoutParameter(parameterName) || parameterName.equalsIgnoreCase("x-session-token") || parameterName.equalsIgnoreCase("x-resource-token") || this.getWhereClauseAndCheckThatFirst(parameterName, url.getParameter(parameterName), whereClause)) continue;
            if (parameterName.equalsIgnoreCase(LIMIT_PARAMETER)) {
                limit = url.getParameter(parameterName);
                try {
                    Integer.valueOf(limit);
                    continue;
                }
                catch (Exception exceptino) {
                    throw new ServletErrorInvalidUri("Invalid limit '" + limit + "' parameter value. Should be an Integer.");
                }
            }
            if (parameterName.equalsIgnoreCase(ORDERBY_PARAMETER)) {
                orderBy = url.getParameter(parameterName);
                continue;
            }
            if (parameterName.equalsIgnoreCase(NOROWSET_PARAMETER) || parameterName.equalsIgnoreCase(NOROWS_PARAMETER) || parameterName.equalsIgnoreCase(NOHEADER_PARAMETER)) continue;
            if (parameterName.equalsIgnoreCase(TUPLE_SET_PARAMETER)) {
                tupleSet = url.getParameter(parameterName);
                if (tupleSet != null && tupleSet.length() != 0) continue;
                tupleSet = "";
                continue;
            }
            String value = url.getParameter(parameterName);
            if (value != null && value.length() > 0 && ((value = value.trim()).equalsIgnoreCase("false") || value.equals("0"))) continue;
            if (!noColumnsSpecified) {
                queryBuilder.append(",");
            }
            queryBuilder.append(parameterName);
            noColumnsSpecified = false;
        }
        if (tupleSet != null) {
            if (!noColumnsSpecified) {
                throw new ServletErrorInvalidUri("One of tupleSet or column names should be specified in the query.");
            }
            FormatAndMimeTypes.FormatAndMimeType requestFormat = RestServletUtils.getRequestFormatAndMimeType(url);
            if (tupleSet.equals("")) {
                noColumnsSpecified = true;
            } else if (requestFormat.isFormat("xml")) {
                HierarchicalStreamReader reader;
                try {
                    reader = HTTPUtils.getXmlSerializer().createReader(new StringReader(tupleSet));
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                    throw new ServletError(500, "OMF", "Failed to parse XML tuple set.", exception);
                }
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    String name = reader.getNodeName();
                    String value = reader.getValue();
                    if (value == null || reader.hasMoreChildren()) {
                        throw new ServletError(500, "OMF", "Invalid value for element '" + name + "' in tupleSet specified.");
                    }
                    String svalue = String.valueOf(value);
                    if (svalue.equalsIgnoreCase("true") || svalue.equalsIgnoreCase("1")) {
                        if (!noColumnsSpecified) {
                            queryBuilder.append(",");
                        }
                        queryBuilder.append(name);
                        noColumnsSpecified = false;
                    }
                    reader.moveUp();
                }
            } else {
                try (JsonParser parser = HTTPUtils.getJsonSerializerForRest(requestFormat).createParser(tupleSet);){
                    JsonToken token = parser.nextToken();
                    if (token != JsonToken.START_OBJECT) {
                        throw new ServletError(500, "OMF", "JSON tuple set should be in tupleSet parameter.");
                    }
                    while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
                        if (token != JsonToken.FIELD_NAME) {
                            throw new ServletError(500, "OMF", "Invalid tuple set format, at " + String.valueOf(parser.getCurrentLocation()));
                        }
                        String name = parser.getCurrentName();
                        token = parser.nextToken();
                        if (token != JsonToken.VALUE_STRING && token != JsonToken.VALUE_NUMBER_INT && token != JsonToken.VALUE_FALSE && token != JsonToken.VALUE_TRUE) {
                            throw new ServletError(500, "OMF", "Invalid value for element '" + name + "' in tupleSet specified.");
                        }
                        String value = parser.getValueAsString();
                        if (!"true".equalsIgnoreCase(value) && !"1".equalsIgnoreCase(value)) continue;
                        if (!noColumnsSpecified) {
                            queryBuilder.append(",");
                        }
                        queryBuilder.append(name);
                        noColumnsSpecified = false;
                    }
                }
                catch (IOException exception) {
                    Trace.logException(this, exception, false);
                    throw new ServletError(500, "OMF", "Failed to parse JSON tuple set.", exception);
                }
            }
        }
        if (noColumnsSpecified) {
            queryBuilder.append("*");
        }
        queryBuilder.append(" from ").append("[").append(collectionName).append("]");
        queryBuilder.append(whereClause.toString());
        if (orderBy != null) {
            queryBuilder.append(" order by ").append(orderBy);
        }
        if (limit != null) {
            queryBuilder.append(" limit ").append(limit);
        }
        String query = queryBuilder.toString();
        Trace.logDebug(this, query);
        try {
            RowSet rowSet = accessor.executeQuery(query);
            DSRowSetResponse.build(rowSet).reply(url, response);
            rowSet.close();
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Failed to execute select query: " + query);
            Trace.logDebug(this, exception.getMessage());
            throw new ServletError(500, "DSQL", "Failed to execute select query '" + query + "'.", exception);
        }
    }

    private void doUpdate(final FabricHTTPRequest url, HttpServletResponse response, final DataspaceAccessor accessor, final String collectionName) throws ServletError, IOException {
        FormatAndMimeTypes.FormatAndMimeType requestFormat = RestServletUtils.getRequestFormatAndMimeType(url);
        final StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("update [").append(collectionName).append("] set ");
        final ArrayList<Object> values = new ArrayList<Object>();
        final StringBuilder whereClause = new StringBuilder();
        final Map[] collectionColumnTypes = new LinkedHashMap[1];
        final boolean[] first = new boolean[]{true};
        this.addDefaultParametersForSwaggerClient(url, USE_TUPLE_SET_PARAMETER);
        this.listParameters(url, new ParameterObserver(){

            @Override
            public void onParameter(String parameterName, Object parameterValue) throws ServletError {
                if (RestServletUtils.isRequestResponseFormatParameter(url, parameterName) || parameterName.equalsIgnoreCase(DataspaceServlet.TRANSFER_BUFFER_SIZE_PARAMETER) || DataspaceServlet.this.isQueryTimeoutParameter(parameterName) || parameterName.equalsIgnoreCase(DataspaceServlet.NOROWSET_PARAMETER) || parameterName.equalsIgnoreCase("x-session-token") || parameterName.equalsIgnoreCase("x-resource-token")) {
                    return;
                }
                if (DataspaceServlet.this.getWhereClauseAndCheckThatFirst(parameterName, parameterValue, whereClause)) {
                    return;
                }
                if (!first[0]) {
                    queryBuilder.append(",");
                } else {
                    first[0] = false;
                }
                if (parameterValue instanceof FunctionWrapper) {
                    queryBuilder.append(parameterName).append("=").append(((FunctionWrapper)parameterValue).getFunctionCall());
                    values.addAll(((FunctionWrapper)parameterValue).getParameterValues());
                } else {
                    queryBuilder.append(parameterName).append("=").append("?");
                    values.add(parameterValue);
                }
            }

            @Override
            public String getParameterSemanticType(String parameterName) {
                return DataspaceServlet.this.getCollectionColumnSemanticType(accessor, collectionName, collectionColumnTypes, parameterName);
            }

            @Override
            public String getParameterType(String parameterName) {
                return DataspaceServlet.this.getCollectionColumnType(accessor, collectionName, collectionColumnTypes, parameterName);
            }
        });
        queryBuilder.append(whereClause.toString());
        String query = queryBuilder.toString();
        Trace.logDebug(this, query);
        this.processRequestParameters(values, requestFormat);
        try {
            RowSet rowSet = accessor.executeQuery(query, values.toArray());
            DSResultUpdateCountResponse.build(rowSet, url).reply(url, response);
            rowSet.close();
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Failed to execute update query: " + query);
            Trace.logDebug(this, exception.getMessage());
            throw new ServletError(500, "DSQL", "Failed to execute update query '" + query + "'.", exception);
        }
    }

    private void doDelete(final FabricHTTPRequest url, HttpServletResponse response, DataspaceAccessor accessor, String collectionName) throws ServletError, IOException {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("delete from [").append(collectionName).append("]");
        final StringBuilder whereClause = new StringBuilder();
        this.listParameters(url, new ParameterObserver(){

            @Override
            public void onParameter(String parameterName, Object parameterValue) throws ServletError {
                if (RestServletUtils.isRequestResponseFormatParameter(url, parameterName) || DataspaceServlet.this.isQueryTimeoutParameter(parameterName) || parameterName.equalsIgnoreCase("x-session-token") || parameterName.equalsIgnoreCase("x-resource-token")) {
                    return;
                }
                if (DataspaceServlet.this.getWhereClauseAndCheckThatFirst(parameterName, parameterValue, whereClause)) {
                    return;
                }
                if (parameterName.equalsIgnoreCase(DataspaceServlet.NOROWSET_PARAMETER)) {
                    return;
                }
                throw new ServletErrorInvalidUri("Invalid delete request, unknown parameter '" + parameterName + "'.");
            }

            @Override
            public String getParameterSemanticType(String parameterName) {
                return null;
            }

            @Override
            public String getParameterType(String parameterName) {
                return null;
            }
        });
        queryBuilder.append(whereClause.toString());
        String query = queryBuilder.toString();
        Trace.logDebug(this, query);
        try {
            RowSet rowSet = accessor.executeQuery(query);
            DSResultUpdateCountResponse.build(rowSet, url).reply(url, response);
            rowSet.close();
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Failed to execute delete query: " + query);
            Trace.logDebug(this, exception.getMessage());
            throw new ServletError(500, "DSQL", "Failed to execute delete query '" + query + "'.", exception);
        }
    }

    private void addDefaultParametersForSwaggerClient(FabricHTTPRequest url, String ... parameters) {
        if (RestServletUtils.isSwaggerRequest(url)) {
            Arrays.asList(parameters).forEach(parameter -> {
                if (url.getParameter((String)parameter) == null) {
                    url.addParameter((String)parameter, "true");
                }
            });
        }
    }

    private void doFunctionCall(final FabricHTTPRequest url, HttpServletResponse response, DataspaceAccessor accessor, String functionName) throws ServletError, IOException {
        FormatAndMimeTypes.FormatAndMimeType requestFormat = RestServletUtils.getRequestFormatAndMimeType(url);
        final LinkedHashMap<String, String> parameterNamesTypes = new LinkedHashMap<String, String>();
        try {
            RowSet rowSet = accessor.executeQuery("describe function " + functionName + " parameters");
            while (rowSet.next()) {
                if (!"IN".equalsIgnoreCase(rowSet.getString(3))) continue;
                parameterNamesTypes.put(rowSet.getString(1), rowSet.getString(2));
            }
            rowSet.close();
        }
        catch (Exception exception) {
            Trace.logDebug(this, exception.toString());
            throw new ServletErrorInvalidUri("Function '" + functionName + "' doesn't exist.", null);
        }
        this.addDefaultParametersForSwaggerClient(url, USE_TUPLE_SET_PARAMETER, NOROWSET_PARAMETER);
        final HashMap parameterValuesMap = new HashMap();
        this.listParameters(url, new ParameterObserver(){

            @Override
            public void onParameter(String parameterName, Object parameterValue) throws ServletError {
                if (RestServletUtils.isRequestResponseFormatParameter(url, parameterName) || DataspaceServlet.this.isQueryTimeoutParameter(parameterName) || parameterName.equalsIgnoreCase("x-session-token") || parameterName.equalsIgnoreCase("x-resource-token")) {
                    return;
                }
                if (parameterName.equalsIgnoreCase(DataspaceServlet.NOROWSET_PARAMETER) || parameterName.equalsIgnoreCase(DataspaceServlet.NOROWS_PARAMETER) || parameterName.equalsIgnoreCase(DataspaceServlet.TRANSFER_BUFFER_SIZE_PARAMETER) || parameterName.equalsIgnoreCase(DataspaceServlet.NOHEADER_PARAMETER)) {
                    return;
                }
                if (!parameterNamesTypes.containsKey(parameterName)) {
                    throw new ServletErrorInvalidUri("Invalid DSQL function request, unknown function parameter '" + parameterName + "'.");
                }
                if (parameterValuesMap.put(parameterName, parameterValue) != null) {
                    throw new ServletErrorInvalidUri("Invalid DSQL function request, function parameter '" + parameterName + "' specified twice.");
                }
            }

            @Override
            public String getParameterSemanticType(String parameterName) {
                return DataspaceServlet.this.getCollectionColumnSemanticType(parameterNamesTypes, parameterName);
            }

            @Override
            public String getParameterType(String parameterName) {
                if (parameterNamesTypes != null) {
                    return (String)parameterNamesTypes.get(parameterName);
                }
                return null;
            }
        });
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("call ").append(functionName).append("(");
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (String parameterName : parameterNamesTypes.keySet()) {
            Object parameterValue = parameterValuesMap.get(parameterName);
            if (parameterValue == null && !parameterValuesMap.containsKey(parameterName)) {
                throw new ServletErrorInvalidUri("Invalid DSQL function call request, function parameter '" + parameterName + "' not specified.");
            }
            if (queryBuilder.charAt(queryBuilder.length() - 1) != '(') {
                queryBuilder.append(", ");
            }
            if (parameterValue instanceof FunctionWrapper) {
                queryBuilder.append(((FunctionWrapper)parameterValue).getFunctionCall());
                parameterValues.addAll(((FunctionWrapper)parameterValue).getParameterValues());
                continue;
            }
            queryBuilder.append("?");
            parameterValues.add(parameterValue);
        }
        queryBuilder.append(")");
        String query = queryBuilder.toString();
        Trace.logDebug(this, query);
        this.processRequestParameters(parameterValues, requestFormat);
        DataspaceAccessorConfigurator configurator = null;
        if (RestServletUtils.getResponseFormatAndMimeType(url).isBinary() && AbstractRestResponse.isNorowset(url)) {
            configurator = new DataspaceAccessorConfigurator(accessor, url);
            configurator.configureDownloadableBlobSize(0xA00000);
        }
        RowSet rowSet = null;
        try {
            rowSet = accessor.executeQuery(query, parameterValues.toArray());
            if (rowSet.getMeta().getColumnCount() == 1 && !rowSet.getMeta().getColumnName(1).equals("UpdateCount") && rowSet.next() && !rowSet.next()) {
                rowSet.beforeFirst();
                DSResultSingleValueResponse.build(rowSet, url).reply(url, response);
            } else {
                rowSet.beforeFirst();
                this.buildAndReplyUpdateCountOrRowSetResult(url, response, rowSet);
            }
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Failed to execute function : {}", query);
            Trace.logDebug(this, exception.getMessage());
            Trace.logDebug(this, "Function parameter values: {}", parameterValues);
            throw new ServletError(500, "DSQL", "Failed to execute function '" + query + "'.", exception);
        }
        finally {
            if (configurator != null) {
                configurator.unconfigureDownloadableBlobSize();
            }
            if (rowSet != null) {
                rowSet.close();
            }
        }
    }

    private void doAnyStatement(FabricHTTPRequest url, HttpServletResponse response, DataspaceAccessor accessor) throws ServletError {
        String query = null;
        for (String parameterName : url.listParameterNames()) {
            if (RestServletUtils.isRequestResponseFormatParameter(url, parameterName) || this.isQueryTimeoutParameter(parameterName) || parameterName.equalsIgnoreCase("x-session-token") || parameterName.equalsIgnoreCase("x-resource-token")) continue;
            if (parameterName.equalsIgnoreCase(QUERY_PARAMETER)) {
                query = url.getParameter(parameterName);
                continue;
            }
            if (parameterName.equalsIgnoreCase(NOROWSET_PARAMETER) || parameterName.equalsIgnoreCase(NOROWS_PARAMETER) || parameterName.equalsIgnoreCase(NOHEADER_PARAMETER)) continue;
            throw new ServletErrorInvalidUri("Invalid DSQL statement request, unknown parameter '" + parameterName + "'.");
        }
        Trace.logDebug(this, query);
        try {
            RowSet rowSet = accessor.executeQuery(query);
            if (rowSet == null) {
                rowSet = new RowSet();
            }
            this.buildAndReplyUpdateCountOrRowSetResult(url, response, rowSet);
            rowSet.close();
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Failed to execute query: " + query);
            Trace.logDebug(this, exception.getMessage());
            throw new ServletError(500, "DSQL", "Failed to execute query '" + query + "'.", exception);
        }
    }

    private boolean isBinaryType(String type) {
        return this.isBlobType(type) || type != null && (type.equals(BinaryType.BINARY_NAME) || type.equals(BinaryType.BINARY_FULL_NAME) || type.equals(BinaryType.VBINARY_NAME) || type.equals(BinaryType.VBINARY_FULL_NAME));
    }

    private boolean isLobType(String type) {
        return this.isClobType(type) || this.isBlobType(type) || this.isFlobType(type);
    }

    private boolean isClobType(String type) {
        return type != null && (type.equalsIgnoreCase(ClobType.NAME_STRING) || type.equalsIgnoreCase(ClobType.NAME_FULL_STRING));
    }

    private boolean isBlobType(String type) {
        return type != null && (type.equalsIgnoreCase(BlobType.NAME_STRING) || type.equalsIgnoreCase(BlobType.NAME_FULL_STRING));
    }

    private boolean isFlobType(String type) {
        return type != null && (type.toLowerCase().equals(FlobType.NAME_STRING.toLowerCase()) || type.toLowerCase().startsWith(FlobType.NAME_STRING.toLowerCase() + "("));
    }

    private boolean isFlobAutotagType(String type) {
        return this.isFlobType(type) && type.toLowerCase().contains("autotag");
    }

    private void listParameters(FabricHTTPRequest url, ParameterObserver observer) throws IOException, ServletError {
        boolean useTupleSet = false;
        for (String parameterName : url.listParameterNames()) {
            if (parameterName.equals(USE_TUPLE_SET_PARAMETER)) {
                useTupleSet = true;
                continue;
            }
            observer.onParameter(parameterName, this.getParameterValue(url, parameterName));
        }
        if (useTupleSet) {
            this.listParametersFromTupleSet(url, observer);
        } else {
            this.listParametersFromMultiparts(url, observer);
        }
    }

    private void listParametersFromMultiparts(FabricHTTPRequest url, ParameterObserver observer) throws IOException, ServletError {
        List<FileItem> parts = MultipartFormDataHelper.getOrParseMultiParts(url.getRequest(), this.getAcceptorConfiguration(), -1);
        if (parts != null) {
            for (FileItem part : parts) {
                FunctionWrapper wrapper;
                String contentType = part.getContentType();
                String charset = RestServletUtils.getCharset(contentType);
                if (charset != null && !Charset.isSupported(charset)) {
                    charset = null;
                }
                String parameterType = observer.getParameterType(part.getFieldName());
                boolean isLobType = this.isLobType(parameterType);
                boolean isFlobType = this.isFlobType(parameterType);
                boolean isBinaryType = this.isBinaryType(parameterType);
                if (part.isInMemory() || !isLobType) {
                    Object parameterValue = part.get();
                    if (isFlobType) {
                        wrapper = new ToFlobFunctionWrapper(parameterValue);
                        wrapper.setCharset(charset);
                        ((ToFlobFunctionWrapper)wrapper).setFilename(this.getFlobFilename(part, parameterType));
                        parameterValue = wrapper;
                    } else if (!isBinaryType) {
                        try {
                            parameterValue = charset != null ? (Object)new String((byte[])parameterValue, charset) : (Object)new String((byte[])parameterValue, StandardCharsets.UTF_8);
                        }
                        catch (Exception exception) {
                            parameterValue = new String((byte[])parameterValue);
                        }
                    }
                    observer.onParameter(part.getFieldName(), parameterValue);
                    continue;
                }
                DiskFileItem filePart = (DiskFileItem)part;
                wrapper = new ReadFunctionWrapper(filePart.getStoreLocation().getAbsolutePath());
                if (isFlobType) {
                    wrapper = new ToFlobFunctionWrapper((ReadFunctionWrapper)wrapper);
                    wrapper.setCharset(charset);
                    ((ToFlobFunctionWrapper)wrapper).setFilename(this.getFlobFilename(part, parameterType));
                } else if (!isBinaryType) {
                    wrapper.setCharset(charset != null ? charset : StandardCharsets.UTF_8.name());
                }
                observer.onParameter(part.getFieldName(), wrapper);
            }
        }
    }

    private void listParametersFromTupleSet(FabricHTTPRequest url, ParameterObserver observer) throws IOException, ServletError {
        block19: {
            String content = HTTPUtils.readPostRequestAsString(url.getRequest());
            if (content == null || content.trim().length() == 0) {
                throw new ServletError(500, "OMF", "Tuple set is empty.");
            }
            FormatAndMimeTypes.FormatAndMimeType requestFormat = RestServletUtils.getRequestFormatAndMimeType(url);
            if (requestFormat.isFormat("json")) {
                JSONSerializer serializer = HTTPUtils.getJsonSerializerForRestNoRoot(requestFormat);
                try (JsonParser parser = serializer.createParser(content);){
                    JsonToken token;
                    if (parser.nextToken() != JsonToken.START_OBJECT) {
                        throw new ServletError(500, "OMF", "JSON tuple set should be in POST data.");
                    }
                    while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
                        Object value;
                        if (token != JsonToken.FIELD_NAME) {
                            throw new ServletError(500, "OMF", "JSON tuple set has incorrect format.");
                        }
                        String name = parser.getCurrentName();
                        token = parser.nextToken();
                        try {
                            String parameterType = observer.getParameterSemanticType(name);
                            value = parameterType != null ? serializer.deserialize(parameterType, parser) : serializer.deserialize(parser);
                        }
                        catch (Exception exception) {
                            Trace.logException(this, exception, false);
                            throw new ServletError(500, "OMF", "Implicit data marshaling from JSON failed for field '" + name + "' failed. ", exception);
                        }
                        observer.onParameter(name, value);
                    }
                    break block19;
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                    throw new ServletError(500, "OMF", "Failed to parse JSON tuple set.", exception);
                }
            }
            if (requestFormat.isFormat("xml")) {
                try {
                    new ExchangeServletHelper.XmlParserHelper(observer::getParameterSemanticType, observer::onParameter, requestFormat).parse(content);
                }
                catch (ExchangeServletHelper.XmlParserHelperException exception) {
                    throw new ServletError(500, "OMF", "Failed to parse XML tuple set.", exception);
                }
            } else {
                throw new ServletError(500, "OMF", "JSON or XML tuple set are supported only.");
            }
        }
    }

    private String getFlobFilename(FileItem part, String parameterType) throws ServletErrorInvalidUri {
        String filename = part.getName();
        if (filename == null || filename.length() == 0) {
            if (this.isFlobAutotagType(parameterType)) {
                filename = "unknownname";
            } else {
                throw new ServletErrorInvalidUri("Filename not specified for multipart field '" + part.getFieldName() + "'. If target FLOB type is not autotag filename should be specified.");
            }
        }
        return filename;
    }

    private Map<String, String> getCollectionColumnTypes(DataspaceAccessor accessor, String collectionName) throws ServletErrorInvalidUri {
        LinkedHashMap<String, String> collectionColumnTypes = new LinkedHashMap<String, String>();
        try {
            RowSet rowSet = accessor.executeQuery("describe collection " + collectionName + " tuples");
            while (rowSet.next()) {
                collectionColumnTypes.put(rowSet.getString(1), rowSet.getString(2));
            }
            rowSet.close();
            return collectionColumnTypes;
        }
        catch (Exception exception) {
            Trace.logDebug(this, exception.toString());
            throw new ServletErrorInvalidUri("Collection '" + collectionName + "' doesn't exist.", null);
        }
    }

    private String getCollectionColumnType(DataspaceAccessor accessor, String collectionName, Map<String, String>[] types, String columnName) {
        if (types[0] == null) {
            try {
                types[0] = this.getCollectionColumnTypes(accessor, collectionName);
            }
            catch (ServletErrorInvalidUri exception) {
                Trace.logError(this, "Failed to get collection column list. Cause: " + exception.getMessage());
            }
        }
        if (types[0] != null) {
            return types[0].get(columnName);
        }
        return null;
    }

    private String getCollectionColumnSemanticType(DataspaceAccessor accessor, String collectionName, Map<String, String>[] types, String columnName) {
        if (types[0] == null) {
            try {
                types[0] = this.getCollectionColumnTypes(accessor, collectionName);
            }
            catch (ServletErrorInvalidUri exception) {
                Trace.logError(this, "Failed to get collection column list. Cause: " + exception.getMessage());
            }
        }
        if (types[0] != null) {
            return this.getCollectionColumnSemanticType(types[0], columnName);
        }
        return null;
    }

    private String getCollectionColumnSemanticType(Map<String, String> types, String columnName) {
        String columnType = types.get(columnName);
        int sqlType = SqlTypeToEdmMapping.getPrimitiveSqlType((String)columnType);
        if (sqlType == -1) {
            return columnType;
        }
        if (sqlType == 2003) {
            String itemType = SqlTypeToEdmMapping.extractItemTypeFromArrayType((String)columnType);
            String itemSemanticType = "object";
            if (itemType != null && (itemSemanticType = SqlTypeToEdmMapping.getSemanticTypeFromSqlType((String)itemType)) == null) {
                itemSemanticType = itemType;
            }
            return itemSemanticType + "[]";
        }
        String columnSemanticType = SqlTypeToEdmMapping.getSemanticTypeFromSqlType((String)columnType);
        if (columnSemanticType == null) {
            columnSemanticType = columnType;
        }
        return columnSemanticType;
    }

    private Object getParameterValue(FabricHTTPRequest url, String parameterName) throws IOException {
        Object parameterValue = url.getParameter(parameterName);
        if (parameterValue != null && (parameterValue.equals("http{content}") || parameterValue.equals("http{content-bytes}"))) {
            byte[] content = HTTPUtils.readPostRequest(url.getRequest());
            parameterValue = parameterValue.equals("http{content}") ? HTTPUtils.convertPostData(url.getRequest(), content) : (Object)content;
        }
        if (parameterValue instanceof String) {
            if (((String)parameterValue).equals("''")) {
                parameterValue = "";
            } else if (((String)parameterValue).startsWith("'") && ((String)parameterValue).endsWith("'")) {
                parameterValue = ((String)parameterValue).substring(1, ((String)parameterValue).length() - 1);
            } else if (((String)parameterValue).length() == 0) {
                parameterValue = null;
            }
        }
        return parameterValue;
    }

    private void buildAndReplyUpdateCountOrRowSetResult(FabricHTTPRequest url, HttpServletResponse response, RowSet rowSet) throws Exception {
        if (rowSet.getMeta().getColumnCount() == 1 && rowSet.getMeta().getColumnName(1).equals("UpdateCount") && rowSet.next() && !rowSet.next()) {
            rowSet.beforeFirst();
            DSResultUpdateCountResponse.build(rowSet, url).reply(url, response);
        } else {
            rowSet.beforeFirst();
            DSRowSetResponse.build(rowSet).reply(url, response);
        }
    }

    private boolean getWhereClauseAndCheckThatFirst(String parameterName, Object whereValue, StringBuilder whereClause) throws ServletError {
        boolean first;
        boolean bl = first = whereClause.length() == 0;
        if (parameterName.equalsIgnoreCase(WHERE_PARAMETER)) {
            whereClause.append(" where ").append(whereValue);
        } else if (parameterName.length() >= 7 && parameterName.substring(0, 6).equalsIgnoreCase("where(")) {
            String where = parameterName.substring(6, parameterName.length() - 1).trim();
            if (where.length() > 0) {
                whereClause.append(" where ").append(where);
            } else {
                whereClause = null;
            }
        } else {
            return false;
        }
        if (!(whereClause != null && whereClause.length() <= 0 || first)) {
            throw new ServletErrorInvalidUri("Invalid update request, two where clauses specified.");
        }
        return true;
    }

    private DataspaceAccessor getDataspaceAccessor(FabricHTTPRequest url, String dataspace) throws Exception {
        DataspaceType dataspaceType;
        HTTPServerFabricConnection fabricConnection = DataspaceServlet.getFabricConnectionOrThrowException(url.getRequest());
        StringTokenizer tokenizer = new StringTokenizer(dataspace, ".");
        if (tokenizer.countTokens() < 2 || tokenizer.countTokens() > 3) {
            throw new ServletError(424, "URL", "Invalid Dataspace Resource '" + dataspace + "'. Should be in format [<DataspaceNode>.]<DataspaceType>.<DataspaceName>.");
        }
        String dataspaceNode = null;
        if (tokenizer.countTokens() == 3) {
            dataspaceNode = tokenizer.nextToken();
        }
        String type = tokenizer.nextToken();
        String dataspaceName = tokenizer.nextToken();
        try {
            dataspaceType = DataspaceType.valueOf(type.toUpperCase());
        }
        catch (Exception exception) {
            throw new ServletError(424, "URL", "Invalid Dataspace type '" + type + "'.");
        }
        DataspaceAccessor dataspaceAccessor = fabricConnection.getOrCreateDataspaceAccessor(dataspaceNode, dataspaceType, dataspaceName, (String)(dataspaceNode != null ? dataspaceNode + "://" : "") + String.valueOf((Object)dataspaceType) + "." + dataspaceName + "_AccessorForDataspaceServlet");
        if (dataspaceAccessor == null) {
            throw new ServletError(424, "URL", "Unknown Dataspace Resource '" + dataspace + "'.");
        }
        if (!dataspaceAccessor.isAvailable() && !dataspaceAccessor.resync()) {
            throw new ServletError(424, "URL", "Dataspace Resource '" + dataspace + "' not available.");
        }
        dataspaceAccessor.setRequestTimeout(this.defaultQueryTimeout * 1000);
        dataspaceAccessor.setSessionContext(SLFileSessionContext.SERVER);
        return dataspaceAccessor;
    }

    private DataCollection getCollection(DataspaceAccessor accessor, String collectionName) throws Exception {
        DataCollection collection = accessor.lookupCollection(collectionName);
        if (collection == null) {
            throw new ServletError(425, "URL", "Unknown Dataspace Collection Entity '" + collectionName + "' @ Resource '" + accessor.getComponentName() + "'.");
        }
        return collection;
    }

    private void processRequestParameters(List<Object> params, FormatAndMimeTypes.FormatAndMimeType requestFormat) throws ServletError {
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            if (!(param instanceof String)) continue;
            param = this.processRequestParameter((String)param, requestFormat);
            params.set(i, param);
        }
    }

    private Object processRequestParameter(String data, FormatAndMimeTypes.FormatAndMimeType requestFormat) throws ServletError {
        return this.processRequestParameter(data, requestFormat, null);
    }

    private Object processRequestParameter(String data, FormatAndMimeTypes.FormatAndMimeType requestFormat, String semanticType) throws ServletError {
        Object object;
        if (requestFormat.isFormat("json")) {
            try {
                if (JSONSerializer.isUnquotedString(data)) {
                    object = data;
                }
                JSONSerializer serializer = HTTPUtils.getJsonSerializerForRest(requestFormat);
                object = semanticType != null ? serializer.deserialize(semanticType, data) : serializer.deserialize(data);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
                throw new ServletError(500, "OMF", "Implicit data marshaling from JSON failed. ", exception);
            }
        } else if (requestFormat.isFormat("xml")) {
            try {
                if (data != null && data.startsWith("<")) {
                    object = semanticType != null ? HTTPUtils.getXmlSerializer().deserialize(semanticType, data.getBytes()) : HTTPUtils.getXmlSerializer().deserialize(data.getBytes());
                }
                object = data;
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
                throw new ServletError(500, "OMF", "Implicit data marshaling from XML failed. ", exception);
            }
        } else if (requestFormat.isFormat("string")) {
            object = data;
        } else {
            throw new ServletErrorInvalidUri("Unknown request format '" + String.valueOf(requestFormat) + "' specified.");
        }
        return object;
    }

    private boolean isQueryTimeoutParameter(String parameterName) {
        return parameterName.equalsIgnoreCase(QUERY_TIMEOUT_PARAMETER);
    }

    private class DataspaceAnyRequestDispatcher
    implements DataspaceRequestDispatcher {
        private DataspaceAnyRequestDispatcher() {
        }

        @Override
        public void dispatch(FabricHTTPRequest url, HttpServletResponse response, DataspaceAccessor accessor) throws Exception {
            DataspaceServlet.this.doAnyStatement(url, response, accessor);
        }
    }

    private class DataspaceCrudRequestDispatcher
    implements DataspaceRequestDispatcher {
        private DataspaceCrudRequestDispatcher() {
        }

        @Override
        public void dispatch(FabricHTTPRequest url, HttpServletResponse response, DataspaceAccessor accessor) throws Exception {
            String collectionName = url.getUriParameterOrThrowException("collectionName");
            DataCollection collection = DataspaceServlet.this.getCollection(accessor, collectionName);
            String method = url.getRequest().getMethod().toUpperCase();
            if (collection instanceof Queue) {
                Queue queue = (Queue)collection;
                switch (method) {
                    case "POST": 
                    case "PUT": {
                        DataspaceServlet.this.doAdd(url, response, accessor, collectionName, queue);
                        break;
                    }
                    case "GET": 
                    case "DELETE": {
                        DataspaceServlet.this.doReadTake(url, response, accessor, collectionName, queue, method.equals("GET"));
                        break;
                    }
                    default: {
                        throw new ServletErrorInvalidUri("Unknown HTTP method.");
                    }
                }
            } else {
                switch (method) {
                    case "POST": {
                        DataspaceServlet.this.doInsert(url, response, accessor, collectionName);
                        break;
                    }
                    case "GET": {
                        DataspaceServlet.this.doSelect(url, response, accessor, collectionName);
                        break;
                    }
                    case "PUT": {
                        DataspaceServlet.this.doUpdate(url, response, accessor, collectionName);
                        break;
                    }
                    case "DELETE": {
                        DataspaceServlet.this.doDelete(url, response, accessor, collectionName);
                        break;
                    }
                    default: {
                        throw new ServletErrorInvalidUri("Unknown HTTP method.");
                    }
                }
            }
        }
    }

    private class DataspaceFunctionRequestDispatcher
    implements DataspaceRequestDispatcher {
        private DataspaceFunctionRequestDispatcher() {
        }

        @Override
        public void dispatch(FabricHTTPRequest url, HttpServletResponse response, DataspaceAccessor accessor) throws Exception {
            DataspaceServlet.this.doFunctionCall(url, response, accessor, url.getUriParameterOrThrowException("functionName"));
        }
    }

    static interface DataspaceRequestDispatcher {
        public void dispatch(FabricHTTPRequest var1, HttpServletResponse var2, DataspaceAccessor var3) throws Exception;
    }

    private class DataspaceAccessorConfigurator {
        private DataspaceAccessor accessor;
        private FabricHTTPRequest url;
        private int oldTransferBufferSize = -2;
        private int oldDownloadable = -2;
        private int queryTimeout = -2;

        public DataspaceAccessorConfigurator(DataspaceAccessor accessor, FabricHTTPRequest url) {
            this.accessor = accessor;
            this.url = url;
        }

        public void configure() {
            this.configureTransferBufferSize();
            FormatAndMimeTypes.FormatAndMimeType responseFormatAndMimeType = RestServletUtils.getResponseFormatAndMimeType(this.url);
            if (responseFormatAndMimeType.isFormat("html") || responseFormatAndMimeType.isFormat("string")) {
                this.configureDownloadableBlobSize(0);
            }
            this.configureDataspaceAccessorQueryTimeout();
        }

        public void unconfigure() {
            this.unconfigureDataspaceAccessorQueryTimeout();
            this.unconfigureDownloadableBlobSize();
            this.unconfigureTransferBufferSize();
        }

        public void configureTransferBufferSize() {
            if (AbstractRestResponse.isTransferBufferSizeSet(this.url)) {
                try {
                    this.oldTransferBufferSize = this.accessor.getTransferBufferSize();
                }
                catch (DataspaceComponentException exception) {
                    Trace.logError(this, "Failed to get transfer buffer size. Cause: " + exception.getMessage());
                }
                try {
                    this.accessor.setTransferBufferSize(AbstractRestResponse.getTransferBufferSize(this.url));
                }
                catch (DataspaceComponentException exception) {
                    Trace.logError(this, "Failed to set transfer buffer size. Cause: " + exception.getMessage());
                }
            }
        }

        public void unconfigureTransferBufferSize() {
            if (this.oldTransferBufferSize != -2) {
                try {
                    this.accessor.setTransferBufferSize(this.oldTransferBufferSize);
                }
                catch (DataspaceComponentException exception) {
                    Trace.logError(this, "Failed to set old transfer buffer size. Cause: " + exception.getMessage());
                }
            }
        }

        public void configureDownloadableBlobSize(int downloadableBlobSize) {
            try {
                this.oldDownloadable = this.accessor.getDownloadableBlobSize();
            }
            catch (DataspaceComponentException exception) {
                Trace.logError(this, "Failed to get downloadable blob size. Cause: " + exception.getMessage());
            }
            try {
                this.accessor.setDownloadableBlobSize(downloadableBlobSize);
            }
            catch (DataspaceComponentException exception) {
                Trace.logError(this, "Failed to set downloadable size. Cause: " + exception.getMessage());
            }
        }

        public void unconfigureDownloadableBlobSize() {
            if (this.oldDownloadable != -2) {
                try {
                    this.accessor.setDownloadableBlobSize(this.oldDownloadable);
                }
                catch (DataspaceComponentException e) {
                    Trace.logError(this, "Failed to set downloadable blob size. Cause: " + e.getMessage());
                }
            }
        }

        public void configureDataspaceAccessorQueryTimeout() {
            String queryTimeoutString = this.url.getParameter(DataspaceServlet.QUERY_TIMEOUT_PARAMETER);
            this.queryTimeout = DataspaceServlet.this.defaultQueryTimeout;
            if (queryTimeoutString != null && queryTimeoutString.length() > 0) {
                try {
                    this.queryTimeout = Integer.valueOf(queryTimeoutString);
                }
                catch (Exception exception) {
                    Trace.logError(this, "Invalid queryTimeout parameter '" + queryTimeoutString + "' specified. ");
                }
            }
            if (this.queryTimeout != DataspaceServlet.this.defaultQueryTimeout) {
                this.accessor.setRequestTimeout(this.queryTimeout * 1000);
            }
        }

        public void unconfigureDataspaceAccessorQueryTimeout() {
            this.accessor.setRequestTimeout(DataspaceServlet.this.defaultQueryTimeout * 1000);
        }
    }

    public static interface ParameterObserver {
        public void onParameter(String var1, Object var2) throws ServletError;

        public String getParameterSemanticType(String var1);

        public String getParameterType(String var1);
    }

    private static abstract class FunctionWrapper {
        protected String charset;

        private FunctionWrapper() {
        }

        public abstract String getFunctionCall();

        public List<Object> getParameterValues() {
            return Collections.EMPTY_LIST;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }
    }

    private static class ToFlobFunctionWrapper
    extends FunctionWrapper {
        private String filename;
        private ReadFunctionWrapper readFunctionWrapper;
        private List<Object> values;

        ToFlobFunctionWrapper(ReadFunctionWrapper readFunctionWrapper) {
            this.readFunctionWrapper = readFunctionWrapper;
        }

        ToFlobFunctionWrapper(Object parameterValue) {
            this.values = new ArrayList<Object>();
            this.values.add(parameterValue);
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        @Override
        public String getFunctionCall() {
            return "toFlob('" + this.filename + "', " + (this.readFunctionWrapper != null ? this.readFunctionWrapper.getFunctionCall() : "?") + ", " + (String)(this.charset != null ? "'" + this.charset + "'" : "null") + ")";
        }

        @Override
        public List<Object> getParameterValues() {
            return this.values != null ? this.values : super.getParameterValues();
        }
    }

    private static class ReadFunctionWrapper
    extends FunctionWrapper {
        private String filename;

        ReadFunctionWrapper(String filename) {
            this.filename = filename;
        }

        @Override
        public String getFunctionCall() {
            return "readFile('" + this.filename + "', 0, -1, " + (String)(this.charset != null ? "'" + this.charset + "'" : "'binary'") + ", 'client')";
        }
    }
}

