/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet.dataspace;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.streamscape.Trace;
import com.streamscape.ds.parser.expression.URL;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonGeneratorRootWrapper;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.xstream.core.util.NameValueWrapper;
import com.streamscape.omf.xml.xstream.io.xml.PrettyPrintWriter;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetPrinter;
import com.streamscape.sef.network.http.server.servlet.AbstractRestResponse;
import com.streamscape.sef.network.http.server.servlet.AbstractRestSuccessResponse;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.servlet.RestErrorResponse;
import com.streamscape.sef.network.http.server.servlet.RestServletUtils;
import com.streamscape.sef.network.http.server.servlet.ServletError;
import com.streamscape.sef.network.http.server.servlet.dataspace.DSResult;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletResponse;

public class DSRowSetResponse
extends AbstractRestSuccessResponse
implements DSResult {
    private RowSet rowSet;

    public static AbstractRestResponse build(RowSet rowSet) {
        DSRowSetResponse result = new DSRowSetResponse();
        result.rowSet = rowSet;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replyJson(FabricHTTPRequest url, HttpServletResponse response, FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) throws IOException {
        try (JsonGenerator generator = null;){
            JSONSerializer jsonSerializer = this.getJsonSerializer(url, formatAndMimeType);
            boolean isNorowset = DSRowSetResponse.isNorowset(url);
            boolean isNorows = DSRowSetResponse.isNorows(url);
            boolean isSwaggerRequest = RestServletUtils.isSwaggerRequest(formatAndMimeType);
            boolean noColumnName = isNorowset && !isSwaggerRequest && this.rowSet.getMeta().getColumnCount() == 1;
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            generator = jsonSerializer.createGenerator(response.getOutputStream(), JsonEncoding.UTF8, true);
            boolean closeDSRowSet = false;
            boolean closeRows = false;
            boolean closeArray = false;
            if (!isNorowset) {
                if (jsonSerializer.getJsonNotationLevel().contains((Object)JsonNotationLevel.ROOT_ELEMENT)) {
                    generator.writeStartObject();
                    generator.writeFieldName("DSRowSet");
                    closeDSRowSet = true;
                }
                if (!isNorows) {
                    generator.writeStartObject();
                    generator.writeFieldName("rows");
                    closeRows = true;
                }
                generator.writeStartArray();
                closeArray = true;
            } else if (isSwaggerRequest || this.rowSet.getRowCount() != 1) {
                generator.writeStartArray();
                closeArray = true;
            }
            while (this.rowSet.next()) {
                boolean closeDSRow = false;
                boolean closeObject = false;
                if (!noColumnName) {
                    if (isNorows && !isNorowset) {
                        generator.writeStartObject();
                        generator.writeFieldName("DSRow");
                        closeDSRow = true;
                        generator.writeStartObject();
                        closeObject = true;
                    } else if (isSwaggerRequest || this.rowSet.getMeta().getColumnCount() != 1) {
                        generator.writeStartObject();
                        closeObject = true;
                    }
                }
                for (int i = 1; i <= this.rowSet.getMeta().getColumnCount(); ++i) {
                    String columnName = this.rowSet.getMeta().getColumnName(i);
                    Object columnValue = this.rowSet.getObject(i);
                    columnValue = DSRowSetResponse.convertRowSetValue(columnValue, this.rowSet.getMeta().getColumnDescriptor(i), formatAndMimeType);
                    if (!noColumnName) {
                        generator.writeFieldName(columnName);
                    }
                    jsonSerializer.serialize(columnValue, new JsonGeneratorRootWrapper(generator));
                }
                if (closeObject) {
                    generator.writeEndObject();
                }
                if (!closeDSRow) continue;
                generator.writeEndObject();
            }
            if (closeArray) {
                generator.writeEndArray();
            }
            if (closeRows) {
                generator.writeEndObject();
            }
            if (closeDSRowSet) {
                generator.writeEndObject();
            }
            generator.flush();
        }
    }

    @Override
    protected void replyXML(FabricHTTPRequest url, HttpServletResponse response) throws IOException {
        try {
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            PrettyPrintWriter formatter = new PrettyPrintWriter(response.getWriter());
            formatter.startNode("DSRowSet");
            XSerializer xmlSerializer = this.getXmlSerializer();
            while (this.rowSet.next()) {
                formatter.startNode("DSRow");
                for (int i = 1; i <= this.rowSet.getMeta().getColumnCount(); ++i) {
                    String columnName = this.rowSet.getMeta().getColumnName(i);
                    Object columnValue = this.rowSet.getObject(i);
                    columnValue = DSRowSetResponse.convertRowSetValue(columnValue, this.rowSet.getMeta().getColumnDescriptor(i), FormatAndMimeTypes.XML);
                    xmlSerializer.marshal(new NameValueWrapper(columnName, columnValue), formatter);
                }
                formatter.endNode();
            }
            formatter.endNode();
            formatter.flush();
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
            RestErrorResponse.build(new ServletError(500, "DSQL", "Failed to read rowSet.", exception)).reply(url, response);
        }
    }

    @Override
    protected void replyString(FabricHTTPRequest url, HttpServletResponse response) throws IOException {
        PrintStream printStream = new PrintStream(response.getOutputStream());
        RowSetPrinter printer = new RowSetPrinter();
        printer.setMaxColumnWidth(3000);
        printer.setPrintStream(printStream);
        if (DSRowSetResponse.isNoheader(url)) {
            printer.setSuppressHeader(true);
        }
        printer.print(this.rowSet);
    }

    @Override
    protected void replyHtml(FabricHTTPRequest url, HttpServletResponse response) throws IOException {
        DSRowSetResponse.objectToHtml(this.rowSet, true, null, DSRowSetResponse.isNoheader(url), new PrintStream(response.getOutputStream()));
    }

    public static Object convertRowSetValue(Object value, ColumnDescriptor columnDescriptor, FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) {
        if (columnDescriptor.getType() == SQLType.URL && value != null && value instanceof URL) {
            String responseFormatParameter;
            URL url = (URL)value;
            Object link = url.getLink();
            int index = ((String)link).lastIndexOf(responseFormatParameter = "responseFormat=");
            if (index != -1 && index + responseFormatParameter.length() < ((String)link).length()) {
                return value;
            }
            link = (String)link + (((String)link).indexOf("?") != -1 ? "&" : "?") + responseFormatParameter + formatAndMimeType.getFormatWithParameters();
            value = new URL((String)link, url.getName());
        }
        return value;
    }

    public RowSet getRowSet() {
        return this.rowSet;
    }
}

