/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.lib.utils.Banner;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDoc;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDocHtmlFormatter;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SorServletCss {
    public static String TABLE_LIST_STYLE = "sor-table-list";
    public static String TABLE_LIST_STYLE_ALT = "alt";
    public static String TABLE_PROPERTIES_STYLE = "sor-table-properties";
    public static String TABLE_METHODS_STYLE = "sor-table-methods";
    public static String TABLE_METHODS_STYLE_ALT = "alt";
    public static String TABLE_SERVICE_CALL_STYLE = "sor-table-service-call";
    public static String SERVICE_CALL_TAB_STYLE = "sor-service-call-tab";
    public static String TABLE_SEMANTIC_MAPPER_RULES_STYLE = "sor-table-semantic-mapper-rule";
    public static String TABLE_SEMANTIC_MAPPER_RULES_STYLE_ALT = "alt";
    public static String TABLE_DS_ROW_SET_RESPONSE_STYLE = "sor-table-rowset";
    public static String TABLE_DS_ROW_SET_RESPONSE_STYLE_ALT = "alt";
    public static String TABLE_DATASPACE_REST_CALL_STYLE = "sor-table-dataspace-rest-call";
    public static String TABLE_DATASPACE_REST_CALL_STYLE_ALT = "alt";
    public static String LINK_STYLE = "sor-link";
    public static String DEFAULT_DIV_STYLE = "sor-div-default";
    public static String JAVADOC_DIV_STYLE = "sor-div-javadoc";
    public static String CODE_PRE_STYLE = "sor-pre-code";
    public static String LINK_BUTTON_STYLE = "sor-button-link";
    public static String DEPLOY_BUTTON_STYLE = "sor-button-deploy";
    private static String SOR_ROWSET_CSS_FILENAME = "/" + SorServletCss.class.getPackage().getName().replaceAll("\\.", "/") + "/html/css/sorrowset.css";
    private static String SOR_SERVLET_CSS_FILENAME = "/" + SorServletCss.class.getPackage().getName().replaceAll("\\.", "/") + "/html/css/sorservlet.css";
    private static String SOR_SERVLET_CSS_START = "<!-- SOR SERVLET CSS START -->";
    private static String SOR_SERVLET_CSS_END = "<!-- SOR SERVLET CSS END -->";
    private static String HEADER_VERSION_PLACE_HOLDER = "<!-- HEADER VERSION PLACE HOLDER -->";
    private static String NAVIGATION_PLACE_HOLDER = "<!-- NAVIGATION PLACE HOLDER -->";
    private static SorServletCss instance;
    private String sorServletCss = this.readCssFile(SOR_SERVLET_CSS_FILENAME);
    private String sorRowSetCss = this.readCssFile(SOR_ROWSET_CSS_FILENAME);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SorServletCss getInstance() {
        if (instance != null) return instance;
        Class<SorServletCss> clazz = SorServletCss.class;
        synchronized (SorServletCss.class) {
            if (instance != null) return instance;
            instance = new SorServletCss();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SorServletCss() {
    }

    private String readCssFile(String name) {
        InputStream in = SorServletCss.class.getResourceAsStream(name);
        try {
            if (in == null) {
                Trace.logError(this, "Failed to read " + name + " from jar.");
                in = new FileInputStream(new File("./html/css/" + name));
            }
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int count = -1;
            while ((count = in.read(buffer)) != -1) {
                bos.write(buffer, 0, count);
            }
            return bos.toString();
        }
        catch (IOException exception) {
            Trace.logException(this, exception, false);
            return "";
        }
    }

    public String getSorServletCss(boolean asLink) {
        if (asLink) {
            return "<link href='/public/css/sorservlet.css' rel='stylesheet'/>\n";
        }
        return this.sorServletCss;
    }

    public String getSorRowSetCss(boolean asLink) {
        if (asLink) {
            return "<link href='/public/css/sorrowset.css' rel='stylesheet'/>\n";
        }
        return this.sorRowSetCss;
    }

    public static String header(String header) {
        return "<h2>" + header + "</h2>";
    }

    public static String subheader(String header) {
        return "<h3>" + header + "</h3>";
    }

    public static String bold(String text) {
        return "<b>" + text + "</b>";
    }

    public static String makeFullHtml(String title, String html) {
        return SorServletCss.makeFullHtml(title, html, SorServletCss.getHeaderVersion(), SorServletCss.getNavigateButtons(), true);
    }

    public static String makeFullHtmlWithPlaceHolders(String title, String html) {
        return SorServletCss.makeFullHtml(title, html, HEADER_VERSION_PLACE_HOLDER, NAVIGATION_PLACE_HOLDER, false);
    }

    public static String makeFullHtml(String title, String html, String headerVersion, String navigateButtons, boolean cssAsLink) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>\n");
        builder.append("<head>\n");
        builder.append("<link href='/public/css/prism.css' rel='stylesheet'/>\n");
        if (!cssAsLink) {
            builder.append("\n\n").append(SOR_SERVLET_CSS_START).append("\n\n");
        }
        builder.append(SorServletCss.getInstance().getSorServletCss(cssAsLink));
        if (!cssAsLink) {
            builder.append("\n\n").append(SOR_SERVLET_CSS_END).append("\n\n");
        }
        builder.append("</head>\n");
        builder.append("<body>\n");
        builder.append("<script src='/public/css/prism.js'></script>\n");
        builder.append("<table class=\"sor-main-table\"><tr><td>\n");
        builder.append(headerVersion);
        builder.append("</td></tr><tr><td>\n");
        if (html.startsWith("<table")) {
            builder.append("<br>");
        }
        if (title != null && title.length() > 0) {
            builder.append("<title>").append(title).append("</title>");
        }
        builder.append(html);
        builder.append("</td></tr></table>");
        builder.append(navigateButtons);
        builder.append(SorServletCss.getLogoutButton());
        builder.append("</body>\n");
        builder.append("</html>\n");
        return builder.toString();
    }

    public static String getHeaderVersion() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n<script>function ExpandToggle(topicID) {var expand=document.getElementById(topicID);if(!expand)  return true;if(expand.style.display==\"none\") {  expand.style.display=\"block\"} else {  expand.style.display=\"none\" }return true;}</script>\n");
        builder.append("<div class=\"sor-div-page-header\"><table>\n");
        builder.append("<tr><td align=\"left\" width=60px><img onClick=\"return ExpandToggle('jvminfo')\" src=\"/public/images/fabricUser.png\" class=\"sor-img-fabric-user\"></td>");
        builder.append("<td><table><tr><td width=90px><b>Fabric Node:</b></td><td><b>").append(RuntimeContext.getInstance().getName()).append("</b></td></tr>\n");
        builder.append("<tr><td><b>Domain:</b></td><td><b>").append(RuntimeContext.getInstance().getDomain()).append("</b></td></tr>").append("</table>").append("</td>\n");
        builder.append("</tr></table>\n");
        builder.append("<p class=\"sor-p-version\">").append("\n");
        builder.append("<text onClick=\"return ExpandToggle('jvminfo')\">").append(Banner.getStreamscapeBanner().trim().replaceAll("\n", "<br>")).append("</text>\n");
        builder.append("<text id=\"jvminfo\" style=\"display:none\">").append("<br>").append(Banner.getJvmBanner().trim().replaceAll("\n", "<br>")).append("</text>\n");
        builder.append("</p>\n");
        builder.append("</div>\n");
        return builder.toString();
    }

    public static String getNavigateButtons() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div class=\"sor-div-navigate-buttons\">\n");
        builder.append("<input type=\"submit\" class=\"sor-navigate-button\" value=\"Home\" onclick=\"location.href='" + SorUriRegistry.registry().getPrefix() + "'\"/>");
        builder.append("<input type=\"submit\" class=\"sor-navigate-button\" value=\"Back\" onclick=\"history.back();\"/>\n");
        builder.append("</div>");
        return builder.toString();
    }

    public static String getLogoutButton() {
        StringBuilder builder = new StringBuilder();
        builder.append("<div class=\"sor-div-navigate-buttons\">\n");
        builder.append("<form class=\"logout\" id=\"logoutform\" action=\"/sor/security/apikey/token/revoke\" method=\"post\">");
        builder.append("<input type=\"hidden\" id=\"basePath\" name=\"basePath\" value=\"/sor\"/>");
        builder.append("<input type=\"hidden\" id=\"redirectUri\" name=\"redirectUri\" value=\"/sor\"/>");
        builder.append("<input type=\"submit\" name=\"Logout\" id=\"logout\" value=\"Logout\"/>");
        builder.append("</form>");
        builder.append("</div>");
        return builder.toString();
    }

    public static String makeDefaultDiv(String html) {
        return "<div class=\"" + DEFAULT_DIV_STYLE + "\">" + html + "</div>\n";
    }

    public static String hightlightCode(String code, String lang) {
        return "\n<pre style='background: #FFFFFF;'; class='" + CODE_PRE_STYLE + "'><code class='language-" + lang + "'>" + code + "</code></pre>";
    }

    public static String makeJavaDocHtm(String javaDoc, DataspaceType dataspaceType, String dataspaceName) {
        return SorServletCss.makeJavaDocHtml(new JavaDoc.Builder().appendUnformattedJavaDoc(javaDoc).build(), dataspaceType, dataspaceName);
    }

    public static String makeJavaDocHtml(JavaDoc javaDoc, DataspaceType dataspaceType, String dataspaceName) {
        return "<div class =\"" + JAVADOC_DIV_STYLE + "\">" + javaDoc.format(new JavaDocHtmlFormatter(dataspaceType, dataspaceName)) + "</div>";
    }

    public static String hightlightCodeJava(String code) {
        return SorServletCss.hightlightCode(code, "java");
    }

    public static String hightlightCodeSQL(String code) {
        return SorServletCss.hightlightCode(code, "sql");
    }
}

