/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.html.AbstractPage;
import com.streamscape.sef.network.http.server.html.RedirectPageResponse;
import com.streamscape.sef.network.http.server.servlet.AbstractServlet;
import com.streamscape.sef.network.http.server.servlet.RestErrorResponse;
import com.streamscape.sef.network.http.server.servlet.RestResponse;
import com.streamscape.sef.network.http.server.servlet.ServletErrorInvalidUri;
import com.streamscape.sef.network.http.server.servlet.ServletErrorNotFound;
import com.streamscape.sef.network.http.server.servlet.SorUriRegistry;
import com.streamscape.sef.network.http.server.uri.UriTree;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SorServlet
extends AbstractServlet {
    public static final String VALUE_COLOR = "style=\"color:#0174DF\"";

    @Override
    public void init() throws ServletException {
        super.init();
        SorUriRegistry.instance();
    }

    @Override
    public String getServletInfo() {
        return "SOR servlet.";
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block16: {
            FabricHTTPRequest url = new FabricHTTPRequest(request);
            FabricHTTPRequest.setThreadLocal(url);
            try {
                Class<? extends AbstractPage> pageClass = SorUriRegistry.registry().lookup(url);
                if (pageClass != null) {
                    AbstractPage page = pageClass.newInstance();
                    if (AuthenticationHelper.isSorLoginRequest(request)) {
                        page.init(RuntimeContext.getInstance(), null, url);
                    } else {
                        page.init(RuntimeContext.getInstance(), SorServlet.getFabricConnectionOrThrowException(request), url);
                    }
                    Object pageResponse = page.buildResponse(url);
                    if (pageResponse instanceof String) {
                        response.setContentType("text/html");
                        response.getOutputStream().print(pageResponse.toString());
                    } else if (pageResponse instanceof RedirectPageResponse) {
                        response.sendRedirect(((RedirectPageResponse)pageResponse).getUrl());
                    } else {
                        RestResponse.build(pageResponse).reply(url, response);
                    }
                    break block16;
                }
                throw new ServletErrorNotFound(url.getUri());
            }
            catch (UriTree.UriException exception) {
                RestErrorResponse.build(new ServletErrorInvalidUri("Invalid Uri.", exception)).reply(url, response);
            }
            catch (ServletErrorNotFound exception) {
                response.sendError(404);
            }
            catch (Exception exception) {
                RestErrorResponse.build("SOR", exception).reply(url, response);
            }
            finally {
                FabricHTTPRequest.unsetThreadLocal(url);
            }
        }
    }
}

