/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.streamscape.Trace;
import com.streamscape.cli.http.HTTPClientException;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.sys.Void;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricEventSourceFactory;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.jetty.HTTPRequestTrigger;
import com.streamscape.sef.network.http.server.servlet.AbstractServlet;
import com.streamscape.sef.network.http.server.servlet.ExchangeServletHelper;
import com.streamscape.sef.network.http.server.servlet.RestErrorResponse;
import com.streamscape.sef.network.http.server.servlet.RestResponse;
import com.streamscape.sef.network.http.server.servlet.RestServletUtils;
import com.streamscape.sef.network.http.server.servlet.ServletError;
import com.streamscape.sef.network.http.server.servlet.ServletErrorInvalidUri;
import com.streamscape.sef.network.http.server.servlet.ServletErrorNotFound;
import com.streamscape.sef.network.http.server.uri.UriRegistry;
import com.streamscape.sef.network.http.server.uri.UriTree;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.slex.slang.SLSession;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServiceServlet
extends AbstractServlet {
    private UriRegistry<Object> registry;

    @Override
    public void init() throws ServletException {
        try {
            this.registry = new UriRegistry();
            this.registry.setPrefix("/service");
            this.registry.register("/invoke", new Object());
            this.registry.register("/invoke/{serviceName}", new Object());
            this.registry.register("/invoke/{serviceName}/{eventHandlerName}", new Object());
        }
        catch (UriTree.UriException e) {
            throw new ServletException("Failed to initialize service uri registry. Cause: " + e.getMessage());
        }
    }

    @Override
    public String getServletInfo() {
        return "Service servlet.";
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processOperation(req, res);
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processOperation(req, res);
    }

    protected void processOperation(HttpServletRequest request, HttpServletResponse response) throws IOException {
        FabricHTTPRequest url = new FabricHTTPRequest(request);
        try {
            Object o = this.registry.lookup(url);
            if (o == null) {
                throw new ServletErrorNotFound(url.getUri());
            }
            this.processInvokeServiceOperation(response, url);
        }
        catch (UriTree.UriException exception) {
            RestErrorResponse.build(new ServletErrorInvalidUri("Failed to parse uri '" + url.getUri() + "'.", exception)).reply(url, response);
        }
        catch (ServletErrorNotFound exception) {
            RestErrorResponse.build(exception).reply(url, response);
        }
    }

    protected void processInvokeServiceOperation(HttpServletResponse response, FabricHTTPRequest url) throws IOException {
        String serviceFullName = null;
        try {
            Object reply;
            boolean isPost = url.getRequest().getMethod().equalsIgnoreCase("post");
            String eventHandlerName = this.getEventHandlerName(url);
            if (url.getUriParameter("eventHandlerName") != null && url.getParameter("eventHandler") != null) {
                throw new ServletErrorInvalidUri("'eventHandler' parameter cannot be specified if handler name specified in URI.");
            }
            if (eventHandlerName != null && url.getParameter("eventId") != null) {
                if (url.getParameter("eventHandler") != null) {
                    throw new ServletErrorInvalidUri("'eventId' and 'eventHandler' can not be specified simultaneously.");
                }
                throw new ServletErrorInvalidUri("'eventId' can not be specified if handler name specified in URI.");
            }
            if (url.getParameter("useEventWrapper") != null && eventHandlerName == null && url.getParameter("eventId") == null) {
                throw new ServletErrorInvalidUri("'useEventWrapper' should be specified with 'eventId' or 'eventHandler' parameter.");
            }
            if (url.getParameter("eventId") == null && url.getParameter("event") == null && eventHandlerName == null) {
                throw new ServletErrorInvalidUri("One of 'eventId' or 'eventHandler' or 'event' parameters should be specified.");
            }
            if (isPost) {
                if (url.getParameter("event") != null) {
                    throw new ServletErrorInvalidUri("For POST request 'event' query parameter parameter is not allowed. Event should be in POST data.");
                }
                if (url.getParameter("data") != null) {
                    throw new ServletErrorInvalidUri("For POST request 'data' query parameter parameter is not allowed. Data should be in POST data.");
                }
            }
            Object serviceName = this.getServiceFullName(url);
            String nodeName = null;
            StringTokenizer tokenizer = new StringTokenizer((String)serviceName, ".");
            if (tokenizer.countTokens() >= 3) {
                nodeName = tokenizer.nextToken();
                serviceName = tokenizer.nextToken() + "." + tokenizer.nextToken();
            }
            if (nodeName != null && url.getParameter("nodeName") != null) {
                throw new ServletErrorInvalidUri("'nodeName' query parameter cannot be specified if service name specified in formant <nodeName>.<serviceType>.<serviceName>.");
            }
            if (nodeName == null) {
                nodeName = url.getParameter("nodeName");
            }
            serviceFullName = nodeName != null ? nodeName + "://" + (String)serviceName : serviceName;
            HTTPRequestTrigger.setOperationType(url.getRequest(), HTTPRequestTrigger.OperationType.SERVICE);
            HTTPRequestTrigger.setComponentName(url.getRequest(), HTTPRequestTrigger.makeComponentName(nodeName, (String)serviceName));
            this.getHTTPRequestTrigger().postBefore(url.getRequest());
            HTTPServerFabricConnection connection = ServiceServlet.getFabricConnectionOrThrowException(url.getRequest());
            ServiceAccessor accessor = connection.getOrCreateServiceAccessor(serviceFullName, serviceFullName + "_AccessorForServiceServlet");
            if (!accessor.isAvailable() && !accessor.resync()) {
                throw new FabricComponentAccessorException(6068, "Service '" + serviceFullName + "' does not exist or is not registered.");
            }
            if (RestServletUtils.isSwaggerRequest(url) && url.getParameter("useEventWrapper") == null && eventHandlerName != null && url.getParameter("eventId") == null && this.isEventInRequest(this.getEventHandler(url, accessor))) {
                url.addParameter("useEventWrapper", "true");
            }
            if (url.getParameter("useEventWrapper") != null && eventHandlerName != null && url.getParameter("eventId") == null) {
                EventHandler eventHandler = this.getEventHandler(url, accessor);
                url.addParameter("eventId", eventHandler.getRequestEventId());
                eventHandlerName = null;
            }
            String loadBalance = url.getParameter("loadBalance");
            if (eventHandlerName != null && (loadBalance == null || loadBalance.length() == 0)) {
                EventHandler handler = this.getEventHandler(url, accessor);
                String requestSemanticType = handler != null ? handler.getRequestSemanticType() : null;
                Object requestObject = ExchangeServletHelper.createDataObject(url, requestSemanticType);
                reply = accessor.invokeServiceRequest(eventHandlerName, requestObject, ExchangeServletHelper.getTimeout(url));
                if (reply == null && "Void".equals(handler.getResponseSemanticType())) {
                    reply = new Void();
                }
            } else {
                EventHandler handler;
                if (url.getParameter("eventId") == null && (handler = this.getEventHandler(url, accessor)) != null) {
                    url.addParameter("eventId", handler.getRequestEventId());
                }
                ImmutableEventDatagram event = "true".equalsIgnoreCase(url.getParameter("useEventWrapper")) ? ExchangeServletHelper.createEventFromWrapper(url, isPost ? HTTPUtils.readPostRequestAsString(url.getRequest()) : url.getParameter("data")) : ExchangeServletHelper.createEvent(url, null);
                if (url.getParameter("eventId") == null) {
                    url.addParameter("eventId", event.getEventId());
                }
                reply = ExchangeServletHelper.raiseRequest(connection, event, (String)serviceName, url);
            }
            this.processServiceReply(reply, response, url, connection, accessor);
        }
        catch (ServletErrorInvalidUri exception) {
            RestErrorResponse.build(exception).reply(url, response);
        }
        catch (ServletError exception) {
            Trace.logException(this, exception, true);
            RestErrorResponse.build(exception).setState(this.getServiceState(url, serviceFullName)).reply(url, response);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            RestErrorResponse.build("SVC", exception).setState(this.getServiceState(url, serviceFullName)).reply(url, response);
        }
    }

    protected boolean isEventInRequest(EventHandler eventHandler) {
        block5: {
            if (eventHandler == null) {
                return true;
            }
            String semanticTypeName = eventHandler.getRequestSemanticType();
            if (semanticTypeName == null || semanticTypeName.trim().length() == 0) {
                return true;
            }
            try {
                Class<?> semanticTypeClass;
                SemanticType semanticType = RuntimeContext.getInstance().getSemanticTypeCache().lookupSemanticType(semanticTypeName);
                if (semanticType != null && ImmutableEventDatagram.class.isAssignableFrom(semanticTypeClass = RuntimeContext.getInstance().getPackageLoaderRegistry().getSystemClassLoaderChain().loadClass(semanticType.getClassName()))) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!semanticTypeName.equals("event") && !semanticTypeName.equals("ImmutableEventDatagram")) break block5;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceState(FabricHTTPRequest url, String serviceFullName) {
        if (serviceFullName == null) {
            return "UNKNOWN";
        }
        HTTPServerFabricConnection connection = ServiceServlet.getFabricConnectionOrThrowException(url.getRequest());
        SLSession session = connection.createSLSession();
        try {
            SLResponse response = session.slangRequest("show service state " + serviceFullName, 30000L);
            if (!response.isOK()) {
                if (response.getException() != null) {
                    throw response.getException();
                }
                if (response.getText() != null) {
                    throw new Exception(response.getText());
                }
            }
            String string = response.getText();
            session.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                session.close();
                throw throwable;
            }
            catch (Throwable exception) {
                Trace.logError(this, "Obtaining service '" + serviceFullName + "' state failed.");
                Trace.logException(this, exception, false);
                return "UNKNOWN";
            }
        }
    }

    protected void processServiceReply(Object reply, HttpServletResponse response, FabricHTTPRequest url, HTTPServerFabricConnection connection, ServiceAccessor accessor) throws Exception {
        EventHandler handler;
        Object replyObject = reply;
        if (reply instanceof SLResponse) {
            SLResponse resp = (SLResponse)reply;
            if (!resp.isOK()) {
                HTTPClientException httpException = new HTTPClientException(1016, resp.getException());
                HTTPFabricEventSourceFactory.coalesce((ImmutableEventDatagram)httpException, connection.getFabricAddress());
                replyObject = httpException;
            }
        } else if (reply instanceof ImmutableEventDatagram && (handler = this.getEventHandler(url, accessor)) != null) {
            ServiceContext serviceContext = this.getServiceContext(url);
            ClassLoader classLoader = serviceContext != null ? serviceContext.getPackageManifestManager().getManifestClassLoader() : RuntimeContext.getInstance().getSystemClassLoaderChain();
            Class responseObjectClass = ClassUtils.loadClass(handler.getResponseObjectClass(), classLoader);
            if (!ImmutableEventDatagram.class.isAssignableFrom(responseObjectClass)) {
                try {
                    replyObject = ExchangeServletHelper.getResultObject((ImmutableEventDatagram)reply);
                }
                catch (IllegalArgumentException error) {
                    throw new ServletException("Unsupported event received as a result of service invocation. Unable to extract its payload.");
                }
            }
        }
        RestResponse.build(replyObject).reply(url, response);
    }

    private String getServiceFullName(FabricHTTPRequest url) throws ServletErrorInvalidUri {
        String serviceFullName = url.getUriParameter("serviceName");
        if ((serviceFullName == null || serviceFullName.length() == 0) && (serviceFullName = url.getParameter("service")) == null) {
            throw new ServletErrorInvalidUri("No service name specified.");
        }
        if (serviceFullName.indexOf(46) == -1) {
            throw new ServletErrorInvalidUri("Invalid service name '" + serviceFullName + "' specified.");
        }
        return serviceFullName;
    }

    private String getServiceName(FabricHTTPRequest url) throws ServletErrorInvalidUri {
        String serviceFullName = this.getServiceFullName(url);
        StringTokenizer tokenizer = new StringTokenizer(serviceFullName, ".");
        if (tokenizer.countTokens() == 3) {
            tokenizer.nextToken();
            return tokenizer.nextToken() + "." + tokenizer.nextToken();
        }
        return serviceFullName;
    }

    private ServiceContext getServiceContext(FabricHTTPRequest url) throws ServletErrorInvalidUri {
        String serviceName = this.getServiceName(url);
        FabricComponent service = RuntimeContext.getInstance().lookupComponentByFQName(serviceName);
        if (service instanceof ServiceContext) {
            return (ServiceContext)service;
        }
        return null;
    }

    private EventHandler getEventHandler(FabricHTTPRequest url, ServiceAccessor accessor) throws FabricComponentAccessorException {
        return this.getEventHandler(url, accessor.getEventHandlers());
    }

    private String getEventHandlerName(FabricHTTPRequest url) {
        String handlerName = url.getUriParameter("eventHandlerName");
        if (handlerName == null) {
            handlerName = url.getParameter("eventHandler");
        }
        return handlerName;
    }

    private EventHandler getEventHandler(FabricHTTPRequest url, List<EventHandler> handlers) {
        String handlerName = this.getEventHandlerName(url);
        if (handlerName != null) {
            for (EventHandler handler : handlers) {
                if (!handler.getHandlerName().equals(handlerName)) continue;
                return handler;
            }
            return null;
        }
        String eventId = url.getParameter("eventId");
        if (eventId != null) {
            for (EventHandler handler : handlers) {
                if (!handler.getRequestEventId().equals(eventId)) continue;
                return handler;
            }
        }
        return null;
    }
}

