/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.ParameterParser;

public class RestServletUtils {
    public static final String REQUEST_FORMAT = "requestFormat";
    public static final String RESPONSE_FORMAT = "responseFormat";
    public static final String EXCEPTION_FORMAT = "exceptionFormat";
    public static final String RESPONSE_MIME_TYPE = "responseMimeType";
    public static final String EVENT_ID_PARAMETER = "eventId";
    public static final String HANDLER_PARAMETER = "eventHandler";
    public static final String EVENT_PARAMETER = "event";
    public static final String DATA_PARAMETER = "data";
    public static final String CORRELATION_ID_PARAMETER = "correlationId";
    public static final String EVENT_GROUP_ID_PARAMETER = "eventGroupId";
    public static final String EVENT_KEY_PARAMETER = "eventKey";
    public static final String DURABLE_PARAMETER = "durable";
    public static final String REPLY_TO_PARAMETER = "replyTo";
    public static final String EVENT_PROPERTIES_PARAMETER = "eventProperties";
    public static final String LOAD_BALANCE_PARAMETER = "loadBalance";
    public static final String NODE_NAME_PARAMETER = "nodeName";
    public static final String TIMEOUT_PARAMETER = "timeout";
    public static final String EVENT_SELECTOR_PARAMETER = "eventSelector";
    public static final String USE_EVENT_WRAPPER = "useEventWrapper";
    public static final String RAISE_EVENT_OP = "raiseEvent";
    public static final String RAISE_REQUEST_OP = "raiseRequest";
    public static final String RECEIVE_EVENT_OP = "receiveEvent";
    public static final String RECEIVE_EVENT_NO_WAIT_OP = "receiveEventNoWait";
    public static final String INQUIRE_OP = "inquire";
    public static final String ECHO_OP = "echo";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XML = "application/xml";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_HTML = "text/html";
    public static final String APPLICATION_BINARY = "application/octet-stream";
    public static final String APPLICATION_YAML = "application/yml";
    public static final String CHARSET_UTF_8 = "; charset=UTF-8";
    public static final String APPLICATION_JSON_UTF_8 = "application/json; charset=UTF-8";
    public static final String APPLICATION_YAML_UTF_8 = "application/yml; charset=UTF-8";
    public static final String APPLICATION_JSON_SWAGGER = "application/json;swagger=true";
    public static final String APPLICATION_XML_SWAGGER = "application/xml;swagger=true";
    public static final String FORMAT_JSON = "json";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_STRING = "string";
    public static final String FORMAT_HTML = "html";
    public static final String FORMAT_BINARY = "binary";
    public static final String FORMAT_JSON_SWAGGER = "json;swagger=true";
    public static final String FORMAT_XML_SWAGGER = "xml;swagger=true";

    public static FormatAndMimeTypes.FormatAndMimeType getExceptionResponseFormatAndMimeType(FabricHTTPRequest url) {
        String format = url.getParameter(EXCEPTION_FORMAT);
        FormatAndMimeTypes.FormatAndMimeType result = null;
        if (format == null) {
            result = RestServletUtils.getResponseFormatAndMimeType(url);
            format = result.getFormat();
            if (!(format.equalsIgnoreCase(FORMAT_JSON) || format.equalsIgnoreCase(FORMAT_XML) || format.equalsIgnoreCase(FORMAT_STRING) || format.equalsIgnoreCase(FORMAT_HTML))) {
                Trace.logDebug(RestServletUtils.class, "WARNING: Unsupported format for exception response " + format + ". Use json.");
                format = FORMAT_JSON;
            } else {
                return result;
            }
        }
        if ((result = FormatAndMimeTypes.lookupByFormat(format)) == null) {
            Trace.logDebug(RestServletUtils.class, "WARNING: Unknown format, no content type for " + format + ". Use text plain.");
            result = FormatAndMimeTypes.lookupByFormat(FORMAT_STRING);
        }
        return result;
    }

    public static FormatAndMimeTypes.FormatAndMimeType getResponseFormatAndMimeType(FabricHTTPRequest url) {
        String format = (String)url.getRequest().getAttribute("API_CUSTOMIZER_RESPONSE_FORMAT");
        String mimeType = (String)url.getRequest().getAttribute("API_CUSTOMIZER_RESPONSE_MIME_TYPE");
        if (format == null || format.trim().length() == 0) {
            format = url.getParameter(RESPONSE_FORMAT);
        }
        if (mimeType == null || mimeType.trim().length() == 0) {
            mimeType = url.getParameter(RESPONSE_MIME_TYPE);
        }
        if (format != null && format.trim().length() == 0) {
            format = null;
        }
        if (mimeType != null && mimeType.trim().length() == 0) {
            mimeType = null;
        }
        if (format == null && mimeType == null) {
            String accept = mimeType;
            if (accept == null) {
                accept = url.getRequest().getHeader("Accept");
            }
            if (accept != null) {
                FormatAndMimeTypes.FormatAndMimeType formatAndMimeType = RestServletUtils.getFormatAndMimeTypeFrom(accept = accept.toLowerCase(), TEXT_HTML);
                if (formatAndMimeType == null) {
                    formatAndMimeType = RestServletUtils.getFormatAndMimeTypeFrom(accept, APPLICATION_JSON);
                }
                if (formatAndMimeType == null) {
                    formatAndMimeType = RestServletUtils.getFormatAndMimeTypeFrom(accept, APPLICATION_XML);
                }
                if ((formatAndMimeType = RestServletUtils.hackFormatAndMimeTypeForSwagger(formatAndMimeType, url)) != null) {
                    return formatAndMimeType;
                }
            }
        }
        if (format == null) {
            format = FORMAT_JSON;
        }
        FormatAndMimeTypes.FormatAndMimeType result = null;
        if (mimeType == null) {
            result = FormatAndMimeTypes.lookupByFormat(format);
            if (result == null) {
                Trace.logDebug(RestServletUtils.class, "WARNING: Unknown format, no content type for " + format + ". Use text plain.");
                result = FormatAndMimeTypes.lookupByFormat(FORMAT_STRING);
            }
        } else {
            result = FormatAndMimeTypes.create(format, mimeType);
        }
        return result;
    }

    public static FormatAndMimeTypes.FormatAndMimeType getRequestFormatAndMimeType(FabricHTTPRequest url) {
        FormatAndMimeTypes.FormatAndMimeType formatAndMimeType;
        String contentType;
        String format = (String)url.getRequest().getAttribute("API_CUSTOMIZER_REQUEST_FORMAT");
        if (format == null) {
            format = url.getParameter(REQUEST_FORMAT);
        }
        if (format == null && (contentType = url.getRequest().getHeader("Content-Type")) != null) {
            FormatAndMimeTypes.FormatAndMimeType formatAndMimeType2 = FormatAndMimeTypes.lookupByMimeType(contentType);
            if ((formatAndMimeType2 = RestServletUtils.hackFormatAndMimeTypeForSwagger(formatAndMimeType2, url)) != null && (formatAndMimeType2.getFormat().equals(FORMAT_JSON) || formatAndMimeType2.getFormat().equals(FORMAT_XML) || formatAndMimeType2.getFormat().equals(FORMAT_STRING))) {
                return formatAndMimeType2;
            }
        }
        if (format == null) {
            format = FORMAT_STRING;
        }
        if ((formatAndMimeType = FormatAndMimeTypes.lookupByFormat(format)) == null) {
            Trace.logError(RestServletUtils.class, "Unknown request format '" + format + "'.");
            formatAndMimeType = FormatAndMimeTypes.lookupByFormat(FORMAT_STRING);
        }
        return formatAndMimeType;
    }

    private static FormatAndMimeTypes.FormatAndMimeType hackFormatAndMimeTypeForSwagger(FormatAndMimeTypes.FormatAndMimeType formatAndMimeType, FabricHTTPRequest url) {
        if (formatAndMimeType != null && !formatAndMimeType.existsParameter("swagger") && url.getRequest().getHeader("User-Agent") != null && url.getRequest().getHeader("User-Agent").indexOf("Swagger-Codegen") != -1) {
            formatAndMimeType = FormatAndMimeTypes.lookupByMimeType(APPLICATION_JSON_SWAGGER);
        }
        return formatAndMimeType;
    }

    public static boolean isRequestResponseFormatParameter(FabricHTTPRequest url, String parameterName) {
        return url.getRequest().getAttribute("API_CUSTOMIZER_REQUEST_FORMAT") == null && (parameterName.equalsIgnoreCase(RESPONSE_FORMAT) || parameterName.equalsIgnoreCase(REQUEST_FORMAT) || parameterName.equalsIgnoreCase(RESPONSE_MIME_TYPE));
    }

    public static FormatAndMimeTypes.FormatAndMimeType getFormatAndMimeTypeFrom(String header, String mimeType) {
        int end1;
        if (header == null) {
            return null;
        }
        int start = header.indexOf(mimeType);
        if (start == -1) {
            return null;
        }
        int end = header.indexOf(44, start);
        if (end == -1) {
            end = header.length();
        }
        if ((end1 = header.indexOf(59, start)) != -1 && end1 < end) {
            end = header.length();
        }
        header = header.substring(start, end);
        return FormatAndMimeTypes.lookupByMimeType(header);
    }

    public static <T> T getServletInitParameter(ServletConfig config, String parameterName, T defaultValue, Class<T> valueClass) throws ServletException {
        String value = config.getInitParameter(parameterName);
        if (value != null) {
            try {
                return RestServletUtils.convertValue(value, valueClass);
            }
            catch (Exception exception) {
                throw new ServletException("Invalid parameter " + parameterName + " value " + value + ".");
            }
        }
        return defaultValue;
    }

    public static <T> T convertValue(String value, Class<T> valueClass) {
        if (valueClass == Boolean.class || valueClass == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (valueClass == Long.class || valueClass == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (valueClass == Integer.class || valueClass == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        return (T)value;
    }

    public static String getCharset(String contentType) {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        return (String)parser.parse(contentType, ';').get("charset");
    }

    public static boolean isContentType(String contentTypeString, String contentType) {
        if (contentTypeString == null || contentType == null) {
            return false;
        }
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        return parser.parse(contentTypeString.toLowerCase(), ';').containsKey(contentType.toLowerCase());
    }

    public static boolean isSwaggerRequest(FabricHTTPRequest url) {
        return RestServletUtils.isSwaggerRequest(RestServletUtils.getRequestFormatAndMimeType(url)) || RestServletUtils.isSwaggerRequest(RestServletUtils.getResponseFormatAndMimeType(url)) || url.getRequest().getHeader("User-Agent") != null && url.getRequest().getHeader("User-Agent").indexOf("Swagger-Codegen") != -1;
    }

    public static boolean isSwaggerRequest(FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) {
        return formatAndMimeType.existsParameter("swagger");
    }

    public static boolean isSwaggerRequestForApiCustomizer(HttpServletRequest request) {
        return request.getHeader("Content-Type") != null && request.getHeader("Content-Type").contains("swagger") || request.getHeader("Accept") != null && request.getHeader("Accept").contains("swagger") || request.getHeader("User-Agent") != null && request.getHeader("User-Agent").indexOf("Swagger-Codegen") != -1;
    }
}

