/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.streamscape.ds.DataspaceException;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.excp.SoapFaultException;
import com.streamscape.sef.network.http.server.servlet.AbstractRestResponse;
import com.streamscape.sef.network.http.server.servlet.ServletError;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import java.sql.SQLException;

public class RestErrorResponse
extends AbstractRestResponse {
    private HTTPException httpException;

    private RestErrorResponse(HTTPException httpException) {
        super(500);
        this.httpException = httpException;
        this.isException = true;
    }

    @Override
    protected void customizeResponseStatus(FabricHTTPRequest url) {
        Object errorCode = null;
        errorCode = url.getRequest().getAttribute("API_CUSTOMIZER_ERROR_CODE");
        if (errorCode != null && errorCode instanceof Integer) {
            this.responseStatus = (Integer)errorCode;
        }
    }

    @Override
    protected Object getResponseObject() {
        return this.httpException;
    }

    public RestErrorResponse setState(String state) {
        if (state == null) {
            state = "00000";
        }
        this.httpException.state = state;
        return this;
    }

    public static RestErrorResponse build(String errorPrefix, Exception exception) {
        if (exception instanceof ServletError) {
            return RestErrorResponse.build((ServletError)exception);
        }
        HTTPException httpException = new HTTPException();
        httpException.errorPrefix = errorPrefix;
        httpException.detailMessage = Utils.formatExceptionWithUnrepeatedCauses(exception);
        RestErrorResponse.initFromException(httpException, exception);
        return new RestErrorResponse(httpException);
    }

    public static RestErrorResponse build(ServletError error) {
        HTTPException httpException = new HTTPException();
        httpException.errorPrefix = error.getErrorPrefix();
        httpException.detailMessage = Utils.formatExceptionWithUnrepeatedCauses(error);
        RestErrorResponse.initFromException(httpException, error.getCause());
        RestErrorResponse result = new RestErrorResponse(httpException);
        result.setResponseStatus(error.getStatus());
        return result;
    }

    private static void initFromException(HTTPException httpException, Throwable exception) {
        if (exception == null) {
            return;
        }
        Throwable e = RestErrorResponse.getCause(DataspaceException.class, exception);
        if (e != null) {
            httpException.errorPrefix = "DSQL";
            httpException.errorCode = Integer.toString(((DataspaceException)e).getErrorCode());
            httpException.state = ((DataspaceException)e).getSQLState();
        } else {
            e = RestErrorResponse.getCause(SQLException.class, exception);
            if (e != null) {
                httpException.errorPrefix = "DSQL";
                httpException.errorCode = Integer.toString(((SQLException)e).getErrorCode());
                httpException.state = ((SQLException)e).getSQLState();
            } else if (exception instanceof IAbstractExceptionEvent) {
                httpException.errorPrefix = ((IAbstractExceptionEvent)exception).getErrorPrefix();
                httpException.errorCode = Integer.toString(((IAbstractExceptionEvent)exception).getErrorCode());
                httpException.severity = ((IAbstractExceptionEvent)exception).getSeverity();
            } else if (exception instanceof SoapFaultException) {
                httpException.errorPrefix = "SVC-SOAP";
                httpException.errorCode = ((SoapFaultException)e).getSoapFaultCode();
                httpException.state = "REST";
                httpException.severity = ((SoapFaultException)e).getSeverity();
            }
        }
        if (exception instanceof ServiceFrameworkException) {
            httpException.stackTrace = exception.getStackTrace();
            Throwable cause = ((ServiceFrameworkException)exception).getCause();
            if (cause != null && cause instanceof SoapFaultException) {
                httpException.errorPrefix = "SVC-SOAP";
                httpException.errorCode = ((SoapFaultException)cause).getSoapFaultCode();
                httpException.state = "REST";
                httpException.severity = ((SoapFaultException)cause).getSeverity();
            }
        }
    }

    private static <T> T getCause(Class<T> clazz, Throwable exception) {
        while (exception != null) {
            if (clazz.isAssignableFrom(exception.getClass())) {
                return (T)exception;
            }
            exception = exception.getCause();
        }
        return null;
    }

    public static class HttpStatus {
        public static final int UNKNOWN_DATASPACE = 424;
        public static final int UNKNOWN_COLLECTION = 425;
        public static final int UNDEFINED_ELEMENT = 426;
        public static final int UNKNOWN_SERVICE = 427;
        public static final int INVALID_REQUEST = 400;
        public static final int NOT_FOUND = 404;
        public static final int PROCESSING_ERROR = 500;
        public static final int DSQL_ERROR = 500;
    }

    public static class HTTPException {
        private String errorPrefix;
        private String errorCode = Integer.toString(1111);
        private String detailMessage = "";
        private String state = "00000";
        private Severity severity = Severity.SEVERE;
        private StackTraceElement[] stackTrace = null;

        public String getErrorPrefix() {
            return this.errorPrefix;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getDetailMessage() {
            return this.detailMessage;
        }

        public String getState() {
            return this.state;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        public String toString() {
            return this.errorPrefix + "-" + this.errorCode + (String)(this.state != null && !this.state.equals("00000") ? ", state " + this.state : "") + " : " + this.detailMessage;
        }
    }

    public static interface ErrorCode {
        public static final int SERVLET = 1111;
    }

    public static interface ErrorPrefix {
        public static final String URL = "URL";
        public static final String SVC = "SVC";
        public static final String SOR = "SOR";
        public static final String EXCH = "EXCH";
        public static final String DSQL = "DSQL";
        public static final String OMF = "OMF";
    }
}

