/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.streamscape.Trace;
import com.streamscape.cli.http.HTTPClientException;
import com.streamscape.cli.http.HTTPDataspaceAccessor;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.fabric.HTTPEventListener;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricConnectionRemoteCall;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricEventSourceFactory;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCall;
import com.streamscape.sef.network.http.server.fabric.RemoteMethodCallPostprocessor;
import com.streamscape.sef.network.http.server.jetty.HTTPRequestTrigger;
import com.streamscape.sef.network.http.server.servlet.AbstractServlet;
import com.streamscape.sef.network.http.server.servlet.RestServletUtils;
import com.streamscape.sef.network.http.server.servlet.StaticMethodWrapper;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.network.http.server.utils.MultipartFormDataHelper;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;

public class JsonExchangeServlet
extends AbstractServlet {
    public static final String MAGIC_START = "5eeve2ec";
    public static final String MAGIC_END = "ce2evee5";
    public static final byte[] REQUEST_ALREADY_PROCESSED = "!@#$request with specifed unique id already processed$#@!".getBytes();
    public static final String SESSION_ATTRIBUTE_REQUEST_UNIQUES = JsonExchangeServlet.class.getName() + ".requests.uniques";
    public static final String PARAMETER_UNIQUE = "unique";
    public static final String PARAMETER_LOGIN = "login";
    public static final String PARAMETER_LOGOUT = "logout";
    public static final String PARAMETER_REVERSE = "reverse";
    public static final String PARAMETER_RECONNECT = "reconnect";
    public static final String SERVLET_PARAMETER_ALLOW_DUPLICATE = "allow.duplicate.request";
    public static final String SERVLET_PARAMETER_UNIQUE_QUEUE_MAX_SIZE = "request.unique.queue.max.size";
    private static boolean allowDuplicateRequest = false;
    private static int requestUniqueQueueMaxSize = 25000;

    @Override
    public String getServletInfo() {
        return "Fabric exchange servlet.";
    }

    @Override
    public void init() throws ServletException {
        super.init();
        allowDuplicateRequest = RestServletUtils.getServletInitParameter(this.getServletConfig(), SERVLET_PARAMETER_ALLOW_DUPLICATE, allowDuplicateRequest, Boolean.class);
        requestUniqueQueueMaxSize = RestServletUtils.getServletInitParameter(this.getServletConfig(), SERVLET_PARAMETER_UNIQUE_QUEUE_MAX_SIZE, requestUniqueQueueMaxSize, Integer.class);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.processFilespacePost(request, response)) {
            return;
        }
        this.doRequest(request, response);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FabricHTTPRequest url = new FabricHTTPRequest(request);
        try {
            if (url.getParameter(PARAMETER_REVERSE) != null) {
                HTTPRequestTrigger.ignoreRequest(url.getRequest());
                HTTPServerFabricConnection fabricConnection = JsonExchangeServlet.getFabricConnectionOrThrowException(url.getRequest());
                if (!fabricConnection.getSLFileDownloadUploadRequestsHolder().hold(url, response) && !fabricConnection.getSLAudioRequestsHolder().hold(url, response)) {
                    fabricConnection.getReverseProcessor().holdReverseConnection(url, response);
                }
            } else {
                this.processRequest(url, response);
            }
        }
        catch (Throwable exception) {
            HTTPClientException httpException = new HTTPClientException(1016, exception.getMessage());
            this.sendJsonReply(httpException, url, response);
        }
    }

    protected void processRequest(FabricHTTPRequest url, HttpServletResponse response) throws ServletException, IOException {
        String requestText;
        String sessionId = url.getRequest().getSession().getId();
        if (url.getParameter(PARAMETER_LOGOUT) != null) {
            this.getFabricConnectionsProviders().removeConnection(sessionId, false);
            HttpSession session = url.getRequest().getSession();
            if (session != null) {
                try {
                    session.invalidate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Trace.logDebug(this, "User '{}' has logged out", url.getRequest().getRemoteUser());
            return;
        }
        if (url.getRequest().getMethod().equalsIgnoreCase("POST")) {
            byte[] magic = new byte[MAGIC_START.length()];
            int read = url.getRequest().getInputStream().read(magic);
            if (read != MAGIC_START.length() || !MAGIC_START.equals(new String(magic))) {
                if (read > 0) {
                    throw new ServletException("Incorrect request (wrong magic word): " + new String(magic));
                }
                throw new ServletException("Incorrect request (no magic word)");
            }
            requestText = HTTPUtils.readPostRequestAsString(url.getRequest());
        } else {
            requestText = url.getParameter("request");
            if (!requestText.startsWith(MAGIC_START)) {
                throw new ServletException("Incorrect request (no magic word). Request: " + JsonExchangeServlet.formatForTrace(requestText));
            }
            requestText = requestText.substring(MAGIC_START.length());
        }
        if (this.isProcessed(url)) {
            response.getOutputStream().write(REQUEST_ALREADY_PROCESSED);
            response.getOutputStream().flush();
            return;
        }
        HTTPServerFabricConnection fabricConnection = null;
        try {
            fabricConnection = JsonExchangeServlet.getFabricConnectionOrThrowException(url.getRequest());
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Fabric connection does not exist for request session: {}, unique: {}, uri: {}, request: {}", url.getRequest().getSession().getId(), url.getParameter(PARAMETER_UNIQUE), url.getRequest().getRequestURI(), JsonExchangeServlet.formatForTrace(requestText));
            throw exception;
        }
        try {
            if (Trace.isDebugEnabled(this.getClass())) {
                Trace.logDebug(this, "{} Start processing of request, unique: {}, uri: {}, request: {}", fabricConnection, url.getParameter(PARAMETER_UNIQUE), url.getRequest().getRequestURI(), JsonExchangeServlet.formatForTrace(requestText));
            }
            Object reply = this.processJsonRequest(url, requestText, fabricConnection);
            this.sendJsonReply(reply, url, response);
            Trace.logDebug(this, "{} End processing of request, unique: {}.", fabricConnection, url.getParameter(PARAMETER_UNIQUE));
        }
        catch (Throwable error) {
            try {
                Trace.logError(this, "{} Processing of request failed, unique: {}, request: {}", fabricConnection, url.getParameter(PARAMETER_UNIQUE), JsonExchangeServlet.formatForTrace(requestText));
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logException(this, error, true);
                }
                HTTPClientException httpException = new HTTPClientException(1016, error);
                if (fabricConnection != null && fabricConnection.isOpened() && fabricConnection.getEventScope() != EventScope.LOCAL) {
                    HTTPFabricEventSourceFactory.coalesce((ImmutableEventDatagram)httpException, fabricConnection.getFabricAddress());
                }
                this.sendJsonReply(httpException, url, response);
            }
            catch (Exception fail) {
                Trace.logError(this, String.valueOf(fabricConnection) + " Sending http client exception failed.");
                Trace.logException(this, fail, true);
            }
        }
    }

    private static String formatForTrace(String requestText) {
        return requestText.length() > 2048 ? requestText.substring(0, 2048) + "..." : requestText;
    }

    private boolean isProcessed(FabricHTTPRequest url) {
        if (allowDuplicateRequest) {
            return false;
        }
        Long unique = null;
        try {
            unique = Long.valueOf(url.getParameter(PARAMETER_UNIQUE));
        }
        catch (Exception exception) {
            Trace.logDebug(this, "Invalid unique {} in request {}?{}", url.getParameter(PARAMETER_UNIQUE), url.getUri(), url.getQuery());
            return false;
        }
        HttpSession session = url.getRequest().getSession(false);
        if (session != null && url.getParameter("FabricSession") != null) {
            RequestUniqueQueue requestUniqueQueue = (RequestUniqueQueue)session.getAttribute(SESSION_ATTRIBUTE_REQUEST_UNIQUES);
            if (requestUniqueQueue == null) {
                requestUniqueQueue = new RequestUniqueQueueSimpleImpl(this);
                session.setAttribute(SESSION_ATTRIBUTE_REQUEST_UNIQUES, requestUniqueQueue);
            }
            return requestUniqueQueue.isProcessed(unique);
        }
        return false;
    }

    protected Object processJsonRequest(FabricHTTPRequest url, String requestText, HTTPServerFabricConnection fabricConnection) throws Throwable {
        HTTPFabricConnectionRemoteCall remoteCall = this.getJsonSerializer(url).deserialize(HTTPFabricConnectionRemoteCall.class, requestText);
        if (!(remoteCall instanceof HTTPFabricConnectionRemoteCall)) {
            throw new ServletException("Unexpected request data: " + remoteCall.getClass().getName() + ", expected: HTTPFabricConnectionRemoteCall");
        }
        return new HTTPRemoteMethodCallExecutor(url, fabricConnection).execute(remoteCall);
    }

    protected static Object resolveReferences(Object obj, HTTPServerFabricConnection fabricConnection) {
        if (obj instanceof HTTPEventListener) {
            HTTPEventListener listener = (HTTPEventListener)obj;
            listener.setFabricConnection(fabricConnection);
            return listener;
        }
        return obj;
    }

    protected JSONSerializer getJsonSerializer(FabricHTTPRequest url) {
        return HTTPUtils.getJsonSerializerForFabric(url != null ? url.getRequest() : null);
    }

    protected void sendJsonReply(Object object, FabricHTTPRequest url, HttpServletResponse response) throws ServletException, IOException {
        Object json = null;
        try {
            json = this.getJsonSerializer(url).serialize(object);
        }
        catch (Exception serializeError) {
            try {
                json = this.getJsonSerializer(url).serialize(serializeError);
            }
            catch (SerializerException e) {
                json = "{ \"error\" : \"deserialization of object '" + String.valueOf(object) + "' failed.\"cause\" : \"" + e.toString() + "\"}";
            }
        }
        try {
            String callback = url.getParameter("callback");
            if (callback != null) {
                if (json == null || ((String)json).length() == 0) {
                    json = "''";
                }
                response.setContentType("text/javascript; charset=UTF-8");
                response.getOutputStream().println(callback + "(");
                this.printWithSequence(url, response, (String)json);
                response.getOutputStream().println(callback + ");");
            } else {
                response.setContentType("application/json; charset=UTF-8");
                this.printWithSequence(url, response, (String)json);
            }
        }
        catch (Exception serializeError) {
            throw new ServletException(serializeError);
        }
        response.flushBuffer();
    }

    private void printWithSequence(FabricHTTPRequest url, HttpServletResponse response, String json) throws ServletException, IOException {
        String sequenceId = url.getParameter("sequenceId");
        if (sequenceId != null) {
            response.getOutputStream().print("{\"sequenceId\" : \"" + sequenceId + "\", \"event\" : ");
        }
        response.getOutputStream().print(json);
        if (sequenceId != null) {
            response.getOutputStream().print("}");
        }
    }

    private boolean processFilespacePost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getRequestURI().endsWith("filespace")) {
            return false;
        }
        byte[] fileData = null;
        String fileName = null;
        try {
            List<FileItem> items = MultipartFormDataHelper.getOrParseMultiParts(request, this.getAcceptorConfiguration(), 1);
            for (FileItem item : items) {
                if (item.isFormField()) {
                    request.setAttribute(item.getFieldName(), HTTPUtils.removeTrailingNullsForString(item.get()));
                    continue;
                }
                fileName = item.getName();
                fileData = item.get();
            }
        }
        catch (Exception exception) {
            Trace.logError(this, "Unable to parse the request! " + exception.getMessage());
            throw new ServletException("Unable to parse post request. Cause: " + exception.getMessage());
        }
        String action = (String)request.getAttribute("action");
        if (action == null) {
            throw new ServletException("Empty action parameter for uploading operation specified");
        }
        if (!action.isEmpty()) {
            if (fileData == null) {
                throw new ServletException("No file data specified.");
            }
            if (action.equals("get-as-base64")) {
                String base64 = Base64.encodeBytes(fileData);
                response.setContentType("text/plain; charset=UTF-8");
                response.getOutputStream().print(base64);
                response.getOutputStream().close();
                Trace.logDebug(this, "Replied with base64-encoding of " + fileData.length + " bytes");
            }
            if (action.equals("raise-as-bytes")) {
                String eventId = (String)request.getAttribute("eventId");
                if (eventId == null) {
                    throw new ServletException("Empty eventId parameter for uploading operation specified");
                }
                String stringScope = (String)request.getAttribute("scope");
                if (stringScope == null) {
                    stringScope = "INHERITED";
                }
                EventScope scope = EventScope.valueOf(stringScope);
                HTTPServerFabricConnection fabricConnection = JsonExchangeServlet.getFabricConnectionOrThrowException(request);
                try {
                    fabricConnection.bindProducerFor(eventId);
                    BytesEvent event = (BytesEvent)EventDatagramFactory.getInstance().createEvent(eventId);
                    event.setBytes(fileData);
                    fabricConnection.raiseEvent(event, scope, 0L);
                    Trace.logDebug(this, "BytesEvent from file was sent with eventId: " + eventId + " and " + String.valueOf((Object)scope) + " scope.");
                    response.setContentType("text/plain; charset=UTF-8");
                    response.getOutputStream().print("OK");
                    response.getOutputStream().close();
                }
                catch (Exception e) {
                    Trace.logError(this, "Unable to buid produccer for " + eventId + " or create and send bytes Event. Event will not be sent. " + e.getMessage());
                    response.setContentType("text/plain; charset=UTF-8");
                    response.getOutputStream().print("NOK");
                    response.getOutputStream().close();
                }
            }
            if (action.equals("save-to-disk")) {
                String path = (String)request.getAttribute("path");
                if (path == null) {
                    throw new ServletException("Empty upload path specified!");
                }
                BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(path + fileName));
                fileOut.write(fileData);
                fileOut.close();
                response.setContentType("text/plain; charset=UTF-8");
                response.getOutputStream().print("OK");
                response.getOutputStream().close();
            }
        } else {
            throw new ServletException("Empty file action specified!");
        }
        return true;
    }

    public static interface RequestUniqueQueue {
        public boolean isProcessed(Long var1);
    }

    class RequestUniqueQueueSimpleImpl
    implements RequestUniqueQueue {
        private List<Long> processedRequests = new ArrayList<Long>();

        RequestUniqueQueueSimpleImpl(JsonExchangeServlet this$0) {
        }

        @Override
        public boolean isProcessed(Long unique) {
            boolean contains = this.processedRequests.contains(unique);
            if (!contains) {
                this.processedRequests.add(unique);
            }
            if (this.processedRequests.size() >= requestUniqueQueueMaxSize && !this.processedRequests.subList(0, 1000).contains(unique)) {
                this.processedRequests.subList(0, 1000).clear();
            }
            return contains;
        }
    }

    class HTTPRemoteMethodCallExecutor {
        private FabricHTTPRequest url;
        private Object caller;
        private HTTPServerFabricConnection fabricConnection;

        HTTPRemoteMethodCallExecutor(FabricHTTPRequest url, HTTPServerFabricConnection fabricConnection) {
            this.url = url;
            this.fabricConnection = fabricConnection;
            this.caller = fabricConnection;
        }

        Object execute(HTTPFabricConnectionRemoteCall httpFabricConnectionRemoteCall) throws Throwable {
            RemoteMethodCall methodCall;
            if (this.caller == null) {
                return null;
            }
            while ((methodCall = httpFabricConnectionRemoteCall.getNextMethodCall()) != null) {
                this.caller = this.execute(methodCall);
            }
            this.caller = this.execute(httpFabricConnectionRemoteCall.getPostprocessorMethodCall());
            String name = httpFabricConnectionRemoteCall.getMethodCall(0).getMethodName();
            if (!name.equals("ping") && !name.equals("touch")) {
                this.fabricConnection.touch();
            }
            if (name.equals("touch")) {
                HTTPRequestTrigger.ignoreRequest(this.url.getRequest());
            }
            HTTPDataspaceAccessor.processAccessibleObjects(this.caller, null);
            return this.caller;
        }

        Object execute(RemoteMethodCall remoteMethodCall) throws Throwable {
            try {
                Method method;
                Class<?> callerClass;
                if (this.caller == null) {
                    throw new Exception("Failed to call remote method '" + remoteMethodCall.toString() + "' on null object.");
                }
                if (!(remoteMethodCall.getMethodName().equals("createUser") || remoteMethodCall.getMethodName().equals("getSysplexDomain") || remoteMethodCall.getMethodName().equals("getAcceptorName") || remoteMethodCall.getMethodName().equals("isApiKeyAuthenticationEnabled") || remoteMethodCall.getMethodName().equals("getRuntimeVersion") || remoteMethodCall.getMethodName().equals("listOrganizations") || this.url.getRequest().getParameter("anonymous") == null)) {
                    this.fabricConnection.authenticate();
                }
                if ((callerClass = this.caller.getClass()) == StaticMethodWrapper.class) {
                    callerClass = ((StaticMethodWrapper)this.caller).getStaticClass();
                }
                if ((method = ClassUtils.getDeclaredOrInheritedMethodCastNumerics(callerClass, remoteMethodCall.getMethodName(), remoteMethodCall.getArgumentClasses())) != null) {
                    remoteMethodCall.applyTypes(method.getParameterTypes());
                }
                if (method == null) {
                    throw new NoSuchMethodException("No such method '" + String.valueOf(remoteMethodCall) + "' in class '" + callerClass.getName() + "'");
                }
                if (method.getDeclaringClass().getSimpleName().equals("AbstractFabricConnection") && method.getName().equals("createSystemRequestConsumer")) {
                    method.setAccessible(true);
                }
                if (Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                Object[] arguments = remoteMethodCall.getArguments();
                for (int i = 0; i < arguments.length; ++i) {
                    arguments[i] = JsonExchangeServlet.resolveReferences(arguments[i], this.fabricConnection);
                }
                this.caller = method.invoke(this.caller, remoteMethodCall.getArguments());
                if (remoteMethodCall.getMethodName().equals("open")) {
                    AuthenticationHelper.touchSession(this.url.getRequest().getSession());
                }
                if (remoteMethodCall.getMethodName().equals("touch") && !this.fabricConnection.isOpened()) {
                    throw new Exception("Fabric connection is not opened.");
                }
            }
            catch (InvocationTargetException methodException) {
                if (remoteMethodCall.getMethodName().equals("open")) {
                    JsonExchangeServlet.this.getFabricConnectionsProviders().removeConnection(this.url.getRequest().getSession().getId(), false);
                }
                throw methodException.getTargetException();
            }
            return this.caller;
        }

        Object execute(RemoteMethodCallPostprocessor postprocessorMethodCall) throws Throwable {
            if (postprocessorMethodCall == null) {
                return this.caller;
            }
            switch (postprocessorMethodCall) {
                case IS_NULL: {
                    this.caller = this.caller == null;
                    break;
                }
                case GET_NAMES_FROM_LIST: {
                    if (this.caller instanceof List) {
                        ArrayList<String> reply = new ArrayList<String>();
                        for (Object object : (List)this.caller) {
                            if (!(object instanceof NamedObject)) {
                                throw new Exception("Postprocessor GET_NAMES_FROM_LIST failed: caller element is of type " + object.getClass().getName() + ", should be AbstractNamedObject.");
                            }
                            reply.add(((NamedObject)object).getName());
                        }
                        this.caller = reply;
                        break;
                    }
                    throw new Exception("Postprocessor GET_NAMES_FROM_LIST failed: caller is of type " + this.caller.getClass().getName() + ", should be List<?>.");
                }
                case GET_NAME_IF_NOT_NULL: {
                    if (this.caller == null) break;
                    RemoteMethodCall getName = new RemoteMethodCall("getName", new Object[0]);
                    this.caller = this.execute(getName);
                }
            }
            return this.caller;
        }
    }
}

