/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.streamscape.Trace;
import com.streamscape.lib.utils.Pair;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class FormatAndMimeTypes {
    private static final ConcurrentHashMap<String, String> formatToMimeType = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> mimeTypeToFormat = new ConcurrentHashMap();
    public static final FormatAndMimeType XML;
    public static final FormatAndMimeType JSON;
    public static final FormatAndMimeType STRING;
    public static final FormatAndMimeType HTML;
    public static final FormatAndMimeType BINARY;
    public static final FormatAndMimeType JSON_SWAGGER;
    public static final FormatAndMimeType XML_SWAGGER;

    public static FormatAndMimeType lookupByFormat(String format) {
        Pair<String, Map<String, String>> pair = FormatAndMimeTypes.split(format);
        if (pair == null) {
            return null;
        }
        String mime = formatToMimeType.get(((String)pair.first).toLowerCase());
        if (mime == null) {
            return null;
        }
        return new FormatAndMimeType((String)pair.first, mime, (Map)pair.second);
    }

    public static FormatAndMimeType lookupByMimeType(String mimeType) {
        Pair<String, Map<String, String>> pair = FormatAndMimeTypes.split(mimeType);
        if (pair == null) {
            return null;
        }
        String format = mimeTypeToFormat.get(pair.first);
        if (format == null) {
            return null;
        }
        return new FormatAndMimeType(format, (String)pair.first, (Map)pair.second);
    }

    public static FormatAndMimeType create(String format, String mime) {
        return new FormatAndMimeType(format, mime);
    }

    public static Pair<String, Map<String, String>> split(String format) {
        if (format == null) {
            return null;
        }
        Pair<String, Object> pair = new Pair<String, Object>(format, null);
        int pos = format.indexOf(59);
        if (pos > 0) {
            pair.first = format.substring(0, pos).trim();
            if (format.length() > pos) {
                pair.second = FormatAndMimeTypes.splitParameters(format.substring(pos + 1).trim());
            }
        }
        return pair;
    }

    public static Map<String, String> splitParameters(String parameters) {
        HashMap<String, String> result = null;
        for (int pos = 0; pos < parameters.length(); ++pos) {
            int pos1 = parameters.indexOf(59, pos);
            if (pos1 == -1) {
                pos1 = parameters.length();
            }
            int pos2 = parameters.indexOf(61, pos + 1);
            String value = null;
            if (pos2 != -1 && pos2 < pos1) {
                value = parameters.substring(pos2 + 1, pos1).trim();
            } else {
                pos2 = pos1;
            }
            String name = parameters.substring(pos, pos2).trim();
            if (result == null) {
                result = new HashMap<String, String>();
            }
            result.put(name, value);
            pos = pos1;
        }
        return result;
    }

    static {
        String mimeFile = FormatAndMimeTypes.class.getPackage().getName().replace(".", "/") + "/mime";
        try {
            ResourceBundle mime = ResourceBundle.getBundle(mimeFile);
            Enumeration<String> i = mime.getKeys();
            while (i.hasMoreElements()) {
                String ext = i.nextElement();
                String m = mime.getString(ext);
                formatToMimeType.put(ext.toLowerCase(), m.toLowerCase());
                mimeTypeToFormat.put(m.toLowerCase(), ext.toLowerCase());
            }
        }
        catch (MissingResourceException e) {
            Trace.logError(FormatAndMimeTypes.class, "Failed to load file properties file " + mimeFile);
        }
        formatToMimeType.putIfAbsent("json", "application/json");
        formatToMimeType.putIfAbsent("xml", "application/xml");
        formatToMimeType.putIfAbsent("string", "text/plain");
        formatToMimeType.putIfAbsent("html", "text/html");
        formatToMimeType.putIfAbsent("binary", "application/octet-stream");
        mimeTypeToFormat.put("application/json", "json");
        mimeTypeToFormat.put("application/xml", "xml");
        mimeTypeToFormat.put("text/plain", "string");
        mimeTypeToFormat.put("text/html", "html");
        mimeTypeToFormat.put("application/octet-stream", "binary");
        XML = FormatAndMimeTypes.lookupByFormat("xml");
        JSON = FormatAndMimeTypes.lookupByFormat("json");
        STRING = FormatAndMimeTypes.lookupByFormat("string");
        HTML = FormatAndMimeTypes.lookupByFormat("html");
        BINARY = FormatAndMimeTypes.lookupByFormat("binary");
        JSON_SWAGGER = FormatAndMimeTypes.lookupByMimeType("application/json;swagger=true");
        XML_SWAGGER = FormatAndMimeTypes.lookupByMimeType("application/xml;swagger=true");
    }

    public static class FormatAndMimeType {
        private String format;
        private String mimeType;
        private Map<String, String> parameters;

        private FormatAndMimeType(String format, String mimeType) {
            this(format, mimeType, null);
        }

        private FormatAndMimeType(String format, String mimeType, Map<String, String> parameters) {
            this.format = format;
            this.mimeType = mimeType;
            this.parameters = parameters;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean isFormat(String format) {
            return this.format != null && this.format.equalsIgnoreCase(format);
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getMimeTypeWithCharset() {
            if (this.mimeType != null && this.mimeType.indexOf(";charset=") == -1) {
                if (this.parameters != null && this.parameters.get("charset") != null) {
                    return this.mimeType + ";charset=" + this.parameters.get("charset");
                }
                if (this.mimeType.contains("xml") || this.mimeType.contains("json")) {
                    return this.mimeType + "; charset=UTF-8";
                }
            }
            return this.mimeType;
        }

        public String getFormatWithParameters() {
            if (this.format == null) {
                return null;
            }
            String parametersString = this.getParametersString();
            if (parametersString != null && parametersString.length() > 0) {
                return this.format + ";" + parametersString;
            }
            return this.format;
        }

        public String getMimeTypeWithParameters() {
            if (this.mimeType == null) {
                return null;
            }
            String parametersString = this.getParametersString();
            if (parametersString != null && parametersString.length() > 0) {
                return this.mimeType + ";" + parametersString;
            }
            return this.mimeType;
        }

        public String getParametersString() {
            return this.parameters != null ? this.parameters.entrySet().stream().map(e -> e.getValue() != null ? (String)e.getKey() + "=" + (String)e.getValue() : (String)e.getKey()).collect(Collectors.joining(",")) : "";
        }

        public Map<String, String> getParametersMap() {
            return this.parameters != null ? new HashMap<String, String>(this.parameters) : new HashMap();
        }

        public String getNotation() {
            return this.parameters != null ? this.parameters.get("notation") : null;
        }

        public boolean existsParameter(String name) {
            return this.parameters != null && this.parameters.containsKey(name);
        }

        public boolean isBinary() {
            return this.format != null && !this.format.equalsIgnoreCase("json") && !this.format.equalsIgnoreCase("xml") && !this.format.equalsIgnoreCase("html") && !this.format.equalsIgnoreCase("string");
        }

        public String toString() {
            return this.format + "(" + this.mimeType + ")" + (String)(this.parameters != null ? ";" + this.getParametersString() : "");
        }
    }
}

