/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.streamscape.Trace;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.xstream.converters.ErrorWriter;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.AbstractEventPrototypeOperation;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AbstractMutableEvent;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.event.RowArrayEvent;
import com.streamscape.sdo.event.RowEvent;
import com.streamscape.sdo.event.RowSetEvent;
import com.streamscape.sdo.event.TextEvent;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.ColumnDescriptor;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sys.Text;
import com.streamscape.sdo.sys.Void;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventCacheReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricEventSinkFactory;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.servlet.RestServletUtils;
import com.streamscape.sef.network.http.server.servlet.ServletError;
import com.streamscape.sef.network.http.server.servlet.ServletErrorInvalidUri;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.EventWrapper;
import com.streamscape.sef.network.http.server.swagger.eventwrapper.EventWrapperFactory;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;

public class ExchangeServletHelper
extends AbstractRuntimeFactory {
    public static final long DEFAULT_TIMEOUT = 30000L;

    public static Object getResultObject(ImmutableEventDatagram sourceEvent) throws Exception {
        if (sourceEvent instanceof DataEvent) {
            return ((DataEvent)sourceEvent).getData();
        }
        if (sourceEvent instanceof BytesEvent) {
            return ((BytesEvent)sourceEvent).getBytes();
        }
        if (sourceEvent instanceof RowSetEvent) {
            return ((RowSetEvent)sourceEvent).getRowSet();
        }
        if (sourceEvent instanceof RowArrayEvent) {
            return ((RowArrayEvent)sourceEvent).getRowArray();
        }
        if (sourceEvent instanceof RowEvent) {
            return ((RowEvent)sourceEvent).getRow();
        }
        if (sourceEvent instanceof TextEvent) {
            return ((TextEvent)sourceEvent).getText();
        }
        if (sourceEvent instanceof XMLEvent) {
            return ((XMLEvent)sourceEvent).getXML();
        }
        if (sourceEvent instanceof OpaqueEvent) {
            return ((OpaqueEvent)sourceEvent).getData();
        }
        throw new IllegalArgumentException("Unsupported event type. Unable to extract its payload.");
    }

    public static Object createDataObject(FabricHTTPRequest url, String semanticType) throws ServletError, IOException {
        return ExchangeServletHelper.createDataObject(url, ExchangeServletHelper.getData(url, "data"), semanticType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object createDataObject(FabricHTTPRequest url, String data, String semanticType) throws ServletError, IOException {
        if (data == null) {
            return null;
        }
        FormatAndMimeTypes.FormatAndMimeType requestFormat = RestServletUtils.getRequestFormatAndMimeType(url);
        try {
            Object dataObject = data;
            if ((data == null || data.length() == 0) && semanticType != null && semanticType.equals("Void")) {
                return new Void();
            }
            if (requestFormat.isFormat("json")) {
                try {
                    dataObject = JSONSerializer.isUnquotedString(data) && (semanticType == null || semanticType.equalsIgnoreCase("string")) ? data : HTTPUtils.getJsonSerializerForRest(requestFormat).deserialize(data);
                    if (dataObject == null) return dataObject;
                    if (dataObject instanceof Map) return HTTPUtils.getJsonSerializerForRest(requestFormat).deserialize(semanticType, data);
                    if (dataObject.getClass() != Object.class) return dataObject;
                    return HTTPUtils.getJsonSerializerForRest(requestFormat).deserialize(semanticType, data);
                }
                catch (Exception exception) {
                    if (semanticType == null) throw exception;
                    return HTTPUtils.getJsonSerializerForRestNoRoot(requestFormat).deserialize(semanticType, data);
                }
            }
            if (!requestFormat.isFormat("xml")) return dataObject;
            return HTTPUtils.getXmlSerializer().deserialize(data);
        }
        catch (Exception exception) {
            Object error = "Data deserialization failed.";
            String tmp = Utils.formatExceptionWithUnrepeatedCauses(exception);
            if (tmp == null || tmp.indexOf(data) == -1) {
                error = (String)error + " Data: '" + data + "'.";
            }
            error = (String)error + " Data format: '" + String.valueOf(requestFormat) + "'.";
            throw new ServletError(500, "OMF", (String)error, exception);
        }
    }

    public static long getTimeout(FabricHTTPRequest url) throws ServletErrorInvalidUri {
        long timeout = 30000L;
        String timeoutString = url.getParameter("timeout");
        if (timeoutString != null) {
            try {
                timeout = Long.parseLong(timeoutString);
            }
            catch (NumberFormatException error) {
                throw new ServletErrorInvalidUri("Invalid timeout value specified '" + timeoutString + "'.");
            }
        }
        return timeout;
    }

    public static ImmutableEventDatagram createEvent(FabricHTTPRequest url, String operation) throws ServletException, IAbstractExceptionEvent, IllegalAccessException, SDOException, ServletError {
        String eventId = ExchangeServletHelper.trimAndNullIfEmpty(url.getParameter("eventId"));
        String data = ExchangeServletHelper.trimAndNullIfEmpty(url.getParameter("data"));
        String eventString = ExchangeServletHelper.trimAndNullIfEmpty(url.getParameter("event"));
        if (eventString != null && data != null) {
            throw new ServletErrorInvalidUri("'data' and 'event' can not be specified simulteneously.");
        }
        FormatAndMimeTypes.FormatAndMimeType requestFormat = RestServletUtils.getRequestFormatAndMimeType(url);
        ImmutableEventDatagram event = null;
        if (eventString != null && eventString.length() > 0) {
            block24: {
                if (requestFormat == null || requestFormat.getFormat().length() == 0) {
                    throw new ServletErrorInvalidUri("Request format is not specified.");
                }
                try {
                    if (requestFormat.isFormat("json")) {
                        event = (ImmutableEventDatagram)HTTPUtils.getJsonSerializerForRest(requestFormat).deserialize(eventString);
                        break block24;
                    }
                    if (requestFormat.isFormat("xml")) {
                        event = (ImmutableEventDatagram)HTTPUtils.getXmlSerializer().deserialize(eventString);
                        break block24;
                    }
                    throw new ServletErrorInvalidUri("Unsupported request format '" + String.valueOf(requestFormat) + "' specified.");
                }
                catch (SerializerException exception) {
                    throw new ServletError("Failed to deserialize event, event: '" + eventString + "', eventId [" + eventId + "], request data format: '" + String.valueOf(requestFormat) + "'.", exception);
                }
            }
            HTTPFabricEventSinkFactory.reset(event);
        } else if (data != null) {
            if (eventId == null || eventId.length() == 0) {
                throw new ServletErrorInvalidUri("'eventId' is not specified.");
            }
            try {
                event = ExchangeServletHelper.wrapRequest(eventId, ExchangeServletHelper.createDataObject(url, data, null));
            }
            catch (Exception exception) {
                if (exception instanceof ServletException) {
                    throw (ServletException)exception;
                }
                if (exception instanceof ServletError) {
                    throw (ServletError)exception;
                }
                throw new ServletException("Event creation failed. Event data: '" + data + "'. EventId: [" + eventId + "]. Data format: '" + String.valueOf(requestFormat) + "'. Cause: " + Utils.formatExceptionWithUnrepeatedCauses(exception));
            }
        } else if (eventId != null) {
            event = EventDatagramFactory.getInstance().createEvent(eventId);
        }
        if (event instanceof AbstractMutableEvent) {
            AbstractMutableEvent mutableEvent = (AbstractMutableEvent)event;
            String durable = ExchangeServletHelper.trimAndNullIfEmpty(url.getParameter("durable"));
            String replyTo = ExchangeServletHelper.trimAndNullIfEmpty(url.getParameter("replyTo"));
            String correlationId = ExchangeServletHelper.trimAndNullIfEmpty(url.getParameter("correlationId"));
            String eventKey = ExchangeServletHelper.trimAndNullIfEmpty(url.getParameter("eventKey"));
            String eventGroupId = ExchangeServletHelper.trimAndNullIfEmpty(url.getParameter("eventGroupId"));
            String properties = ExchangeServletHelper.trimAndNullIfEmpty(url.getParameter("eventProperties"));
            if (durable != null) {
                mutableEvent.setDurable(Boolean.parseBoolean(durable));
            }
            if (operation != null && operation.equals("raiseRequest") && replyTo != null) {
                mutableEvent.setReplyTo(replyTo);
            }
            if (correlationId != null) {
                mutableEvent.setCorrelationId(correlationId);
            }
            if (eventKey != null) {
                mutableEvent.setEventKey(eventKey);
            }
            if (eventGroupId != null) {
                mutableEvent.setEventGroupId(eventGroupId);
            }
            if (properties != null) {
                StringTokenizer entries = new StringTokenizer(properties, ";");
                while (entries.hasMoreTokens()) {
                    String[] keyValue = FabricHTTPRequest.splitSafe(entries.nextToken(), "=", 2);
                    mutableEvent.setEventStringProperty(keyValue[0], keyValue[1]);
                }
            }
        }
        return event;
    }

    private static String trimAndNullIfEmpty(String s) {
        if (s != null) {
            s = s.trim();
        }
        if (s != null && s.length() == 0) {
            s = null;
        }
        return s;
    }

    private static ImmutableEventDatagram wrapRequest(String eventId, Object invocationResult) throws Exception {
        EventDatagram responseEvent = EventDatagramFactory.getInstance().createEvent(eventId);
        if (responseEvent instanceof DataEvent) {
            ((DataEvent)responseEvent).setData(invocationResult);
        }
        if (responseEvent instanceof BytesEvent && invocationResult instanceof byte[]) {
            ((BytesEvent)responseEvent).setBytes((byte[])invocationResult);
        } else if (responseEvent instanceof RowSetEvent && invocationResult instanceof RowSet) {
            RowMetaData resultMeta = ((RowSet)invocationResult).getRowMetaData();
            RowMetaData protoMeta = ((RowSetEvent)responseEvent).getRowSet().getRowMetaData();
            if (protoMeta != null && resultMeta != null) {
                ExchangeServletHelper.compareRowMetaData(resultMeta, protoMeta);
            }
            Field field = RowSetEvent.class.getDeclaredField("rowSet");
            field.setAccessible(true);
            field.set(responseEvent, invocationResult);
        } else if (responseEvent instanceof RowArrayEvent && invocationResult instanceof RowArray) {
            RowMetaData resultMeta = ((RowArray)invocationResult).getMetaData();
            RowMetaData protoMeta = ((RowArrayEvent)responseEvent).getRowArray().getMetaData();
            ExchangeServletHelper.compareRowMetaData(resultMeta, protoMeta);
            Field field = RowArrayEvent.class.getDeclaredField("rowArray");
            field.setAccessible(true);
            field.set(responseEvent, invocationResult);
        } else if (responseEvent instanceof RowEvent && invocationResult instanceof Row) {
            RowMetaData resultMeta = ((Row)invocationResult).getMetaData();
            RowMetaData protoMeta = ((RowEvent)responseEvent).getRow().getMetaData();
            ExchangeServletHelper.compareRowMetaData(resultMeta, protoMeta);
            Field field = RowEvent.class.getDeclaredField("row");
            field.setAccessible(true);
            field.set(responseEvent, invocationResult);
        } else if (responseEvent instanceof TextEvent && invocationResult instanceof String) {
            ((TextEvent)responseEvent).setText((String)invocationResult);
        } else if (responseEvent instanceof TextEvent && invocationResult instanceof Text) {
            ((TextEvent)responseEvent).setText(((Text)invocationResult).getText());
        } else if (responseEvent instanceof XMLEvent && invocationResult instanceof String) {
            ((XMLEvent)responseEvent).setXML((String)invocationResult);
        } else if (responseEvent instanceof OpaqueEvent) {
            ((OpaqueEvent)((Object)responseEvent)).setData(invocationResult);
        }
        return responseEvent;
    }

    private static void compareRowMetaData(RowMetaData source, RowMetaData target) throws Exception {
        if (source.getColumnCount() != target.getColumnCount()) {
            throw new IllegalArgumentException("Number of columns in returned row does not match number of columns in prototype.");
        }
        for (int i = 0; i < source.getColumnCount(); ++i) {
            ColumnDescriptor sourceColumn = source.getColumnDescriptor(i);
            ColumnDescriptor targetColumn = target.getColumnDescriptor(i);
            if (sourceColumn.getName().equals(targetColumn.getName()) && sourceColumn.getType() == targetColumn.getType()) continue;
            throw new IllegalArgumentException("Column meta data in returned row does not match the one in prototype.");
        }
    }

    public static ImmutableEventDatagram raiseRequest(HTTPServerFabricConnection fabricConnection, ImmutableEventDatagram event, String serviceName, FabricHTTPRequest url) throws IAbstractExceptionEvent, ServletException, ServletErrorInvalidUri {
        ExchangeServletHelper.addEventToCache(fabricConnection, event);
        String eventId = event.getEventId();
        if (!fabricConnection.isBoundEventId(eventId)) {
            fabricConnection.bindProducerFor(eventId);
        }
        RequestDistributionStrategy strategy = null;
        String loadBalance = url.getParameter("loadBalance");
        if (loadBalance != null && loadBalance.length() > 0) {
            try {
                strategy = RequestDistributionStrategy.valueOf(loadBalance.toUpperCase());
            }
            catch (Exception exception) {
                throw new ServletErrorInvalidUri("Invalid loadBalance value: " + loadBalance);
            }
        }
        long timeout = ExchangeServletHelper.getTimeout(url);
        if (serviceName == null) {
            return fabricConnection.raiseRequest((EventDatagram)event, EventScope.INHERITED, strategy == null ? RequestDistributionStrategy.AUCTION : strategy, ReplyMatchStrategy.REPLY_TO, timeout);
        }
        if (RuntimeContext.getInstance().getRunLevel() < 4) {
            throw new ServletException("Runtime context is not yet initialized.");
        }
        ServiceAccessor accessor = fabricConnection.getOrCreateServiceAccessor(serviceName, serviceName + "_AccessorForExchangeServlet");
        if (!accessor.isAvailable() && !accessor.resync()) {
            throw new ServletException("Service '" + serviceName + "' not available.");
        }
        if (strategy == null) {
            return accessor.invokeServiceRequest(event, timeout);
        }
        return accessor.invokeServiceRequest((EventDatagram)event, strategy, timeout);
    }

    protected static void addEventToCache(HTTPServerFabricConnection fabricConnection, ImmutableEventDatagram event) throws IAbstractExceptionEvent {
        String eventId = event.getEventId();
        if (event.getDurable()) {
            Moderator moderator = fabricConnection.getModerator();
            boolean isCacheAlreadyPresent = false;
            for (EventCacheReference cache : moderator.getEventCaches()) {
                if (!cache.getEventFilter().equals(eventId)) continue;
                isCacheAlreadyPresent = true;
                break;
            }
            if (!isCacheAlreadyPresent) {
                fabricConnection.addEventCache(eventId, 1, CacheThresholdAction.LRE_DISCARD);
            }
        }
    }

    public static String getData(FabricHTTPRequest url, String parameterName) throws IOException {
        boolean isGet = url.getRequest().getMethod().equalsIgnoreCase("get");
        if (isGet && url.getParameter(parameterName) != null) {
            return url.getParameter(parameterName);
        }
        if (!isGet) {
            return HTTPUtils.readPostRequestAsString(url.getRequest());
        }
        return null;
    }

    public static ImmutableEventDatagram createEventFromWrapper(FabricHTTPRequest url, String eventWrapperString) throws ServletError, DatagramFactoryException {
        ImmutableEventDatagram event;
        block19: {
            if (eventWrapperString == null || eventWrapperString.trim().length() == 0) {
                throw new ServletError(500, "OMF", "Event wrapper is empty.");
            }
            String eventId = ExchangeServletHelper.trimAndNullIfEmpty(url.getParameter("eventId"));
            event = (ImmutableEventDatagram)ExchangeServletHelper.createEventPrototype((String)eventId).second;
            EventWrapper eventWrapper = EventWrapperFactory.createEventWrapper(event);
            if (eventWrapper == null) {
                throw new ServletError(500, "OMF", "Event wrapper doesn't support '" + event.getClass().getSimpleName() + "' model for now.");
            }
            FormatAndMimeTypes.FormatAndMimeType requestFormat = RestServletUtils.getRequestFormatAndMimeType(url);
            if (requestFormat.isFormat("json")) {
                JSONSerializer serializer = HTTPUtils.getJsonSerializerForRestNoRoot(requestFormat);
                try (JsonParser parser = serializer.createParser(eventWrapperString);){
                    JsonToken token;
                    if (parser.nextToken() != JsonToken.START_OBJECT) {
                        throw new ServletError(500, "OMF", "JSON event wrapper should be in POST data.");
                    }
                    while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
                        if (token != JsonToken.FIELD_NAME) {
                            throw new ServletError(500, "OMF", "JSON event wrapper has incorrect format.");
                        }
                        PropertyDeserializer<Class> deserializer = (name, clazz) -> {
                            try {
                                return serializer.deserialize(clazz, parser);
                            }
                            catch (Exception exception) {
                                Trace.logException(ExchangeServletHelper.class, exception, false);
                                throw new ServletError(500, "OMF", "Implicit data marshaling from JSON failed for field '" + name + "' failed. ", exception);
                            }
                        };
                        String name2 = parser.getCurrentName();
                        parser.nextToken();
                        String semanticType = "object";
                        Class<?> fieldType = eventWrapper.getFieldType(event, name2);
                        if (fieldType == null) {
                            throw new ServletError(500, "OMF", "Failed to resolve field '" + name2 + "' for event [" + event.getEventId() + "].");
                        }
                        eventWrapper.setField(event, name2, deserializer.apply(name2, fieldType));
                    }
                    break block19;
                }
                catch (Exception exception) {
                    Trace.logException(ExchangeServletHelper.class, exception, false);
                    throw new ServletError(500, "OMF", "Failed to parse JSON event wrapper.", exception);
                }
            }
            if (requestFormat.isFormat("xml")) {
                try {
                    new XmlParserHelper(name -> {
                        Class<?> clazz = eventWrapper.getFieldType(event, name);
                        SemanticType semanticType = ExchangeServletHelper.getContext().getSemanticTypeCache().lookupSemanticClass(clazz);
                        if (semanticType != null) {
                            return semanticType.getTypeName();
                        }
                        return null;
                    }, (name, value) -> eventWrapper.setField(event, name, value), requestFormat).parse(eventWrapperString);
                }
                catch (Exception exception) {
                    Trace.logException(ExchangeServletHelper.class, exception, false);
                    throw new ServletError(500, "OMF", "Failed to parse event wrapper xml.", exception);
                }
            } else {
                throw new ServletError(500, "OMF", "JSON or XML tuple set are supported only.");
            }
        }
        return event;
    }

    public static Pair<Prototype, ImmutableEventDatagram> createEventPrototype(final String eventId) throws DatagramFactoryException {
        return new AbstractEventPrototypeOperation(){

            @Override
            public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
                return null;
            }

            @Override
            public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
                return null;
            }

            public Pair<Prototype, ImmutableEventDatagram> get() throws DatagramFactoryException {
                this.activate(AbstractRuntimeFactory.getContext());
                return this.getPrototype(eventId);
            }
        }.get();
    }

    public static interface PropertyDeserializer<T> {
        public Object apply(String var1, T var2) throws ServletError;
    }

    public static class XmlParserHelper {
        private final XmlParserHelperTypeResolver typeResolver;
        private final XmlParserHelperObserver observer;
        private FormatAndMimeTypes.FormatAndMimeType requestFormat;

        public XmlParserHelper(XmlParserHelperTypeResolver typeResolver, XmlParserHelperObserver observer, FormatAndMimeTypes.FormatAndMimeType requestFormat) {
            this.typeResolver = typeResolver;
            this.observer = observer;
            this.requestFormat = requestFormat;
        }

        public void parse(String xml) throws XmlParserHelperException {
            HierarchicalStreamReader r;
            XSerializer serializer = HTTPUtils.getXmlSerializer();
            try {
                r = HTTPUtils.getXmlSerializer().createReader(new StringReader(xml));
            }
            catch (Exception exception) {
                Trace.logException(XmlParserHelper.class, exception, false);
                throw new XmlParserHelperException("Failed to parse XML.", exception);
            }
            final HierarchicalStreamReader reader = r;
            int childsCount = 0;
            while (reader.hasMoreChildren()) {
                ++childsCount;
                reader.moveDown();
                String name = reader.getNodeName();
                Object value = reader.getValue();
                try {
                    if (name.equals("eventProperties") && this.requestFormat.existsParameter("swagger")) {
                        HashMap<String, String> properties = new HashMap<String, String>();
                        value = properties;
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            String propertyName = reader.getNodeName();
                            String propertyValue = reader.getValue();
                            if (reader.hasMoreChildren()) {
                                throw new Exception("Invalid value for event property '" + propertyName + "'.");
                            }
                            properties.put(propertyName, propertyValue);
                            reader.moveUp();
                        }
                    } else if (reader.hasMoreChildren()) {
                        final String type = this.typeResolver.resolveType(name);
                        final Integer[] level = new Integer[]{0};
                        value = serializer.unmarshal(new HierarchicalStreamReader(){

                            @Override
                            public boolean hasMoreChildren() {
                                Integer[] integerArray = level;
                                Integer n = integerArray[0];
                                integerArray[0] = integerArray[0] + 1;
                                return level[0] == 1 || reader.hasMoreChildren();
                            }

                            @Override
                            public void moveDown() {
                                reader.moveDown();
                            }

                            @Override
                            public void moveUp() {
                                reader.moveUp();
                            }

                            @Override
                            public String getNodeName() {
                                if (level[0] == 0) {
                                    return type;
                                }
                                return reader.getNodeName();
                            }

                            @Override
                            public String getValue() {
                                if (level[0] == 0) {
                                    return type;
                                }
                                return reader.getValue();
                            }

                            @Override
                            public String getAttribute(String name) {
                                if (level[0] == 0) {
                                    return null;
                                }
                                return reader.getAttribute(name);
                            }

                            @Override
                            public String getAttribute(int index) {
                                if (level[0] == 0) {
                                    return null;
                                }
                                return reader.getAttribute(index);
                            }

                            @Override
                            public int getAttributeCount() {
                                if (level[0] == 0) {
                                    return 0;
                                }
                                return reader.getAttributeCount();
                            }

                            @Override
                            public String getAttributeName(int index) {
                                if (level[0] == 0) {
                                    return null;
                                }
                                return reader.getAttributeName(index);
                            }

                            @Override
                            public Iterator getAttributeNames() {
                                if (level[0] == 0) {
                                    return new ArrayList().iterator();
                                }
                                return reader.getAttributeNames();
                            }

                            @Override
                            public void appendErrors(ErrorWriter errorWriter) {
                                reader.appendErrors(errorWriter);
                            }

                            @Override
                            public void close() {
                                reader.close();
                            }

                            @Override
                            public HierarchicalStreamReader underlyingReader() {
                                return reader.underlyingReader();
                            }
                        });
                    }
                    reader.moveUp();
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                    throw new XmlParserHelperException("Implicit data marshaling from XML failed for field '" + name + "' failed.", exception);
                }
                try {
                    this.observer.onParameter(name, value);
                }
                catch (Exception exception) {
                    throw new XmlParserHelperException("Failed to set property '" + name + "'.", exception);
                }
            }
            if (childsCount == 0) {
                throw new XmlParserHelperException("Invalid XML.");
            }
        }
    }

    public static interface XmlParserHelperTypeResolver {
        public String resolveType(String var1);
    }

    public static interface XmlParserHelperObserver {
        public void onParameter(String var1, Object var2) throws Exception;
    }

    public static class XmlParserHelperException
    extends Exception {
        public XmlParserHelperException(String message) {
            super(message);
        }

        public XmlParserHelperException(String message, Exception exception) {
            super(message, exception);
        }
    }
}

