/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.streamscape.Trace;
import com.streamscape.cli.http.HTTPClientException;
import com.streamscape.lib.utils.Base64;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.network.http.server.fabric.HTTPFabricEventSourceFactory;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.jetty.HTTPRequestTrigger;
import com.streamscape.sef.network.http.server.servlet.AbstractServlet;
import com.streamscape.sef.network.http.server.servlet.ExchangeServletHelper;
import com.streamscape.sef.network.http.server.servlet.RaiseEventResponse;
import com.streamscape.sef.network.http.server.servlet.RestErrorResponse;
import com.streamscape.sef.network.http.server.servlet.RestResponse;
import com.streamscape.sef.network.http.server.servlet.ServletError;
import com.streamscape.sef.network.http.server.servlet.ServletErrorInvalidUri;
import com.streamscape.sef.network.http.server.servlet.ServletErrorNotFound;
import com.streamscape.sef.network.http.server.uri.UriRegistry;
import com.streamscape.sef.network.http.server.uri.UriTree;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.MultipartFormDataHelper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;

public class ExchangeServlet
extends AbstractServlet {
    private UriRegistry<Object> registry;

    @Override
    public void init() throws ServletException {
        super.init();
        try {
            this.registry = new UriRegistry();
            this.registry.setPrefix("/exchange");
            this.registry.register("/{operationName}", new Object());
            this.registry.register("/{operationName}/{serviceName}", new Object());
        }
        catch (UriTree.UriException e) {
            throw new ServletException("Failed to initialize service uri registry. Cause: " + e.getMessage());
        }
    }

    @Override
    public String getServletInfo() {
        return "REST exchange servlet.";
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (req.getRequestURI().endsWith("filespace")) {
            this.processFileEncode(req, res);
        }
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processOperation(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processOperation(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block21: {
            FabricHTTPRequest url = new FabricHTTPRequest(request);
            try {
                Object o = this.registry.lookup(url);
                if (o == null) {
                    throw new ServletErrorNotFound("Invalid uri.");
                }
                String operation = this.getOperationName(url);
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logDebug(this, "Received: {} ? {}", operation, request.getQueryString());
                }
                if (operation.equals("inquire")) {
                    this.processInquireOperation(response);
                    break block21;
                }
                if (operation.equals("echo")) {
                    this.processEchoOperation(response);
                    break block21;
                }
                if (operation.equals("receiveEvent") || operation.equals("receiveEventNoWait")) {
                    this.processReceiveOperation(response, url);
                    break block21;
                }
                if (operation.equals("raiseEvent") || operation.equals("raiseRequest")) {
                    this.processRaiseOperation(response, url);
                    break block21;
                }
                throw new ServletErrorInvalidUri("Invalid operation: " + operation);
            }
            catch (UriTree.UriException exception) {
                RestErrorResponse.build(new ServletErrorInvalidUri("Failed to parse uri '" + url.getUri() + "'.", exception)).reply(url, response);
            }
            catch (ServletErrorInvalidUri exception) {
                RestErrorResponse.build(exception).reply(url, response);
            }
            catch (ServletErrorNotFound exception) {
                RestErrorResponse.build(exception).reply(url, response);
            }
            catch (ServletError exception) {
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logException(this, exception, true);
                }
                RestErrorResponse.build(exception).reply(url, response);
            }
            catch (Exception exception) {
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logException(this, exception, true);
                }
                RestErrorResponse.build("EXCH", exception).reply(url, response);
            }
            finally {
                response.getOutputStream().close();
            }
        }
    }

    protected void processInquireOperation(HttpServletResponse response) throws IOException {
        List<String> redirectList = this.getRedirectList();
        boolean shouldRedirect = Math.random() < 0.5;
        ServletOutputStream answer = response.getOutputStream();
        if (shouldRedirect) {
            int index = (int)(Math.random() * (double)redirectList.size());
            String redirect = redirectList.get(index);
            response.sendRedirect("http://" + redirect + "/");
        } else {
            answer.println("<html>Redirect list\n<ul>");
            for (String redirect : redirectList) {
                answer.println("<li>" + redirect + "</li>");
            }
            answer.println("</ul></html>");
        }
    }

    protected void processEchoOperation(HttpServletResponse response) throws IOException {
        response.getOutputStream().print("It is successful response on echo request!");
    }

    protected void processReceiveOperation(HttpServletResponse response, FabricHTTPRequest url) throws Exception {
        String operation;
        String eventId = url.getParameter("eventId");
        if (eventId == null) {
            throw new ServletErrorInvalidUri("Event id is not specified");
        }
        String receiverName = "HttpReceiver" + this.getSessionId(url.getRequest()) + eventId.replaceAll("\\*", "_");
        HTTPServerFabricConnection connection = ExchangeServlet.getFabricConnectionOrThrowException(url.getRequest());
        EventReceiver receiver = connection.getEventReceiver(receiverName);
        if (receiver == null) {
            receiver = connection.createEventReceiver(receiverName, eventId, null, EventScope.INHERITED, false);
        }
        ImmutableEventDatagram event = null;
        String selector = url.getParameter("eventSelector");
        if (selector != null && selector.length() == 0) {
            selector = null;
        }
        if ((operation = this.getOperationName(url)).equals("receiveEvent")) {
            long timeout = ExchangeServletHelper.getTimeout(url);
            event = timeout > 0L ? (selector == null ? receiver.receive(timeout) : receiver.receive(selector, timeout)) : (selector == null ? receiver.receive() : receiver.receive(selector));
        } else if (operation.equals("receiveEventNoWait")) {
            event = selector == null ? receiver.receiveNoWait() : receiver.receiveNoWait(selector);
        } else {
            throw new ServletErrorInvalidUri("Unknown operation specified '" + operation + "'.");
        }
        RestResponse.build(event).reply(url, response);
    }

    protected void processRaiseOperation(HttpServletResponse response, FabricHTTPRequest url) throws Exception {
        HTTPServerFabricConnection fabricConnection = ExchangeServlet.getFabricConnectionOrThrowException(url.getRequest());
        String operation = this.getOperationName(url);
        ImmutableEventDatagram event = ExchangeServletHelper.createEvent(url, operation);
        if (event == null) {
            throw new ServletErrorInvalidUri("Event is not specified.");
        }
        if (operation.equals("raiseEvent")) {
            this.performRaiseEvent(fabricConnection, event);
            RestResponse.build(new RaiseEventResponse("OK", event.getTimestamp().getTime())).reply(url, response);
        } else if (operation.equals("raiseRequest") || operation.equals("invoke")) {
            SLResponse resp;
            String service = url.getUriParameter("serviceName");
            if (service == null || service.length() == 0) {
                service = url.getParameter("service");
            }
            HTTPRequestTrigger.setOperationType(url.getRequest(), HTTPRequestTrigger.OperationType.EXCHANGE);
            HTTPRequestTrigger.setComponentName(url.getRequest(), service);
            this.getHTTPRequestTrigger().postBefore(url.getRequest());
            ImmutableEventDatagram reply = ExchangeServletHelper.raiseRequest(fabricConnection, event, service, url);
            if (reply instanceof SLResponse && !(resp = (SLResponse)((Object)reply)).isOK()) {
                HTTPClientException httpException = new HTTPClientException(1016, resp.getException());
                HTTPFabricEventSourceFactory.coalesce((ImmutableEventDatagram)httpException, fabricConnection.getFabricAddress());
                reply = httpException;
            }
            RestResponse.build(reply).reply(url, response);
        } else {
            throw new ServletErrorInvalidUri("Undefined request operation: " + operation);
        }
    }

    protected void performRaiseEvent(HTTPServerFabricConnection fabricConnection, ImmutableEventDatagram event) throws IAbstractExceptionEvent, ServletException {
        ExchangeServletHelper.addEventToCache(fabricConnection, event);
        String eventId = event.getEventId();
        if (!fabricConnection.isBoundEventId(eventId)) {
            fabricConnection.bindProducerFor(eventId);
        }
        fabricConnection.raiseEvent(event, EventScope.INHERITED, -1L);
    }

    protected void processFileEncode(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List<FileItem> items = MultipartFormDataHelper.getOrParseMultiParts(request, this.getAcceptorConfiguration(), 1);
        for (FileItem item : items) {
            if (item.isFormField()) continue;
            String base64 = Base64.encodeBytes(item.get());
            response.setContentType("text/plain; charset=UTF-8");
            response.getOutputStream().print(base64);
            response.getOutputStream().close();
            Trace.logDebug(this, "Replied with base64-encoding of " + item.getSize() + " bytes");
            break;
        }
    }

    private String getOperationName(FabricHTTPRequest url) throws ServletErrorInvalidUri {
        return url.getUriParameterOrThrowException("operationName");
    }

    protected List<String> getRedirectList() {
        LinkedList<String> redirectList = new LinkedList<String>();
        redirectList.add("127.0.0.1:80");
        redirectList.add("localhost:80");
        redirectList.add("127.0.0.1");
        redirectList.add("localhost");
        return redirectList;
    }
}

