/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.authentication.RealmManager;
import com.streamscape.sef.network.http.server.config.RealmInfo;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.jetty.HTTPRequestTrigger;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProvider;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProviders;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpURI;

public abstract class AbstractServlet
extends HttpServlet {
    protected String getSessionId(HttpServletRequest request) {
        return request.getSession().getId();
    }

    protected HTTPAcceptorConfiguration getAcceptorConfiguration() {
        return (HTTPAcceptorConfiguration)this.getServletContext().getAttribute(HTTPAcceptorConfiguration.ATTRIBUTE);
    }

    protected HTTPRequestTrigger getHTTPRequestTrigger() {
        return (HTTPRequestTrigger)this.getServletContext().getAttribute(HTTPRequestTrigger.ATTRIBUTE);
    }

    protected FabricConnectionsProviders getFabricConnectionsProviders() {
        return (FabricConnectionsProviders)this.getServletContext().getAttribute(FabricConnectionsProviders.ATTRIBUTE);
    }

    public static HTTPServerFabricConnection getFabricConnection(HttpServletRequest request) {
        return FabricConnectionsProvider.getConnectionFromRequest(request);
    }

    public static HTTPAcceptorConfiguration getAcceptorConfiguration(HttpServletRequest request) {
        return (HTTPAcceptorConfiguration)request.getServletContext().getAttribute(HTTPAcceptorConfiguration.ATTRIBUTE);
    }

    public static HTTPServerFabricConnection getFabricConnectionOrThrowException(HttpServletRequest request) throws ServletException {
        HTTPServerFabricConnection connection = AbstractServlet.getFabricConnection(request);
        if (connection == null || connection.isRemoved()) {
            String requestUri = request.getRequestURI();
            HttpURI uri = (HttpURI)request.getAttribute("API_CUSTOMIZER_ORIGINAL_URI");
            if (uri != null) {
                requestUri = uri.getPath();
            }
            Trace.logError(AbstractServlet.class, "Fabric connection {} in session {}, uri: {}, query: {}", connection == null ? "doesn't exist" : "removed", request.getSession().getId(), requestUri, request.getQueryString());
            RealmInfo realm = RealmManager.getRealmInfo(AbstractServlet.getAcceptorConfiguration(request).getRealms(), requestUri);
            if (realm == null) {
                Trace.logError(AbstractServlet.class, "Request not authorized. Realm doesn't exist for URI '" + requestUri + "'");
                throw new ServletException("Request not authorized. Realm doesn't exist for URI '" + requestUri + "'");
            }
            throw new ServletException("Request not authorized. Not logged in session " + request.getSession().getId());
        }
        return connection;
    }
}

