/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.servlet;

import com.streamscape.Trace;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sys.Null;
import com.streamscape.sef.network.http.server.html.ObjectToRowSetConverter;
import com.streamscape.sef.network.http.server.html.RowSetHtmlFormatter;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.servlet.RestResponse;
import com.streamscape.sef.network.http.server.servlet.RestServletUtils;
import com.streamscape.sef.network.http.server.servlet.SorServletCss;
import com.streamscape.sef.network.http.server.servlet.dataspace.DSRowSetResponse;
import com.streamscape.sef.network.http.server.utils.FabricHTTPRequest;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractRestResponse {
    protected int responseStatus = 200;
    protected boolean isException = false;

    protected AbstractRestResponse() {
    }

    protected AbstractRestResponse(int responseStatus) {
        this();
        this.responseStatus = responseStatus;
    }

    public AbstractRestResponse setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
        return this;
    }

    public void reply(FabricHTTPRequest url, HttpServletResponse response) throws IOException {
        this.reply(url, response, null);
    }

    public void reply(FabricHTTPRequest url, HttpServletResponse response, FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) throws IOException {
        try {
            this.customizeResponseStatus(url);
            response.setStatus(this.responseStatus);
            if (formatAndMimeType == null) {
                formatAndMimeType = this.isException ? RestServletUtils.getExceptionResponseFormatAndMimeType(url) : RestServletUtils.getResponseFormatAndMimeType(url);
            }
            response.setContentType(formatAndMimeType.getMimeTypeWithCharset());
            if (formatAndMimeType.isFormat("json")) {
                this.replyJson(url, response, formatAndMimeType);
            } else if (formatAndMimeType.isFormat("xml")) {
                this.replyXML(url, response);
            } else if (formatAndMimeType.isFormat("html")) {
                this.replyHtml(url, response);
            } else if (formatAndMimeType.isFormat("string")) {
                this.replyString(url, response);
            } else {
                this.replyBinary(url, response);
            }
        }
        catch (IOException exception) {
            Trace.logError(this, "Sending http response failed. Cause: " + exception.getMessage());
            Trace.logException(this, exception, true);
            throw exception;
        }
    }

    protected abstract Object getResponseObject();

    protected abstract void customizeResponseStatus(FabricHTTPRequest var1);

    protected void replyJson(FabricHTTPRequest url, HttpServletResponse response, FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) throws IOException {
        this.replySerialized(url, response, this.getJsonSerializer(url, formatAndMimeType), this.getResponseObject());
    }

    protected void replyXML(FabricHTTPRequest url, HttpServletResponse response) throws IOException {
        this.replySerialized(url, response, this.getXmlSerializer(), this.getResponseObject());
    }

    protected void replyString(FabricHTTPRequest url, HttpServletResponse response) throws IOException {
        Object object = this.getResponseObject();
        if (object != null) {
            response.getOutputStream().print(object.toString());
        } else {
            response.getOutputStream().print("null");
        }
    }

    protected void replyHtml(FabricHTTPRequest url, HttpServletResponse response) throws IOException {
        AbstractRestResponse.objectToHtml(this.getResponseObject(), true, null, AbstractRestResponse.isNoheader(url), new PrintStream(response.getOutputStream()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void replyBinary(FabricHTTPRequest url, HttpServletResponse response) throws IOException {
        Object object = null;
        if (!(this instanceof RestResponse)) {
            if (!(this instanceof DSRowSetResponse)) throw new IOException("Binary response format is not allowed for this type of response.");
            RowSet rowSet = ((DSRowSetResponse)this).getRowSet();
            if (rowSet.getMeta().getColumnCount() != 1 || rowSet.getRowCount() != 1) throw new IOException("Binary response format is not allowed for RowSet response with more than one column or more than one row.");
            try {
                rowSet.next();
                object = rowSet.getBytes(1);
            }
            catch (SQLException exception) {
                throw new IOException(exception);
            }
        } else {
            object = this.getResponseObject();
        }
        if (object instanceof byte[]) {
            response.getOutputStream().write((byte[])object);
            return;
        }
        if (object instanceof ByteBuffer) {
            response.getOutputStream().write(((ByteBuffer)object).array());
            return;
        }
        if (object instanceof Blob) {
            try (InputStream inputStream = ((Blob)object).getBinaryStream();){
                byte[] buffer = new byte[AbstractRestResponse.getTransferBufferSize(url)];
                int len = -1;
                while ((len = inputStream.read(buffer, 0, buffer.length)) > 0) {
                    response.getOutputStream().write(buffer, 0, len);
                }
                return;
            }
            catch (SQLException exception) {
                throw new IOException(exception);
            }
        }
        if (object instanceof Clob) {
            try (Reader reader = ((Clob)object).getCharacterStream();){
                char[] buffer = new char[AbstractRestResponse.getTransferBufferSize(url)];
                int len = -1;
                while ((len = reader.read(buffer, 0, buffer.length)) > 0) {
                    response.getWriter().write(buffer, 0, len);
                }
                return;
            }
            catch (SQLException exception) {
                throw new IOException(exception);
            }
        }
        if (object == null) return;
        response.getOutputStream().print(object.toString());
    }

    public static boolean isTransferBufferSizeSet(FabricHTTPRequest url) {
        return url.getParameter("transferBufferSize") != null && url.getParameter("transferBufferSize").trim().length() > 0;
    }

    public static int getTransferBufferSize(FabricHTTPRequest url) {
        int transferBufferSize = 10383360;
        String transferBufferSizeString = url.getParameter("transferBufferSize");
        if (transferBufferSizeString != null && transferBufferSizeString.length() > 0) {
            transferBufferSize = Integer.valueOf(transferBufferSizeString);
        }
        if ((transferBufferSize = Math.min(transferBufferSize, 0x6306000)) <= 0) {
            transferBufferSize = 10383360;
        }
        return transferBufferSize;
    }

    protected XSerializer getXmlSerializer() {
        return HTTPUtils.getOrCreateXmlSerializer("XSerializer$AbstractRestResponse");
    }

    protected JSONSerializer getJsonSerializer(FabricHTTPRequest url, FormatAndMimeTypes.FormatAndMimeType formatAndMimeType) {
        Object suppressJsonType = url.getRequest().getAttribute("API_CUSTOMIZER_SUPPRESS_JSON_TYPE");
        if (suppressJsonType != null && suppressJsonType instanceof Boolean && ((Boolean)suppressJsonType).booleanValue()) {
            return HTTPUtils.getJsonSerializerForRestNoRoot(formatAndMimeType);
        }
        if (!formatAndMimeType.existsParameter("swagger") && RestServletUtils.isSwaggerRequest(url)) {
            return HTTPUtils.getJsonSerializerForRest(FormatAndMimeTypes.lookupByMimeType(formatAndMimeType.getMimeType() + ";swagger=true"));
        }
        return HTTPUtils.getJsonSerializerForRest(formatAndMimeType);
    }

    protected void replySerialized(FabricHTTPRequest url, HttpServletResponse response, TextSerializer serializer, Object object) throws IOException {
        if (object == null) {
            object = new Null();
        }
        Object reply = null;
        try {
            reply = serializer.serialize(object);
        }
        catch (Exception exception) {
            reply = "Failed to serialize response '" + (object != null ? object.toString() : "null") + "'. Cause: " + exception.getMessage();
            Trace.logException(this, exception, false);
            Trace.logError(this, (String)reply);
        }
        response.getOutputStream().print((String)reply);
    }

    public static boolean isNorowset(FabricHTTPRequest url) {
        return url.getParameter("norowset") != null && url.getParameter("norowset").equalsIgnoreCase("true");
    }

    public static boolean isNorows(FabricHTTPRequest url) {
        return url.getParameter("norows") == null || url.getParameter("norows").equalsIgnoreCase("true");
    }

    public static boolean isNoheader(FabricHTTPRequest url) {
        return url.getParameter("noheader") != null && url.getParameter("noheader").equalsIgnoreCase("true");
    }

    public static <T extends Appendable> T objectToHtml(Object object, boolean cssAsLink, String css, boolean noheader, T builder) throws IOException {
        ConsumerWithException writer = null;
        if (object instanceof RowSet) {
            RowSet rowSet = (RowSet)object;
            writer = () -> {
                RowSetHtmlFormatter formatter = new RowSetHtmlFormatter(SorServletCss.TABLE_DS_ROW_SET_RESPONSE_STYLE, SorServletCss.TABLE_DS_ROW_SET_RESPONSE_STYLE_ALT);
                formatter.formatHorizontal(rowSet, !noheader, builder);
            };
        } else {
            ObjectToRowSetConverter objectToRowSetConverter = new ObjectToRowSetConverter().setVertical(true);
            object = objectToRowSetConverter.convertObjectToRowSet(object);
            if (object instanceof RowSet) {
                RowSet rowSet = (RowSet)object;
                writer = () -> {
                    RowSetHtmlFormatter formatter = new RowSetHtmlFormatter(SorServletCss.TABLE_DS_ROW_SET_RESPONSE_STYLE);
                    formatter.setObjectToRowSetConverter(objectToRowSetConverter);
                    formatter.formatRowSetToExpandableTable(rowSet, builder);
                };
            }
        }
        if (writer != null) {
            builder.append("<html>\n");
            if (css != null) {
                builder.append(css);
            } else {
                builder.append(SorServletCss.getInstance().getSorRowSetCss(cssAsLink));
            }
            writer.execute();
            builder.append("</html>\n");
        } else {
            builder.append(HTTPUtils.htmlEncode(String.valueOf(object), true));
        }
        return builder;
    }

    public static interface ConsumerWithException {
        public void execute() throws IOException;
    }
}

