/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.sysint;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.dispatcher.EventTriggerActionHelper;
import com.streamscape.sef.network.http.server.jetty.sysint.SysInitScriptExecutor;
import com.streamscape.sef.network.http.server.jetty.sysint.SysInitScriptExecutorException;
import com.streamscape.sef.network.http.server.jetty.sysint.SysInitScriptReader;
import com.streamscape.sef.network.http.server.jetty.sysint.SysInitScriptsExecutorException;
import com.streamscape.slex.slang.SLSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;

public class SysInitScriptsExecutor
extends EventTriggerActionHelper {
    private String applicationName;
    private FabricConnection connection;
    private ResourcesProvider resourcesProvider;
    private boolean interruptScriptOnFail = true;
    private boolean interruptExecutorOnFail = true;

    public SysInitScriptsExecutor(String path, String applicationName) {
        this.resourcesProvider = new ResourcesProviderByAbsolutePath(path);
        this.applicationName = applicationName;
    }

    public SysInitScriptsExecutor(ServletContext context, String path) {
        this(context, path, null);
    }

    SysInitScriptsExecutor(ServletContext context, String path, FabricConnection connection) {
        this.resourcesProvider = new ResourcesProviderFromContext(context, path);
        this.applicationName = context.getContextPath();
        this.connection = connection;
    }

    public void setInterruptScriptOnFail(boolean interruptScriptOnFail) {
        this.interruptScriptOnFail = interruptScriptOnFail;
    }

    public void setInterruptExecutorOnFail(boolean interruptExecutorOnFail) {
        this.interruptExecutorOnFail = interruptExecutorOnFail;
    }

    public List<SysInitScriptsExecutorException> execute() throws SysInitScriptsExecutorException {
        ArrayList<SysInitScriptsExecutorException> result = new ArrayList<SysInitScriptsExecutorException>();
        for (String resource : this.resourcesProvider.listResources()) {
            Trace.logInfo(this, "Web application '{}' executing script from resource {}", this.applicationName, resource);
            try {
                String script = this.resourcesProvider.getResourceContent(resource);
                List<SysInitScriptExecutorException> result1 = this.execute(script);
                result.addAll(result1.stream().map(e -> new SysInitScriptsExecutorException(resource, (Throwable)e)).collect(Collectors.toList()));
                if (!this.interruptExecutorOnFail || result1.size() <= 0) continue;
                break;
            }
            catch (Exception exception2) {
                SysInitScriptsExecutorException exception2 = new SysInitScriptsExecutorException(resource, exception2);
                if (this.interruptExecutorOnFail) {
                    throw exception2;
                }
                result.add(exception2);
            }
        }
        return result;
    }

    private void initConnection() {
        if (this.connection == null) {
            super.init(AbstractRuntimeFactory.getContext());
            this.connection = super.getConnection();
        }
    }

    private List<SysInitScriptExecutorException> execute(String script) throws SysInitScriptExecutorException {
        this.initConnection();
        try (SLSession slSession = null;){
            slSession = this.connection.createSLSession();
            SysInitScriptExecutor executor = new SysInitScriptExecutor(slSession);
            executor.setInterruptOnFail(this.interruptScriptOnFail);
            List<SysInitScriptExecutorException> list = executor.execute(new SysInitScriptReader(script));
            return list;
        }
    }

    public static class ResourcesProviderByAbsolutePath
    implements ResourcesProvider {
        private final String absolutePath;

        ResourcesProviderByAbsolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        @Override
        public Collection<String> listResources() {
            if (!new File(this.absolutePath).exists() || !new File(this.absolutePath).isDirectory()) {
                return new ArrayList<String>();
            }
            String[] files = new File(this.absolutePath).list();
            if (files == null) {
                files = new String[]{};
            }
            return Arrays.asList(files).stream().sorted().collect(Collectors.toList());
        }

        @Override
        public String getResourceContent(String resourceName) throws SysInitScriptsExecutorException {
            try {
                return new String(FileIOUtils.getFile(this.absolutePath, resourceName));
            }
            catch (UtilitiesException exception) {
                throw new SysInitScriptsExecutorException(resourceName, exception);
            }
        }
    }

    public static interface ResourcesProvider {
        public Collection<String> listResources();

        public String getResourceContent(String var1) throws SysInitScriptsExecutorException;
    }

    public static class ResourcesProviderFromContext
    implements ResourcesProvider {
        private final ServletContext context;
        private final String path;

        ResourcesProviderFromContext(ServletContext context, String path) {
            this.context = context;
            this.path = path;
        }

        @Override
        public Collection<String> listResources() {
            return this.context.getResourcePaths(this.path).stream().sorted().collect(Collectors.toList());
        }

        @Override
        public String getResourceContent(String resourcePath) throws SysInitScriptsExecutorException {
            String content = null;
            try (InputStream inputStream = this.context.getResourceAsStream(resourcePath);){
                content = new String(FileIOUtils.getStreamContent(inputStream, -1L));
            }
            catch (UtilitiesException exception) {
                throw new SysInitScriptsExecutorException(resourcePath, exception);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return content;
        }
    }
}

