/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.sysint;

import com.streamscape.tools.lexer.BufferUtils;

public class SysInitScriptReader {
    private String script;
    private int position = 0;
    private int lastStatementPosition;
    private String delimiter;
    private String statement = "";

    public SysInitScriptReader(String script) {
        this.script = script;
    }

    public boolean hasNext() {
        this.statement = null;
        this.position = BufferUtils.skipSpacesAndCommends(this.script, this.position);
        if (this.position >= this.script.length()) {
            return false;
        }
        this.lastStatementPosition = this.position;
        String line = this.readLine();
        if (this.isSetDelimiter(line)) {
            this.lastStatementPosition = this.position;
            this.position = BufferUtils.skipSpacesAndCommends(this.script, this.position);
            if (this.position >= this.script.length()) {
                return false;
            }
            line = this.readLine();
        }
        if (this.delimiter == null || this.delimiter.length() == 0) {
            this.statement = line;
            return true;
        }
        if (line == null) {
            return false;
        }
        StringBuilder statementBuilder = new StringBuilder();
        do {
            if (statementBuilder.length() > 0) {
                statementBuilder.append("\n");
            }
            if (line.endsWith(this.delimiter)) {
                statementBuilder.append(line.substring(0, line.length() - this.delimiter.length()));
                break;
            }
            statementBuilder.append(line);
        } while ((line = this.readLine()) != null);
        this.statement = statementBuilder.toString();
        return true;
    }

    public String next() {
        try {
            String string = this.statement;
            return string;
        }
        finally {
            this.statement = null;
        }
    }

    private boolean isSetDelimiter(String line) {
        String setDelimiter = "set delimiter";
        if (line.toLowerCase().startsWith("set delimiter")) {
            this.delimiter = line.substring("set delimiter".length());
            if (this.delimiter.length() == 0 || Character.isWhitespace(this.delimiter.charAt(0))) {
                this.delimiter = this.delimiter.trim();
                return true;
            }
        }
        return false;
    }

    private String readLine() {
        if (this.position >= this.script.length()) {
            return null;
        }
        int crPosition = -1;
        int newLinePosition = -1;
        int startPosition = this.position;
        while (this.position < this.script.length()) {
            char c = this.script.charAt(this.position);
            if (c == '\r') {
                if (crPosition == -1) {
                    crPosition = this.position;
                }
            } else {
                if (c == '\n') {
                    newLinePosition = crPosition == -1 ? this.position : crPosition;
                    ++this.position;
                    break;
                }
                crPosition = -1;
            }
            ++this.position;
        }
        String line = null;
        line = newLinePosition == -1 ? this.script.substring(startPosition) : this.script.substring(startPosition, newLinePosition);
        return line;
    }

    public int getLastStatementPosition() {
        return this.lastStatementPosition;
    }

    public int getLastStatementLineNumber() {
        return BufferUtils.getLineNumber(this.script, this.lastStatementPosition);
    }

    public int getLastStatementPositionInLine() {
        return BufferUtils.getPositionInLine(this.script, this.lastStatementPosition);
    }
}

