/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.sysint;

import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.network.http.server.jetty.sysint.SysInitScriptExecutorException;
import com.streamscape.sef.network.http.server.jetty.sysint.SysInitScriptReader;
import com.streamscape.slex.slang.SLSession;
import java.util.ArrayList;
import java.util.List;

public class SysInitScriptExecutor {
    private SLSession slSession;
    private boolean interruptOnFail = true;

    public SysInitScriptExecutor(SLSession accessor) {
        this.slSession = accessor;
    }

    public void setInterruptOnFail(boolean interruptOnFail) {
        this.interruptOnFail = interruptOnFail;
    }

    public List<SysInitScriptExecutorException> execute(SysInitScriptReader reader) throws SysInitScriptExecutorException {
        ArrayList<SysInitScriptExecutorException> result = new ArrayList<SysInitScriptExecutorException>();
        while (reader.hasNext()) {
            String statement = reader.next();
            try {
                SLResponse response = this.slSession.slangRequest(statement, 30000L);
                if (response.isOK()) continue;
                if (response.getException() != null) {
                    throw response.getException();
                }
                throw new SysInitScriptExecutorException(response.getText(), null);
            }
            catch (Throwable exception) {
                Throwable cause = exception.getCause();
                SysInitScriptExecutorException scriptException = new SysInitScriptExecutorException(cause != null ? cause.getMessage() : exception.getMessage(), cause != null ? cause : exception);
                scriptException.setLine(statement);
                scriptException.setLineNumber(reader.getLastStatementLineNumber());
                scriptException.setPositionInLine(reader.getLastStatementPositionInLine());
                if (this.interruptOnFail) {
                    throw scriptException;
                }
                result.add(scriptException);
            }
        }
        return result;
    }
}

