/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.log;

import com.streamscape.Trace;
import com.streamscape.sef.trace.AbstractTrace;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Logger;

public class JettyTraceLogger
extends AbstractLogger {
    private final String className;
    private final String logPrefix;

    public JettyTraceLogger() throws Exception {
        this(JettyTraceLogger.class.getName());
    }

    public JettyTraceLogger(String name) {
        this.className = name;
        this.logPrefix = "[" + name + "] ";
    }

    public String getName() {
        return this.className;
    }

    public void warn(String msg, Object ... args) {
        if (Trace.isErrorEnabled(((Object)((Object)this)).getClass())) {
            Trace.logError((Object)this, AbstractTrace.formatMessageArgs(this.logPrefix, msg, args));
        }
    }

    public void warn(Throwable thrown) {
        this.warn("", thrown);
    }

    public void warn(String msg, Throwable thrown) {
        if (Trace.isErrorEnabled(((Object)((Object)this)).getClass())) {
            Trace.logError((Object)this, msg);
            Trace.logException((Object)this, thrown, true);
        }
    }

    public void info(String msg, Object ... args) {
        if (Trace.isInfoEnabled(((Object)((Object)this)).getClass())) {
            Trace.logInfo((Object)this, AbstractTrace.formatMessageArgs(this.logPrefix, msg, args));
        }
    }

    public void info(Throwable thrown) {
        this.info("", thrown);
    }

    public void info(String msg, Throwable thrown) {
        if (Trace.isInfoEnabled(((Object)((Object)this)).getClass())) {
            Trace.logInfo((Object)this, msg);
            Trace.logException((Object)this, thrown, true);
        }
    }

    public void debug(String msg, Object ... args) {
        if (Trace.isDebugEnabled(((Object)((Object)this)).getClass()) && !msg.startsWith("Scavenging sessions")) {
            Trace.logDebug((Object)this, AbstractTrace.formatMessageArgs(this.logPrefix, msg, args));
        }
    }

    public void debug(Throwable thrown) {
        this.debug("", thrown);
    }

    public void debug(String msg, Throwable thrown) {
        if (Trace.isDebugEnabled(((Object)((Object)this)).getClass())) {
            Trace.logInfo((Object)this, msg);
            Trace.logException((Object)this, thrown, true);
        }
    }

    public boolean isDebugEnabled() {
        return Trace.isDebugEnabled(((Object)((Object)this)).getClass());
    }

    public void setDebugEnabled(boolean enabled) {
        Trace.enable(((Object)((Object)this)).getClass().getName(), Trace.Level.DEBUG);
    }

    protected Logger newLogger(String fullName) {
        return new JettyTraceLogger(fullName);
    }

    public void ignore(Throwable ignored) {
    }

    public String toString() {
        return this.getName();
    }
}

