/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.fabric;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProvider;
import java.util.ArrayList;
import java.util.List;

public class FabricConnectionsProviders {
    public static final String ATTRIBUTE = FabricConnectionsProviders.class.getName();
    private List<FabricConnectionsProvider> providers = new ArrayList<FabricConnectionsProvider>();

    public void register(FabricConnectionsProvider provider) {
        Trace.logDebug(this, "New provider '{}' registered.", provider.getClass().getName());
        this.providers.add(provider);
    }

    public void removeConnection(String sessionId, boolean expired) {
        Trace.logDebug(this, "Removing and closing all connection bound to sessionId {}", sessionId);
        this.providers.forEach(p -> p.removeAndCloseConnection(sessionId, expired));
    }

    public void closeAllConnections() {
        Trace.logDebug(this, "Removing and closing all connection");
        this.providers.forEach(FabricConnectionsProvider::removeAndCloseAllConnections);
    }

    public HTTPServerFabricConnection getConnection(String sessionId) {
        return this.providers.stream().map(p -> {
            HTTPServerFabricConnection connection = p.getConnection(sessionId);
            if (connection != null) {
                return connection;
            }
            return null;
        }).filter(c -> c != null).findFirst().orElse(null);
    }
}

