/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.fabric;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.ClientId;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.jetty.JettyAdvancedProperties;
import com.streamscape.sef.network.http.server.jetty.fabric.AbstractFabricConnectionsProvider;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.AbstractSession;

public class FabricConnectionsProviderForRest
extends AbstractFabricConnectionsProvider {
    private List<HTTPServerFabricConnection> allConnections = new ArrayList<HTTPServerFabricConnection>();
    private Map<String, HTTPServerFabricConnection> availableConnections = new HashMap<String, HTTPServerFabricConnection>();
    private Set<String> lockedSessions = new HashSet<String>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition conditionConnections = this.lock.newCondition();
    private final Condition conditionSessions = this.lock.newCondition();
    private volatile boolean running = true;
    private Boolean shareConnectionsBetweenSessions;
    private Boolean shareConnectionsBetweenUrls;
    private Integer connectionsPerUserLimit;
    private Integer connectionWaitTimeout;
    private Integer lockedSessionWaitTimeout;

    public FabricConnectionsProviderForRest(HTTPAcceptor acceptor) {
        super(acceptor);
        JettyAdvancedProperties.Properties properties = JettyAdvancedProperties.build(acceptor.getConfiguration());
        this.shareConnectionsBetweenSessions = properties.getBooleanProperty("jetstream.rest.share.connection.between.sessions");
        this.shareConnectionsBetweenUrls = properties.getBooleanProperty("jetstream.rest.share.connection.between.uris");
        this.connectionsPerUserLimit = properties.getIntProperty("jetstream.rest.connections.per.user.limit");
        this.connectionWaitTimeout = properties.getIntProperty("jetstream.rest.connection.wait.timeout");
        this.lockedSessionWaitTimeout = properties.getIntProperty("jetstream.rest.locked.session.wait.timeout");
        if (this.shareConnectionsBetweenUrls.booleanValue() && !this.shareConnectionsBetweenSessions.booleanValue()) {
            Trace.logInfo(this, "WARNING: HTTP server advanced property {} is true but {} is false. That means that share between URLs also disabled.", "jetstream.rest.share.connection.between.uris", "jetstream.rest.share.connection.between.sessions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTTPServerFabricConnection provideAndAcquireConnection(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        HTTPCredentials credentials = (HTTPCredentials)request.getAttribute(HTTPCredentials.ATTRIBUTE);
        if (credentials == null) {
            throw new ServletException("Request is not authorized.");
        }
        HttpSession session = null;
        HTTPServerFabricConnection connection = null;
        try {
            this.lock.lock();
            try {
                session = request.getSession(true);
                if (session == null) {
                    throw new ServletException("Request is not authorized or doesn't have valid session.");
                }
                long waitTime = this.lockedSessionWaitTimeout * 1000;
                long startTime = System.currentTimeMillis();
                while (this.lockedSessions.contains(session.getId())) {
                    if (waitTime >= 0L) {
                        try {
                            this.conditionSessions.await(waitTime > 0L ? waitTime : 30000L, TimeUnit.MILLISECONDS);
                            if (waitTime <= 0L) continue;
                            startTime = System.currentTimeMillis();
                            if ((waitTime -= System.currentTimeMillis() - startTime) > 0L) continue;
                            waitTime = -1L;
                            continue;
                        }
                        catch (InterruptedException exception) {
                            session = null;
                            throw new ServletException("Request has been interrupted.");
                        }
                    }
                    session = null;
                    throw new ServletException("Only one request per session is allowed.");
                }
                this.lockedSessions.add(session.getId());
                connection = this.acquireConnectionInternal(request, session, credentials);
            }
            finally {
                this.lock.unlock();
            }
            if (connection == null && this.running) {
                connection = this.createAndOpenRestConnectionInternal(request, session);
            }
            if (connection != null) {
                FabricConnectionsProvider.setConnectionToRequest(request, connection);
                FabricConnectionsProvider.setProviderToRequest(request, this);
                this.initAndTouchConnection(connection, request);
            }
        }
        finally {
            if (connection == null && session != null) {
                this.lockedSessions.remove(session.getId());
                this.lock.lock();
                try {
                    this.conditionSessions.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return connection;
    }

    private HTTPServerFabricConnection acquireConnectionInternal(HttpServletRequest request, HttpSession session, HTTPCredentials credentials) throws ServletException {
        HTTPServerFabricConnection connection = FabricConnectionsProvider.getConnectionFromRequest(request);
        if (connection != null && !Objects.equals(connection.getHttpSessionId(), session.getId())) {
            this.releaseConnection(request);
            connection = null;
        }
        if (connection == null) {
            connection = this.availableConnections.remove(session.getId());
            if (connection != null && !connection.getUserName().equalsIgnoreCase(credentials.getUserName())) {
                this.allConnections.remove(connection);
                connection.setRemoved(true);
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connection = null;
            }
            if (connection == null && this.shareConnectionsBetweenSessions.booleanValue()) {
                long timeToWait = this.connectionWaitTimeout >= 0 ? TimeUnit.SECONDS.toMillis(this.connectionWaitTimeout.intValue()) : -1L;
                long startTime = System.currentTimeMillis();
                boolean waitForConnection = false;
                do {
                    long connectionsCountPerUser;
                    Map.Entry entry = null;
                    if (this.shareConnectionsBetweenUrls.booleanValue()) {
                        entry = this.availableConnections.entrySet().stream().filter(c -> ((HTTPServerFabricConnection)c.getValue()).getUserName().equalsIgnoreCase(credentials.getUserName())).findFirst().orElse(null);
                    } else {
                        String contextPath = AuthenticationHelper.getRequestContextPath(request);
                        entry = this.availableConnections.entrySet().stream().filter(c -> ((HTTPServerFabricConnection)c.getValue()).getUserName().equalsIgnoreCase(credentials.getUserName()) && Objects.equals(((HTTPServerFabricConnection)c.getValue()).getInitialContextPath(), contextPath)).findFirst().orElse(null);
                    }
                    if (entry != null) {
                        this.availableConnections.remove(entry.getKey());
                        connection = (HTTPServerFabricConnection)entry.getValue();
                        Trace.logDebug(this, "{} rest connection moved to session {}.", connection, session.getId());
                        connection.setHttpSessionId(session.getId());
                    }
                    if (connection != null || this.connectionsPerUserLimit <= 0 || (connectionsCountPerUser = this.allConnections.stream().filter(c -> Objects.equals(c.getUserName(), credentials.getUserName())).count()) < (long)this.connectionsPerUserLimit.intValue()) continue;
                    if (timeToWait < 0L) {
                        throw new ServletException("REST connections limit  " + connectionsCountPerUser + " of " + this.connectionsPerUserLimit + " is reached for user " + credentials.getUserName() + ".");
                    }
                    if (timeToWait < 0L) continue;
                    try {
                        waitForConnection = true;
                        this.conditionConnections.await(Math.min(timeToWait, 30000L), TimeUnit.MILLISECONDS);
                        if (this.connectionWaitTimeout <= 0) continue;
                        timeToWait -= System.currentTimeMillis() - startTime;
                        startTime = System.currentTimeMillis();
                    }
                    catch (InterruptedException exception) {
                        throw new ServletException("Request has been interrupted.");
                    }
                } while (this.running && connection == null && waitForConnection);
            }
        }
        if (connection != null && (connection.isRemoved() || !connection.isOpened() || connection.isClosed())) {
            Trace.logInfo(this, "Removing connection {}, because it was {}.", connection, connection.isRemoved() ? "removed" : (!connection.isOpened() ? "closed or not opened" : "closed"));
            this.removeAndCloseConnection(connection.getHttpSessionId(), false);
            connection = null;
        }
        if (!credentials.isAnonymousUser() && connection != null && connection.getUserName() != null && connection.getUserName().equals("anonymous")) {
            this.releaseConnection(connection);
            this.releaseConnection(request);
            connection = null;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPServerFabricConnection createAndOpenRestConnectionInternal(HttpServletRequest request, HttpSession session) throws ServletException {
        HTTPServerFabricConnection connection = this.createConnectionInternal(request, true);
        try {
            session.setMaxInactiveInterval(0);
            connection.setEventScope(EventScope.GLOBAL);
            connection.open();
            this.lock.lock();
            try {
                if (!((AbstractSession)session).isValid() || !this.running) {
                    Trace.logError(this, "{} It seems that session was expired or invalidated while opening a rest connection. Closing this connection.", connection);
                    throw new Exception("HTTP session expired.");
                }
                connection.touch();
                AuthenticationHelper.touchSession(session);
                this.allConnections.add(connection);
                Trace.logDebug(this, "{} New rest connection created. Rest connections count: {}", connection.toStringMaxInfo(), this.allConnections.size());
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception exception) {
            if (connection != null) {
                this.allConnections.remove(connection);
                session.setMaxInactiveInterval(1);
                try {
                    connection.setRemoved(true);
                    connection.close();
                }
                catch (Exception e) {
                    Trace.logDebug(this, "{} Failed to close rest connection.", connection);
                }
            }
            throw new ServletException(exception);
        }
        return connection;
    }

    public void releaseConnection(HttpServletRequest request) {
        HTTPServerFabricConnection connection = FabricConnectionsProvider.getConnectionFromRequest(request);
        if (connection != null) {
            this.releaseConnection(connection);
            FabricConnectionsProvider.setConnectionToRequest(request, null);
        }
    }

    @Override
    public void releaseConnection(HTTPServerFabricConnection connection) {
        HTTPServerFabricConnection oldConnection = null;
        this.lock.lock();
        try {
            if (connection.getHttpSessionId() != null) {
                this.lockedSessions.remove(connection.getHttpSessionId());
                this.conditionSessions.signalAll();
            }
            if (this.allConnections.contains(connection)) {
                oldConnection = this.availableConnections.put(connection.getHttpSessionId(), connection);
                if (oldConnection != null && oldConnection != connection) {
                    this.allConnections.remove(oldConnection);
                    Trace.logInfo(this, "WARNING: Two fabric connection with the same sessionId. {} replaced with {}.", oldConnection.toStringMaxInfo(), connection.toStringMaxInfo());
                }
                this.conditionConnections.signalAll();
            } else {
                oldConnection = connection;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (oldConnection != null && oldConnection != connection) {
            oldConnection.setRemoved(true);
            try {
                oldConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public HTTPServerFabricConnection getConnection(String sessionId) {
        this.lock.lock();
        try {
            HTTPServerFabricConnection hTTPServerFabricConnection = this.allConnections.stream().filter(c -> c.getHttpSessionId().equals(sessionId)).findFirst().orElse(null);
            return hTTPServerFabricConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<HTTPServerFabricConnection> getConnectionsForUser(String userName) {
        this.lock.lock();
        try {
            List<HTTPServerFabricConnection> list = this.allConnections.stream().filter(c -> Objects.equals(c.getUserName(), userName)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTTPServerFabricConnection getConnectionForUserAndClientId(String userName, ClientId clientId) {
        this.lock.lock();
        try {
            HTTPServerFabricConnection hTTPServerFabricConnection = this.allConnections.stream().filter(c -> c.getUserName() != null && c.getUserName().equals(userName) && c.getClientId() != null && c.getClientId().toString().equals(clientId.toString()) && c.isOpened()).findFirst().orElse(null);
            return hTTPServerFabricConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAndCloseConnection(String sessionId, boolean expired) {
        this.lock.lock();
        HTTPServerFabricConnection connection = null;
        try {
            this.lockedSessions.remove(sessionId);
            this.conditionSessions.signalAll();
            connection = this.availableConnections.remove(sessionId);
            if (connection == null) {
                connection = this.allConnections.stream().filter(c -> c.getHttpSessionId().equals(sessionId)).findFirst().orElse(null);
            }
            if (connection != null) {
                this.allConnections.remove(connection);
                connection.setRemoved(expired);
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logDebug(this, String.valueOf(connection) + " Closing and removing " + (expired ? "expired." : "removed") + " rest connection, connections count: " + this.allConnections.size());
                }
            }
            this.conditionConnections.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (connection != null) {
            try {
                connection.setRemoved(true);
                connection.close();
            }
            catch (Exception closeFailed) {
                Trace.logDebug(this, String.valueOf(connection) + " Closing rest connection failed. Cause: " + closeFailed.getMessage());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAndCloseAllConnections() {
        this.lock.lock();
        try {
            for (HTTPServerFabricConnection connection : this.allConnections) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            this.allConnections.clear();
            this.availableConnections.clear();
            this.lockedSessions.clear();
            this.running = false;
            this.conditionConnections.signalAll();
            this.conditionSessions.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

