/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.fabric;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.ClientId;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.dispatcher.AbstractAuthenticator;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.authentication.Authenticator;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.jetty.fabric.AbstractFabricConnectionsProvider;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FabricConnectionsProviderForFabric
extends AbstractFabricConnectionsProvider {
    private static final Long UNAUTORIZED_SESSIONS_KEEP_TIMEOUT = 60000L;
    private static final ConcurrentHashMap<String, Pair<AtomicLong, AtomicInteger>> unauthorizedSessions = new ConcurrentHashMap();
    private static final Semaphore unauthorizedSessionsSemaphore = new Semaphore(1);
    private boolean isClosed = false;
    private Map<String, HTTPServerFabricConnection> connections = new HashMap<String, HTTPServerFabricConnection>();
    private final ReentrantLock lock = new ReentrantLock();
    private AbstractAuthenticator httpAuthenticator;
    private final AbstractAuthenticator commonAuthenticator;

    public FabricConnectionsProviderForFabric(HTTPAcceptor acceptor, AbstractAuthenticator httpAuthenticator, AbstractAuthenticator commonAuthenticator) {
        super(acceptor);
        this.httpAuthenticator = httpAuthenticator;
        this.commonAuthenticator = commonAuthenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTTPServerFabricConnection provideAndAcquireConnection(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        HTTPServerFabricConnection connection;
        block12: {
            this.cleanupUnauthorizedSessions();
            HTTPCredentials credentials = (HTTPCredentials)request.getAttribute(HTTPCredentials.ATTRIBUTE);
            if (credentials == null) {
                throw new ServletException("Request is not authorized.");
            }
            HttpSession session = request.getSession(true);
            connection = null;
            this.lock.lock();
            try {
                if (this.isClosed) {
                    throw new ServletException("Http acceptor is stopped.");
                }
                connection = this.connections.get(session.getId());
                if (connection != null && !connection.getUserName().equalsIgnoreCase(credentials.getUserName())) {
                    Trace.logDebug(this, "Connection {} owned by {} is started using by user {} in session {}, Closing and opening the new one.", connection, connection.getUserName(), credentials.getUserName(), session.getId());
                    this.removeAndCloseConnection(session.getId(), false);
                }
                if (connection != null && (connection.isRemoved() || connection.isClosed())) {
                    Trace.logDebug(this, "Connection {} is {}. Opening the new one.", connection, connection.isRemoved() ? "removed" : "closed");
                    this.removeAndCloseConnection(session.getId(), false);
                    connection = null;
                }
                if (connection != null) break block12;
                if (request.getParameter("reconnect") == null && request.getParameter("login") == null && request.getParameter("anonymous") == null) {
                    if (session != null) {
                        session.invalidate();
                    }
                    this.logUnauthorizedRequest(request);
                    try {
                        AbstractAuthenticator authenticator = this.commonAuthenticator.containsAuthentication(request) ? this.commonAuthenticator : this.httpAuthenticator;
                        authenticator.sendSessionExpired(request, response, new Authenticator.AuthenticationFailedException("Unknown or missing fabric session id in request.", "7003"));
                    }
                    catch (IOException exception) {
                        throw new ServletException(exception);
                    }
                    HTTPServerFabricConnection hTTPServerFabricConnection = null;
                    return hTTPServerFabricConnection;
                }
                connection = this.createConnectionInternal(request, false);
                this.connections.put(connection.getHttpSessionId(), connection);
                Trace.logDebug(this, "{} New http connection created. Http connections count: {}", connection.toStringMaxInfo(), this.connections.size());
            }
            finally {
                this.lock.unlock();
            }
        }
        FabricConnectionsProvider.setConnectionToRequest(request, connection);
        FabricConnectionsProvider.setProviderToRequest(request, this);
        this.initAndTouchConnection(connection, request);
        return connection;
    }

    @Override
    public void releaseConnection(HTTPServerFabricConnection connection) {
    }

    @Override
    public HTTPServerFabricConnection getConnection(String sessionId) {
        this.lock.lock();
        try {
            HTTPServerFabricConnection hTTPServerFabricConnection = this.connections.get(sessionId);
            return hTTPServerFabricConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<HTTPServerFabricConnection> getConnectionsForUser(String userName) {
        this.lock.lock();
        try {
            List<HTTPServerFabricConnection> list = this.connections.values().stream().filter(c -> c.getUserName() != null && c.getUserName().equals(userName) && c.isOpened()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTTPServerFabricConnection getConnectionForUserAndClientId(String userName, ClientId clientId) {
        this.lock.lock();
        try {
            HTTPServerFabricConnection hTTPServerFabricConnection = this.connections.values().stream().filter(c -> c.getUserName() != null && c.getUserName().equals(userName) && c.getClientId() != null && c.getClientId().toString().equals(clientId.toString()) && c.isOpened()).findFirst().orElse(null);
            return hTTPServerFabricConnection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAndCloseConnection(String sessionId, boolean expired) {
        this.lock.lock();
        HTTPServerFabricConnection connection = null;
        try {
            connection = this.connections.remove(sessionId);
            if (connection != null) {
                connection.setRemoved(expired);
                if (Trace.isDebugEnabled(this.getClass())) {
                    Trace.logDebug(this, "{} Closing and removing {} http connection, connections count: {}", connection, expired ? "expired." : "removed", this.connections.size());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                Trace.logError(this, "{} Close of http connection failed. Cause: {}", connection, exception.getMessage());
                Trace.logException(this, exception, true);
            }
        }
        return connection != null;
    }

    @Override
    public void removeAndCloseAllConnections() {
        this.lock.lock();
        Trace.logDebug(this, "Closing and removing all fabric connections.");
        try {
            this.isClosed = true;
            this.connections.values().forEach(c -> {
                try {
                    c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.connections.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupUnauthorizedSessions() {
        if (!unauthorizedSessions.isEmpty() && unauthorizedSessionsSemaphore.tryAcquire()) {
            try {
                if (!unauthorizedSessions.isEmpty()) {
                    Long now = System.currentTimeMillis();
                    for (Map.Entry<String, Pair<AtomicLong, AtomicInteger>> entry : unauthorizedSessions.entrySet()) {
                        if (now - ((AtomicLong)entry.getValue().first).get() <= UNAUTORIZED_SESSIONS_KEEP_TIMEOUT + 5000L) continue;
                        unauthorizedSessions.remove(entry.getKey());
                    }
                }
            }
            finally {
                unauthorizedSessionsSemaphore.release();
            }
        }
    }

    private void logUnauthorizedRequest(HttpServletRequest request) {
        int count = 0;
        Long now = System.currentTimeMillis();
        long startTime = now;
        String key = request.getRemoteAddr() + "-" + request.getParameter("FabricSession");
        Pair<AtomicLong, AtomicInteger> pair = unauthorizedSessions.get(key);
        if (pair == null) {
            pair = new Pair<AtomicLong, AtomicInteger>(new AtomicLong(now), new AtomicInteger(0));
            if ((pair = unauthorizedSessions.putIfAbsent(key, pair)) != null) {
                ((AtomicInteger)pair.second).incrementAndGet();
            } else {
                count = 1;
            }
        } else if (now - ((AtomicLong)pair.first).get() > UNAUTORIZED_SESSIONS_KEEP_TIMEOUT) {
            startTime = ((AtomicLong)pair.first).get();
            if (now - ((AtomicLong)pair.first).getAndSet(now) > UNAUTORIZED_SESSIONS_KEEP_TIMEOUT) {
                count = ((AtomicInteger)pair.second).getAndSet(0);
                ++count;
            } else {
                ((AtomicInteger)pair.second).incrementAndGet();
            }
        } else {
            ((AtomicInteger)pair.second).incrementAndGet();
        }
        if (count > 0) {
            Trace.logError(this, "Unknown or missing fabric session id in request '{}?{}' from '{}'. {} requests in last {} seconds. Reconnect is required.", request.getRequestURI(), request.getQueryString(), request.getRemoteAddr(), count, (int)((now - startTime) / 1000L));
        }
    }
}

