/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.fabric;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.ClientId;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface FabricConnectionsProvider {
    public static final String ATTRIBUTE = FabricConnectionsProvider.class.getName();
    public static final String ATTRIBUTE_CONNECTION = FabricConnectionsProvider.class.getName() + ".connection";

    public HTTPServerFabricConnection provideAndAcquireConnection(HttpServletRequest var1, HttpServletResponse var2) throws ServletException;

    public void releaseConnection(HTTPServerFabricConnection var1);

    public HTTPServerFabricConnection getConnection(String var1);

    public List<HTTPServerFabricConnection> getConnectionsForUser(String var1);

    public HTTPServerFabricConnection getConnectionForUserAndClientId(String var1, ClientId var2);

    public boolean removeAndCloseConnection(String var1, boolean var2);

    public void removeAndCloseAllConnections();

    public static void setConnectionToRequest(HttpServletRequest request, HTTPServerFabricConnection connection) {
        Trace.logDebug(FabricConnectionsProvider.class, "Set connection {} to request in session {}", connection, request.getSession().getId());
        request.setAttribute(ATTRIBUTE_CONNECTION, connection);
    }

    public static void setProviderToRequest(HttpServletRequest request, FabricConnectionsProvider provider) {
        request.setAttribute(ATTRIBUTE, provider);
    }

    public static HTTPServerFabricConnection getConnectionFromRequest(HttpServletRequest request) {
        return (HTTPServerFabricConnection)request.getAttribute(ATTRIBUTE_CONNECTION);
    }

    public static FabricConnectionsProvider getProviderFromRequest(HttpServletRequest request) {
        return (FabricConnectionsProvider)request.getAttribute(ATTRIBUTE);
    }

    public static void releaseConnectionForRequest(HttpServletRequest request) {
        HTTPServerFabricConnection connection;
        FabricConnectionsProvider provider = FabricConnectionsProvider.getProviderFromRequest(request);
        if (provider != null && (connection = FabricConnectionsProvider.getConnectionFromRequest(request)) != null) {
            provider.releaseConnection(connection);
            FabricConnectionsProvider.setConnectionToRequest(request, null);
        }
    }
}

