/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.fabric;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.authentication.HTTPCredentials;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnectionFactory;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnectionImpl;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProvider;
import com.streamscape.sef.security.AuthenticationType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class AbstractFabricConnectionsProvider
implements FabricConnectionsProvider {
    public static long LEASE_PERIOD_FOR_NOT_OPENED_CONNECTON_SECONDS = 20000L;
    private HTTPAcceptor acceptor;

    public AbstractFabricConnectionsProvider(HTTPAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    protected HTTPServerFabricConnection createConnectionInternal(HttpServletRequest request, boolean isRest) throws ServletException {
        HTTPCredentials credentials = (HTTPCredentials)request.getAttribute(HTTPCredentials.ATTRIBUTE);
        if (credentials == null) {
            throw new ServletException("Request is not authorized.");
        }
        HttpSession session = request.getSession(true);
        String sessionId = session.getId();
        HTTPServerFabricConnectionImpl connection = null;
        try {
            HTTPServerFabricConnectionFactory factory = new HTTPServerFabricConnectionFactory(sessionId, isRest, this.acceptor.getRuntimeContext());
            connection = factory.createConnection(this.acceptor, request);
            connection.setUserName(credentials.getUserName());
            connection.setPassword(credentials.getCredentials());
            connection.setAuthenticationParameters(credentials.getKeys());
            connection.setAuthenticationType(AuthenticationType.DIGEST);
            connection.setDigestCalculator(credentials.getDigestCalculator());
            connection.setLeasePeriod(LEASE_PERIOD_FOR_NOT_OPENED_CONNECTON_SECONDS);
        }
        catch (Exception exception) {
            if (connection != null) {
                session.setMaxInactiveInterval(1);
                try {
                    connection.close();
                }
                catch (Exception e) {
                    Trace.logDebug(this, "{} Failed to close connection.", connection);
                }
            }
            throw new ServletException(exception);
        }
        return connection;
    }

    void initAndTouchConnection(HTTPServerFabricConnection connection, HttpServletRequest request) {
        if (connection != null) {
            ((HTTPServerFabricConnectionImpl)connection).init(this.acceptor, request);
            connection.touch();
        }
    }
}

