/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.customizer;

import com.streamscape.Trace;
import com.streamscape.sef.network.http.server.jetty.HTTPRequestTrigger;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;

public class CustomizedHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private Request request;
    private static final Field contentParametersField;

    public CustomizedHttpServletRequestWrapper(Request request) {
        super((HttpServletRequest)request);
        this.request = request;
    }

    public void setQueryString(String queryString) {
        if (queryString == null) {
            queryString = "";
        }
        if (queryString.equals(this.request.getQueryString())) {
            return;
        }
        Object uriString = this.request.getUri().toString();
        int index = ((String)uriString).lastIndexOf(63);
        if (index != -1) {
            uriString = ((String)uriString).substring(0, index);
        }
        if (queryString != null && queryString.length() > 0) {
            uriString = (String)uriString + "?" + queryString;
        }
        HttpURI uri = new HttpURI((String)uriString);
        this.request.setUri(uri);
        this.request.setQueryString(null);
        this.request.resetParameters();
        this.request.setQueryParameters(null);
    }

    public void clearContentParametersAndSetTriggerContent() {
        try {
            MultiMap multiMap = (MultiMap)contentParametersField.get(this.request);
            if (multiMap != null) {
                String content = UrlEncoded.encode((MultiMap)multiMap, (Charset)UrlEncoded.ENCODING, (boolean)true);
                HTTPRequestTrigger.setRequestContent((HttpServletRequest)this.request, content.getBytes());
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
        this.request.setContentParameters(null);
    }

    public void setMethod(String method) {
        this.request.setMethod(HttpMethod.fromString((String)method), method);
    }

    public void setRequestUri(String requestURI) {
        this.request.setRequestURI(requestURI);
    }

    public void setPathInfo(String pathInfo) {
        this.request.setPathInfo(pathInfo);
    }

    static {
        try {
            contentParametersField = Request.class.getDeclaredField("_contentParameters");
            contentParametersField.setAccessible(true);
        }
        catch (Exception exception) {
            Trace.logException(CustomizedHttpServletRequestWrapper.class, exception, true);
            throw new RuntimeException(exception);
        }
    }
}

