/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty.customizer;

import com.streamscape.Trace;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptorConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizer;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerConfiguration;
import com.streamscape.sef.network.http.server.apicustomizer.APICustomizerException;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.AbstractRuleWrapper;
import com.streamscape.sef.network.http.server.apicustomizer.any.AnyRule;
import com.streamscape.sef.network.http.server.apicustomizer.any.AnyRuleAccessor;
import com.streamscape.sef.network.http.server.apicustomizer.dataspace.AbstractDataspaceRule;
import com.streamscape.sef.network.http.server.apicustomizer.eventfabric.EventFabricRule;
import com.streamscape.sef.network.http.server.apicustomizer.service.ServiceRule;
import com.streamscape.sef.network.http.server.jetty.customizer.CustomizedHttpServletRequestWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class APICustomizerHandler
extends HandlerWrapper {
    private APICustomizer apiCustomizer;
    private HTTPAcceptorConfiguration configuration;
    private boolean servlets;

    public APICustomizerHandler(boolean servlets) {
        this.servlets = servlets;
    }

    public void setConfiguration(HTTPAcceptorConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        APICustomizerConfiguration apiCustomizerConfiguration = (APICustomizerConfiguration)SDOUtils.cloneByJSerializer(this.configuration.getAPICustomizerConfiguration());
        if (apiCustomizerConfiguration != null) {
            if (this.servlets) {
                apiCustomizerConfiguration.setAnyRules(new ArrayList<AnyRule>(apiCustomizerConfiguration.listAnyRules().stream().filter(r -> r.getCustomizedUri().toLowerCase().startsWith("/dropbox")).collect(Collectors.toList())));
            } else {
                apiCustomizerConfiguration.setAnyRules(new ArrayList<AnyRule>(apiCustomizerConfiguration.listAnyRules().stream().filter(r -> !r.getCustomizedUri().toLowerCase().startsWith("/dropbox")).collect(Collectors.toList())));
                apiCustomizerConfiguration.setDataspaceRules(new ArrayList<AbstractDataspaceRule>());
                apiCustomizerConfiguration.setEventFabricRules(new ArrayList<EventFabricRule>());
                apiCustomizerConfiguration.setServiceRules(new ArrayList<ServiceRule>());
            }
        }
        try {
            this.apiCustomizer = new APICustomizer();
            this.apiCustomizer.init(apiCustomizerConfiguration);
        }
        catch (Exception exception) {
            Trace.logError((Object)this, "Failed to start API Customizer");
            Trace.logException((Object)this, exception, true);
        }
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.isHandled()) {
            return;
        }
        Request httpRequest = (Request)request;
        HttpServletResponse httpResponse = response;
        httpRequest.setAttribute(HTTPAcceptorConfiguration.ATTRIBUTE, (Object)this.configuration);
        AbstractRuleAccessor rule = this.apiCustomizer.getRuleFor(httpRequest.getMethod(), httpRequest.getRequestURI(), (HttpServletRequest)httpRequest);
        if (rule == null) {
            super.handle(target, baseRequest, request, response);
            return;
        }
        CustomizedHttpServletRequestWrapper customizedRequest = new CustomizedHttpServletRequestWrapper(httpRequest);
        try {
            String queryString = AbstractRuleAccessor.splitDataAndHints((HttpServletRequest)httpRequest, rule.getRuleWrapper(), httpRequest.getQueryString());
            if (queryString != null) {
                customizedRequest.setQueryString(queryString);
            }
        }
        catch (Exception exception) {
            this.sendCustomizerError((HttpServletRequest)httpRequest, httpResponse, "Failed to extract hints from req query: " + exception.getMessage());
            baseRequest.setHandled(true);
            return;
        }
        try {
            customizedRequest.setAttribute("API_CUSTOMIZER_ORIGINAL_URI", httpRequest.getUri());
            customizedRequest.setAttribute("API_CUSTOMIZER_ORIGINAL_METHOD", httpRequest.getMethod());
            customizedRequest.setAttribute("API_CUSTOMIZER_ORIGINAL_QUERY_PARAMETERS", httpRequest.getParameterMap());
            String methodOld = customizedRequest.getMethod();
            String requestUriOld = customizedRequest.getRequestURI();
            String queryStringOld = customizedRequest.getQueryString();
            String method = rule.customizeMethod();
            String requestUri = rule.customizeUri();
            String queryString = rule.customizeQuery((HttpServletRequest)httpRequest);
            rule.afterprocess();
            if (rule instanceof AnyRuleAccessor) {
                AnyRule anyRule = (AnyRule)((AbstractRuleWrapper)rule.getRuleWrapper()).getRule();
                if (anyRule.isRedirect()) {
                    Object redirectUri = requestUri;
                    if (queryString != null && queryString.length() > 0) {
                        redirectUri = (String)redirectUri + "?" + queryString;
                    } else if (httpRequest.getQueryString() != null && httpRequest.getQueryString().length() > 0) {
                        redirectUri = (String)redirectUri + "?" + httpRequest.getQueryString();
                    }
                    response.sendRedirect((String)redirectUri);
                    baseRequest.setHandled(true);
                    return;
                }
                Map<String, String> cookies = ((AnyRuleAccessor)rule).getCookies();
                if (cookies != null) {
                    for (String cookieName : cookies.keySet()) {
                        Cookie cookie = new Cookie(cookieName, cookies.get(cookieName));
                        cookie.setPath(requestUriOld);
                        response.addCookie(cookie);
                    }
                }
            }
            customizedRequest.setMethod(method);
            customizedRequest.setRequestUri(requestUri);
            customizedRequest.clearContentParametersAndSetTriggerContent();
            customizedRequest.setQueryString(queryString);
            if (Trace.isDebugEnabled(((Object)((Object)this)).getClass())) {
                String message = methodOld + " " + requestUriOld + (String)(queryStringOld != null && queryStringOld.length() > 0 ? "?" + queryStringOld : "") + " customized to " + method + " " + requestUri + (String)(queryString != null && queryString.length() > 0 ? "?" + queryString : "");
                Trace.logDebug((Object)this, message);
            }
            super.handle(requestUri, baseRequest, request, response);
        }
        catch (APICustomizerException exception) {
            this.sendCustomizerError((HttpServletRequest)httpRequest, httpResponse, exception.getMessage());
            baseRequest.setHandled(true);
        }
    }

    private void sendCustomizerError(HttpServletRequest request, HttpServletResponse response, String error) throws IOException {
        int errorCode = 400;
        Object apiCustomizerErrorCode = request.getAttribute("API_CUSTOMIZER_ERROR_CODE");
        if (apiCustomizerErrorCode != null) {
            errorCode = (Integer)apiCustomizerErrorCode;
        }
        Trace.logDebug((Object)this, error);
        response.setStatus(errorCode);
        response.getOutputStream().println(error);
    }
}

