/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.network.http.server.jetty;

import com.streamscape.sef.network.http.server.authentication.AuthenticationHelper;
import com.streamscape.sef.network.http.server.fabric.HTTPServerFabricConnection;
import com.streamscape.sef.network.http.server.fabric.RESTServerFabricConnectionImpl;
import com.streamscape.sef.network.http.server.jetty.fabric.FabricConnectionsProvider;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class SessionMaxInactiveIntervalHandler
extends HandlerWrapper {
    SessionMaxInactiveIntervalHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (baseRequest.isHandled()) {
            return;
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            int maxInactiveInterval = session.getMaxInactiveInterval();
            try {
                session.setMaxInactiveInterval(0);
                super.handle(target, baseRequest, request, response);
            }
            finally {
                try {
                    AuthenticationHelper.touchSession(session);
                }
                catch (Exception exception) {}
                HTTPServerFabricConnection connection = FabricConnectionsProvider.getConnectionFromRequest(request);
                if (connection != null && (connection instanceof RESTServerFabricConnectionImpl && ((RESTServerFabricConnectionImpl)connection).isLeasPeriodIsDefault() || connection.getLeasePeriod() / 1000L == (long)maxInactiveInterval) || connection == null && session.getMaxInactiveInterval() == 0) {
                    session.setMaxInactiveInterval(maxInactiveInterval);
                }
            }
        }
    }
}

